/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import cern.colt.bitvector.BitVector;
import cern.colt.function.LongObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.OpenLongObjectHashMap;
import com.eaio.uuid.UUID;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.aep.AepBusConnection;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepEngineStats;
import com.neeve.aep.AepEngineStopEvent;
import com.neeve.aep.AepEnvironmentFactory;
import com.neeve.aep.AepEnvironmentProviderProxy;
import com.neeve.aep.AepEventDispatcher;
import com.neeve.aep.AepFlow;
import com.neeve.aep.AepFlowFactory;
import com.neeve.aep.AepMessageSender;
import com.neeve.aep.AepObject;
import com.neeve.aep.AepResumeTransactionEvent;
import com.neeve.aep.AepScheduleEvent;
import com.neeve.aep.AepSendCommitCompletionEvent;
import com.neeve.aep.AepSendEvent;
import com.neeve.aep.AepSysStats;
import com.neeve.aep.EAepAppException;
import com.neeve.aep.EAepException;
import com.neeve.aep.EAepExpectationNotMetException;
import com.neeve.aep.EAepRollbackError;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.IAepAsynchronousEventHandler;
import com.neeve.aep.IAepBusConnectionStats;
import com.neeve.aep.IAepEngineStats;
import com.neeve.aep.IAepEnvironmentProvider;
import com.neeve.aep.IAepPostdispatchMessageHandler;
import com.neeve.aep.IAepPredispatchMessageHandler;
import com.neeve.aep.IAepWatcher;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepApplicationExceptionEvent;
import com.neeve.aep.event.AepBusBindingCreateFailedEvent;
import com.neeve.aep.event.AepBusBindingCreatedEvent;
import com.neeve.aep.event.AepBusBindingDestroyedEvent;
import com.neeve.aep.event.AepBusBindingDownEvent;
import com.neeve.aep.event.AepBusBindingOpenFailedEvent;
import com.neeve.aep.event.AepBusBindingOpenedEvent;
import com.neeve.aep.event.AepBusBindingOpeningEvent;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineActiveEvent;
import com.neeve.aep.event.AepEngineCreatedEvent;
import com.neeve.aep.event.AepEngineStartedEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepEngineStoppingEvent;
import com.neeve.aep.event.AepFlowCreatedEvent;
import com.neeve.aep.event.AepInboundLogExceptionEvent;
import com.neeve.aep.event.AepMessageTraceLoggingExceptionEvent;
import com.neeve.aep.event.AepMessagingFailedEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.event.AepMessagingStartFailedEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.aep.event.AepOutOfOrderSendCommitCompletionAlertEvent;
import com.neeve.aep.event.AepOutboundLogExceptionEvent;
import com.neeve.aep.event.AepSendStabilityEvent;
import com.neeve.aep.event.AepStateCreatedEvent;
import com.neeve.aep.event.AepStatsAlertEvent;
import com.neeve.aep.event.AepStuckAlertEvent;
import com.neeve.aep.event.AepTransactionStageEvent;
import com.neeve.aep.event.AepUnhandledMessageEvent;
import com.neeve.aep.messages.AepHeartbeatMessage;
import com.neeve.aep.messages.AepMessageFactory;
import com.neeve.aep.messages.AepScheduleActivateMessage;
import com.neeve.aep.messages.AepScheduleCancelMessage;
import com.neeve.aep.messages.AepScheduleCreateMessage;
import com.neeve.aep.messages.AepScheduleIntervalExpiryMessage;
import com.neeve.aep.messages.AepShutdownMessage;
import com.neeve.aep.mon.txnstats.AepMonInboundMessageTimings;
import com.neeve.aep.mon.txnstats.AepMonOutboundMessageTimings;
import com.neeve.aep.mon.txnstats.AepMonTransactionStatsMessage;
import com.neeve.aep.mon.txnstats.AepMonTxnStatsFactory;
import com.neeve.config.Config;
import com.neeve.emx.nio.tcp.EmxNioTcpNwLnkPeerEndpoint;
import com.neeve.event.Event;
import com.neeve.event.EventMultiplexerFreeThreadedSerialized;
import com.neeve.event.EventMultiplexerSingleThreaded;
import com.neeve.event.IEventAcknowledger;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.event.IEventSource;
import com.neeve.event.alert.IAlertEvent;
import com.neeve.io.IOBufferPacket;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingFailedEvent;
import com.neeve.ods.IStoreBindingRoleChangedEvent;
import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreIndex;
import com.neeve.ods.IStoreMemberControlEvent;
import com.neeve.ods.IStoreMemberInitCompleteEvent;
import com.neeve.ods.IStoreNonUniqueIndex;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectAddedEvent;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStoreObjectReceivedEvent;
import com.neeve.ods.IStoreObjectRemovedEvent;
import com.neeve.ods.IStoreObjectUpdatedEvent;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStoreUniqueIndex;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsExpectationNotMetException;
import com.neeve.ods.StoreBindingFactory;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderRR;
import com.neeve.query.IQueryAPICallerContext;
import com.neeve.rog.IRogGraphCollection;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogMessageLogger;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogGraphCollection;
import com.neeve.rog.impl.RogPacketMessageFactory;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.rog.log.RogMessageLog;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageChannelKeyResolver;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sma.MessageViewFilter;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.MessagingProviderRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageChannelEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.sma.event.MessageStabilityEvent;
import com.neeve.sma.event.UnhandledMessageEvent;
import com.neeve.sma.impl.DefaultMessageChannelKeyResolver;
import com.neeve.stats.IStats;
import com.neeve.stats.IStatsAlert;
import com.neeve.stats.Stats;
import com.neeve.sto.StoTypeFactory;
import com.neeve.sto.StoTypeFactoryRegistry;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlLinkedLongMap;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPlist;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import com.neeve.util.UtlUnit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class AepEngine
extends AepObject
implements IStoreEventHandler,
IEventHandler,
IEventSource {
    private static final int ZERO_OUTBOUND_MESSAGE_TXN_SEND_COMMIT_COMPLETION_EVENT_PRIORITY = -1000;
    private static final int STORE_MEMBER_CONTROL_EVENT_PRIORITY = -1001;
    private final XString name;
    private final String tracePrefix;
    private final Tracer snoTracer;
    private final Tracer evTracer;
    private final Tracer alertTracer;
    private final Tracer msgTracer;
    private final Tracer txnTracer;
    private final Tracer schedTracer;
    private final boolean someDebugTrace;
    private final boolean msgTracerJson;
    private final RogLogUtil.JsonPrettyPrintStyle msgTracerJsonStyle;
    private final RogLogUtil.MetadataDisplayPolicy msgTracerMetadataDisplay;
    private final boolean msgTracerFilterUnsetFields;
    private final AepEngineDescriptor engineDescriptor;
    private final IAepApplicationStateFactory stateFactory;
    private final AepEventDispatcher dispatcher;
    private final AepEnvironmentProviderProxy[] environmentProviderProxies;
    private final Map<String, MessageBusDescriptor> busDescriptors;
    private final StoreDescriptor storeDescriptor;
    private final List<AepBusConnection> busConnectionList;
    private final Map<String, AepBusConnection> busConnections;
    private final Map<String, AepBusConnection> internalBusConnections;
    private final Map<Class<? extends IRogMessage>, XString> messageGlobalTypes;
    private final AepEngineStats stats;
    private final AepSysStats systats;
    private final Transaction transaction;
    private final OutboundMessagingContext outboundMessagingContext;
    private final HAPolicy haPolicy;
    private final ReplicationPolicy replicationPolicy;
    private final MessagingStartFailPolicy messagingStartFailPolicy;
    private final MessageBusBindingFailPolicy messageBusBindingFailPolicy;
    private final InboundMessageLoggingPolicy inboundMessageLoggingPolicy;
    private final InboundMessageLoggingFailurePolicy inboundMessageLoggingFailurePolicy;
    private final OutboundMessageLoggingPolicy outboundMessageLoggingPolicy;
    private final OutboundMessageLoggingFailurePolicy outboundMessageLoggingFailurePolicy;
    private final PerTransactionStatsLoggingPolicy perTransactionStatsLoggingPolicy;
    private final PerTransactionStatsLoggingFailurePolicy perTransactionStatsLoggingFailurePolicy;
    private final EventMultiplexerType emuxType;
    private final int adaptiveCommitBatchCeiling;
    private final boolean enableMultipleFlows;
    private final boolean enableReplayOnRollback;
    private final boolean dispatchSendStabilityEvents;
    private final boolean dispatchTransactionStageEvents;
    private final boolean enableTransactionCommitSuspension;
    private final boolean enableTransactionSavepoints;
    private final boolean replicateSolicitedSends;
    private final boolean replicateUnsolicitedSends;
    private final boolean sequenceUnsolicitedSends;
    private final boolean sequenceUnsolicitedWithSolicitedSends;
    private final boolean disposeOnSend;
    private final int clusterHeartbeatInterval;
    private final boolean administrative;
    private final long stuckAlertThreshold;
    private final boolean ackOnStoreCommit;
    private final boolean preserveChannelJoinsOnStop;
    private final boolean recordMsgLegWaypoints;
    private final boolean recordMsgLegLatencies;
    private final boolean recordMsgTypeLegLatencies;
    private final boolean captureMsgTypeStats;
    private final boolean recordTxnLegLatencies;
    private final boolean capturePerTxnStats;
    private final boolean captureEvLatencyStats;
    private final boolean duplicateChecking;
    private final boolean midstreamInitializationValidation;
    private final boolean enableSendCommitCompleteSequenceAlerts;
    private final boolean setInboundMessageAsReadOnly;
    private final boolean setOutboundMessageAsReadOnly;
    private final boolean replicateInParallel;
    private final boolean setSupportMetadata;
    private final boolean setOutboundSequenceNumbers;
    private final boolean syncOnInject;
    private final boolean enableTypeBasedRouting;
    private final boolean stopOnJVMShutdown;
    private final Object engineStartCompletionNotifier;
    private final Object roleChangeSerializer;
    private final MessagingStartCompletionNotifier messagingStartCompletionNotifier;
    private final Object engineStopCompletionNotifier;
    private final int senderId;
    private final OpenLongObjectHashMap schedules;
    private final ScheduleRecoverer scheduleRecoverer;
    private final List<AepScheduleEvent> cancelledSchedules;
    private final IEventMultiplexer multiplexer;
    private final IStoreBinding store;
    private final IRogGraphCollection flows;
    private final String clientBusName;
    private final AtomicLong nextRequestId;
    private final UtlLinkedLongMap<InjectedRequestContext> injectedRequestContexts;
    private final UtlPool<InjectedRequestContext> injectedRequestContextsPool;
    private AepFlow singletonFlow;
    private MessageChannel controlChannel;
    private int adaptiveCommitBatchCountdown;
    private int numEnvironmentProviderProxies;
    private AppExceptionHandlingPolicy appExceptionHandlingPolicy;
    private MessageSendExceptionHandlingPolicy sendExceptionHandlingPolicy;
    private MessageSendStabilityFailureHandlingPolicy sendStabilityFailureHandlingPolicy;
    private IRogMessageLogger inboundMessageLogger;
    private IRogMessageLogger outboundMessageLogger;
    private IRogMessageLogger perTransactionStatsLogger;
    private Thread activeThread;
    private IRogMessage activeMessage;
    private boolean inMessagingStarted;
    private boolean inAppExceptionHandler;
    private State state;
    private MessagingState messagingState;
    private IStoreBinding.Role role;
    private LastTransactionContext lastTransactionContext;
    private MessageChannel quarantineChannel;
    private MessageViewFilter messageFilter;
    private IAepPredispatchMessageHandler predispatchMessageHandler;
    private IAepPostdispatchMessageHandler postdispatchMessageHandler;
    private IAepAsynchronousEventHandler asynchronousEventHandler;
    private long lastCommitCompleteTs = -1L;
    private long lastStuckAlertCommitCompleteCount = -1L;
    private long lastHealthCheckPendingCommitCount = 0L;
    private long lastEventProcessedTs = -1L;
    private long lastStuckAlertEventProcessedCount = -1L;
    private long lastHealthCheckEventPendingCount = -1L;
    private boolean inCommitBatch = false;
    private long nextScheduleId;
    private ScheduledFuture<?> healthCheck;
    private ShutdownHook shutdownHook;
    private boolean inJVMShutdown;
    static final String CONTROL_BUS_NAME = "control-" + new UUID().toString();
    public static final String DIRECT_BUS_NAME = "direct-" + new UUID().toString();
    public static final String CLIENT_BUS_NAME_SUFFIX = "_client_bus";
    public static final String CLIENT_BUS_REQUESTS_CHANNEL_NAME = "requests";
    public static final short CLIENT_BUS_REQUESTS_CHANNEL_ID = 1;
    public static final String CLIENT_BUS_RESPONSES_CHANNEL_NAME = "responses";
    public static final short CLIENT_BUS_RESPONSES_CHANNEL_ID = 2;
    public static final String CLIENT_BUS_RESPONSES_CHANNEL_KEY_CLIENT_ID_ELEMENT = "clientId";
    public static final String DEFAULT_CHANNEL_NAME = "default";
    public static final short DEFAULT_CHANNEL_ID = 32766;
    public static final String DEFAULT_CHANNEL_KEY_MESSAGE_TYPE_ELEMENT = "#mt";
    public static final String STATS_INTERVAL_PROPNAME = "nv.aep.%s.stats.interval";
    public static final String SYSTATS_INTERVAL_PROPNAME = "nv.aep.%s.systats.interval";
    private IOElasticBuffer tmpBufferToDeserializeScheduleDispatchMessage = IOElasticBuffer.create((int)1024);
    private final IOBufferPacket scheduleDispatchDeserializePacket = new IOBufferPacket();
    private final IOElasticBuffer tmpBufferToSerializeScheduleDispatchMessage = IOElasticBuffer.create((int)1024);

    private AepEngine(AepEngineDescriptor engineDescriptor, IAepApplicationStateFactory stateFactory, Set<Object> eventHandlerContainers, IEventHandler defaultEventHandler, Collection<AepMessageSender> messageSenders) {
        if (messageSenders != null && messageSenders.size() > 0 && eventHandlerContainers == null) {
            throw new IllegalArgumentException("event handler container collection cannot be null if at least one message sender is provided");
        }
        this.name = XString.create((String)engineDescriptor.getName());
        this.tracePrefix = "[AepEngine<" + engineDescriptor.getName() + ">]";
        this.snoTracer = Tracer.create((Tracer.Level)(engineDescriptor.getEnableSequenceNumberTrace() ? Tracer.Level.DEBUG : Tracer.Level.OFF));
        this.snoTracer.bind("nv.aep.sno");
        this.evTracer = Tracer.create((Tracer.Level)(engineDescriptor.getEnableEventTrace() ? Tracer.Level.DEBUG : Tracer.Level.OFF));
        this.evTracer.bind("nv.aep.event");
        this.alertTracer = Tracer.create((Tracer.Level)(engineDescriptor.getEnableAlertTrace() ? Tracer.Level.INFO : Tracer.Level.OFF));
        this.alertTracer.bind("nv.aep.alert");
        this.txnTracer = Tracer.create((Tracer.Level)(engineDescriptor.getEnableTransactionTrace() ? Tracer.Level.DEBUG : Tracer.Level.OFF));
        this.txnTracer.bind("nv.aep.txn");
        this.schedTracer = Tracer.create((Tracer.Level)(engineDescriptor.getEnableScheduleTrace() ? Tracer.Level.DEBUG : Tracer.Level.OFF));
        this.schedTracer.bind("nv.aep.sched");
        this.msgTracer = Tracer.create((Tracer.Level)(engineDescriptor.getEnableMessageTrace() ? Tracer.Level.DEBUG : Tracer.Level.OFF));
        this.msgTracer.bind("nv.aep.msg");
        this.msgTracerJson = engineDescriptor.getMessageTraceInJson();
        this.msgTracerJsonStyle = engineDescriptor.getMessageTraceJsonStyle();
        this.msgTracerMetadataDisplay = engineDescriptor.getMessageTraceMetadataDisplayPolicy();
        this.msgTracerFilterUnsetFields = engineDescriptor.getMessageTraceFilterUnsetFields();
        boolean bl = this.someDebugTrace = this.tracer.debug || this.snoTracer.debug || this.evTracer.debug || this.alertTracer.debug || this.txnTracer.debug || this.schedTracer.debug || this.msgTracer.debug;
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Creating engine...", Tracer.Level.DEBUG);
        }
        this.engineDescriptor = engineDescriptor;
        this.stateFactory = stateFactory;
        this.environmentProviderProxies = new AepEnvironmentProviderProxy[engineDescriptor.getMaxEnvironmentProviders()];
        this.busDescriptors = new LinkedHashMap<String, MessageBusDescriptor>();
        this.busConnections = new LinkedHashMap<String, AepBusConnection>();
        this.busConnectionList = new ArrayList<AepBusConnection>();
        this.internalBusConnections = new LinkedHashMap<String, AepBusConnection>();
        this.messageGlobalTypes = new ConcurrentHashMap<Class<? extends IRogMessage>, XString>();
        this.haPolicy = engineDescriptor.getHAPolicy();
        this.replicationPolicy = engineDescriptor.getReplicationPolicy();
        this.messagingStartFailPolicy = engineDescriptor.getMessagingStartFailPolicy();
        this.messageBusBindingFailPolicy = engineDescriptor.getMessageBusBindingFailPolicy();
        this.inboundMessageLoggingPolicy = engineDescriptor.getInboundMessageLoggingPolicy();
        this.inboundMessageLoggingFailurePolicy = engineDescriptor.getInboundMessageLoggingFailurePolicy();
        this.outboundMessageLoggingPolicy = engineDescriptor.getOutboundMessageLoggingPolicy();
        this.outboundMessageLoggingFailurePolicy = engineDescriptor.getOutboundMessageLoggingFailurePolicy();
        this.perTransactionStatsLoggingPolicy = engineDescriptor.getPerTransactionStatsLoggingPolicy();
        this.perTransactionStatsLoggingFailurePolicy = engineDescriptor.getPerTransactionStatsLoggingFailurePolicy();
        this.appExceptionHandlingPolicy = engineDescriptor.getAppExceptionHandlingPolicy();
        this.sendExceptionHandlingPolicy = engineDescriptor.getMessageSendExceptionHandlingPolicy();
        this.sendStabilityFailureHandlingPolicy = engineDescriptor.getMessageSendStabilityFailureHandlingPolicy();
        this.emuxType = engineDescriptor.getEventMultiplexerType();
        this.enableMultipleFlows = engineDescriptor.getEnableMultipleFlows();
        this.enableReplayOnRollback = engineDescriptor.getEnableReplayOnRollback();
        this.dispatchTransactionStageEvents = engineDescriptor.getDispatchTransactionStageEvents();
        this.enableTransactionCommitSuspension = engineDescriptor.getEnableTransactionCommitSuspension();
        this.enableTransactionSavepoints = engineDescriptor.getEnableTransactionSavepoints();
        this.replicateSolicitedSends = engineDescriptor.getReplicateSolicitedSends();
        this.replicateUnsolicitedSends = engineDescriptor.getReplicateUnsolicitedSends();
        this.sequenceUnsolicitedSends = engineDescriptor.getSequenceUnsolicitedSends();
        this.sequenceUnsolicitedWithSolicitedSends = engineDescriptor.getSequenceUnsolicitedWithSolicitedSends();
        this.dispatchSendStabilityEvents = engineDescriptor.getDispatchSendStabilityEvents();
        this.disposeOnSend = engineDescriptor.getDisposeOnSend();
        this.clusterHeartbeatInterval = engineDescriptor.getClusterHeartbeatInterval();
        this.adaptiveCommitBatchCeiling = engineDescriptor.getAdaptiveCommitBatchCeiling() > 0 ? engineDescriptor.getAdaptiveCommitBatchCeiling() : (Config.tuneForThroughput() ? 64 : 0);
        this.adaptiveCommitBatchCountdown = this.adaptiveCommitBatchCeiling;
        this.administrative = engineDescriptor.getAdministrative();
        this.stuckAlertThreshold = engineDescriptor.getStuckAlertEventThreshold() * 1000;
        switch (engineDescriptor.getInboundEventAcknowledgementPolicy()) {
            case Default: 
            case OnSendStability: {
                this.ackOnStoreCommit = false;
                break;
            }
            case OnStoreStability: {
                this.ackOnStoreCommit = true;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported InboundEventAcknowledgementPolicy: " + (Object)((Object)engineDescriptor.getInboundEventAcknowledgementPolicy()));
            }
        }
        this.duplicateChecking = engineDescriptor.getPerformDuplicateChecking();
        this.midstreamInitializationValidation = engineDescriptor.getPerformMidstreamInitializationValidation();
        this.enableSendCommitCompleteSequenceAlerts = engineDescriptor.getEnableSendCommitCompleteSequenceAlerts();
        this.setInboundMessageAsReadOnly = engineDescriptor.getSetInboundMessagesAsReadOnly();
        this.setOutboundMessageAsReadOnly = engineDescriptor.getSetOutboundMessagesAsReadOnly();
        this.recordMsgLegWaypoints = MessageLatencyManager.recordMsgLegWaypoints;
        this.recordMsgLegLatencies = MessageLatencyManager.recordMsgLegLatencies;
        this.recordMsgTypeLegLatencies = MessageLatencyManager.recordMsgTypeLegLatencies;
        this.captureMsgTypeStats = engineDescriptor.getCaptureMessageTypeStats();
        this.capturePerTxnStats = engineDescriptor.getCapturePerTransactionStats();
        this.recordTxnLegLatencies = engineDescriptor.getCaptureTransactionLatencyStats();
        this.captureEvLatencyStats = engineDescriptor.getCaptureEventLatencyStats();
        if (engineDescriptor.getReplicateInParallel() && this.haPolicy == HAPolicy.StateReplication) {
            this.tracer.log(this.tracePrefix + " replicateInParallel is not supported with StateReplication ... disabling parallel replication.", Tracer.Level.WARNING);
            engineDescriptor.setReplicateInParallel(false);
        }
        if (engineDescriptor.getReplicateInParallel() && this.adaptiveCommitBatchCeiling > 0) {
            this.tracer.log(this.tracePrefix + " replicateInParallel is not supported with adaptive commit ... disabling parallel replication.", Tracer.Level.WARNING);
            engineDescriptor.setReplicateInParallel(false);
        }
        this.replicateInParallel = engineDescriptor.getReplicateInParallel();
        this.setSupportMetadata = engineDescriptor.getSetSupportMetadata();
        this.setOutboundSequenceNumbers = engineDescriptor.getSetOutboundSequenceNumbers();
        this.syncOnInject = engineDescriptor.getSyncInjectedMessages();
        this.enableTypeBasedRouting = engineDescriptor.getEnableTypeBasedRouting();
        this.stopOnJVMShutdown = engineDescriptor.getStopOnJVMShutdown();
        this.clientBusName = engineDescriptor.getName() + CLIENT_BUS_NAME_SUFFIX;
        this.nextRequestId = new AtomicLong(1L);
        this.injectedRequestContexts = new UtlLinkedLongMap();
        this.injectedRequestContextsPool = UtlPool.create((String)"aep.injected.requestctx", (String)this.getName(), (UtlPool.Factory)new InjectedRequestContextFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
        try {
            for (String factoryClassName : engineDescriptor.getMessageFactories()) {
                this.registerFactory(MessageViewFactoryRegistry.loadViewFactory((String)factoryClassName));
            }
            for (String factoryClassName : engineDescriptor.getStateFactories()) {
                this.registerFactory(StoreObjectFactoryRegistry.loadObjectFactory((String)factoryClassName));
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.storeDescriptor = this.loadStoreDescriptor();
        this.loadBusDescriptors();
        if (messageSenders != null) {
            for (AepMessageSender messageSender : messageSenders) {
                eventHandlerContainers.add(messageSender.init(this.busDescriptors, this));
            }
        }
        if (engineDescriptor.getEnableAlertTrace()) {
            eventHandlerContainers.add(new AlertEventHandler());
        }
        this.dispatcher = AepEventDispatcher.create(this, null, eventHandlerContainers, defaultEventHandler, stateFactory);
        this.setDefaultChannelFilter();
        this.transaction = new Transaction();
        try {
            this.outboundMessagingContext = new OutboundMessagingContext();
        }
        catch (SmaException e) {
            throw new RuntimeException("Error initializing outbound messaging context: " + e.getMessage(), e);
        }
        this.preserveChannelJoinsOnStop = engineDescriptor.getPreserveChannelJoinsOnStop();
        this.schedules = new OpenLongObjectHashMap(256, 0.1, 0.5);
        this.nextScheduleId = 1L;
        this.scheduleRecoverer = new ScheduleRecoverer();
        this.cancelledSchedules = new ArrayList<AepScheduleEvent>();
        this.roleChangeSerializer = new Object();
        this.engineStartCompletionNotifier = new Object();
        this.messagingStartCompletionNotifier = new MessagingStartCompletionNotifier();
        this.engineStopCompletionNotifier = new Object();
        this.senderId = engineDescriptor.getName().hashCode();
        switch (this.emuxType) {
            case FreeThreadedSerialized: {
                this.multiplexer = EventMultiplexerFreeThreadedSerialized.create((String)engineDescriptor.getName(), (boolean)engineDescriptor.getAdministrative(), (IEventHandler)this, (Properties)engineDescriptor.getEventMultiplexerProperties());
                break;
            }
            case DedicatedThreaded: {
                this.multiplexer = EventMultiplexerSingleThreaded.create((String)engineDescriptor.getName(), (boolean)engineDescriptor.getAdministrative(), (IEventHandler)this, (Properties)engineDescriptor.getEventMultiplexerProperties());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown event multiplexer type");
            }
        }
        this.multiplexer.setAllEventDispatch(true);
        CreateStoreReturnValue ret = this.createStore();
        this.store = ret.store;
        this.flows = ret.flows;
        this.createBusConnections();
        if (!engineDescriptor.getAdministrative()) {
            this.tracer.log(engineDescriptor.toString(), Tracer.Level.CONFIG);
            if (this.tracer.getLevel().val <= Tracer.Level.CONFIG.val) {
                this.tracer.log("Bus Provider Addresses {", Tracer.Level.CONFIG);
                for (MessageBusDescriptor busDescriptor : this.busDescriptors.values()) {
                    if (AepEngine.isBusBindingInternal(busDescriptor.getName())) continue;
                    try {
                        this.tracer.log("..." + busDescriptor.getName() + ": " + busDescriptor.getProviderConfigAsAddressDescriptor().toPasswordSanitizedFullString(), Tracer.Level.CONFIG);
                    }
                    catch (Throwable thrown) {
                        this.tracer.log("..." + busDescriptor.getName() + ": Provide address error: " + thrown.getMessage(), Tracer.Level.WARNING);
                    }
                }
            }
            this.tracer.log("}", Tracer.Level.CONFIG);
            if (Config.tuneForLatency()) {
                this.tracer.log("...PERFORMANCE TUNED FOR..................LATENCY", Tracer.Level.CONFIG);
            } else if (Config.tuneForThroughput()) {
                this.tracer.log("...PERFORMANCE TUNED FOR..................THROUGHPUT", Tracer.Level.CONFIG);
            } else {
                this.tracer.log("...PERFORMANCE TUNED FOR..................NONE", Tracer.Level.CONFIG);
            }
            this.tracer.log("...CHECKED OPERATION IS..................." + (Config.checked() ? "ON" : "OFF"), Tracer.Level.CONFIG);
            this.tracer.log("...MEMORY CONSERVATION IS................." + (Config.conserveMemory() ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
            this.tracer.log("......MESSAGE DATA STORAGE POLICY........." + AdmRuntime.getDataStoragePolicyForMessages(null), Tracer.Level.CONFIG);
            this.tracer.log("......STATE DATA STORAGE POLICY..........." + AdmRuntime.getDataStoragePolicyForState(null), Tracer.Level.CONFIG);
            this.tracer.log("...CPU CONSERVATION IS...................." + (Config.conserveCPU() ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
            this.tracer.log("...NATIVE NETWORK IO IS..................." + (EmxNioTcpNwLnkPeerEndpoint.isNativeNetworkIOEnabled() ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
            this.tracer.log("...NATIVE FILE IO IS......................" + (UtlFile.isNativeFileIOEnabled() ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
            this.tracer.log("...NATIVE TIME IS........................." + (UtlTime.isNativeTimeEnabled() ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
            this.tracer.log("...POOL LOCKING STRATEGY IS..............." + UtlPool.getLockingStrategy(), Tracer.Level.CONFIG);
            this.tracer.log("...POOL DETACHED WASH IS.................." + (UtlPool.isDetachedWashEnabled() ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
            this.tracer.log("...THREAD AFFINITIZATION IS..............." + (UtlThread.cpuAffinityMasksEnabled() ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
            this.tracer.log("...THREAD WAIT STATS ARE.................." + (UtlThread.threadWaitStatsEnabled() ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
            this.tracer.log("}", Tracer.Level.CONFIG);
        }
        this.stats = new AepEngineStats(this, engineDescriptor.getName(), String.format(STATS_INTERVAL_PROPNAME, engineDescriptor.getName()), this.captureEvLatencyStats);
        this.systats = new AepSysStats(this, engineDescriptor.getName(), String.format(SYSTATS_INTERVAL_PROPNAME, engineDescriptor.getName()));
        this.state = State.Init;
        this.messagingState = MessagingState.Init;
        this.dispatchAndDisposeEvent((Event)AepEngineCreatedEvent.create(), ExceptionHandlingPolicy.TrapAndDiscard);
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Engine created successfully.", Tracer.Level.DEBUG);
        }
    }

    private final void handleEventHandlingException(Event event, Throwable e, ExceptionHandlingPolicy policy) {
        switch (policy) {
            case PassThrough: {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            case TrapAndDiscard: 
            case TrapAndFail: {
                String eventStr = null;
                try {
                    eventStr = event.toString();
                }
                catch (Throwable t) {
                    eventStr = event.getClass().getSimpleName() + "(toString() failed with: " + t.getMessage() + ")";
                }
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Application ('" + this.engineDescriptor.getName() + "') event handler faulted with error [" + e.toString() + "].\n");
                    sb.append(eventStr).append("\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    switch (policy) {
                        case TrapAndDiscard: {
                            sb.append("Ignoring...");
                            break;
                        }
                        case TrapAndFail: {
                            sb.append("Stopping engine...");
                            break;
                        }
                    }
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    if (policy != ExceptionHandlingPolicy.TrapAndFail) break;
                    this.stop(e instanceof Error ? new Exception(e) : (Exception)e, false);
                    break;
                }
                catch (Throwable thrown) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Application ('" + this.engineDescriptor.getName() + "') event handler encountered error [" + e.toString() + "] while stopping engine on event handling failure.\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)thrown));
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                }
            }
        }
    }

    private final void dispatchEvent(Event event, ExceptionHandlingPolicy policy) {
        if (this.someDebugTrace && this.evTracer.debug) {
            this.evTracer.log("<D> [" + event.getClass().getSimpleName() + "<" + event.getType() + ">]", Tracer.Level.DEBUG);
        }
        try {
            event.setSource((IEventSource)this);
            this.dispatcher.onEvent(event);
        }
        catch (Throwable e) {
            this.handleEventHandlingException(event, e, policy);
        }
    }

    private final void dispatchAndDisposeEvent(Event event, ExceptionHandlingPolicy policy) {
        try {
            this.dispatchEvent(event, policy);
        }
        finally {
            event.dispose();
        }
    }

    final void msgTrace(String prefix, IRogNode message) {
        try {
            if (this.msgTracerJson) {
                RogLogUtil.traceObjectJson((String)(this.tracePrefix + " " + prefix), (IRogNode)message, (RogLogUtil.MetadataDisplayPolicy)this.msgTracerMetadataDisplay, (boolean)this.msgTracerFilterUnsetFields, (RogLogUtil.JsonPrettyPrintStyle)this.msgTracerJsonStyle, (Tracer)this.msgTracer, (Tracer.Level)Tracer.Level.DEBUG);
            } else {
                if (this.msgTracerMetadataDisplay != RogLogUtil.MetadataDisplayPolicy.Off) {
                    this.msgTracer.log(this.tracePrefix + " " + message.metadataToString(), Tracer.Level.DEBUG);
                }
                if (this.msgTracerMetadataDisplay != RogLogUtil.MetadataDisplayPolicy.Only) {
                    this.msgTracer.log(this.tracePrefix + " " + message.toString(), Tracer.Level.DEBUG);
                }
            }
        }
        catch (Throwable e) {
            IRogMessage trigger = this.activeMessage;
            if (message instanceof IRogMessage) {
                trigger = (IRogMessage)message;
            }
            this.dispatchAndDisposeEvent((Event)AepMessageTraceLoggingExceptionEvent.create(prefix + " Message Trace Logging", e, trigger), ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AepEngineStats.MessageTypeStats getMessageTypeStats(MessageView message, boolean forLatencies) {
        if (forLatencies ? this.recordMsgTypeLegLatencies : this.captureMsgTypeStats) {
            AepEngineStats.MessageTypeStats typeStats = null;
            int key = message.getVfid() << 16 | message.getMessageType();
            typeStats = (AepEngineStats.MessageTypeStats)this.stats.msgTypeStatsTable.get(key);
            if (typeStats == null) {
                typeStats = this.stats.newMessageTypeStats(message.getClass().getSimpleName(), key, message.getMessageType(), message.getVfid());
                OpenIntObjectHashMap openIntObjectHashMap = this.stats.msgTypeStatsTable;
                synchronized (openIntObjectHashMap) {
                    this.stats.msgTypeStatsTable.put(key, (Object)typeStats);
                }
            }
            return typeStats;
        }
        return null;
    }

    private final boolean serverProviderExists() {
        try {
            return MessagingProviderRegistry.getInstance().getProvider("server") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private final MessageBusDescriptor addDefaultChannel(MessageBusDescriptor busDescriptor) {
        MessageChannelDescriptor channelDescriptor = busDescriptor.getChannel(DEFAULT_CHANNEL_NAME);
        if (channelDescriptor == null) {
            channelDescriptor = MessageChannelDescriptor.create((String)DEFAULT_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
            busDescriptor.addChannel(channelDescriptor);
            channelDescriptor.setChannelQos(MessageChannel.Qos.Guaranteed);
        }
        channelDescriptor.setChannelId((short)32766);
        String channelKeySuffix = "${#mt}";
        String channelKey = channelDescriptor.getChannelKey();
        channelDescriptor.setChannelKey((channelKey == null || channelKey.contains("${#mt}") ? "" : channelKey + "/") + "${#mt}");
        this.engineDescriptor.addChannel(busDescriptor.getName(), DEFAULT_CHANNEL_NAME, AepEngineDescriptor.ChannelConfig.from("join=true"));
        return busDescriptor;
    }

    private final String prepareDefaultChannelMessageTypeElementFilter() {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Preparing default channel message type filter {", Tracer.Level.DEBUG);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DEFAULT_CHANNEL_KEY_MESSAGE_TYPE_ELEMENT).append("=");
        boolean first = true;
        for (Class<? extends IRogMessage> c : this.dispatcher.getHandledMessageClasses()) {
            XString globalType = this.getMessageGlobalType(c);
            if (globalType != null) {
                if (!first) {
                    sb.append('|');
                }
                sb.append(globalType.toString());
                first = false;
                if (!this.someDebugTrace || !this.tracer.debug) continue;
                this.tracer.log(this.tracePrefix + " ..." + c.getSimpleName() + " [global type = " + globalType + "]", Tracer.Level.DEBUG);
                continue;
            }
            if (!this.someDebugTrace || !this.tracer.debug) continue;
            this.tracer.log(this.tracePrefix + " ..." + c.getSimpleName() + " [X (no registered global type)]", Tracer.Level.DEBUG);
        }
        if (first) {
            sb.append("none");
        }
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " }", Tracer.Level.DEBUG);
        }
        String filter = sb.toString();
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Prepared filter [" + filter + "]", Tracer.Level.DEBUG);
        }
        return filter;
    }

    private final void setDefaultChannelFilter() {
        if (this.enableTypeBasedRouting) {
            try {
                String messageTypeElementFilter = this.prepareDefaultChannelMessageTypeElementFilter();
                for (MessageBusDescriptor busDescriptor : this.busDescriptors.values()) {
                    MessageChannelDescriptor channelDescriptor;
                    String channelFilter;
                    if (AepEngine.isBusBindingInternal(busDescriptor.getName()) || this.clientBusName.equals(busDescriptor.getName()) || (channelFilter = (channelDescriptor = busDescriptor.getChannel(DEFAULT_CHANNEL_NAME)).getChannelFilter()) != null && channelFilter.contains("#mt=")) continue;
                    channelDescriptor.setChannelFilter(channelFilter == null ? messageTypeElementFilter : messageTypeElementFilter + ";" + channelFilter);
                    busDescriptor.save(this.engineDescriptor.getName());
                }
            }
            catch (SmaException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final void loadBusDescriptors() {
        String error;
        Set<String> busNames;
        block22: {
            if (MessageBusDescriptor.exists((String)this.clientBusName)) {
                try {
                    MessageBusDescriptor clientBusDescriptor = MessageBusDescriptor.load((String)this.clientBusName);
                    if (clientBusDescriptor == null) break block22;
                    try {
                        clientBusDescriptor.getProviderConfigAsAddressDescriptor();
                        try {
                            AepEngine.configureClientBusDescriptor(clientBusDescriptor, this.engineDescriptor.getName(), null, null);
                            clientBusDescriptor.save();
                        }
                        catch (SmaException e) {
                            String error2 = e.getMessage() == null ? e.toString() : e.getMessage();
                            this.tracer.log(this.tracePrefix + " Failed to configure client bus '" + this.clientBusName + "' [" + error2 + "]", Tracer.Level.SEVERE);
                            throw new RuntimeException(e);
                        }
                        this.engineDescriptor.addChannel(this.clientBusName, CLIENT_BUS_REQUESTS_CHANNEL_NAME, AepEngineDescriptor.ChannelConfig.from("join=true"));
                        this.engineDescriptor.addChannel(this.clientBusName, CLIENT_BUS_RESPONSES_CHANNEL_NAME, AepEngineDescriptor.ChannelConfig.from("join=false"));
                        if (this.someDebugTrace && this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + " Configured client bus '" + this.clientBusName + "'.", Tracer.Level.DEBUG);
                        }
                    }
                    catch (SmaException e) {
                        this.tracer.log(this.tracePrefix + " Provider has not been configured for the client bus '" + this.clientBusName + "'", Tracer.Level.SEVERE);
                        throw new RuntimeException(e);
                    }
                }
                catch (SmaException e) {
                    String error3 = e.getMessage() == null ? e.toString() : e.getMessage();
                    this.tracer.log(this.tracePrefix + " Failed to load bus '" + this.clientBusName + "' [" + error3 + "]", Tracer.Level.SEVERE);
                    throw new RuntimeException(e);
                }
            }
        }
        if ((busNames = this.engineDescriptor.getBuses()).size() > 0) {
            for (String busName : busNames) {
                try {
                    String userName = this.engineDescriptor.getName();
                    Properties busProperties = this.engineDescriptor.getBusConnectionProperties(busName);
                    if (busProperties != null) {
                        userName = busProperties.getProperty("user_name", userName);
                    }
                    MessageBusDescriptor busDescriptor = MessageBusDescriptor.load((String)busName, (String)userName);
                    if (this.enableTypeBasedRouting && !AepEngine.isBusBindingInternal(busName) && !this.clientBusName.equals(busName)) {
                        this.addDefaultChannel(busDescriptor).save(this.engineDescriptor.getName());
                        if (this.someDebugTrace && this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + " Added default channel to '" + busName + "' bus.", Tracer.Level.DEBUG);
                        }
                    }
                    this.busDescriptors.put(busDescriptor.getName(), busDescriptor);
                    if (!this.someDebugTrace || !this.tracer.debug) continue;
                    this.tracer.log(this.tracePrefix + " Loaded bus '" + busName + "'.", Tracer.Level.DEBUG);
                }
                catch (SmaException e) {
                    String error4 = e.getMessage() == null ? e.toString() : e.getMessage();
                    this.tracer.log(this.tracePrefix + " Failed to load bus '" + busName + "' [" + error4 + "]", Tracer.Level.WARNING);
                }
            }
        }
        if (this.serverProviderExists()) {
            MessageBusDescriptor directBusDescriptor = MessageBusDescriptor.create((String)DIRECT_BUS_NAME);
            try {
                directBusDescriptor.setProviderConfig("server://.&enable_concurrent_sends=true");
            }
            catch (SmaException e) {
                error = e.getMessage() == null ? e.toString() : e.getMessage();
                this.tracer.log(this.tracePrefix + " Failed to localize direct bus '" + DIRECT_BUS_NAME + "' [" + error + "]", Tracer.Level.SEVERE);
                throw new RuntimeException(e);
            }
            this.busDescriptors.put(directBusDescriptor.getName(), directBusDescriptor);
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Created direct bus '" + DIRECT_BUS_NAME + "'.", Tracer.Level.DEBUG);
            }
        }
        MessageBusDescriptor controlBusDescriptor = MessageBusDescriptor.create((String)CONTROL_BUS_NAME);
        controlBusDescriptor.addChannel(MessageChannelDescriptor.create((String)"nil", (MessageBusDescriptor)controlBusDescriptor));
        try {
            controlBusDescriptor.setProviderConfig("nil://.");
        }
        catch (SmaException e) {
            error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log(this.tracePrefix + " Failed to localize control bus '" + CONTROL_BUS_NAME + "' [" + error + "]", Tracer.Level.SEVERE);
            throw new RuntimeException(e);
        }
        this.busDescriptors.put(controlBusDescriptor.getName(), controlBusDescriptor);
        this.engineDescriptor.addChannel(CONTROL_BUS_NAME, "nil", AepEngineDescriptor.ChannelConfig.from("join=false"));
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Created control bus '" + CONTROL_BUS_NAME + "'.", Tracer.Level.DEBUG);
        }
    }

    private final Map<String, AepEngineDescriptor.ChannelConfig> prepareChannelConfig(MessageBusDescriptor busDescriptor) {
        Map<String, AepEngineDescriptor.ChannelConfig> busChannels;
        Map<String, AepEngineDescriptor.ChannelConfig> globalChannels;
        HashMap<String, AepEngineDescriptor.ChannelConfig> channels = new HashMap<String, AepEngineDescriptor.ChannelConfig>();
        if (!AepEngine.isBusBindingInternal(busDescriptor.getName()) && (globalChannels = this.getDescriptor().getChannels("$global$")) != null) {
            for (String channelName : globalChannels.keySet()) {
                channels.put(channelName, globalChannels.get(channelName));
            }
        }
        if ((busChannels = this.getDescriptor().getChannels(busDescriptor.getName())) != null) {
            for (String channelName : busChannels.keySet()) {
                channels.put(channelName, busChannels.get(channelName));
            }
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createBusConnections() {
        int id = 0;
        for (MessageBusDescriptor busDescriptor : this.busDescriptors.values()) {
            boolean isInternal = AepEngine.isBusBindingInternal(busDescriptor.getName());
            AepBusConnection busConnection = null;
            try {
                Properties props = this.engineDescriptor.getBusConnectionProperties(busDescriptor.getName());
                props = props == null ? new Properties() : props;
                props.setProperty("administrative", this.administrative || isInternal ? "true" : "false");
                props.setProperty("reconnect_on_fail", this.getMessageBusBindingFailPolicy() == MessageBusBindingFailPolicy.Reconnect ? "true" : "false");
                props.setProperty("send_exception_handling_policy", this.getMessageSendExceptionHandlingPolicy().toString());
                busConnection = AepBusConnection.create(this.getName(), id++, busDescriptor, this.prepareChannelConfig(busDescriptor), new BusConnectionEventHandler(props), this.outboundMessagingContext, props, new BusConnectionMessageTracer(), this.tracePrefix);
                AepBusBindingCreatedEvent bindingCreatedEvent = AepBusBindingCreatedEvent.create(busDescriptor.getName());
                try {
                    this.onBusBindingCreated(bindingCreatedEvent);
                }
                finally {
                    bindingCreatedEvent.dispose();
                }
            }
            catch (Exception e) {
                this.tracer.log(this.tracePrefix + " Failed to create bus connection for bus ('" + busDescriptor.getName() + "') [" + e.toString() + "]", Tracer.Level.SEVERE);
                this.onBusBindingCreateFailed(AepBusBindingCreateFailedEvent.create(busDescriptor.getName(), e));
            }
            if (busConnection == null) continue;
            this.busConnections.put(busDescriptor.getName(), busConnection);
            this.busConnectionList.add(busConnection);
            if (!AepEngine.isBusBindingInternal(busDescriptor.getName())) continue;
            this.internalBusConnections.put(busDescriptor.getName(), busConnection);
        }
    }

    private final StoreDescriptor loadStoreDescriptor() {
        String storeName = this.engineDescriptor.getStore();
        if (storeName != null && StoreDescriptor.exists((String)storeName)) {
            try {
                StoreDescriptor storeDescriptor = StoreDescriptor.load((String)storeName);
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Loaded engine store '" + storeName + "'.", Tracer.Level.DEBUG);
                }
                return storeDescriptor;
            }
            catch (OdsException e) {
                String error = e.getMessage() == null ? e.toString() : e.getMessage();
                this.tracer.log(this.tracePrefix + " Failed to load engine store '" + storeName + "' [" + error + "]", Tracer.Level.WARNING);
            }
        }
        return null;
    }

    private final void checkAndUpdateReplicatorDescriptor() throws Exception {
        if (this.storeDescriptor.getReplicator() != null && this.stopOnJVMShutdown) {
            StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.load((String)this.storeDescriptor.getReplicator());
            if (replicatorDescriptor != null) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Suppressing use of shutdown hook by store discovery", Tracer.Level.DEBUG);
                }
                replicatorDescriptor.setProperty("suppressDiscoveryShutdownHook", "true");
                replicatorDescriptor.save();
            } else {
                throw new EAepException("invalid replicator '" + this.storeDescriptor.getReplicator() + "' configured for store");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final CreateStoreReturnValue createStore() {
        CreateStoreReturnValue ret = new CreateStoreReturnValue();
        if (this.storeDescriptor != null) {
            String memberName = null;
            try {
                this.checkAndUpdateReplicatorDescriptor();
                int flags = 2 | (this.haPolicy == HAPolicy.EventSourcing ? 1 : 0);
                if (this.haPolicy == HAPolicy.EventSourcing) {
                    ret.store = StoreBindingFactory.getInstance().createBinding(memberName, this.storeDescriptor, (IStoreEventHandler)this, flags);
                    ret.flows = RogGraphCollection.createUnbackedCollection((int)1024);
                } else {
                    ret.flows = RogGraphCollection.create(memberName, (StoreDescriptor)this.storeDescriptor, (IStoreEventHandler)this, (int)flags, (int)1024);
                    ret.store = ret.flows.getStore();
                    if (ret.store != null) {
                        ret.store.setQueryAPICallerContext(new IQueryAPICallerContext(){

                            public void checkAPIContextValid() {
                                if (!AepEngine.this.isDispatchThread()) {
                                    throw new IllegalStateException("This operation can only be called from an engine dispatch thread [current thread = '" + Thread.currentThread().getName() + "']");
                                }
                            }
                        });
                    }
                    if (this.someDebugTrace && this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + " Created new flow collection (store=" + ret.store + ").", Tracer.Level.DEBUG);
                    }
                }
                if (!this.someDebugTrace || !this.tracer.debug) return ret;
                this.tracer.log(this.tracePrefix + " Created engine store '" + this.storeDescriptor.getName() + "' (member id='" + memberName + "').", Tracer.Level.DEBUG);
                return ret;
            }
            catch (Exception e) {
                String error = e.getMessage() == null ? e.toString() : e.getMessage();
                this.tracer.log(this.tracePrefix + " Failed to create engine store '" + this.storeDescriptor.getName() + "' (member id='" + memberName + "') [" + error + "].", Tracer.Level.WARNING);
                throw new RuntimeException(e);
            }
        } else {
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " No engine store to create, creating unbacked flow collection.", Tracer.Level.DEBUG);
            }
            ret.flows = RogGraphCollection.createUnbackedCollection((int)1024);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void openStore(Map<IStoreBinding.StartupExpectation, Enum<?>> expectations) throws EAepException {
        if (this.storeDescriptor != null) {
            try {
                this.store.open(expectations);
                if (!this.someDebugTrace || !this.tracer.debug) return;
                this.tracer.log(this.tracePrefix + " Opened engine store.", Tracer.Level.DEBUG);
                return;
            }
            catch (Exception e) {
                String error = e.getMessage() == null ? e.toString() : e.getMessage();
                this.tracer.log(this.tracePrefix + " Failed to open engine store '" + this.storeDescriptor.getName() + "' [" + error + "].", Tracer.Level.WARNING);
                if (!(e instanceof OdsExpectationNotMetException)) throw new EAepException(e);
                throw this.storeToAepExpectationNotMetException((OdsExpectationNotMetException)e);
            }
        } else {
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " No engine store to open.", Tracer.Level.DEBUG);
            }
            if (expectations == null) return;
            for (IStoreBinding.StartupExpectation expectation : expectations.keySet()) {
                Enum<?> value = expectations.get(expectation);
                switch (expectation) {
                    case Role: {
                        if (!(value instanceof IStoreBinding.Role)) throw new EAepException("role expectation must of type IStoreBinding.Role");
                        if ((IStoreBinding.Role)value != IStoreBinding.Role.Backup) break;
                        throw new EAepExpectationNotMetException(StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Backup, null, "mismatch startup role expectation (expected=backup, actual=standalone)");
                    }
                }
            }
        }
    }

    private final void closeStore(Exception cause, boolean preserveChannelJoins) {
        if (this.store != null) {
            try {
                int flags = 1;
                if (cause != null || preserveChannelJoins) {
                    flags |= 2;
                }
                this.store.close(flags);
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Closed engine store '" + this.storeDescriptor.getName() + "' (cause=" + (cause != null ? cause.toString() : "null") + ").", Tracer.Level.DEBUG);
                }
            }
            catch (Exception e) {
                String error = e.getMessage() == null ? e.toString() : e.getMessage();
                this.tracer.log(this.tracePrefix + " Failed to close engine store '" + this.storeDescriptor.getName() + "' [" + error + "]", Tracer.Level.WARNING);
                e.printStackTrace();
            }
        }
    }

    private final void openInboundMessageLogger() throws EAepException {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Initializing inbound message logger...", Tracer.Level.DEBUG);
        }
        switch (this.inboundMessageLoggingPolicy) {
            case Off: {
                if (!this.someDebugTrace || !this.tracer.debug) break;
                this.tracer.log(this.tracePrefix + " ...inbound message logging is Off", Tracer.Level.DEBUG);
                break;
            }
            case UseDedicated: {
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " ...creating the inbound message logger", Tracer.Level.DEBUG);
                }
                try {
                    this.engineDescriptor.getInboundMessageLoggingProperties().setProperty("autoRepair", "true");
                    this.inboundMessageLogger = RogMessageLog.create((String)(this.engineDescriptor.getName() + ".in"), (Properties)this.engineDescriptor.getInboundMessageLoggingProperties());
                    this.inboundMessageLogger.open();
                    break;
                }
                catch (Exception e) {
                    throw new EAepException(e);
                }
            }
        }
    }

    private final void openOutboundMessageLogger() throws EAepException {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Initializing outbound message logger...", Tracer.Level.DEBUG);
        }
        switch (this.outboundMessageLoggingPolicy) {
            case Off: {
                if (!this.someDebugTrace || !this.tracer.debug) break;
                this.tracer.log(this.tracePrefix + " ...outbound message logging is off (configured to be Off)", Tracer.Level.DEBUG);
                break;
            }
            case UseDedicated: {
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " ...creating the outbound message logger", Tracer.Level.DEBUG);
                }
                try {
                    this.engineDescriptor.getOutboundMessageLoggingProperties().setProperty("autoRepair", "true");
                    this.outboundMessageLogger = RogMessageLog.create((String)(this.engineDescriptor.getName() + ".out"), (Properties)this.engineDescriptor.getOutboundMessageLoggingProperties());
                    this.outboundMessageLogger.open();
                    break;
                }
                catch (Exception e) {
                    throw new EAepException(e);
                }
            }
        }
    }

    private final void openPerTransactionStatsLogger() throws EAepException {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Initializing per transaction stats logger...", Tracer.Level.DEBUG);
        }
        switch (this.perTransactionStatsLoggingPolicy) {
            case Off: {
                if (!this.someDebugTrace || !this.tracer.debug) break;
                this.tracer.log(this.tracePrefix + " ...per transaction stats logging is off (configured to be Off)", Tracer.Level.DEBUG);
                break;
            }
            case UseDedicated: {
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " ...creating the per transaction stats logger", Tracer.Level.DEBUG);
                }
                try {
                    this.engineDescriptor.getPerTransactionStatsLoggingProperties().setProperty("autoRepair", "true");
                    this.perTransactionStatsLogger = RogMessageLog.create((String)(this.engineDescriptor.getName() + ".txnstats"), (Properties)this.engineDescriptor.getPerTransactionStatsLoggingProperties());
                    this.perTransactionStatsLogger.open();
                    break;
                }
                catch (Exception e) {
                    throw new EAepException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void handleOutboundMessageLoggerException(Throwable e, MessageView triggeringMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to log an outbound message [" + e.getMessage() + "].\n");
        sb.append("Stack trace:\n");
        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
        this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        this.dispatchAndDisposeEvent((Event)AepOutboundLogExceptionEvent.create(e, null), ExceptionHandlingPolicy.TrapAndDiscard);
        switch (this.outboundMessageLoggingFailurePolicy) {
            case StopLogging: {
                this.tracer.log("Outbound message logging failure policy is StopLogging, closing outbound log.", Tracer.Level.SEVERE);
                this.outboundMessageLogger.close();
                this.outboundMessageLogger = null;
                try {
                    this.outboundMessagingContext.clearLogQueue(false);
                }
                catch (Throwable thrown) {
                    this.tracer.log("Error cleaning up outbound log queue: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
                }
                break;
                catch (Throwable thrown) {
                    try {
                        this.tracer.log("Failed to cleanly close outbound message logger after failure (will ignore): " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                        this.dispatchAndDisposeEvent((Event)AepOutboundLogExceptionEvent.create(new RuntimeException("Failed to cleanly close outbound message logger after failure: " + thrown.getMessage(), thrown), triggeringMessage), ExceptionHandlingPolicy.TrapAndDiscard);
                        this.outboundMessageLogger = null;
                    }
                    catch (Throwable throwable) {
                        this.outboundMessageLogger = null;
                        try {
                            this.outboundMessagingContext.clearLogQueue(false);
                        }
                        catch (Throwable thrown2) {
                            this.tracer.log("Error cleaning up outbound log queue: " + UtlThrowable.prepareStackTrace((Throwable)thrown2), Tracer.Level.WARNING);
                        }
                        throw throwable;
                    }
                    try {
                        this.outboundMessagingContext.clearLogQueue(false);
                    }
                    catch (Throwable thrown3) {
                        this.tracer.log("Error cleaning up outbound log queue: " + UtlThrowable.prepareStackTrace((Throwable)thrown3), Tracer.Level.WARNING);
                    }
                    break;
                }
            }
            case StopEngine: {
                this.tracer.log("Outbound message logging failure policy is StopEngine, stopping engine.", Tracer.Level.SEVERE);
                RuntimeException failure = new RuntimeException("Outbound logging failed with a failure policy of StopEngine, cause [" + e.getMessage() + "]", e);
                this.stop(failure, false);
                throw failure;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInboundMessageLoggerException(Throwable e, MessageView triggeringMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to log an inbound message [" + e.toString() + "].\n");
        sb.append("Stack trace:\n");
        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
        this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        this.dispatchAndDisposeEvent((Event)AepInboundLogExceptionEvent.create(e, triggeringMessage), ExceptionHandlingPolicy.TrapAndDiscard);
        switch (this.inboundMessageLoggingFailurePolicy) {
            case StopLogging: {
                this.tracer.log("Inbound message logging failure policy is StopLogging, closing inbound log.", Tracer.Level.SEVERE);
                try {
                    this.inboundMessageLogger.close();
                    break;
                }
                catch (Throwable thrown) {
                    this.tracer.log("Failed to cleanly close inbound message logger after failure (will ignore): " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    this.dispatchAndDisposeEvent((Event)AepInboundLogExceptionEvent.create(new RuntimeException("Failed to cleanly close inbound message logger after failure: " + thrown.getMessage(), thrown), triggeringMessage), ExceptionHandlingPolicy.TrapAndDiscard);
                    break;
                }
                finally {
                    this.inboundMessageLogger = null;
                }
            }
            case StopEngine: {
                this.tracer.log("Inbound message logging failure policy is StopEngine, stopping engine.", Tracer.Level.SEVERE);
                RuntimeException failure = new RuntimeException("Inbound logging failed with a failure policy of StopEngine, cause [" + e.getMessage() + "]", e);
                this.stop(failure, false);
                throw failure;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handlePerTransactionStatsLoggerException(Throwable e, MessageView triggeringMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to log per transaction stats [" + e.getMessage() + "].\n");
        sb.append("Stack trace:\n");
        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
        this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        switch (this.perTransactionStatsLoggingFailurePolicy) {
            case StopLogging: {
                this.tracer.log("PerTransactionStatsLoggingFailurePolicy is StopLogging, closing per transaction stats log.", Tracer.Level.SEVERE);
                try {
                    this.perTransactionStatsLogger.close();
                    break;
                }
                catch (Throwable thrown) {
                    this.tracer.log("Failed to cleanly close per transaction stats logger after failure (will ignore): " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    break;
                }
                finally {
                    this.perTransactionStatsLogger = null;
                }
            }
            case StopEngine: {
                this.tracer.log("PerTransactionStatsLoggingFailurePolicy is StopEngine, stopping engine.", Tracer.Level.SEVERE);
                RuntimeException failure = new RuntimeException("Per transaction stats logging failed with a failure policy of StopEngine, cause [" + e.getMessage() + "]", e);
                this.stop(failure, false);
                throw failure;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startMessaging() throws EAepException {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Starting messaging...", Tracer.Level.DEBUG);
        }
        MessagingStartCompletionNotifier messagingStartCompletionNotifier = this.messagingStartCompletionNotifier;
        synchronized (messagingStartCompletionNotifier) {
            if ((this.state == State.Starting || this.state == State.Started) && this.messagingState == MessagingState.Init) {
                boolean failed;
                this.messagingState = MessagingState.Starting;
                Iterator<AepBusConnection> iterator = this.busConnections.values().iterator();
                EAepException status = null;
                boolean internalBindingFailed = false;
                boolean allBindingsEstablished = true;
                boolean allBindingsFailed = false;
                boolean allBindingsFailedPermanently = false;
                if (iterator.hasNext()) {
                    allBindingsFailed = this.busConnections.size() > this.internalBusConnections.size();
                    boolean bl = allBindingsFailedPermanently = this.busConnections.size() > this.internalBusConnections.size();
                    while (iterator.hasNext()) {
                        AepBusConnection busConnection = iterator.next();
                        EAepException openStatus = busConnection.openNoStart();
                        if (AepEngine.isBusBindingInternal(busConnection.getBusDescriptor().getName())) {
                            if (openStatus == null) continue;
                            status = openStatus;
                            internalBindingFailed = true;
                            break;
                        }
                        status = openStatus;
                        allBindingsFailed &= status != null;
                        allBindingsFailedPermanently &= status != null && busConnection.getState() == AepBusConnection.State.FAILED;
                        allBindingsEstablished &= status == null;
                        if (status == null || this.messagingStartFailPolicy != MessagingStartFailPolicy.FailIfOneBindingFails) continue;
                        break;
                    }
                }
                if (!(failed = internalBindingFailed)) {
                    switch (this.messagingStartFailPolicy) {
                        case NeverFail: {
                            failed = allBindingsFailedPermanently;
                            break;
                        }
                        case FailIfOneBindingFails: {
                            failed = !allBindingsEstablished;
                            break;
                        }
                        case FailIfAllBindingsFail: {
                            failed = allBindingsFailed;
                        }
                    }
                }
                this.multiplexer.multiplexEvent((Event)AepMessagingStartedEvent.create(failed ? status : null), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completeMessagingStartedEventProcessing(AepMessagingStartedEvent event) {
        Exception status = event.getStatus();
        if (status != null) {
            EAepException e = status instanceof EAepException ? (EAepException)((Object)status) : new EAepException(status);
            this.messagingStartCompletionNotifier.status(e);
            this.messagingState = MessagingState.Stopped;
        } else {
            this.messagingStartCompletionNotifier.status(null);
            this.messagingState = MessagingState.Started;
        }
        this.inMessagingStarted = true;
        try {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
            this.dispatchAndDisposeEvent((Event)(status != null ? AepMessagingStartFailedEvent.create(status) : AepEngineActiveEvent.create()), ExceptionHandlingPolicy.TrapAndDiscard);
        }
        finally {
            this.inMessagingStarted = false;
        }
        if (!this.engineDescriptor.getAdministrative() && UtlThread.cpuAffinityMasksEnabled() && this.tracer.getLevel().val <= Tracer.Level.CONFIG.val) {
            try {
                StringBuilder sb = new StringBuilder();
                UtlThread.dumpAffinitizationState((Appendable)sb, (String)"  ");
                this.tracer.log(this.tracePrefix + " Thread Affinitization State:\n" + sb, Tracer.Level.CONFIG);
            }
            catch (Throwable thrown) {
                this.tracer.log("Error getting affinization summary " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            }
        }
        this.messagingStartCompletionNotifier.notifyAll();
        if (status == null) {
            this.tracer.log(this.tracePrefix + " Messaging started.", Tracer.Level.INFO);
        } else {
            this.tracer.log(this.tracePrefix + " Messaging start failed [" + (status.getMessage() == null ? UtlThrowable.prepareStackTrace((Throwable)status) : status.getMessage()) + "].", Tracer.Level.SEVERE);
        }
    }

    private final void onMessagingStartFail(AepMessagingStartedEvent event) {
        Exception status = event.getStatus();
        Iterator<AepBusConnection> iterator = this.busConnections.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().close(status, status != null);
        }
        this.completeMessagingStartedEventProcessing(event);
        this.stop(event.getStatus(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onMessagingStarted(AepMessagingStartedEvent event) {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Completing messaging start (status=" + event.getStatus() + ")...", Tracer.Level.DEBUG);
        }
        MessagingStartCompletionNotifier messagingStartCompletionNotifier = this.messagingStartCompletionNotifier;
        synchronized (messagingStartCompletionNotifier) {
            if (this.messagingState == MessagingState.Starting) {
                boolean success;
                boolean bl = success = event.getStatus() == null;
                if (success) {
                    try {
                        this.outboundMessagingContext.retransmitOutboundQueue();
                        this.tracer.log(this.tracePrefix + " Retransmitted " + this.stats.numMsgsResent + " message" + (this.stats.numMsgsResent == 1L ? "." : "s."), Tracer.Level.INFO);
                        AepMessagingPrestartEvent prestartEvent = AepMessagingPrestartEvent.create();
                        try {
                            this.dispatchEvent((Event)prestartEvent, ExceptionHandlingPolicy.TrapAndDiscard);
                            if (prestartEvent.getFirstMessage() != null) {
                                MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)prestartEvent.getFirstMessage(), null);
                                prestartEvent.getFirstMessage().setTag(0, (Object)messageEvent);
                                this.multiplexer.multiplexEvent((Event)messageEvent, 0);
                            }
                            for (MessageView initialMessage : prestartEvent.getInitialMessages()) {
                                MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)initialMessage, null);
                                initialMessage.setTag(0, (Object)messageEvent);
                                this.multiplexer.multiplexEvent((Event)messageEvent, 0);
                            }
                        }
                        finally {
                            prestartEvent.dispose();
                        }
                        this.schedules.forEachPair((LongObjectProcedure)this.scheduleRecoverer.reset());
                        for (AepScheduleEvent scheduleEvent : this.cancelledSchedules) {
                            this.cancelAndRemoveSchedule(scheduleEvent);
                        }
                        this.tracer.log(this.tracePrefix + " Reactivated " + this.scheduleRecoverer.reactivated() + " schedule" + (this.scheduleRecoverer.reactivated() == 1 ? "." : "s."), Tracer.Level.INFO);
                        this.tracer.log(this.tracePrefix + " Cancelled " + this.cancelledSchedules.size() + " schedule" + (this.cancelledSchedules.size() == 1 ? "." : "s."), Tracer.Level.INFO);
                        this.cancelledSchedules.clear();
                        if (this.clusterHeartbeatInterval > 0) {
                            AepHeartbeatMessage heartbeatMessage = AepHeartbeatMessage.create();
                            heartbeatMessage.setAsInternal(true);
                            this.scheduleObjectOrMessageCore(heartbeatMessage, this.clusterHeartbeatInterval, AepScheduleEvent.HAPolicy.Cancel);
                        }
                        for (AepBusConnection busConnection : this.busConnections.values()) {
                            if (!busConnection.isManualStart()) {
                                if (this.someDebugTrace && this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + " Starting bus connection " + busConnection.getName() + "...", Tracer.Level.DEBUG);
                                }
                                busConnection.start();
                                continue;
                            }
                            this.tracer.log(this.tracePrefix + " Not starting bus connection " + busConnection.getName() + " (configured for manual start)", Tracer.Level.CONFIG);
                        }
                        this.completeMessagingStartedEventProcessing(event);
                    }
                    catch (Exception e) {
                        event.setStatus(e);
                        this.onMessagingStartFail(event);
                    }
                } else {
                    this.onMessagingStartFail(event);
                }
            } else {
                if (this.messagingState == MessagingState.Started) {
                    throw new InternalError("messaging state is started in the 'messaging started' event handler");
                }
                this.tracer.log(this.tracePrefix + " Messaging was stopped while 'messaging started' event was in transit", Tracer.Level.INFO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EAepException checkAndWaitForMessagingToStart() {
        if (this.messagingState == MessagingState.Init || this.messagingState == MessagingState.Starting) {
            MessagingStartCompletionNotifier messagingStartCompletionNotifier = this.messagingStartCompletionNotifier;
            synchronized (messagingStartCompletionNotifier) {
                while ((this.messagingState == MessagingState.Init || this.messagingState == MessagingState.Starting) && this.state != State.Stopped) {
                    try {
                        this.messagingStartCompletionNotifier.wait();
                        return this.messagingStartCompletionNotifier.status();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }
        return this.messagingStartCompletionNotifier.status();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopMessaging(Exception cause, boolean preserveChannelJoins) {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Stopping messaging (cause=" + (cause != null ? cause.toString() : "null") + ")...", Tracer.Level.DEBUG);
        }
        MessagingStartCompletionNotifier messagingStartCompletionNotifier = this.messagingStartCompletionNotifier;
        synchronized (messagingStartCompletionNotifier) {
            for (AepBusConnection busConnection : this.busConnections.values()) {
                busConnection.close(cause, preserveChannelJoins);
                AepBusBindingDestroyedEvent bindingDestroyedEvent = AepBusBindingDestroyedEvent.create(busConnection.getBusDescriptor().getName());
                try {
                    this.onBusBindingDestroyed(bindingDestroyedEvent);
                }
                finally {
                    bindingDestroyedEvent.dispose();
                }
            }
            this.messagingState = MessagingState.Stopped;
            this.messagingStartCompletionNotifier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAndGoActive(IStoreBinding.Role role) throws EAepException {
        Object object = this.roleChangeSerializer;
        synchronized (object) {
            if (role != this.role) {
                String roleStr;
                String string = roleStr = this.store != null ? role.toString() : "Standalone";
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Engine is " + roleStr, Tracer.Level.DEBUG);
                }
                if ((this.role = role) != IStoreBinding.Role.Backup) {
                    this.startMessaging();
                } else if (!this.engineDescriptor.getAdministrative() && UtlThread.cpuAffinityMasksEnabled() && this.tracer.getLevel().val <= Tracer.Level.CONFIG.val) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        UtlThread.dumpAffinitizationState((Appendable)sb, (String)"  ");
                        this.tracer.log(this.tracePrefix + " Thread Affinitization State:\n" + sb, Tracer.Level.CONFIG);
                    }
                    catch (Throwable thrown) {
                        this.tracer.log("Error getting affinization summary " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
                    }
                }
            }
        }
    }

    private final AepFlow getFlow(int flowid) {
        AepFlow flow;
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Getting flow (id=" + flowid + ").", Tracer.Level.DEBUG);
        }
        if (!this.enableMultipleFlows && this.singletonFlow != null) {
            flow = this.singletonFlow;
        } else {
            flow = (AepFlow)this.flows.get(flowid);
            if (flow == null) {
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " ...flow does not exist.", Tracer.Level.DEBUG);
                }
                try {
                    if (this.someDebugTrace && this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + " ...creating a new flow object...", Tracer.Level.DEBUG);
                    }
                    flow = new AepFlow(flowid);
                    this.flows.add((IRogNode)flow);
                    if (this.someDebugTrace && this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + " ...added flow to collection (store=" + flow.getBinding() + ").", Tracer.Level.DEBUG);
                    }
                    ++this.stats.numFlows;
                    this.dispatchAndDisposeEvent((Event)AepFlowCreatedEvent.create(flowid), ExceptionHandlingPolicy.TrapAndDiscard);
                }
                catch (Exception e) {
                    throw new InternalError("Failed to create a new flow object for flow <id=" + flowid + ">. [" + e.toString() + "]");
                }
            } else if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " ...flow already exists.", Tracer.Level.DEBUG);
            }
            if (flow.getAepEngine() == null) {
                flow.setAepEngine(this);
            }
            if (!this.enableMultipleFlows) {
                this.singletonFlow = flow;
            }
        }
        return flow;
    }

    /*
     * Unable to fully structure code
     */
    private final IRogNode getApplicationState(AepFlow flow, MessageView view) {
        state = flow.getApplicationState();
        if (state == null) {
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Application state does not exist. creating...", Tracer.Level.DEBUG);
            }
            if (this.stateFactory != null) {
                try {
                    state = this.stateFactory.createState(view);
                    if (!this.someDebugTrace || !this.tracer.debug) ** GOTO lbl21
                    this.tracer.log(this.tracePrefix + " ...application state factory returned '" + (state == null ? "null" : state.getClass().getName()) + "' as the flow state...", Tracer.Level.DEBUG);
                }
                catch (Throwable e) {
                    sb = new StringBuilder();
                    sb.append("Application ('" + this.engineDescriptor.getName() + "') state factory threw faulted with error [" + e.toString() + "] during state creation with the following stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    throw new RuntimeException("Application state factory threw an exception when creating a state object [" + e.toString() + "]");
                }
            } else if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " ...application does not support flow based state.", Tracer.Level.DEBUG);
            }
lbl21:
            // 5 sources

            if (state != null) {
                flow.setApplicationState(state);
                this.onApplicationStateCreated(state);
            }
        }
        return state;
    }

    private final AepFlow getFlow(MessageView view) {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Getting message's flow.", Tracer.Level.DEBUG);
        }
        AepFlow flow = this.getFlow(!this.enableMultipleFlows || view == null ? 0 : view.getMessageFlow());
        this.getApplicationState(flow, view);
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Message is in flow '" + flow.getFlowId() + "'.", Tracer.Level.DEBUG);
        }
        return flow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void onFlowEvent(MessageEvent event, long preProcessingTs, long eventReceiptTs) {
        ++this.stats.numFlowEventsRcvd;
        try {
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Dispatching event to application...", Tracer.Level.DEBUG);
            }
            this.activeMessage = (IRogMessage)event.getMessageView();
            if (!this.replicateInParallel && this.state != State.Starting && this.isPrimary()) {
                this.activeMessage.setPreProcessingTsMicros(preProcessingTs == 0L ? UtlTime.nowInMicros() : preProcessingTs);
            }
            if (!this.activeMessage.getIsInternal()) {
                IAepPostdispatchMessageHandler postdispatchMessageHandler;
                block31: {
                    IAepPredispatchMessageHandler predispatchMessageHandler = this.predispatchMessageHandler;
                    if (predispatchMessageHandler != null) {
                        predispatchMessageHandler.onMessage(this.activeMessage);
                    }
                    long ts = 0L;
                    if (this.recordMsgLegLatencies) {
                        ts = UtlTime.now();
                        if (eventReceiptTs > 0L) {
                            this.stats.msgPreProcessingLatencies.add((double)(ts - eventReceiptTs));
                        }
                    }
                    try {
                        this.dispatchEvent((Event)event, ExceptionHandlingPolicy.PassThrough);
                        if (!this.recordMsgLegLatencies) break block31;
                    }
                    catch (Throwable throwable) {
                        if (!this.recordMsgLegLatencies) throw throwable;
                        long now = this.transaction.postLastMessageProcessingTs = UtlTime.now();
                        this.stats.msgProcessingLatencies.add((double)(now - ts));
                        AepEngineStats.MessageTypeStats typeStats = this.getMessageTypeStats((MessageView)this.activeMessage, true);
                        if (typeStats == null) throw throwable;
                        if (event.getOfferTs() > 0L) {
                            if (typeStats.msgCreateToOfferLatencies != null && this.activeMessage.getCreateTs() > 0L) {
                                typeStats.msgCreateToOfferLatencies.add((double)(event.getOfferTs() - this.activeMessage.getCreateTs()));
                            }
                            if (typeStats.msgOfferToPollLatencies != null && event.getPollTs() > 0L) {
                                typeStats.msgOfferToPollLatencies.add((double)(event.getPollTs() - event.getOfferTs()));
                            }
                        }
                        if (typeStats.msgPreProcessingLatencies != null && eventReceiptTs > 0L) {
                            typeStats.msgPreProcessingLatencies.add((double)(ts - eventReceiptTs));
                        }
                        if (typeStats.msgProcessingLatencies == null) throw throwable;
                        typeStats.msgProcessingLatencies.add((double)(now - ts));
                        throw throwable;
                    }
                    long now = this.transaction.postLastMessageProcessingTs = UtlTime.now();
                    this.stats.msgProcessingLatencies.add((double)(now - ts));
                    AepEngineStats.MessageTypeStats typeStats = this.getMessageTypeStats((MessageView)this.activeMessage, true);
                    if (typeStats != null) {
                        if (event.getOfferTs() > 0L) {
                            if (typeStats.msgCreateToOfferLatencies != null && this.activeMessage.getCreateTs() > 0L) {
                                typeStats.msgCreateToOfferLatencies.add((double)(event.getOfferTs() - this.activeMessage.getCreateTs()));
                            }
                            if (typeStats.msgOfferToPollLatencies != null && event.getPollTs() > 0L) {
                                typeStats.msgOfferToPollLatencies.add((double)(event.getPollTs() - event.getOfferTs()));
                            }
                        }
                        if (typeStats.msgPreProcessingLatencies != null && eventReceiptTs > 0L) {
                            typeStats.msgPreProcessingLatencies.add((double)(ts - eventReceiptTs));
                        }
                        if (typeStats.msgProcessingLatencies != null) {
                            typeStats.msgProcessingLatencies.add((double)(now - ts));
                        }
                    }
                }
                if (!event.isHandled()) {
                    this.dispatchAndDisposeEvent((Event)AepUnhandledMessageEvent.create(event), ExceptionHandlingPolicy.TrapAndDiscard);
                }
                if ((postdispatchMessageHandler = this.postdispatchMessageHandler) != null) {
                    postdispatchMessageHandler.postMessage(this.activeMessage);
                }
                ++this.stats.numFlowEventsProcSuccess;
                return;
            }
            if (this.activeMessage.getVfid() != 33) return;
            switch (this.activeMessage.getMessageType()) {
                case 1: {
                    this.onHeartbeatMessage((AepHeartbeatMessage)this.activeMessage);
                    return;
                }
                case 6: {
                    this.onShutdownMessage((AepShutdownMessage)this.activeMessage);
                    return;
                }
            }
            return;
        }
        catch (Throwable e) {
            ++this.stats.numFlowEventsProcFail;
            this.handleAppMessageHandlingException("message handler", event, e);
            return;
        }
        finally {
            this.activeMessage.setTag(0, null);
            this.activeMessage.setTag(3, null);
            this.activeMessage.setTag(1, null);
            this.activeMessage.setTag(4, null);
            this.activeMessage.setPostProcessingTsMicros(UtlTime.nowInMicros());
            if (Config.conserveMemory()) {
                this.activeMessage.saveMemory();
            }
            this.activeMessage = null;
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Event dispatch is complete.", Tracer.Level.DEBUG);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleAppMessageHandlingException(String operation, MessageEvent event, Throwable e) {
        block16: {
            MessageView view = event.getMessageView();
            StringBuilder sb = new StringBuilder();
            sb.append("Application ('" + this.engineDescriptor.getName() + "') " + operation + " faulted with error [" + e.toString() + "].\n");
            sb.append("Stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            AppExceptionHandlingPolicy policy = this.appExceptionHandlingPolicy;
            if (e instanceof Error && policy == AppExceptionHandlingPolicy.LogExceptionAndContinue) {
                sb.append("Policy is LogExceptionAndContinue but application exception is an Error. Switching to RollbackAndStop...\n");
                policy = AppExceptionHandlingPolicy.RollbackAndStop;
            }
            this.inAppExceptionHandler = true;
            try {
                if (this.state == State.Starting || this.role == IStoreBinding.Role.Backup) {
                    switch (policy) {
                        case LogExceptionAndContinue: {
                            sb.append("Logging exception and continuing...\n");
                            break block16;
                        }
                        default: {
                            sb.append("In 'Starting' state or in Backup. Engine will shutdown...\n");
                            throw new RuntimeException(sb.toString(), e);
                        }
                    }
                }
                try {
                    switch (policy) {
                        case LogExceptionAndContinue: {
                            sb.append("Logging exception and continuing...\n");
                            break;
                        }
                        case RollbackAndStop: {
                            sb.append("Rolling back current transaction...\n");
                            event.setAutoAck(false);
                            this.transaction.rollback();
                            sb.append("Waiting for prior transactions to complete and stopping engine...\n");
                            this.setAsLastTransactionCore(new EAepAppException(e), true, false, true);
                            break;
                        }
                        default: {
                            throw new EAepException("unknown application exception handling policy '" + (Object)((Object)policy) + "'");
                        }
                    }
                }
                catch (Throwable e1) {
                    sb.append("FATAL: App exception handling code threw an exception...\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e1));
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    throw new RuntimeException("App exception handling code threw an exception: " + e.getLocalizedMessage(), e);
                }
            }
            finally {
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                if (view instanceof IRogMessage) {
                    this.dispatchAndDisposeEvent((Event)AepApplicationExceptionEvent.create(e, (IRogMessage)view), ExceptionHandlingPolicy.TrapAndDiscard);
                } else {
                    this.dispatchAndDisposeEvent((Event)AepApplicationExceptionEvent.create(e, null), ExceptionHandlingPolicy.TrapAndDiscard);
                }
                this.inAppExceptionHandler = false;
            }
        }
    }

    private final void onApplicationStateCreated(IRogNode state) {
        this.dispatchAndDisposeEvent((Event)AepStateCreatedEvent.create(state), ExceptionHandlingPolicy.TrapAndDiscard);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setAsLastTransactionCore(Exception cause, boolean ignoreIfStarting, boolean shutdownCluster, boolean shutdownAfterThisTransaction) {
        if (this.state == State.Started) {
            if (this.activeThread != Thread.currentThread() || this.activeMessage == null && !this.inAppExceptionHandler) throw new IllegalStateException("invoked from outside of a message handler");
            if (!this.isPrimary() && !shutdownAfterThisTransaction) return;
            if (this.lastTransactionContext == null) {
                this.lastTransactionContext = new LastTransactionContext();
            }
            this.lastTransactionContext.init(this.transaction.id(), cause, shutdownCluster, shutdownAfterThisTransaction);
            if (this.activeMessage != null && shutdownAfterThisTransaction) {
                this.activeMessage.setAsLastTransaction(true);
            }
            if (this.haPolicy == HAPolicy.StateReplication && shutdownCluster && shutdownAfterThisTransaction) {
                AepShutdownMessage shutdownMessage = AepShutdownMessage.create();
                shutdownMessage.setAsInternal(true);
                shutdownMessage.setAsLastTransaction(true);
                if (cause != null) {
                    shutdownMessage.setCause(cause.getMessage() != null ? cause.getMessage() : cause.toString());
                }
                shutdownMessage.setShutdownCluster(true);
                this.sendMessage(this.controlChannel, shutdownMessage);
            }
            if (!this.someDebugTrace || !this.tracer.debug) return;
            if (this.lastTransactionContext.shutdownAfterThisTransaction) {
                this.tracer.log(this.tracePrefix + " Set #" + this.lastTransactionContext.transactionId + " as last transaction", Tracer.Level.DEBUG);
                return;
            } else {
                this.tracer.log(this.tracePrefix + " Set #" + this.lastTransactionContext.transactionId + " as penultimate transaction", Tracer.Level.DEBUG);
            }
            return;
        } else {
            if (ignoreIfStarting && this.state == State.Starting) return;
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
    }

    private final void activateSchedule(AepScheduleEvent event) {
        if (event.getState() != AepScheduleEvent.State.NotActivated) {
            throw new InternalError("attempt to activate an already activated schedule");
        }
        if (this.state == State.Started && this.isPrimary()) {
            this.scheduleScheduleActivateMessage(event);
        }
    }

    private final void cancelAndRemoveSchedule(AepScheduleEvent event) {
        event.setState(AepScheduleEvent.State.Cancelled);
        this.schedules.removeKey(event.getId());
        event.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onScheduleIntervalExpiry(AepScheduleEvent event, IRogMessage message) {
        IRogMessage messageToDispatch = event.getMessage();
        if (messageToDispatch != null) {
            MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)messageToDispatch, null);
            messageToDispatch.setTag(0, (Object)messageEvent);
            messageToDispatch.setTag(4, (Object)event);
            messageToDispatch.setTag(1, (Object)this.getFlow((MessageView)messageToDispatch));
            messageToDispatch.setAsMessage(true);
            messageToDispatch.setTransactionId(this.transaction.id());
            messageToDispatch.setPreProcessingTsMicros(message.getPreProcessingTsMicros());
            this.onFlowEvent(messageEvent, message.getPreProcessingTsMicros(), 0L);
            messageToDispatch.acquire();
            messageEvent.dispose();
        } else {
            this.activeMessage = message;
            try {
                this.dispatchEvent(event, ExceptionHandlingPolicy.TrapAndDiscard);
            }
            finally {
                this.activeMessage = null;
            }
        }
        event.setDispatchTime(message.getPreProcessingTs());
        if (event.getState() != AepScheduleEvent.State.Cancelling) {
            if (event.isRepeating()) {
                if (this.isPrimary()) {
                    this.scheduleScheduleIntervalExpiryMessage(event);
                }
            } else {
                this.cancelAndRemoveSchedule(event);
            }
        }
    }

    private final void onHeartbeatMessage(AepHeartbeatMessage message) {
        AepHeartbeatMessage heartbeatMessage;
        if (this.haPolicy == HAPolicy.StateReplication) {
            heartbeatMessage = AepHeartbeatMessage.create();
            heartbeatMessage.setAsInternal(true);
            this.sendMessage(this.controlChannel, heartbeatMessage);
        }
        if (this.clusterHeartbeatInterval > 0) {
            heartbeatMessage = AepHeartbeatMessage.create();
            heartbeatMessage.setAsInternal(true);
            this.scheduleObjectOrMessageCore(heartbeatMessage, this.clusterHeartbeatInterval, AepScheduleEvent.HAPolicy.Cancel);
        }
    }

    private final void onShutdownMessage(AepShutdownMessage message) {
        this.setAsLastTransactionCore(this.lastTransactionContext != null ? this.lastTransactionContext.cause : (message.getCause() != null ? new Exception(message.getCause()) : null), true, message.getShutdownCluster(), this.isPrimary() || message.getShutdownCluster());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void onScheduleCreateMessage(AepScheduleCreateMessage message) {
        AepScheduleEvent event = (AepScheduleEvent)((Object)this.schedules.get(message.getScheduleId()));
        if (event == null) {
            if (this.isPrimary()) {
                throw new InternalError("schedule for id=" + message.getScheduleId() + " does not exist on a primary!!");
            }
            if (message.getMessageDispatch()) {
                MessageViewFactory factory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory(message.getFactoryId());
                if (factory == null) throw new IllegalStateException("failed to create schedule [cannot find object factory (id=" + message.getFactoryId() + ")]");
                try {
                    int dataLen = message.getSerializedMessageDataCount();
                    this.tmpBufferToDeserializeScheduleDispatchMessage.setLength(dataLen);
                    message.getSerializedMessageDataTo(this.tmpBufferToDeserializeScheduleDispatchMessage.getBackingBufferUnsafe(), 0);
                    IRogMessage dispatchMessage = (IRogMessage)factory.wrap(message.getSerializedMessageType(), message.getSerializedMessageEncodingType(), (Object)this.scheduleDispatchDeserializePacket.init(this.tmpBufferToDeserializeScheduleDispatchMessage.getBackingBufferUnsafe(), 0, dataLen));
                    int metadataLen = message.getSerializedMessageMetadataCount();
                    this.tmpBufferToDeserializeScheduleDispatchMessage.setLength(metadataLen);
                    message.getSerializedMessageMetadataTo(this.tmpBufferToDeserializeScheduleDispatchMessage.getBackingBufferUnsafe(), 0);
                    dispatchMessage.deserializeMetadata(this.tmpBufferToDeserializeScheduleDispatchMessage, 0, true);
                    event = AepScheduleEvent.create(message.getScheduleId(), dispatchMessage, message.getDelayOrInterval(), AepScheduleEvent.HAPolicy.valueOf(message.getHaPolicy()));
                    this.schedules.put(message.getScheduleId(), (Object)event);
                }
                catch (Exception e) {
                    throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                }
            } else {
                this.schedules.put(message.getScheduleId(), (Object)AepScheduleEvent.create(message.getScheduleId(), null, message.getDelayOrInterval(), AepScheduleEvent.HAPolicy.valueOf(message.getHaPolicy())));
            }
            this.nextScheduleId = message.getScheduleId() + 1L;
        } else if (!this.isPrimary()) {
            throw new InternalError("schedule for id=" + message.getScheduleId() + " already exists during schedule creation on a backup!");
        }
        if (this.someDebugTrace && this.schedTracer.debug) {
            this.schedTracer.log("Sched #" + message.getScheduleId() + " <-- create --> " + (Object)((Object)event.getState()), Tracer.Level.DEBUG);
        }
        this.activateSchedule(event);
    }

    private final void onScheduleActivateMessage(AepScheduleActivateMessage message) {
        AepScheduleEvent event = (AepScheduleEvent)((Object)this.schedules.get(message.getScheduleId()));
        if (event != null) {
            switch (event.getState()) {
                case NotActivated: {
                    event.setState(AepScheduleEvent.State.Activated);
                    event.setScheduledTime(message.getPreProcessingTs());
                    if (event.getDelay() > 0) {
                        if (!this.isPrimary()) break;
                        this.scheduleScheduleIntervalExpiryMessage(event);
                        break;
                    }
                    this.onScheduleIntervalExpiry(event, message);
                    break;
                }
                case Activated: {
                    throw new InternalError("received a schedule activate message in Activated state!");
                }
                case Cancelling: {
                    break;
                }
                case Cancelled: {
                    throw new InternalError("received a schedule activate message in Cancelled state!");
                }
                default: {
                    throw new InternalError("unknown schedule state '" + (Object)((Object)event.getState()) + "'");
                }
            }
            if (this.someDebugTrace && this.schedTracer.debug) {
                this.schedTracer.log("Sched #" + message.getScheduleId() + " <-- activate --> " + (Object)((Object)event.getState()), Tracer.Level.DEBUG);
            }
        } else {
            throw new InternalError("schedule for id=" + message.getScheduleId() + " could not be found!");
        }
    }

    private final void onScheduleIntervalExpiryMessage(AepScheduleIntervalExpiryMessage message) {
        AepScheduleEvent event = (AepScheduleEvent)((Object)this.schedules.get(message.getScheduleId()));
        if (event != null) {
            switch (event.getState()) {
                case NotActivated: {
                    throw new InternalError("received a schedule interval expiry message in NotActivated state!");
                }
                case Activated: {
                    this.onScheduleIntervalExpiry(event, message);
                    break;
                }
                case Cancelling: {
                    break;
                }
                case Cancelled: {
                    throw new InternalError("received a schedule interval expiry message in Cancelled state!");
                }
                default: {
                    throw new InternalError("unknown schedule state '" + (Object)((Object)event.getState()) + "'");
                }
            }
            if (this.someDebugTrace && this.schedTracer.debug) {
                this.schedTracer.log("Sched #" + message.getScheduleId() + " <-- expiry --> " + (Object)((Object)event.getState()), Tracer.Level.DEBUG);
            }
        } else {
            throw new InternalError("schedule event for id=" + message.getScheduleId() + " could not be found!");
        }
    }

    private final void onScheduleCancelMessage(AepScheduleCancelMessage message) {
        AepScheduleEvent event = (AepScheduleEvent)((Object)this.schedules.get(message.getScheduleId()));
        if (event != null) {
            switch (event.getState()) {
                case NotActivated: {
                    throw new InternalError("received a schedule cancel message in NotActivated state!");
                }
                case Activated: {
                    throw new InternalError("received a schedule cancel message in Activated state!");
                }
                case Cancelling: {
                    this.cancelAndRemoveSchedule(event);
                    break;
                }
                case Cancelled: {
                    throw new InternalError("received a schedule cancel message in Cancelled state!");
                }
            }
            if (this.someDebugTrace && this.schedTracer.debug) {
                this.schedTracer.log("Sched #" + message.getScheduleId() + " <-- cancel --> " + (Object)((Object)event.getState()), Tracer.Level.DEBUG);
            }
        } else {
            throw new InternalError("schedule event for id=" + message.getScheduleId() + " could not be found!");
        }
    }

    private final void onMessage(MessageEvent event, long eventReceiptTs) {
        MessageLatencyManager latencyManager;
        if (!(event.getMessageView() instanceof IRogMessage)) {
            AepUnhandledMessageEvent ume = AepUnhandledMessageEvent.create(event);
            this.dispatchAndDisposeEvent((Event)ume, ExceptionHandlingPolicy.TrapAndDiscard);
            return;
        }
        IRogMessage message = (IRogMessage)event.getMessageView();
        message.setAsMessage(true);
        message.setAsInboundMessage(true);
        message.setTransactionId(this.transaction.id());
        if (this.setSupportMetadata && message.getTransactionInSequenceNumber() == 0) {
            message.setTransactionInSequenceNumber(++this.transaction.inboundSno);
        }
        if (this.setInboundMessageAsReadOnly) {
            message.setAsReadOnly();
        }
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.i, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)message);
        if (this.recordMsgLegWaypoints) {
            message.setReceiveTs(eventReceiptTs);
        }
        if (this.recordMsgLegLatencies && (latencyManager = (MessageLatencyManager)message.getTag(3)) != null) {
            latencyManager.calcAndRecordLegLatencies((MessageView)message, MessageLatencyManager.MessagingDirection.Inbound);
        }
        if (this.someDebugTrace) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Processing message event " + event + "...", Tracer.Level.DEBUG);
            }
            if (this.msgTracer.debug) {
                this.msgTrace("[MSG-IN]", (IRogNode)message);
            }
        }
        event.setAutoAck(false);
        event.acquire();
        AepFlow flow = this.getFlow((MessageView)message);
        int sender = message.getMessageSender();
        long sno = message.getMessageSequenceNumber();
        long flowSno = this.duplicateChecking ? flow.getLastSno(sender) : 0L;
        boolean isDuplicate = false;
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Message is {sender='" + sender + "', sno=" + sno + "} flow {id=" + flow.getFlowId() + ", sno=" + flowSno + "}.", Tracer.Level.DEBUG);
        }
        if (!this.duplicateChecking || sno <= 1L || flowSno < sno) {
            MessageEvent processEvent;
            if (this.someDebugTrace && this.snoTracer.debug) {
                if (!this.duplicateChecking) {
                    this.snoTracer.log("**** Duplicate checking is disabled *****", Tracer.Level.DEBUG);
                }
                this.snoTracer.log("<-- [" + sender + ", " + sno + ", " + flow.getFlowId() + ", " + flowSno + "] OK", Tracer.Level.DEBUG);
            }
            if (this.duplicateChecking) {
                flow.setLastSno(sender, sno);
            }
            message.setTag(1, (Object)flow);
            MessageEvent messageEvent = processEvent = this.enableReplayOnRollback ? flow.enque(event) : event;
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Next event to process=" + processEvent + ".", Tracer.Level.DEBUG);
            }
            if (this.enableReplayOnRollback) {
                this.transaction.addFlow(flow);
            }
            this.transaction.addEvent((Event)processEvent);
            this.transaction.currentCommitContext.hasInboundMsgs = true;
            if (this.enableTransactionSavepoints) {
                this.transaction.createSavepoint(true);
            }
            long preProcessingTsMicros = 0L;
            if (this.replicateInParallel && this.state != State.Starting && this.isPrimary()) {
                preProcessingTsMicros = UtlTime.nowInMicros();
                processEvent.getMessageView().setPreProcessingTsMicros(preProcessingTsMicros);
                this.transaction.doStoreCommitCore(this.transaction.doInboundMessageReplicatePrepare(this.transaction.currentCommitContext));
            }
            this.onFlowEvent(processEvent, preProcessingTsMicros, eventReceiptTs);
            if (message.getVfid() == 33) {
                switch (message.getMessageType()) {
                    case 2: {
                        this.onScheduleCreateMessage((AepScheduleCreateMessage)message);
                        break;
                    }
                    case 3: {
                        this.onScheduleActivateMessage((AepScheduleActivateMessage)message);
                        break;
                    }
                    case 4: {
                        this.onScheduleIntervalExpiryMessage((AepScheduleIntervalExpiryMessage)message);
                        break;
                    }
                    case 5: {
                        this.onScheduleCancelMessage((AepScheduleCancelMessage)message);
                        break;
                    }
                }
            }
        } else {
            if (this.someDebugTrace) {
                if (this.snoTracer.debug) {
                    this.snoTracer.log("<-- [" + sender + ", " + sno + ", " + flow.getFlowId() + ", " + flowSno + "] DUP", Tracer.Level.DEBUG);
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Message is a duplicate.", Tracer.Level.DEBUG);
                }
                if (this.msgTracer.debug) {
                    this.msgTrace("MSG-IN-DUP", (IRogNode)message);
                }
            }
            isDuplicate = true;
            this.transaction.ackEvent((Event)event);
        }
        this.updateRcvdMessageStats((MessageView)message, event, false, isDuplicate);
    }

    private final void updateRcvdMessageStats(MessageView message, MessageEvent event, boolean filtered, boolean duplicate) {
        AepEngineStats.MessageTypeStats typeStats = this.getMessageTypeStats(message, false);
        MessageChannel channel = event.getSource() != null ? event.getMessageChannel() : null;
        if (channel != null) {
            if (channel.getQos() == MessageChannel.Qos.BestEffort) {
                ++this.stats.numMsgsRcvdBestEffort;
                if (typeStats != null) {
                    ++typeStats.numMsgsRcvdBestEffort;
                }
            } else {
                ++this.stats.numMsgsRcvdGuaranteed;
                if (typeStats != null) {
                    ++typeStats.numMsgsRcvdGuaranteed;
                }
            }
        } else {
            ++this.stats.numMsgsSourced;
            if (typeStats != null) {
                ++typeStats.numMsgsSourced;
            }
        }
        if (duplicate) {
            ++this.stats.numDupMsgsRcvd;
            if (typeStats != null) {
                ++typeStats.numDupMsgsRcvd;
            }
        }
        if (filtered) {
            ++this.stats.numMsgsFiltered;
            if (typeStats != null) {
                ++typeStats.numMsgsFiltered;
            }
        }
    }

    private final void onBusBindingCreated(AepBusBindingCreatedEvent event) {
        if (!AepEngine.isBusBindingInternal(event.getBusBindingName())) {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void onBusBindingCreateFailed(AepBusBindingCreateFailedEvent event) {
        if (!AepEngine.isBusBindingInternal(event.getBusBindingName())) {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void onBusBindingOpening(AepBusBindingOpeningEvent event) {
        if (!AepEngine.isBusBindingInternal(event.getBusBindingName())) {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void onBusBindingOpened(AepBusBindingOpenedEvent event) {
        if (!AepEngine.isBusBindingInternal(event.getBusBindingName())) {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void onBusBindingOpenFailed(AepBusBindingOpenFailedEvent event) {
        if (!AepEngine.isBusBindingInternal(event.getBusBindingName())) {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void onChannelUp(AepChannelUpEvent event) {
        String busBindingName = event.getMessageBusBinding().getName();
        if (AepEngine.isBusBindingInternal(busBindingName)) {
            if (busBindingName.equals(CONTROL_BUS_NAME)) {
                this.controlChannel = event.getMessageChannel();
            }
        } else {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void onBusBindingUp(AepBusBindingUpEvent event) {
        if (!AepEngine.isBusBindingInternal(event.getMessageBusBinding().getName())) {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void onMessageStability(MessageStabilityEvent event) {
        if (((IRogMessage)event.getMessageView()).getTransactionId() > 0L) {
            this.outboundMessagingContext.setStableSno(((IRogMessage)event.getMessageView()).getMessageSequenceNumber());
        }
        this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        this.dispatchSendStabilityEvent(event.getMessageChannel(), event.getMessageView(), event.getStatus());
    }

    final void dispatchSendStabilityEvent(MessageChannel channel, MessageView messageView, Exception status) {
        if (this.dispatchSendStabilityEvents && messageView != null && !messageView.isPossibleDuplicate()) {
            AepSendStabilityEvent sendStabilityEvent = AepSendStabilityEvent.create(channel, messageView, status);
            this.dispatchEvent(sendStabilityEvent, ExceptionHandlingPolicy.TrapAndDiscard);
            sendStabilityEvent.dispose();
        }
    }

    private final void onSend(AepSendEvent event) {
        try {
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Processing send event " + (Object)((Object)event) + "...", Tracer.Level.DEBUG);
            }
            IRogMessage message = event.getMessage();
            if (this.setOutboundSequenceNumbers) {
                message.setMessageSequenceNumber(this.outboundMessagingContext.nextSno((MessageView)message));
            }
            if (this.dispatchSendStabilityEvents) {
                event.acquire();
                this.transaction.addEvent(event);
            }
            this.sendMessageSolicited(event.getMessageChannel(), message);
        }
        finally {
            event.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onSendCommitComplete(AepSendCommitCompletionEvent event) {
        long ts = 0L;
        Transaction.CommitContext commitContext = null;
        Transaction.EventList events = null;
        int eventCount = 0;
        int sendCommitCompletionProcTime = 0;
        if (this.recordTxnLegLatencies) {
            ts = UtlTime.now();
            commitContext = (Transaction.CommitContext)event.getAttachment();
            events = commitContext.events;
            eventCount = events != null ? events.count() : 0;
            sendCommitCompletionProcTime = commitContext.sendCommitCompletionProcTime;
        }
        boolean sendCommitComplete = false;
        try {
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " A send commit is complete (owners=" + event.owners() + ").", Tracer.Level.DEBUG);
            }
            sendCommitComplete = this.transaction.onSendCommitComplete(event);
        }
        finally {
            if (this.recordTxnLegLatencies && eventCount > 0) {
                long now = UtlTime.now();
                sendCommitCompletionProcTime += (int)(now - ts);
                if (sendCommitComplete) {
                    this.stats.txnLeg3ProcTimes.add((double)sendCommitCompletionProcTime);
                } else {
                    commitContext.sendCommitCompletionProcTime = sendCommitCompletionProcTime;
                }
            }
        }
    }

    private final void onResumeTransaction(AepResumeTransactionEvent event) {
        if (this.someDebugTrace) {
            if (this.txnTracer.debug) {
                this.txnTracer.log("Txn #" + event.getCommitContext().id + "(" + event.getCommitContext().stableId + ")..resume", Tracer.Level.DEBUG);
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Transaction #" + event.getCommitContext().id + " resumed.", Tracer.Level.DEBUG);
            }
        }
        this.transaction.launchCommit(event.getCommitContext(), true);
    }

    private final void onRoleChange(IStoreBindingRoleChangedEvent event) {
        try {
            this.checkAndGoActive(event.getRole());
        }
        catch (EAepException eAepException) {
            // empty catch block
        }
        this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onStoreCommitComplete(IStoreCommitCompletionEvent event) {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " A store commit is complete.", Tracer.Level.DEBUG);
        }
        long ts = this.recordTxnLegLatencies ? UtlTime.now() : 0L;
        try {
            if (!this.transaction.onStoreCommitComplete(event)) {
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Commit is not an AEP commit (attachment=" + event.getAttachment() + ").", Tracer.Level.DEBUG);
                }
                this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
            }
        }
        finally {
            if (this.recordTxnLegLatencies) {
                this.stats.txnLeg2ProcTimes.add((double)(UtlTime.now() - ts));
            }
        }
    }

    private final boolean onObjectAddition(IStoreObjectAddedEvent event) {
        IStoreObject object = event.getObject();
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Received an object added event (object=" + object + " id=" + object.getOid() + ")", Tracer.Level.DEBUG);
        }
        if (object instanceof IRogNode) {
            IRogNode state;
            IRogNode node = (IRogNode)object;
            if (this.someDebugTrace && this.msgTracer.debug) {
                this.msgTrace("[OBJ-ADD-IN]", node);
            }
            AepFlow flow = (AepFlow)this.flows.get(node.getGraphId());
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " ...flow=" + (Object)((Object)flow), Tracer.Level.DEBUG);
            }
            IRogNode iRogNode = state = flow != null ? flow.getApplicationState() : null;
            if (this.someDebugTrace && this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " ...state=" + state, Tracer.Level.DEBUG);
            }
            if (state == node) {
                this.onApplicationStateCreated(state);
            }
            this.transaction.id(event.getTransactionId());
            this.transaction.stableId(event.getStableTransactionId());
            return event.isCommitEnd();
        }
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " ...object is not an AEP managed state element.", Tracer.Level.DEBUG);
        }
        this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        return false;
    }

    private final boolean onObjectUpdate(IStoreObjectUpdatedEvent event) {
        IStoreObject object = event.getObject();
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Received an object update event (object=" + object + " id=" + object.getOid() + ")", Tracer.Level.DEBUG);
        }
        if (object instanceof IRogNode) {
            IRogNode node = (IRogNode)object;
            if (this.someDebugTrace && this.msgTracer.debug) {
                this.msgTrace("[OBJ-UPD-IN]", node);
            }
            this.transaction.id(event.getTransactionId());
            this.transaction.stableId(event.getStableTransactionId());
            return event.isCommitEnd();
        }
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " ...object is not an AEP managed state element.", Tracer.Level.DEBUG);
        }
        this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        return false;
    }

    private final boolean onObjectRemoval(IStoreObjectRemovedEvent event) {
        IStoreObject object = event.getObject();
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Received an object removed event (object=" + object + " id=" + object.getOid() + ")", Tracer.Level.DEBUG);
        }
        if (object instanceof IRogNode) {
            IRogNode node = (IRogNode)object;
            if (this.someDebugTrace && this.msgTracer.debug) {
                this.msgTrace("[OBJ-REM-IN]", node);
            }
            this.transaction.id(event.getTransactionId());
            this.transaction.stableId(event.getStableTransactionId());
            return event.isCommitEnd();
        }
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " ...object is not an AEP managed state element.", Tracer.Level.DEBUG);
        }
        this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean onObjectReceipt(IStoreObjectReceivedEvent event) {
        IStoreObject object = event.getObject();
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Received an object received event (object=" + object + " id=" + object.getOid() + ")", Tracer.Level.DEBUG);
        }
        if (object instanceof IRogMessage) {
            IRogMessage message = (IRogMessage)object;
            if (this.someDebugTrace && this.msgTracer.debug) {
                this.msgTrace("[MSG-REPL-IN]", (IRogNode)message);
            }
            if (this.state == State.Starting) {
                message.setAsReplayedMessage(true);
            }
            if (this.haPolicy == HAPolicy.EventSourcing) {
                long transactionId = this.transaction.id();
                if (this.midstreamInitializationValidation && transactionId == 1L && event.getTransactionId() != 2L) {
                    throw new IllegalStateException(this.role + " invalid transaction id (exp=2, actual=" + event.getTransactionId() + ")");
                }
            }
            this.transaction.id(event.getTransactionId());
            this.transaction.stableId(event.getStableTransactionId());
            int environmentProviderId = AepEnvironmentProviderProxy.getId(message);
            if (environmentProviderId == -1) {
                if (this.haPolicy == HAPolicy.EventSourcing) {
                    message.acquire();
                    MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)message, null);
                    try {
                        message.setTag(0, (Object)messageEvent);
                        this.onMessage(messageEvent, 0L);
                        return event.isCommitEnd();
                    }
                    finally {
                        messageEvent.dispose();
                    }
                } else {
                    AepShutdownMessage shutdownMessage;
                    if (this.haPolicy != HAPolicy.StateReplication) throw new InternalError("Received a message  ('" + object.getClass().getSimpleName() + "') through the store with unknown HA policy ['" + (Object)((Object)this.haPolicy) + "'].");
                    if (!message.getIsInternal()) {
                        message.setAsReadOnly();
                        this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
                    }
                    if (message.getMessageReflector() != null && message.getMessageReflector().needsSync()) {
                        message.sync();
                    }
                    this.outboundMessagingContext.enqueInOutboundQueue(message, -1);
                    this.outboundMessagingContext.setSno(message.getMessageSequenceNumber());
                    if (this.state == State.Starting || !message.getIsLastTransaction() || !(message instanceof AepShutdownMessage) || !(shutdownMessage = (AepShutdownMessage)message).getShutdownCluster()) return event.isCommitEnd();
                    this.lastTransactionContext = new LastTransactionContext();
                    this.lastTransactionContext.init(event.getTransactionId(), shutdownMessage.getCause() != null ? new Exception(shutdownMessage.getCause()) : null, true, true);
                }
                return event.isCommitEnd();
            } else {
                this.environmentProviderProxies[environmentProviderId].startPlayback(message);
            }
            return event.isCommitEnd();
        }
        this.tracer.log(this.tracePrefix + " Received a store message ('" + object.getClass().getSimpleName() + "') through the store that not an ROG message. Discarding...", Tracer.Level.WARNING);
        return false;
    }

    private final void onStoreMemberInitComplete(IStoreMemberInitCompleteEvent event) {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Received a store member init complete event (member=" + (event.getMember() == this.store.getMember() ? "self" : event.getMember().getName()) + ", lastTransactionId=" + event.getLastTransactionId() + ")", Tracer.Level.DEBUG);
        }
        if (event.getMember() == this.store.getMember()) {
            IStoreBinding.Role role = this.getStore().getRole();
            this.transaction.id(event.getLastTransactionId() + 1L);
            if (role == IStoreBinding.Role.Primary) {
                this.tracer.log("Initialization complete. Synchronized to transaction id #" + event.getLastTransactionId() + " in the store.", Tracer.Level.INFO);
            } else {
                this.tracer.log("Initialization complete. Synchronized to transaction id #" + event.getLastTransactionId() + " on the primary.", Tracer.Level.INFO);
            }
            if (this.haPolicy == HAPolicy.StateReplication) {
                int objectCount = this.store.size();
                long dataSize = this.store.getStats().getDataSize();
                this.tracer.log("Store Recovered State: " + this.store.size() + (objectCount == 1 ? " object, size: " : " objects, size: ") + UtlUnit.readableBytesSize((long)dataSize), Tracer.Level.INFO);
            }
        }
        this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
    }

    private final void onStoreBindingFailed(IStoreBindingFailedEvent event) {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Received a store binding failed event (cause=" + event.getCause() + ")", Tracer.Level.DEBUG);
        }
        this.tracer.log("Store binding failure: " + event.getCause() != null ? UtlThrowable.prepareStackTrace((Throwable)event.getCause()) : " no cause reported.", Tracer.Level.WARNING);
        this.stop(event.getCause(), false);
    }

    private final void onChannelDown(AepChannelDownEvent event) {
        String busBindingName = event.getMessageBusBinding().getName();
        if (AepEngine.isBusBindingInternal(busBindingName)) {
            if (busBindingName.equals(CONTROL_BUS_NAME)) {
                this.controlChannel = event.getMessageChannel();
            }
        } else {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void onBusBindingDown(AepBusBindingDownEvent event) {
        try {
            if (!AepEngine.isBusBindingInternal(event.getMessageBusBinding().getName())) {
                this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Processing bus binding down event " + (Object)((Object)event) + "...", Tracer.Level.DEBUG);
                }
                if (this.messageBusBindingFailPolicy == MessageBusBindingFailPolicy.FailIfAnyBindingFails) {
                    if (this.someDebugTrace && this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + " Stopping the engine...", Tracer.Level.DEBUG);
                    }
                    this.stop(event.getCause(), true);
                    this.dispatchEvent((Event)AepMessagingFailedEvent.create(event.getCause()), ExceptionHandlingPolicy.TrapAndDiscard);
                } else if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Nothing to be done. Message bus binding fail policy is '" + (Object)((Object)this.messageBusBindingFailPolicy) + "'.", Tracer.Level.DEBUG);
                }
            }
        }
        finally {
            event.dispose();
        }
    }

    private final void onBusBindingDestroyed(AepBusBindingDestroyedEvent event) {
        if (!AepEngine.isBusBindingInternal(event.getBusBindingName())) {
            this.dispatchEvent((Event)event, ExceptionHandlingPolicy.TrapAndDiscard);
        }
    }

    private final void sendMessageSolicited(MessageChannel channel, IRogMessage message) {
        long ts;
        long l = ts = this.recordMsgLegLatencies ? UtlTime.now() : 0L;
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Sending message " + message + " through channel '" + channel.getName() + "@" + channel.getMessageBusBinding().getName() + "'...", Tracer.Level.DEBUG);
        }
        AepEngineStats.MessageTypeStats typeStats = this.getMessageTypeStats((MessageView)message, false);
        if (channel.getQos() == MessageChannel.Qos.Guaranteed) {
            this.transaction.numGuaranteedMsgsEnqueued++;
            if (typeStats != null) {
                ++typeStats.numMsgsSentGuaranteed;
            }
        } else {
            this.transaction.numBestEffortMsgsEnqueued++;
            if (typeStats != null) {
                ++typeStats.numMsgsSentBestEffort;
            }
        }
        message.setTransactionId(this.transaction.id());
        this.transaction.currentCommitContext.hasOutboundMsgs = true;
        message.setInMsgsInTransaction(this.transaction.currentCommitContext.hasInboundMsgs);
        if (this.setSupportMetadata && !message.isPossibleDuplicate()) {
            message.setTransactionInSequenceNumber(this.transaction.inboundSno);
            message.setTransactionOutSequenceNumber(++this.transaction.outboundSno);
        }
        AepBusConnection busConnection = (AepBusConnection)((Object)channel.getMessageBusBinding().getAttachment());
        if (this.someDebugTrace) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " ...qos=" + channel.getQos(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + " ...sender=" + message.getMessageSender(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + " ...flow=" + message.getMessageFlow(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + " ...sno=" + message.getMessageSequenceNumber(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + " ...key=" + message.getMessageKey(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + " ...busconn=<" + (Object)((Object)busConnection) + ">", Tracer.Level.DEBUG);
            }
            if (this.snoTracer.debug) {
                this.snoTracer.log("--> [" + message.getMessageSender() + ", " + message.getMessageSequenceNumber() + "]" + (message.isPossibleDuplicate() ? " R" : ""), Tracer.Level.DEBUG);
            }
        }
        this.transaction.addBusConnection(busConnection);
        int flags = 60;
        if (message.getMessageReflector() != null && message.getMessageReflector().needsSync()) {
            flags |= 2;
        }
        busConnection.enque(channel, message, flags);
        this.outboundMessagingContext.enqueForLogging(message, this.transaction.savepoint);
        if (this.recordMsgLegLatencies) {
            this.stats.msgSendCoreLatencies.add((double)(UtlTime.now() - ts));
        }
    }

    private final void sendMessageUnsolicited(MessageChannel channel, IRogMessage message, long ts, int sendFlags, boolean needsSyncForKeyResolution) throws SmaException {
        if (this.recordMsgLegWaypoints) {
            message.setSendTs(ts);
            if (message.getOriginTs() == 0L) {
                message.setOriginTs(message.getCreateTs());
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.o, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)message);
        }
        if (this.isClustered() && this.replicateUnsolicitedSends || this.sequenceUnsolicitedWithSolicitedSends) {
            this.multiplexer.multiplexEvent((Event)AepSendEvent.create(channel, message, this), 0);
        } else {
            AepBusConnection busConnection;
            AepEngineStats.MessageTypeStats typeStats = this.getMessageTypeStats((MessageView)message, false);
            if (channel.getQos() == MessageChannel.Qos.BestEffort) {
                ++this.stats.numMsgsSentBestEffort;
                if (typeStats != null) {
                    ++typeStats.numMsgsSentBestEffort;
                }
            } else {
                ++this.stats.numMsgsSentGuaranteed;
                if (typeStats != null) {
                    ++typeStats.numMsgsSentGuaranteed;
                }
            }
            message.setTransactionId(-1L);
            message.setTag(2, null);
            int flags = sendFlags | 4 | 0x10 | 0x20;
            if (needsSyncForKeyResolution) {
                flags |= 2;
            }
            if (!this.setOutboundSequenceNumbers || !this.sequenceUnsolicitedSends) {
                message.setMessageSequenceNumber(0L);
                flags |= 8;
            }
            if ((busConnection = (AepBusConnection)((Object)channel.getMessageBusBinding().getAttachment())) == null) {
                throw new RuntimeException("send channel is not on an engine managed bus connection");
            }
            busConnection.send(channel, message, flags);
            if (this.someDebugTrace) {
                if (this.snoTracer.debug) {
                    this.snoTracer.log("--> [" + message.getMessageSender() + ", " + message.getMessageSequenceNumber() + "] U", Tracer.Level.DEBUG);
                }
                if (this.msgTracer.debug) {
                    this.msgTrace("[MSG-OUT]", (IRogNode)message);
                }
            }
            if (this.dispatchSendStabilityEvents && channel.getQos() == MessageChannel.Qos.BestEffort) {
                this.getEventMultiplexer().multiplexEvent((Event)MessageStabilityEvent.create((MessageBusBinding)channel.getMessageBusBinding(), (MessageChannel)channel, (MessageView)message, null), 0);
            }
            if (this.outboundMessageLogger != null) {
                try {
                    this.outboundMessageLogger.log(message, true, true);
                }
                catch (Throwable e) {
                    this.handleOutboundMessageLoggerException(e, (MessageView)message);
                }
            }
        }
    }

    private final Map<IStoreBinding.StartupExpectation, Enum<?>> engineExpectationsToStoreExpectations(Map<StartupExpectation, Enum<?>> engineExpectations) {
        if (engineExpectations != null) {
            HashMap storeExpectations = new HashMap();
            for (StartupExpectation engineExpectation : engineExpectations.keySet()) {
                switch (engineExpectation) {
                    case Role: {
                        storeExpectations.put(IStoreBinding.StartupExpectation.Role, engineExpectations.get((Object)engineExpectation));
                        break;
                    }
                    case LogEmptiness: {
                        storeExpectations.put(IStoreBinding.StartupExpectation.LogEmptiness, engineExpectations.get((Object)engineExpectation));
                    }
                }
            }
            return storeExpectations;
        }
        return null;
    }

    private final EAepExpectationNotMetException storeToAepExpectationNotMetException(OdsExpectationNotMetException enme) {
        if (enme.getUnmetExpectationType() == IStoreBinding.StartupExpectation.Role) {
            return new EAepExpectationNotMetException(StartupExpectation.Role, enme.getUnmetExpectationValue(), enme.getUnmetExpectationData(), enme.getMessage());
        }
        if (enme.getUnmetExpectationType() == IStoreBinding.StartupExpectation.LogEmptiness) {
            return new EAepExpectationNotMetException(StartupExpectation.LogEmptiness, enme.getUnmetExpectationValue(), enme.getUnmetExpectationData(), enme.getMessage());
        }
        return new EAepExpectationNotMetException(null, null, null, enme.getMessage());
    }

    private final void scheduleScheduleCreateMessage(AepScheduleEvent event) {
        AepScheduleCreateMessage message = AepScheduleCreateMessage.create();
        message.setAsInternal(true);
        message.setScheduleId(event.getId());
        if (event.getMessage() != null) {
            IRogMessage dispatchMessage = event.getMessage();
            message.setMessageDispatch(true);
            message.setFactoryId(dispatchMessage.getOfid());
            message.setSerializedMessageEncodingType(dispatchMessage.getMessageEncodingType());
            message.setSerializedMessageType(dispatchMessage.getObjectType());
            int metadataLen = message.serializeMetadata(this.tmpBufferToSerializeScheduleDispatchMessage, 0);
            message.setSerializedMessageMetadataFrom(this.tmpBufferToSerializeScheduleDispatchMessage.getBackingBufferUnsafe(), this.tmpBufferToSerializeScheduleDispatchMessage.getOffset(), metadataLen);
            int len = message.serializeTo(this.tmpBufferToSerializeScheduleDispatchMessage, 0);
            message.setSerializedMessageDataFrom(this.tmpBufferToSerializeScheduleDispatchMessage.getBackingBufferUnsafe(), this.tmpBufferToSerializeScheduleDispatchMessage.getOffset(), len);
        }
        message.setDelayOrInterval(event.getDelay());
        message.setHaPolicy(event.getHAPolicy().toString());
        event.setInternalSchedulingEvent(MessageEvent.create(null, null, (MessageView)message, null).setDelay(Integer.MIN_VALUE));
        this.multiplexer.scheduleEvent(event.getInternalSchedulingEvent());
    }

    private final void scheduleScheduleActivateMessage(AepScheduleEvent event) {
        AepScheduleActivateMessage message = AepScheduleActivateMessage.create();
        message.setAsInternal(true);
        message.setScheduleId(event.getId());
        event.setInternalSchedulingEvent(MessageEvent.create(null, null, (MessageView)message, null).setDelay(-2147483647));
        this.multiplexer.scheduleEvent(event.getInternalSchedulingEvent());
    }

    private final void scheduleScheduleIntervalExpiryMessage(AepScheduleEvent event) {
        AepScheduleIntervalExpiryMessage message = AepScheduleIntervalExpiryMessage.create();
        message.setAsInternal(true);
        message.setScheduleId(event.getId());
        event.setInternalSchedulingEvent(MessageEvent.create(null, null, (MessageView)message, null).setDelay(event.getDelay()));
        this.multiplexer.scheduleEvent(event.getInternalSchedulingEvent());
    }

    private final void scheduleScheduleCancelMessage(AepScheduleEvent event) {
        AepScheduleCancelMessage message = AepScheduleCancelMessage.create();
        message.setAsInternal(true);
        message.setScheduleId(event.getId());
        this.multiplexer.scheduleEvent(MessageEvent.create(null, null, (MessageView)message, null).setDelay(-2147483646));
    }

    private final void unscheduleScheduleInternalSchedulingEvent(AepScheduleEvent event) {
        this.multiplexer.unscheduleEvent(event.getInternalSchedulingEvent());
        event.setInternalSchedulingEvent(null);
    }

    private final AepScheduleEvent scheduleObjectOrMessageCore(Object object, int delayOrInterval, AepScheduleEvent.HAPolicy haPolicy) {
        AepScheduleEvent scheduleEvent = object instanceof IRogMessage ? AepScheduleEvent.create(this.nextScheduleId++, (IRogMessage)object, delayOrInterval, haPolicy) : AepScheduleEvent.create(this.nextScheduleId++, object, delayOrInterval, haPolicy);
        this.schedules.put(scheduleEvent.getId(), (Object)scheduleEvent);
        if (this.someDebugTrace && this.schedTracer.debug) {
            this.schedTracer.log("Sched #" + scheduleEvent.getId() + " --> create --> " + (Object)((Object)scheduleEvent.getState()), Tracer.Level.DEBUG);
        }
        if (this.activeMessage == null) {
            if (this.isPrimary()) {
                this.scheduleScheduleCreateMessage(scheduleEvent);
            }
        } else {
            this.activateSchedule(scheduleEvent);
        }
        return scheduleEvent;
    }

    private final AepScheduleEvent scheduleObjectOrMessage(Object object, int delayOrInterval, AepScheduleEvent.HAPolicy haPolicy) {
        if (this.activeMessage == null && !this.inMessagingStarted) {
            throw new IllegalStateException("must be invoked from a message, 'messaging started' or schedule event handler");
        }
        if (this.activeThread != Thread.currentThread()) {
            throw new IllegalStateException("invoked by a non handler dispatch thread");
        }
        if (this.state != State.Starting && this.state != State.Started) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        return this.scheduleObjectOrMessageCore(object, delayOrInterval, haPolicy);
    }

    private final void performHealthChecks() {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Checking health, pipeline: " + (this.stats.numCommitsStarted - this.stats.numCommitsCompleted), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "Checking health, currentComplete: " + this.stats.numCommitsCompleted + ", lastComplete: " + this.lastStuckAlertCommitCompleteCount + " " + (System.currentTimeMillis() - this.lastCommitCompleteTs) + "ms ago, alert at: " + this.stuckAlertThreshold, Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "Checking health, eventsReceived : " + this.stats.numEventsRcvd + ", eventsProcessed: " + this.stats.numEventsProcessed + " " + (System.currentTimeMillis() - this.lastEventProcessedTs) + "ms ago, alert at: " + this.stuckAlertThreshold, Tracer.Level.DEBUG);
        }
        if (this.stuckAlertThreshold > 0L) {
            long numCommitsCompleted = this.stats.numCommitsCompleted;
            int numCommitsPending = (int)(this.stats.numCommitsStarted - numCommitsCompleted);
            long numEventsProcessed = this.stats.numEventsProcessed;
            int numEventsPending = (int)(this.stats.numEventsRcvd - numEventsProcessed);
            if (this.lastCommitCompleteTs == -1L && this.stats.numCommitsStarted > 0L) {
                this.lastCommitCompleteTs = System.currentTimeMillis();
            }
            if (this.lastEventProcessedTs == -1L && this.stats.numEventsRcvd > 0L) {
                this.lastEventProcessedTs = System.currentTimeMillis();
            }
            if (numCommitsPending > 0 && System.currentTimeMillis() - this.lastCommitCompleteTs > this.stuckAlertThreshold) {
                if (this.lastStuckAlertCommitCompleteCount < numCommitsCompleted && this.lastHealthCheckPendingCommitCount > 0L) {
                    AepStuckAlertEvent alertEvent = AepStuckAlertEvent.create(AepStuckAlertEvent.Reason.HungTransactionPipeline, this.lastEventProcessedTs, this.lastCommitCompleteTs, numCommitsPending);
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n").append(this.getDescriptor().getName()).append(" stuck transaction pipeline detected:").append("\n");
                    sb.append(alertEvent.toString());
                    this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    if (this.asynchronousEventHandler != null) {
                        this.asynchronousEventHandler.onEvent((Event)alertEvent);
                    }
                    alertEvent.dispose();
                    this.lastStuckAlertCommitCompleteCount = numCommitsCompleted;
                }
            } else if (numEventsPending > 0 && System.currentTimeMillis() - this.lastEventProcessedTs > this.stuckAlertThreshold && this.lastStuckAlertEventProcessedCount < numEventsProcessed && this.lastHealthCheckEventPendingCount > 0L) {
                AepStuckAlertEvent alertEvent = AepStuckAlertEvent.create(AepStuckAlertEvent.Reason.HungEventHandler, this.lastEventProcessedTs, this.lastCommitCompleteTs, numEventsPending);
                StringBuilder sb = new StringBuilder();
                Thread activeThread = this.activeThread;
                sb.append("\n").append(this.getDescriptor().getName()).append(" stuck event handler detected:").append("\n");
                sb.append(alertEvent.toString()).append("\n");
                if (activeThread != null) {
                    sb.append("Stack Trace:\n");
                    UtlThrowable.prepareStackTrace((StringBuilder)sb, (StackTraceElement[])activeThread.getStackTrace());
                }
                String message = sb.toString();
                this.tracer.log(message, Tracer.Level.WARNING);
                alertEvent.setMessage(message);
                if (this.asynchronousEventHandler != null) {
                    this.asynchronousEventHandler.onEvent((Event)alertEvent);
                }
                alertEvent.dispose();
                this.lastStuckAlertEventProcessedCount = numEventsProcessed;
            }
            this.lastHealthCheckPendingCommitCount = numCommitsPending;
            this.lastHealthCheckEventPendingCount = numEventsPending;
        }
    }

    private final void injectMessage(MessageEvent messageEvent, boolean nonBlocking, int delay) {
        MessageView message = messageEvent.getMessageView();
        if (this.state == State.Started && this.isPrimary()) {
            if (this.syncOnInject) {
                message.sync();
            }
            if (this.setSupportMetadata && delay <= 0) {
                message.setEnqueueTsMicros(UtlTime.nowInMicros());
            }
            message.setTag(0, (Object)messageEvent);
            if (delay == 0) {
                this.multiplexer.multiplexEvent((Event)messageEvent, nonBlocking ? 1 : 0);
            } else {
                messageEvent.setDelay(delay);
                this.multiplexer.scheduleEvent((Event)messageEvent);
            }
        }
    }

    final void onStatsAlert(IStatsAlert alert) {
        this.dispatchAndDisposeEvent((Event)AepStatsAlertEvent.create(alert.getMetricName(), alert.getMetricValue(), alert.getMetricAlertThreshold(), alert.getType()), ExceptionHandlingPolicy.TrapAndDiscard);
    }

    final IEventMultiplexer getEventMultiplexerInternal() {
        return this.multiplexer;
    }

    static final boolean isBusBindingInternal(String name) {
        return name.equals(CONTROL_BUS_NAME) || name.equals(DIRECT_BUS_NAME);
    }

    final void collectBusConnectionStats(List<IAepBusConnectionStats> busConnectionStats) {
        for (int i = 0; i < this.busConnectionList.size(); ++i) {
            AepBusConnection busConnection = this.busConnectionList.get(i);
            busConnectionStats.add(busConnection.getStats());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean onReplyToInjectedRequest(long requestId, IRogMessage reply) {
        InjectedRequestContext injectedRequestContext;
        UtlLinkedLongMap<InjectedRequestContext> utlLinkedLongMap = this.injectedRequestContexts;
        synchronized (utlLinkedLongMap) {
            injectedRequestContext = (InjectedRequestContext)((Object)this.injectedRequestContexts.get(requestId));
        }
        if (injectedRequestContext != null) {
            injectedRequestContext.onReply(reply);
            return true;
        }
        return false;
    }

    public static final AepEngine create(AepEngineDescriptor engineDescriptor, IAepApplicationStateFactory stateFactory, Set<Object> eventHandlerContainers, IEventHandler defaultEventHandler, Collection<AepMessageSender> messageSenders, IAepWatcher watcher) {
        return new AepEngine(engineDescriptor, stateFactory, eventHandlerContainers, defaultEventHandler, messageSenders);
    }

    public static final AepEngine create(AepEngineDescriptor engineDescriptor, IAepApplicationStateFactory stateFactory, Set<Object> eventHandlerContainers, IEventHandler defaultEventHandler, IAepWatcher watcher) {
        return AepEngine.create(engineDescriptor, stateFactory, eventHandlerContainers, defaultEventHandler, null, watcher);
    }

    public static final MessageBusDescriptor configureClientBusDescriptor(MessageBusDescriptor busDescriptor, String serviceName, String overrideRequestsChannelKey, String overrideResponsesChannelKey) throws SmaException {
        MessageChannelDescriptor requestsChannelDescriptor = busDescriptor.getChannel(CLIENT_BUS_REQUESTS_CHANNEL_NAME);
        if (requestsChannelDescriptor == null) {
            requestsChannelDescriptor = MessageChannelDescriptor.create((String)CLIENT_BUS_REQUESTS_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
            busDescriptor.addChannel(requestsChannelDescriptor);
            requestsChannelDescriptor.setChannelQos(MessageChannel.Qos.Guaranteed);
        }
        requestsChannelDescriptor.setChannelId((short)1);
        if (overrideRequestsChannelKey != null) {
            requestsChannelDescriptor.setChannelKey(overrideRequestsChannelKey);
        } else {
            String requestsChannelKey = requestsChannelDescriptor.getChannelKey();
            if (requestsChannelKey == null) {
                requestsChannelDescriptor.setChannelKey(serviceName);
            }
        }
        MessageChannelDescriptor responsesChannelDescriptor = busDescriptor.getChannel(CLIENT_BUS_RESPONSES_CHANNEL_NAME);
        if (responsesChannelDescriptor == null) {
            responsesChannelDescriptor = MessageChannelDescriptor.create((String)CLIENT_BUS_RESPONSES_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
            busDescriptor.addChannel(responsesChannelDescriptor);
            responsesChannelDescriptor.setChannelQos(MessageChannel.Qos.Guaranteed);
        }
        responsesChannelDescriptor.setChannelId((short)2);
        String responsesChannelKeySuffix = "${clientId}";
        if (overrideResponsesChannelKey != null) {
            responsesChannelDescriptor.setChannelKey(overrideResponsesChannelKey + "/" + "${clientId}");
        } else {
            String responsesChannelKey = responsesChannelDescriptor.getChannelKey();
            responsesChannelDescriptor.setChannelKey((responsesChannelKey == null ? "" : responsesChannelKey + "/") + "${clientId}");
        }
        busDescriptor.setProviderConfigProperty("sma_metadata_version", "3");
        return busDescriptor;
    }

    public final XString getZGName() {
        return this.name;
    }

    public final AepEventDispatcher getEventDispatcher() {
        return this.dispatcher;
    }

    public final AepEngineDescriptor getDescriptor() {
        return this.engineDescriptor;
    }

    public final boolean isClustered() {
        return this.storeDescriptor != null && this.storeDescriptor.getReplicator() != null;
    }

    public final boolean isPersistent() {
        return this.storeDescriptor != null && this.storeDescriptor.getPersister() != null;
    }

    public final HAPolicy getHAPolicy() {
        return this.haPolicy;
    }

    public final ReplicationPolicy getReplicationPolicy() {
        return this.replicationPolicy;
    }

    public final MessagingStartFailPolicy getMessagingStartFailPolicy() {
        return this.messagingStartFailPolicy;
    }

    public final MessageBusBindingFailPolicy getMessageBusBindingFailPolicy() {
        return this.messageBusBindingFailPolicy;
    }

    public final InboundMessageLoggingPolicy getInboundMessageLoggingPolicy() {
        return this.inboundMessageLoggingPolicy;
    }

    public final OutboundMessageLoggingPolicy getOutboundMessageLoggingPolicy() {
        return this.outboundMessageLoggingPolicy;
    }

    public final void setAppExceptionHandlingPolicy(AppExceptionHandlingPolicy policy) {
        this.appExceptionHandlingPolicy = policy;
    }

    public final AppExceptionHandlingPolicy getAppExceptionHandlingPolicy() {
        return this.appExceptionHandlingPolicy;
    }

    public final void setMessageSendExceptionHandlingPolicy(MessageSendExceptionHandlingPolicy policy) {
        this.sendExceptionHandlingPolicy = policy;
    }

    public final MessageSendExceptionHandlingPolicy getMessageSendExceptionHandlingPolicy() {
        return this.sendExceptionHandlingPolicy;
    }

    public final void setMessageSendStabilityFailureHandlingPolicy(MessageSendStabilityFailureHandlingPolicy policy) {
        this.sendStabilityFailureHandlingPolicy = policy;
    }

    public final MessageSendStabilityFailureHandlingPolicy getMessageSendStabilityFailureHandlingPolicy() {
        return this.sendStabilityFailureHandlingPolicy;
    }

    public final EventMultiplexerType getEventMultiplexerType() {
        return this.emuxType;
    }

    public final AepEngine registerMessageFactory(MessageViewFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (this.state != State.Init) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory(factory);
        return this;
    }

    public final AepEngine registerObjectFactory(IStoreObjectFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (this.state != State.Init) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(factory);
        return this;
    }

    public final AepEngine registerTypeFactory(StoTypeFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (this.state != State.Init) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        StoTypeFactoryRegistry.getInstance().registerTypeFactory(factory);
        return this;
    }

    public final AepEngine registerFactory(Object factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (this.state == null || this.state == State.Init) {
            if (factory instanceof MessageViewFactory) {
                MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)factory);
            }
            if (factory instanceof IStoreObjectFactory) {
                StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)factory);
            }
            if (factory instanceof StoTypeFactory) {
                StoTypeFactoryRegistry.getInstance().registerTypeFactory((StoTypeFactory)factory);
            }
        } else {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        return this;
    }

    public final AepEngine registerEnvironmentProvider(IAepEnvironmentProvider provider) {
        AepEnvironmentProviderProxy proxy;
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        if (this.state == State.Init) {
            if (this.replicateInParallel) {
                throw new IllegalStateException("environment providers cannot be used with an engine configured with replicateInParallel=true'");
            }
            if (this.numEnvironmentProviderProxies == this.environmentProviderProxies.length) {
                throw new IllegalStateException("max environment provider count reached (max=" + this.environmentProviderProxies.length + ")");
            }
        } else {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        this.environmentProviderProxies[proxy.getId()] = proxy = new AepEnvironmentProviderProxy(this.numEnvironmentProviderProxies++, provider);
        return this;
    }

    public final void registerSeriesStat(IStats.Series series) {
        if (this.state != State.Init) {
            throw new IllegalStateException("Cannot add user stat after engine start (" + (Object)((Object)this.state) + ")");
        }
        this.stats.addUserSeriesStat(series);
    }

    public final void registerCounterStat(IStats.Counter counter) {
        if (this.state != State.Init) {
            throw new IllegalStateException("Cannot add user stat after engine start (" + (Object)((Object)this.state) + ")");
        }
        this.stats.addUserCounterStat(counter);
    }

    public final void registerGaugeStat(IStats.Gauge gauge) {
        if (this.state != State.Init) {
            throw new IllegalStateException("Cannot add user stat after engine start (" + (Object)((Object)this.state) + ")");
        }
        this.stats.addUserGaugeStat(gauge);
    }

    @Deprecated
    public final void setCentralMessageHandler(IAepPredispatchMessageHandler handler) {
        this.setPredispatchMessageHandler(handler);
    }

    public final IAepPredispatchMessageHandler setPredispatchMessageHandler(IAepPredispatchMessageHandler handler) {
        IAepPredispatchMessageHandler previous = this.predispatchMessageHandler;
        this.predispatchMessageHandler = handler;
        return previous;
    }

    public final IAepPostdispatchMessageHandler setPostdispatchMessageHandler(IAepPostdispatchMessageHandler handler) {
        IAepPostdispatchMessageHandler previous = this.postdispatchMessageHandler;
        this.postdispatchMessageHandler = handler;
        return previous;
    }

    public final void setAsynchronousEventHandler(IAepAsynchronousEventHandler handler) {
        this.asynchronousEventHandler = handler;
    }

    public final void setMessageFilter(MessageViewFilter messageFilter) {
        this.messageFilter = messageFilter;
    }

    @Deprecated
    public final void start(Map<StartupExpectation, Enum<?>> expectations) throws EAepException {
        if (expectations != null) {
            this.engineDescriptor.getStartupExpectations().clear();
            this.engineDescriptor.getStartupExpectations().putAll(expectations);
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws EAepException {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Starting engine '" + this.engineDescriptor.getName() + "'...", Tracer.Level.DEBUG);
        }
        if (this.state == State.Init) {
            Object object = this.engineStartCompletionNotifier;
            synchronized (object) {
                try {
                    this.multiplexer.open();
                    this.state = State.Starting;
                    if (this.stopOnJVMShutdown) {
                        this.shutdownHook = new ShutdownHook();
                        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                        this.tracer.log(this.tracePrefix + " Registered JVM shutdown hook.", Tracer.Level.INFO);
                    } else {
                        this.tracer.log(this.tracePrefix + " Configured to not automatically stop on JVM shutdown.", Tracer.Level.WARNING);
                    }
                    this.openInboundMessageLogger();
                    this.openOutboundMessageLogger();
                    this.openPerTransactionStatsLogger();
                    this.openStore(this.engineExpectationsToStoreExpectations(this.engineDescriptor.getStartupExpectations()));
                    this.dispatchAndDisposeEvent((Event)AepEngineStartedEvent.create(), ExceptionHandlingPolicy.TrapAndDiscard);
                    this.checkAndGoActive(this.store == null ? IStoreBinding.Role.Primary : this.store.getRole());
                    this.state = State.Started;
                    if (this.stuckAlertThreshold > 0L) {
                        this.healthCheck = HealthCheckScheduler.getExecutor().scheduleAtFixedRate(new Runnable(){

                            @Override
                            public void run() {
                                if (AepEngine.this.state == State.Stopped) {
                                    AepEngine.this.healthCheck.cancel(true);
                                }
                                try {
                                    AepEngine.this.performHealthChecks();
                                }
                                catch (Throwable thrown) {
                                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Failure in engine health check. " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                                }
                            }
                        }, this.stuckAlertThreshold, this.stuckAlertThreshold, TimeUnit.MILLISECONDS);
                    }
                    IStoreBinding.InterClusterReplicationRole icrRole = this.store != null ? this.store.getInterClusterReplicationRole() : null;
                    this.tracer.log(this.tracePrefix + " Engine started [" + (Object)((Object)this.haPolicy) + ", " + (this.isClustered() ? "Clustered" : "Standalone") + (this.isClustered() ? ", " + this.role : "") + ", " + (this.isPersistent() ? "Persistent" : "Non-Persistent") + ", ICR " + (icrRole == null ? "Off" : icrRole) + "].", Tracer.Level.INFO);
                }
                catch (EAepException e) {
                    try {
                        this.stop((Exception)((Object)e), true);
                    }
                    catch (Exception e1) {
                        this.tracer.log(this.tracePrefix + " Failed to stop engine after start failure [" + e1.toString() + "].", Tracer.Level.WARNING);
                    }
                    finally {
                        this.state = State.Stopped;
                        MessagingStartCompletionNotifier messagingStartCompletionNotifier = this.messagingStartCompletionNotifier;
                        synchronized (messagingStartCompletionNotifier) {
                            this.messagingStartCompletionNotifier.notifyAll();
                        }
                    }
                    this.tracer.log(this.tracePrefix + " Engine start failed [" + e.toString() + "].", Tracer.Level.INFO);
                    throw e;
                }
                finally {
                    this.engineStartCompletionNotifier.notifyAll();
                }
            }
        }
        if (this.state != State.Started) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " ...already started.", Tracer.Level.DEBUG);
        }
    }

    public final void waitForMessagingToStart() throws EAepException {
        if (this.state == State.Started) {
            EAepException ret = this.checkAndWaitForMessagingToStart();
            if (ret != null) {
                this.stop((Exception)((Object)ret), false);
                throw ret;
            }
        } else {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
    }

    public final State getState() {
        return this.state;
    }

    public final MessagingState getMessagingState() {
        return this.messagingState;
    }

    public final IStoreBinding getStore() {
        return this.store;
    }

    public final Collection<AepBusConnection> getBusConnections() {
        return this.busConnections.values();
    }

    public final void startBusConnection(String name) throws EAepException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.state != State.Started) {
            throw new IllegalStateException("invalid engine state '" + (Object)((Object)this.state) + "'");
        }
        if (this.messagingState != MessagingState.Started) {
            throw new IllegalStateException("invalid engine messaging state '" + (Object)((Object)this.messagingState) + "'");
        }
        AepBusConnection busConnection = this.busConnections.get(name);
        if (busConnection == null) {
            throw new IllegalArgumentException("supplied name does not refer to a valid bus connection");
        }
        if (!busConnection.isManualStart()) {
            throw new IllegalStateException("specified bus connection is not configured for manual start");
        }
        AepBusConnection.State busConnectionState = busConnection.getState();
        switch (busConnectionState) {
            case CREATED: 
            case FAILED: 
            case CLOSED: {
                throw new IllegalStateException("invalid bus connection state '" + (Object)((Object)busConnectionState) + "'");
            }
            case OPENING: 
            case OPEN: {
                try {
                    busConnection.start();
                    break;
                }
                catch (RuntimeException e) {
                    throw new EAepException(e);
                }
            }
            case STARTED: {
                break;
            }
            default: {
                throw new InternalError("unknown bus connection state '" + (Object)((Object)busConnectionState) + "'");
            }
        }
    }

    @Deprecated
    public final void startBusManager(String name) throws EAepException {
        this.startBusConnection(name);
    }

    public final IEventMultiplexer getEventMultiplexer() {
        if (this.state == State.Started && this.isPrimary()) {
            return this.multiplexer;
        }
        if (this.state != State.Started) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        throw new IllegalStateException("cannot be invoked on a backup");
    }

    public final boolean isDispatchThread() {
        return Thread.currentThread() == this.activeThread;
    }

    public final boolean isMessageDispatchThread() {
        return Thread.currentThread() == this.activeThread && this.activeMessage != null;
    }

    public final IRogMessage getCurrentMessage() {
        return this.activeMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void injectMessage(IRogMessage message, boolean nonBlocking, int delay, IEventAcknowledger acknowledger) {
        if (message == null) {
            throw new IllegalArgumentException("cannot inject a null message");
        }
        if (this.state != State.Starting && this.state != State.Started) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)message, (IEventAcknowledger)acknowledger);
        try {
            this.injectMessage(messageEvent, nonBlocking, delay);
        }
        finally {
            messageEvent.dispose();
        }
    }

    public final void injectMessage(IRogMessage message, boolean nonBlocking, int delay) {
        this.injectMessage(message, nonBlocking, delay, null);
    }

    public final void injectMessage(IRogMessage message, boolean nonBlocking, IEventAcknowledger acknowledger) {
        this.injectMessage(message, nonBlocking, 0, acknowledger);
    }

    public final void injectMessage(IRogMessage message, boolean nonBlocking) {
        this.injectMessage(message, nonBlocking, 0, null);
    }

    public final void injectMessage(IRogMessage message, IEventAcknowledger acknowledger) {
        this.injectMessage(message, false, 0, acknowledger);
    }

    public final void injectMessage(IRogMessage message) {
        this.injectMessage(message, false, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long injectRequest(IRogMessage message, IEventAcknowledger acknowledger) {
        if (message == null) {
            throw new IllegalArgumentException("cannot inject a null message");
        }
        if (this.state != State.Starting && this.state != State.Started) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        if (this.activeThread == Thread.currentThread()) {
            throw new IllegalStateException("this method cannot be invoked by the active engine thread");
        }
        long requestId = this.nextRequestId.getAndIncrement();
        message.setRequestorId(this.getName());
        message.setRequestId(requestId);
        MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)message, (IEventAcknowledger)acknowledger);
        InjectedRequestContext injectedRequestContext = ((InjectedRequestContext)this.injectedRequestContextsPool.get(null)).init(requestId, messageEvent);
        UtlLinkedLongMap<InjectedRequestContext> utlLinkedLongMap = this.injectedRequestContexts;
        synchronized (utlLinkedLongMap) {
            this.injectedRequestContexts.put(requestId, (Object)injectedRequestContext);
        }
        this.injectMessage(messageEvent, false, 0);
        return requestId;
    }

    public final long injectRequest(IRogMessage message) {
        return this.injectRequest(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R extends IRogMessage> R waitForReplyToInjectedRequest(long requestId, int timeout) {
        InjectedRequestContext injectedRequestContext;
        UtlLinkedLongMap<InjectedRequestContext> utlLinkedLongMap = this.injectedRequestContexts;
        synchronized (utlLinkedLongMap) {
            injectedRequestContext = (InjectedRequestContext)((Object)this.injectedRequestContexts.get(requestId));
        }
        if (injectedRequestContext == null) {
            throw new IllegalArgumentException("invalid request id");
        }
        IRogMessage genericReply = injectedRequestContext.waitForReply(timeout);
        if (genericReply != null) {
            IRogMessage reply = genericReply;
            reply.acquire();
            UtlLinkedLongMap<InjectedRequestContext> utlLinkedLongMap2 = this.injectedRequestContexts;
            synchronized (utlLinkedLongMap2) {
                ((InjectedRequestContext)((Object)this.injectedRequestContexts.remove(requestId))).dispose();
            }
            return (R)reply;
        }
        return null;
    }

    public final <R extends IRogMessage> R waitForReplyToInjectedRequest(long requestId) {
        return this.waitForReplyToInjectedRequest(requestId, 0);
    }

    public final <R extends IRogMessage> R injectRequestAndWaitForReply(IRogMessage message, IEventAcknowledger acknowledger, int timeout) {
        return this.waitForReplyToInjectedRequest(this.injectRequest(message, acknowledger), timeout);
    }

    public final <R extends IRogMessage> R injectRequestAndWaitForReply(IRogMessage message, int timeout) {
        return this.injectRequestAndWaitForReply(message, null, timeout);
    }

    public final <R extends IRogMessage> R injectRequestAndWaitForReply(IRogMessage message, IEventAcknowledger acknowledger) {
        return this.injectRequestAndWaitForReply(message, acknowledger, 0);
    }

    public final <R extends IRogMessage> R injectRequestAndWaitForReply(IRogMessage message) {
        return this.injectRequestAndWaitForReply(message, null, 0);
    }

    public final AepScheduleEvent scheduleMessage(IRogMessage message) {
        return this.scheduleMessage(message, 0, AepScheduleEvent.HAPolicy.Cancel);
    }

    public final AepScheduleEvent scheduleMessage(IRogMessage message, int delay) {
        return this.scheduleMessage(message, delay, AepScheduleEvent.HAPolicy.Cancel);
    }

    public final AepScheduleEvent scheduleMessage(IRogMessage message, int delay, AepScheduleEvent.HAPolicy haPolicy) {
        if (message == null) {
            throw new IllegalArgumentException("cannot schedule a null message");
        }
        if (haPolicy == null) {
            throw new IllegalArgumentException("schedule's HA policy cannot be null");
        }
        if (haPolicy == AepScheduleEvent.HAPolicy.Resume) {
            throw new IllegalArgumentException("the 'Resume' policy is in experimental phase and not supported for use right now");
        }
        if (this.syncOnInject) {
            message.sync();
        }
        return this.scheduleObjectOrMessage(message, delay, haPolicy);
    }

    public final AepScheduleEvent scheduleObject(Object object) {
        return this.scheduleObject(object, 0, AepScheduleEvent.HAPolicy.Cancel);
    }

    public final AepScheduleEvent scheduleObject(Object object, int interval) {
        return this.scheduleObject(object, interval, AepScheduleEvent.HAPolicy.Cancel);
    }

    public final AepScheduleEvent scheduleObject(Object object, int interval, AepScheduleEvent.HAPolicy haPolicy) {
        if (haPolicy == null) {
            throw new IllegalArgumentException("HA policy cannot be null");
        }
        if (haPolicy == AepScheduleEvent.HAPolicy.Resume) {
            throw new IllegalArgumentException("the 'Resume' policy is in experimental phase and not supported for use right now");
        }
        return this.scheduleObjectOrMessage(object, interval, haPolicy);
    }

    public final void cancelSchedule(AepScheduleEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("cancel event cannot be null");
        }
        if (this.activeMessage == null && !this.inMessagingStarted) {
            throw new IllegalStateException("must be invoked from a message, 'messaging started' or schedule event handler");
        }
        if (this.activeThread != Thread.currentThread()) {
            throw new IllegalStateException("invoked by a non handler dispatch thread");
        }
        if (this.state != State.Starting && this.state != State.Started) {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
        if (this.state == State.Started && this.isPrimary()) {
            switch (event.getState()) {
                case NotActivated: {
                    this.unscheduleScheduleInternalSchedulingEvent(event);
                    this.cancelAndRemoveSchedule(event);
                    break;
                }
                case Activated: {
                    this.unscheduleScheduleInternalSchedulingEvent(event);
                    this.scheduleScheduleCancelMessage(event);
                    event.setState(AepScheduleEvent.State.Cancelling);
                    break;
                }
            }
        } else {
            switch (event.getState()) {
                case NotActivated: {
                    this.cancelAndRemoveSchedule(event);
                    break;
                }
                case Activated: {
                    event.setState(AepScheduleEvent.State.Cancelling);
                    break;
                }
            }
        }
        if (this.someDebugTrace && this.schedTracer.debug) {
            this.schedTracer.log("Sched #" + event.getId() + " --> cancel --> " + (Object)((Object)event.getState()), Tracer.Level.DEBUG);
        }
    }

    public final IRogMessageLogger getInboundMessageLogger() {
        return this.inboundMessageLogger;
    }

    public final IRogMessageLogger getOutboundMessageLogger() {
        return this.outboundMessageLogger;
    }

    final IRogMessageLogger getPerTransactionStatsLogger() {
        return this.perTransactionStatsLogger;
    }

    public final boolean isPrimary() {
        if (this.state == State.Starting || this.state == State.Started || this.state == State.Stopping) {
            return this.role == IStoreBinding.Role.Primary;
        }
        throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
    }

    public final String getClientBusName() {
        return this.clientBusName;
    }

    public final MessageBusBinding getDirectBusBinding() {
        AepBusConnection busConnection = this.busConnections.get(DIRECT_BUS_NAME);
        return busConnection != null ? busConnection.getBusBinding() : null;
    }

    public final IAepEngineStats getStats() {
        return this.stats;
    }

    public final <T> T getApplicationState(int flowid) {
        if (flowid < 0) {
            throw new IllegalArgumentException("flow id must be >= 0");
        }
        if (this.state == State.Init || this.state == State.Starting || this.state == State.Started) {
            if (this.messagingState == MessagingState.Init || this.messagingState == MessagingState.Starting) {
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Getting application state in flow (id=" + flowid + ") on application's request.", Tracer.Level.DEBUG);
                }
                return (T)this.getApplicationState(this.getFlow(flowid), null);
            }
            throw new IllegalStateException("invalid messaging state '" + (Object)((Object)this.messagingState) + "'");
        }
        throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
    }

    public final <T> T getApplicationState(MessageView message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (this.state == State.Starting || this.state == State.Started) {
            return (T)((AepFlow)((Object)message.getTag(1))).getApplicationState();
        }
        throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
    }

    public final long getEngineTime() {
        if (this.haPolicy == HAPolicy.EventSourcing && this.isDispatchThread()) {
            IRogMessage activeMessage = this.activeMessage;
            return activeMessage != null ? activeMessage.getPreProcessingTs() : System.currentTimeMillis();
        }
        return System.currentTimeMillis();
    }

    public final long getEngineTimeMicros() {
        if (this.haPolicy == HAPolicy.EventSourcing && this.isDispatchThread()) {
            IRogMessage activeMessage = this.activeMessage;
            return activeMessage != null ? activeMessage.getPreProcessingTsMicros() : UtlTime.nowInMicros();
        }
        return UtlTime.nowInMicros();
    }

    public final void resumeCommit(AepTransactionStageEvent.ICommitContext context) {
        if (this.state == State.Started) {
            if (context == null) {
                throw new IllegalArgumentException("commit context cannot be null");
            }
            AepResumeTransactionEvent event = AepResumeTransactionEvent.create((Transaction.CommitContext)context);
            try {
                this.multiplexer.multiplexEvent((Event)event, 1);
            }
            finally {
                event.dispose();
            }
        } else {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
    }

    private final void sendMessageInternal(MessageChannel channel, IRogMessage message, Properties keyResolutionTable, MessageChannel.RawKeyResolutionTable rawKeyResolutionTable, int sendFlags) {
        long ts;
        long l = ts = this.recordMsgLegWaypoints || this.recordMsgLegLatencies ? UtlTime.now() : 0L;
        if (this.state == State.Starting || this.state == State.Started) {
            boolean needsSyncForKeyResolution;
            if (message == null) {
                throw new IllegalArgumentException("outbound message cannot be null");
            }
            if (message.getIsInboundMessage()) {
                throw new IllegalArgumentException("inbound message cannot be sent outbound");
            }
            if (message.getIsOutboundMessage()) {
                throw new IllegalArgumentException("message cannot be sent repeatedly");
            }
            if (this.haPolicy == HAPolicy.EventSourcing && (message.getMessageBus() == null || message.getMessageChannel() == null)) {
                throw new IllegalArgumentException("When using event sourcing, the message bus and channel fields should be set in sent messages");
            }
            if (Config.conserveMemory()) {
                message.saveMemory();
            }
            if (this.setSupportMetadata) {
                message.setOutTsMicros(UtlTime.nowInMicros());
                if (this.recordMsgLegWaypoints && message.getAppSendBeginTs() == 0L) {
                    message.setAppSendBeginTs(ts);
                }
            }
            message.setAsMessage(true);
            message.setAsOutboundMessage(true);
            if (this.setOutboundMessageAsReadOnly) {
                message.setAsReadOnly();
            }
            boolean bl = needsSyncForKeyResolution = message.getMessageReflector() != null && message.getMessageReflector().needsSync();
            if (this.haPolicy != HAPolicy.EventSourcing || this.role == IStoreBinding.Role.Primary) {
                if (channel == null) {
                    throw new IllegalArgumentException("outbound channel cannot be null");
                }
                if (this.checked && !(channel.getMessageBusBinding().getAttachment() instanceof AepBusConnection)) {
                    throw new IllegalArgumentException("channel is not an AEP managed channel. channels used with this method must be obtained from AEP");
                }
                try {
                    XString key;
                    if (needsSyncForKeyResolution) {
                        message.sync();
                    }
                    if ((key = message.getMessageKeyAsRaw()) == null || key.isNull()) {
                        if (keyResolutionTable != null) {
                            message.resolveMessageKeyWith(channel.getMessageKeyResolver(), keyResolutionTable);
                        } else {
                            message.resolveMessageKeyWith(channel.getMessageKeyResolver(), rawKeyResolutionTable);
                        }
                        key = message.getMessageKeyAsRaw();
                    }
                    if (key != null && !key.isNull()) {
                        channel.validateResolvedMessageKey((MessageView)message);
                    }
                    message.setMessageSender(this.senderId);
                    if (this.activeThread == Thread.currentThread() && this.activeMessage != null) {
                        if (this.recordMsgLegWaypoints) {
                            message.setOriginTs(this.activeMessage.getOriginTs());
                        }
                        if (this.setOutboundSequenceNumbers) {
                            message.setMessageSequenceNumber(this.outboundMessagingContext.nextSno((MessageView)message));
                        }
                        this.sendMessageSolicited(channel, message);
                    }
                    this.sendMessageUnsolicited(channel, message, ts, sendFlags, needsSyncForKeyResolution);
                }
                catch (SmaException e) {
                    throw new RuntimeException(e);
                }
            } else if (this.activeThread == Thread.currentThread() && this.activeMessage != null) {
                XString key;
                long sno = this.outboundMessagingContext.nextSno((MessageView)message);
                if (needsSyncForKeyResolution) {
                    message.sync();
                }
                if ((key = message.getMessageKeyAsRaw()) == null || key.isNull()) {
                    DefaultMessageChannelKeyResolver resolver = this.outboundMessagingContext.getMessageKeyResolver(message);
                    try {
                        if (keyResolutionTable != null) {
                            message.resolveMessageKeyWith((MessageChannelKeyResolver)resolver, keyResolutionTable);
                        } else {
                            message.resolveMessageKeyWith((MessageChannelKeyResolver)resolver, rawKeyResolutionTable);
                        }
                    }
                    catch (SmaException e) {
                        throw new RuntimeException(e);
                    }
                }
                message.setMessageSender(this.senderId);
                if (this.setOutboundSequenceNumbers) {
                    message.setMessageSequenceNumber(sno);
                }
                message.setInMsgsInTransaction(this.transaction.currentCommitContext.hasInboundMsgs);
                message.setTransactionId(this.transaction.id());
                IStoreBinding.Role role = this.getStore().getRole();
                if (this.someDebugTrace) {
                    if (this.snoTracer.debug) {
                        this.snoTracer.log("--> [" + this.senderId + ", " + sno + "] Q", Tracer.Level.DEBUG);
                    }
                    if (this.msgTracer.debug) {
                        this.msgTrace("[MSG-OUT-Q]", (IRogNode)message);
                    }
                }
                this.outboundMessagingContext.enqueInOutboundQueue(message, this.transaction.savepoint);
                if (role == IStoreBinding.Role.Backup) {
                    this.outboundMessagingContext.enqueForLogging(message, this.transaction.savepoint);
                }
            } else if (this.someDebugTrace) {
                if (this.snoTracer.debug) {
                    this.snoTracer.log("--> [" + this.senderId + ", ?] X", Tracer.Level.DEBUG);
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Discarding outbound message (operating with event sourcing, primary/backup being initialized OR backup in normal state, unsolicited send)", Tracer.Level.DEBUG);
                }
            }
            if (this.recordMsgLegWaypoints) {
                message.setAppSendDoneTs(UtlTime.now());
            }
            if (this.disposeOnSend) {
                message.dispose();
            }
            if (this.recordMsgLegLatencies) {
                this.stats.msgSendLatencies.add((double)(UtlTime.now() - ts));
            }
        } else {
            throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        }
    }

    public final void sendMessage(MessageChannel channel, IRogMessage message, Properties keyResolutionTable) {
        this.sendMessageInternal(channel, message, keyResolutionTable, null, 0);
    }

    public final void sendMessage(MessageChannel channel, IRogMessage message, MessageChannel.RawKeyResolutionTable keyResolutionTable) {
        this.sendMessageInternal(channel, message, null, keyResolutionTable, 0);
    }

    public final void sendMessage(MessageChannel channel, IRogMessage message, String key, Properties keyResolutionTable) {
        if (message != null) {
            message.setMessageKey(key);
        }
        this.sendMessageInternal(channel, message, keyResolutionTable, null, 0);
    }

    public final void sendMessage(MessageChannel channel, IRogMessage message, XString key, MessageChannel.RawKeyResolutionTable keyResolutionTable) {
        if (message != null) {
            message.setMessageKeyAsRaw(key);
        }
        this.sendMessageInternal(channel, message, null, keyResolutionTable, 0);
    }

    public final void sendMessage(MessageChannel channel, IRogMessage message) {
        this.sendMessageInternal(channel, message, null, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void replyToClient(MessageChannel channel, PktPacket request, PktPacket reply, int replyCount, int replyNum) throws Exception {
        if (channel == null) {
            throw new IllegalArgumentException("outbound channel cannot be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("inbound request cannot be null");
        }
        if (this.state != State.Started) throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        if (reply == null) {
            reply = PktFactory.getInstance().createPacket(260);
        }
        try {
            if (!PktSubheaderRR.prepareReply((PktPacket)request, (PktPacket)reply, (int)replyCount, (int)replyNum)) return;
            this.sendMessageInternal(channel, (IRogMessage)RogPacketMessageFactory.createPacketMessage().deserializeFromPacket(reply.acquire()), null, null, 1);
            return;
        }
        finally {
            reply.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void replyToClientWithError(MessageChannel channel, PktPacket request, PktPacket reply, long errorCode) throws Exception {
        if (channel == null) {
            throw new IllegalArgumentException("outbound channel cannot be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("inbound request cannot be null");
        }
        if (this.state != State.Started) throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
        if (reply == null) {
            reply = PktFactory.getInstance().createPacket(260);
        }
        try {
            if (!PktSubheaderRR.prepareReply((PktPacket)request, (PktPacket)reply, (long)errorCode)) return;
            this.sendMessageInternal(channel, (IRogMessage)RogPacketMessageFactory.createPacketMessage().deserializeFromPacket(reply.acquire()), null, null, 1);
            return;
        }
        finally {
            reply.dispose();
        }
    }

    public final int createTransactionSavepoint() {
        this.assertSavepointsAllowed();
        return this.transaction.createSavepoint(false);
    }

    public final int getTransactionSavepoint() {
        this.assertSavepointsAllowed();
        return this.transaction.getExternalSavepoint();
    }

    public final void rollbackToTransactionSavepoint(int savepoint) {
        this.assertSavepointsAllowed();
        if (savepoint < 0 || savepoint > this.transaction.getExternalSavepoint()) {
            throw new IllegalStateException("Invalid savepoint '" + savepoint + "'");
        }
        this.transaction.rollback(savepoint, false);
    }

    private final void assertSavepointsAllowed() {
        if (!this.enableTransactionSavepoints) {
            throw new IllegalStateException("Transaction savepoints have not been enabled for this aep engine.");
        }
        if (this.store == null) {
            throw new IllegalStateException("Transaction savepoints are only supported when storage is enabled.");
        }
        if (this.replicateInParallel) {
            throw new IllegalStateException("Transaction savepoints are not supported when replicate in parallel is enabled.");
        }
        if (!this.isDispatchThread() || this.activeMessage == null) {
            throw new IllegalStateException("Transaction savepoints operations can only be used from within an event handler.");
        }
        if (!this.transaction.isStarted()) {
            throw new IllegalStateException("Transaction savepoints cannot be used outside of a transaction.");
        }
    }

    public final void setAsLastTransaction(Exception cause, boolean ignoreIfStarting, boolean shutdownCluster) {
        this.setAsLastTransactionCore(cause, ignoreIfStarting, shutdownCluster, false);
    }

    public final void setAsLastTransaction(Exception cause, boolean ignoreIfStarting) {
        this.setAsLastTransaction(cause, ignoreIfStarting, false);
    }

    private final void stopCore(Exception cause, boolean preserveChannelJoins) {
        this.stats.close();
        this.systats.close();
        this.stopMessaging(cause, preserveChannelJoins);
        this.closeStore(cause, preserveChannelJoins);
        for (int i = 0; i < this.numEnvironmentProviderProxies; ++i) {
            this.environmentProviderProxies[i].close();
        }
        if (this.inboundMessageLogger != null) {
            this.inboundMessageLogger.close();
        }
        if (this.outboundMessageLogger != null) {
            this.outboundMessageLogger.close();
        }
        if (this.perTransactionStatsLogger != null) {
            this.perTransactionStatsLogger.close();
        }
        this.multiplexer.close();
        this.transaction.close();
        if (this.healthCheck != null) {
            this.healthCheck.cancel(true);
        }
        this.outboundMessagingContext.close();
        if (this.stopOnJVMShutdown && this.shutdownHook != null && !this.inJVMShutdown) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.tracer.log(this.tracePrefix + " Unregistered JVM shutdown hook.", Tracer.Level.INFO);
        }
        this.state = State.Stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitForStopToComplete() {
        Object object = this.engineStopCompletionNotifier;
        synchronized (object) {
            while (this.state != State.Stopped) {
                try {
                    this.engineStopCompletionNotifier.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private final void stop(Exception cause, boolean waitForStopToComplete) {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Stopping engine '" + this.engineDescriptor.getName() + "' (cause=" + (cause == null ? "null" : cause.toString()) + ")...", Tracer.Level.DEBUG);
        }
        switch (this.state) {
            case Init: {
                this.stopCore(null, true);
                break;
            }
            case Starting: 
            case Started: {
                if (this.someDebugTrace && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Scheduling stop...", Tracer.Level.DEBUG);
                }
                this.state = State.Stopping;
                this.multiplexer.multiplexEvent((Event)AepEngineStopEvent.create(cause), 0);
                this.stop(cause, waitForStopToComplete);
                break;
            }
            case Stopping: {
                if (waitForStopToComplete && Thread.currentThread() != this.activeThread) {
                    if (this.someDebugTrace && this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + " Waiting for stop to complete...", Tracer.Level.DEBUG);
                    }
                    this.waitForStopToComplete();
                    if (!this.someDebugTrace || !this.tracer.debug) break;
                    this.tracer.log(this.tracePrefix + " ...stop is complete...", Tracer.Level.DEBUG);
                    break;
                }
                if (!this.someDebugTrace || !this.tracer.debug) break;
                this.tracer.log(this.tracePrefix + " ...not waiting for stop to complete (waitForStopToComplete=" + waitForStopToComplete + ")...", Tracer.Level.DEBUG);
                break;
            }
            case Stopped: {
                if (!this.someDebugTrace || !this.tracer.debug) break;
                this.tracer.log(this.tracePrefix + " ...already stopped", Tracer.Level.DEBUG);
                break;
            }
            default: {
                throw new IllegalStateException("invalid state '" + (Object)((Object)this.state) + "'");
            }
        }
    }

    final XString getMessageGlobalType(Class<? extends IRogMessage> c) {
        XString ret = this.messageGlobalTypes.get(c);
        if (ret == null) {
            try {
                Method getGlobalTypeMethod = c.getMethod("getGlobalTypeString", new Class[0]);
                try {
                    ret = (XString)getGlobalTypeMethod.invoke(null, new Object[0]);
                    this.messageGlobalTypes.put(c, ret);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Global type fetch method in message class [" + c.getName() + "] returned object of incorrect type");
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Access to global type fetch method in message class [" + c.getName() + "] is denied");
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("Access to global type fetch method in message class [" + c.getName() + "] is denied");
            }
            catch (NoSuchMethodException e1) {
                this.tracer.log(this.tracePrefix + " Could not find getGlobalTypeString method in '" + c.getName() + " message class", Tracer.Level.WARNING);
            }
        }
        return ret;
    }

    public final void stop(Exception cause) {
        this.stop(cause, true);
    }

    public final void stop() {
        this.stop(null);
    }

    public final String getName() {
        return this.engineDescriptor.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void onEvent(Event event) {
        if (this.someDebugTrace && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Received an event (event=" + event + ")", Tracer.Level.DEBUG);
        }
        long eventReceiptTs = this.recordTxnLegLatencies || this.recordMsgLegWaypoints || this.recordMsgLegLatencies || this.captureEvLatencyStats ? UtlTime.now() : 0L;
        ++this.stats.numEventsRcvd;
        this.activeThread = Thread.currentThread();
        short eventType = event.getType();
        boolean isFlowEvent = false;
        if (this.someDebugTrace && this.evTracer.debug) {
            if (event instanceof MessageEvent) {
                this.evTracer.log("<-- [" + event.getClass().getSimpleName() + "<" + eventType + "> (" + ((MessageEvent)event).getMessageView().getClass().getSimpleName() + ", eob=" + event.isEndOfBatch() + ")] " + (this.state != State.Stopping || eventType == 513 ? "" : "X"), Tracer.Level.DEBUG);
            } else if (event instanceof IStoreObjectReceivedEvent) {
                this.evTracer.log("<-- [" + event.getClass().getSimpleName() + "<" + eventType + "> (" + ((IStoreObjectReceivedEvent)event).getObject().getClass().getSimpleName() + ", eob=" + event.isEndOfBatch() + ")] " + (this.state != State.Stopping || eventType == 513 ? "" : "X"), Tracer.Level.DEBUG);
            } else if (event instanceof IStoreObjectAddedEvent) {
                this.evTracer.log("<-- [" + event.getClass().getSimpleName() + "<" + eventType + "> (" + ((IStoreObjectAddedEvent)event).getObject().getClass().getSimpleName() + ", eob=" + event.isEndOfBatch() + ")] " + (this.state != State.Stopping || eventType == 513 ? "" : "X"), Tracer.Level.DEBUG);
            } else if (event instanceof IStoreObjectUpdatedEvent) {
                this.evTracer.log("<-- [" + event.getClass().getSimpleName() + "<" + eventType + "> (" + ((IStoreObjectUpdatedEvent)event).getObject().getClass().getSimpleName() + ", eob=" + event.isEndOfBatch() + ")] " + (this.state != State.Stopping || eventType == 513 ? "" : "X"), Tracer.Level.DEBUG);
            } else if (event instanceof IStoreObjectRemovedEvent) {
                this.evTracer.log("<-- [" + event.getClass().getSimpleName() + "<" + eventType + "> (" + ((IStoreObjectRemovedEvent)event).getObject().getClass().getSimpleName() + ", eob=" + event.isEndOfBatch() + ")] " + (this.state != State.Stopping || eventType == 513 ? "" : "X"), Tracer.Level.DEBUG);
            } else if (event instanceof MessageStabilityEvent) {
                this.evTracer.log("<-- [" + event.getClass().getSimpleName() + "<" + eventType + "> (" + ((MessageStabilityEvent)event).getMessageView().getClass().getSimpleName() + ", eob=" + event.isEndOfBatch() + ")] " + (this.state != State.Stopping || eventType == 513 ? "" : "X"), Tracer.Level.DEBUG);
            } else {
                this.evTracer.log("<-- [" + event.getClass().getSimpleName() + "<" + eventType + "> (eob=" + event.isEndOfBatch() + ")] " + (this.state != State.Stopping || eventType == 513 ? "" : "X"), Tracer.Level.DEBUG);
            }
        }
        try {
            if (eventType == 105 && !(((MessageEvent)event).getMessageView() instanceof IRogMessage)) {
                AepUnhandledMessageEvent ume = AepUnhandledMessageEvent.create((MessageEvent)event);
                this.dispatchAndDisposeEvent((Event)ume, ExceptionHandlingPolicy.TrapAndDiscard);
                return;
            }
            if (this.state != State.Stopping) {
                boolean doCommit;
                if (!this.transaction.isStarted()) {
                    this.transaction.start();
                }
                boolean commit = true;
                boolean adaptiveCommit = false;
                boolean filtered = false;
                if ((eventType == 509 || eventType == 105 || eventType == 508) && this.lastTransactionContext == null) {
                    MessageViewFilter filter;
                    if ((this.recordTxnLegLatencies || this.capturePerTxnStats) && this.transaction.startTs == 0L) {
                        this.transaction.startTs = eventReceiptTs;
                    }
                    isFlowEvent = true;
                    if (eventType == 105 && (filter = this.messageFilter) != null) {
                        MessageEvent messageEvent = (MessageEvent)event;
                        MessageView view = messageEvent.getMessageView();
                        long ts = this.recordMsgLegLatencies ? UtlTime.now() : 0L;
                        boolean appException = false;
                        try {
                            filtered = filter.filter(view);
                        }
                        catch (Throwable thrown) {
                            appException = true;
                            filtered = true;
                            this.handleAppMessageHandlingException("message filter", messageEvent, thrown);
                        }
                        if (!appException && filtered) {
                            commit = false;
                            this.updateRcvdMessageStats(view, messageEvent, true, false);
                            if (this.someDebugTrace) {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.tracePrefix + " Filtered message event " + event + "...", Tracer.Level.DEBUG);
                                }
                                if (this.msgTracer.debug && view instanceof IRogNode) {
                                    this.msgTrace("[MSG-IN-FILTERED]", (IRogNode)view);
                                }
                            }
                        }
                        if (this.recordMsgLegLatencies) {
                            long now = UtlTime.now();
                            this.stats.msgFilteringLatencies.add((double)(now - ts));
                            AepEngineStats.MessageTypeStats typeStats = this.getMessageTypeStats(view, true);
                            if (typeStats != null) {
                                if (typeStats.msgFilteringLatencies != null) {
                                    typeStats.msgFilteringLatencies.add((double)(now - ts));
                                }
                                if (event.getOfferTs() > 0L) {
                                    if (typeStats.msgCreateToOfferLatencies != null && view.getCreateTs() > 0L) {
                                        typeStats.msgCreateToOfferLatencies.add((double)(event.getOfferTs() - view.getCreateTs()));
                                    }
                                    if (typeStats.msgOfferToPollLatencies != null && event.getPollTs() > 0L) {
                                        typeStats.msgOfferToPollLatencies.add((double)(event.getPollTs() - event.getOfferTs()));
                                    }
                                }
                            }
                        }
                    }
                    if (!filtered) {
                        if (eventType == 105 && !this.inCommitBatch) {
                            for (int i = 0; i < this.numEnvironmentProviderProxies; ++i) {
                                try {
                                    this.environmentProviderProxies[i].startRecording();
                                    continue;
                                }
                                catch (Throwable e) {
                                    throw new RuntimeException("Application ('" + this.engineDescriptor.getName() + "') environment provider faulted with error [" + e.toString() + "] on transaction start.", e);
                                }
                            }
                        }
                        switch (eventType) {
                            case 509: {
                                if (this.replicateInParallel) {
                                    this.transaction.doStoreCommitCore(this.transaction.doInboundMessageReplicatePrepare(this.transaction.currentCommitContext));
                                }
                                this.onMessagingStarted((AepMessagingStartedEvent)event);
                                break;
                            }
                            case 105: {
                                adaptiveCommit = true;
                                this.onMessage((MessageEvent)event, eventReceiptTs);
                                break;
                            }
                            case 508: {
                                adaptiveCommit = true;
                                this.onSend((AepSendEvent)event);
                            }
                        }
                    }
                } else {
                    commit = false;
                    switch (eventType) {
                        case 534: {
                            this.onBusBindingOpening((AepBusBindingOpeningEvent)event);
                            break;
                        }
                        case 535: {
                            this.onBusBindingOpened((AepBusBindingOpenedEvent)event);
                            break;
                        }
                        case 536: {
                            this.onBusBindingOpenFailed((AepBusBindingOpenFailedEvent)event);
                            break;
                        }
                        case 504: {
                            this.onChannelUp((AepChannelUpEvent)event);
                            break;
                        }
                        case 511: {
                            this.onBusBindingUp((AepBusBindingUpEvent)event);
                            break;
                        }
                        case 505: {
                            this.onChannelDown((AepChannelDownEvent)event);
                            break;
                        }
                        case 512: {
                            this.onBusBindingDown((AepBusBindingDownEvent)event);
                            break;
                        }
                        case 105: {
                            if (!this.lastTransactionContext.shutdownAfterThisTransaction && ((MessageEvent)event).getMessageView() instanceof AepShutdownMessage) {
                                commit = true;
                                this.onMessage((MessageEvent)event, eventReceiptTs);
                                break;
                            }
                            event.acquire();
                            break;
                        }
                        case 508: {
                            event.acquire();
                            break;
                        }
                        case 104: {
                            this.onMessageStability((MessageStabilityEvent)event);
                            break;
                        }
                        case 506: {
                            this.onSendCommitComplete((AepSendCommitCompletionEvent)event);
                            break;
                        }
                        case 516: {
                            this.onResumeTransaction((AepResumeTransactionEvent)event);
                            break;
                        }
                        case 303: {
                            this.onStoreCommitComplete((IStoreCommitCompletionEvent)event);
                            break;
                        }
                        case 301: {
                            this.onStoreBindingFailed((IStoreBindingFailedEvent)event);
                            break;
                        }
                        case 302: {
                            this.onRoleChange((IStoreBindingRoleChangedEvent)event);
                            break;
                        }
                        case 307: 
                        case 308: 
                        case 309: 
                        case 310: {
                            if (this.recordTxnLegLatencies && this.transaction.startTs == 0L) {
                                this.transaction.startTs = UtlTime.now();
                            }
                            switch (eventType) {
                                case 307: {
                                    commit = this.onObjectAddition((IStoreObjectAddedEvent)event);
                                    break;
                                }
                                case 310: {
                                    commit = this.onObjectUpdate((IStoreObjectUpdatedEvent)event);
                                    break;
                                }
                                case 308: {
                                    commit = this.onObjectRemoval((IStoreObjectRemovedEvent)event);
                                    break;
                                }
                                case 309: {
                                    commit = this.onObjectReceipt((IStoreObjectReceivedEvent)event);
                                }
                            }
                            break;
                        }
                        case 312: 
                        case 313: 
                        case 314: 
                        case 315: 
                        case 316: 
                        case 317: 
                        case 318: 
                        case 319: 
                        case 320: {
                            this.store.processMemberControlEvent((IStoreMemberControlEvent)event);
                            break;
                        }
                        case 305: {
                            this.onStoreMemberInitComplete((IStoreMemberInitCompleteEvent)event);
                            break;
                        }
                        default: {
                            this.dispatchEvent(event, ExceptionHandlingPolicy.TrapAndDiscard);
                        }
                    }
                }
                boolean bl = doCommit = commit && (!adaptiveCommit || this.lastTransactionContext != null || !this.isPrimary());
                if (!doCommit) {
                    boolean bl2 = doCommit = !commit && this.inCommitBatch && event.isEndOfBatch();
                }
                if (!doCommit) {
                    boolean bl3 = doCommit = commit && (this.adaptiveCommitBatchCountdown <= 0 || --this.adaptiveCommitBatchCountdown == 0 || event.isEndOfBatch());
                }
                if (!doCommit && commit) {
                    this.inCommitBatch = true;
                }
                long eventProcessingCompletionTs = 0L;
                if (this.recordTxnLegLatencies) {
                    eventProcessingCompletionTs = UtlTime.now();
                    Transaction ts = this.transaction;
                    ts.cumulativeProcessingTimeBeforeCommit = (int)((long)ts.cumulativeProcessingTimeBeforeCommit + (eventProcessingCompletionTs - eventReceiptTs));
                }
                if (!doCommit) return;
                this.inCommitBatch = false;
                this.adaptiveCommitBatchCountdown = this.adaptiveCommitBatchCeiling;
                try {
                    if (this.someDebugTrace && this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + " Committing current transaction (#" + this.transaction.id() + ")...", Tracer.Level.DEBUG);
                    }
                    this.transaction.commit();
                    if (!this.recordTxnLegLatencies) return;
                    this.stats.txnLeg1ProcTimes.add((double)((long)this.transaction.cumulativeProcessingTimeBeforeCommit + (UtlTime.now() - eventProcessingCompletionTs)));
                    return;
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("AEP transaction commit faulted with error [" + e.toString() + "] with the following stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    sb.append("Stopping engine...\n");
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    this.stop(e instanceof Exception ? (Exception)e : new Exception(e), false);
                }
                return;
            }
            switch (eventType) {
                case 513: {
                    Exception cause = ((AepEngineStopEvent)event).getCause();
                    boolean preserveChannelJoins = cause != null || this.preserveChannelJoinsOnStop;
                    AepEngineStoppingEvent stoppingEvent = AepEngineStoppingEvent.create(cause, preserveChannelJoins);
                    try {
                        this.dispatchEvent((Event)stoppingEvent, ExceptionHandlingPolicy.PassThrough);
                        preserveChannelJoins = stoppingEvent.getPreserveChannelJoins();
                    }
                    catch (Throwable thrown) {
                        preserveChannelJoins = true;
                        this.handleEventHandlingException((Event)stoppingEvent, thrown, ExceptionHandlingPolicy.TrapAndDiscard);
                        if (cause == null) {
                            this.tracer.log("Channel joins will be preserved for app '" + this.getName() + "' because of error in AepEngineStoppingEvent handling", Tracer.Level.SEVERE);
                        }
                    }
                    finally {
                        stoppingEvent.dispose();
                    }
                    this.stopCore(cause, preserveChannelJoins);
                    this.dispatchAndDisposeEvent((Event)AepEngineStoppedEvent.create(cause), ExceptionHandlingPolicy.TrapAndDiscard);
                    Object object = this.engineStopCompletionNotifier;
                    synchronized (object) {
                        this.engineStopCompletionNotifier.notifyAll();
                    }
                    if (!this.someDebugTrace || !this.tracer.debug) return;
                    this.tracer.log(this.tracePrefix + " Engine stopped successfully.", Tracer.Level.DEBUG);
                    return;
                }
                default: {
                    event.acquire();
                    return;
                }
            }
        }
        catch (Throwable e) {
            if (this.state == State.Started) {
                StringBuilder sb = new StringBuilder();
                sb.append("Received unhandled fault [" + e.toString() + "] with the following stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                sb.append("Stopping engine...\n");
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                this.stop(e instanceof Exception ? (Exception)e : new Exception(e), false);
                return;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
        finally {
            this.activeThread = null;
            ++this.stats.numEventsProcessed;
            if (this.stuckAlertThreshold > 0L) {
                this.lastEventProcessedTs = System.currentTimeMillis();
            }
            if (this.captureEvLatencyStats) {
                Stats.LatencyManager eventLatencyManager = this.stats.eventLatencies[eventType];
                if (eventLatencyManager != null) {
                    eventLatencyManager.add((double)(UtlTime.now() - eventReceiptTs));
                } else {
                    this.tracer.log(this.tracePrefix + " *** Latency manager for event '" + eventType + "' is not allocated. Not recording latency ***.", Tracer.Level.WARNING);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onEvent(IStoreEvent event) {
        boolean schedule;
        boolean nonBlockingDispatch;
        boolean dispatchThroughMultiplexer;
        block3 : switch (this.state) {
            case Starting: {
                if (event.getType() == 314) {
                    Object object = this.engineStartCompletionNotifier;
                    synchronized (object) {
                        while (this.state == State.Starting) {
                            try {
                                this.engineStartCompletionNotifier.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.onEvent(event);
                        return;
                    }
                }
                dispatchThroughMultiplexer = false;
                nonBlockingDispatch = false;
                schedule = false;
                this.onEvent((Event)event);
                break;
            }
            case Started: {
                switch (event.getType()) {
                    case 301: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 312: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: {
                        dispatchThroughMultiplexer = true;
                        nonBlockingDispatch = false;
                        schedule = true;
                        event.setDelay(-1001);
                        break block3;
                    }
                    case 313: {
                        dispatchThroughMultiplexer = true;
                        nonBlockingDispatch = false;
                        if (this.isPrimary()) {
                            schedule = true;
                            event.setDelay(-1001);
                            break block3;
                        }
                        schedule = false;
                        break block3;
                    }
                    case 303: {
                        if (Config.tuneForLatency()) {
                            dispatchThroughMultiplexer = false;
                            nonBlockingDispatch = true;
                            schedule = false;
                            this.onStoreCommitComplete((IStoreCommitCompletionEvent)event);
                            break block3;
                        }
                        dispatchThroughMultiplexer = true;
                        nonBlockingDispatch = false;
                        schedule = true;
                        break block3;
                    }
                }
                dispatchThroughMultiplexer = true;
                nonBlockingDispatch = false;
                schedule = false;
                break;
            }
            default: {
                dispatchThroughMultiplexer = false;
                nonBlockingDispatch = false;
                schedule = false;
            }
        }
        if (dispatchThroughMultiplexer) {
            if (schedule) {
                this.multiplexer.scheduleEvent((Event)event);
            } else {
                this.multiplexer.multiplexEvent((Event)event, nonBlockingDispatch ? 1 : 0);
            }
        }
    }

    public <K, T extends IStoreObject> IStoreUniqueIndex<K, T> createStoreUniqueIndex(String fieldPath, String name) {
        if (this.haPolicy != HAPolicy.StateReplication) {
            throw new IllegalStateException(this.tracePrefix + ": Indexing is only supported with HA policy set to 'StateReplication'.");
        }
        if (this.engineDescriptor.getStore() == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index on engine without a store.");
        }
        if (this.store == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index, store not yet initialized.");
        }
        if (this.state != State.Init) {
            throw new IllegalStateException(this.tracePrefix + ": Index must be created before engine is started.");
        }
        return this.store.createUniqueIndex(fieldPath, name);
    }

    public <K, T extends IStoreObject> IStoreNonUniqueIndex<K, T> createStoreNonUniqueIndex(String fieldPath, String name) {
        if (this.haPolicy != HAPolicy.StateReplication) {
            throw new IllegalStateException(this.tracePrefix + ": Indexing is only supported with HA policy set to 'StateReplication'.");
        }
        if (this.engineDescriptor.getStore() == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index on engine without a store.");
        }
        if (this.store == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index, store not yet initialized.");
        }
        if (this.state != State.Init) {
            throw new IllegalStateException(this.tracePrefix + ": Index must be created before engine is started.");
        }
        return this.store.createNonUniqueIndex(fieldPath, name);
    }

    public <K, T extends IStoreObject> IStoreUniqueIndex<K, T> getStoreUniqueIndex(String fieldPath) {
        if (this.haPolicy != HAPolicy.StateReplication) {
            throw new IllegalStateException(this.tracePrefix + ": Indexing is only supported with HA policy set to 'StateReplication'.");
        }
        if (this.engineDescriptor.getStore() == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index on engine without a store.");
        }
        if (this.store == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index, store not yet initialized.");
        }
        if (this.state != State.Init) {
            throw new IllegalStateException(this.tracePrefix + ": Index must be created before engine is started.");
        }
        return this.store.getUniqueIndex(fieldPath);
    }

    public <K, T extends IStoreObject> IStoreNonUniqueIndex<K, T> getStoreNonUniqueIndex(String fieldPath) {
        if (this.haPolicy != HAPolicy.StateReplication) {
            throw new IllegalStateException(this.tracePrefix + ": Indexing is only supported with HA policy set to 'StateReplication'.");
        }
        if (this.engineDescriptor.getStore() == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index on engine without a store.");
        }
        if (this.store == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index, store not yet initialized.");
        }
        if (this.state != State.Init) {
            throw new IllegalStateException(this.tracePrefix + ": Index must be created before engine is started.");
        }
        return this.store.getNonUniqueIndex(fieldPath);
    }

    public boolean dropStoreIndex(String fieldPath) {
        if (this.haPolicy != HAPolicy.StateReplication) {
            throw new IllegalStateException(this.tracePrefix + ": Indexing is only supported with HA policy set to 'StateReplication'.");
        }
        if (this.engineDescriptor.getStore() == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index on engine without a store.");
        }
        if (this.store == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index, store not yet initialized.");
        }
        return this.store.dropIndex(fieldPath);
    }

    public boolean dropStoreIndex(IStoreIndex<?, ? extends IStoreObject> indexView) {
        if (this.haPolicy != HAPolicy.StateReplication) {
            throw new IllegalStateException(this.tracePrefix + ": Indexing is only supported with HA policy set to 'StateReplication'.");
        }
        if (this.engineDescriptor.getStore() == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index on engine without a store.");
        }
        if (this.store == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index, store not yet initialized.");
        }
        return this.store.dropIndex(indexView);
    }

    public boolean dropStoreIndexByName(String name) {
        if (this.haPolicy != HAPolicy.StateReplication) {
            throw new IllegalStateException(this.tracePrefix + ": Indexing is only supported with HA policy set to 'StateReplication'.");
        }
        if (this.engineDescriptor.getStore() == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index on engine without a store.");
        }
        if (this.store == null) {
            throw new IllegalStateException(this.tracePrefix + ": Unable to create index, store not yet initialized.");
        }
        return this.store.dropIndexByName(name);
    }

    static {
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)new AepFlowFactory());
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)new AepEnvironmentFactory());
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)new AepMessageFactory());
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)new AepMessageFactory());
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)new AepMonTxnStatsFactory());
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)new AepMonTxnStatsFactory());
    }

    private final class CreateStoreReturnValue {
        IStoreBinding store;
        IRogGraphCollection flows;

        private CreateStoreReturnValue() {
        }
    }

    public static enum StartupExpectation {
        Role,
        LogEmptiness;

    }

    public static enum MessageSendStabilityFailureHandlingPolicy {
        LogExceptionAndContinue,
        StopEngine;

    }

    public static enum MessageSendExceptionHandlingPolicy {
        LogExceptionAndContinue,
        TreatAsStabilityFailure;

    }

    public static enum InboundEventAcknowledgementPolicy {
        Default,
        OnSendStability,
        OnStoreStability;

    }

    public static enum AppExceptionHandlingPolicy {
        LogExceptionAndContinue,
        RollbackAndStop;

    }

    public static enum PerTransactionStatsLoggingFailurePolicy {
        StopLogging,
        StopEngine;

    }

    public static enum PerTransactionStatsLoggingPolicy {
        Off,
        UseDedicated;

    }

    public static enum OutboundMessageLoggingFailurePolicy {
        StopLogging,
        StopEngine;

    }

    public static enum OutboundMessageLoggingPolicy {
        Off,
        UseDedicated;

    }

    public static enum InboundMessageLoggingFailurePolicy {
        StopLogging,
        StopEngine;

    }

    public static enum InboundMessageLoggingPolicy {
        Off,
        UseDedicated;

    }

    public static enum MessageBusBindingFailPolicy {
        Reconnect,
        FailIfAnyBindingFails;

    }

    public static enum EventMultiplexerType {
        DedicatedThreaded,
        FreeThreadedSerialized;

    }

    @Deprecated
    public static enum MessageSendPolicy {
        ReplicateBeforeSend;

    }

    public static enum MessagingStartFailPolicy {
        NeverFail,
        FailIfOneBindingFails,
        FailIfAllBindingsFail;

    }

    public static enum ReplicationPolicy {
        Asynchronous,
        Pipelined;

    }

    public static enum HAPolicy {
        EventSourcing,
        StateReplication;

    }

    public static enum MessagingState {
        Init,
        Starting,
        Started,
        Stopped;

    }

    public static enum State {
        Init,
        Starting,
        Started,
        Stopping,
        Stopped;

    }

    final class Transaction {
        private long id = 1L;
        private long stableId = 0L;
        private final UtlList flows;
        private final UtlPool<CommitContext> commitContextPool;
        private CommitContext currentCommitContext;
        private final UtlPlist<CommitContext> sendCommitCompletionQueue;
        private int inboundSno;
        private int outboundSno;
        private int numGuaranteedMsgsEnqueued;
        private int numBestEffortMsgsEnqueued;
        private long startTs;
        private long postLastMessageProcessingTs;
        private int cumulativeProcessingTimeBeforeCommit;
        private int savepoint;
        private int storeSavepointOffset;
        private int boundarySavepoint;
        private final StoreCommitEntry messagePersisterCommitEntry = StoreCommitEntry.create();

        Transaction() {
            this.flows = UtlList.create();
            this.commitContextPool = UtlPool.create((String)"aep.txn.commitctx", (String)AepEngine.this.engineDescriptor.getName(), (UtlPool.Factory)new CommitContextFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
            this.sendCommitCompletionQueue = UtlPlist.create();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean dispatchTransactionStageEvent(CommitContext context, AepTransactionStageEvent.TransactionStage stage) {
            boolean suspend = false;
            if (AepEngine.this.dispatchTransactionStageEvents) {
                AepTransactionStageEvent event = AepTransactionStageEvent.create(context, stage);
                try {
                    AepEngine.this.dispatchEvent(event, ExceptionHandlingPolicy.TrapAndDiscard);
                    suspend = stage == AepTransactionStageEvent.TransactionStage.Start && AepEngine.this.enableTransactionCommitSuspension && event.getSuspend();
                }
                finally {
                    event.dispose();
                }
            }
            return suspend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void ackEvent(Event event) {
            try {
                MessageChannel channel;
                IEventAcknowledger acknowledger = event.getAcknowledger();
                AepBusConnection busConnection = acknowledger != null && event instanceof MessageChannelEvent ? ((channel = ((MessageChannelEvent)event).getMessageChannel()) != null ? (AepBusConnection)((Object)channel.getMessageBusBinding().getAttachment()) : null) : null;
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Acknowledging event " + event, Tracer.Level.DEBUG);
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...event=" + event, Tracer.Level.DEBUG);
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...acknowledger=" + acknowledger, Tracer.Level.DEBUG);
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...busConnection=" + (Object)((Object)busConnection), Tracer.Level.DEBUG);
                }
                if (acknowledger != null) {
                    if (((AepEngine)AepEngine.this).snoTracer.debug && event instanceof MessageEvent) {
                        MessageView view = ((MessageEvent)event).getMessageView();
                        AepEngine.this.snoTracer.log("--> [" + view.getMessageSender() + ", " + view.getMessageSequenceNumber() + "] ACK", Tracer.Level.DEBUG);
                    }
                    acknowledger.ack();
                    if (busConnection != null && busConnection.isAcksRequireFlush()) {
                        AepEngine.this.transaction.addBusConnection(busConnection);
                    }
                }
                ++((AepEngine)AepEngine.this).stats.numFlowEventsProcComplete;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                event.dispose();
            }
        }

        private final CommitContext doEnvironmentChangeMessageReplicatePrepare(CommitContext context) {
            IRogMessage[] messagesToReplicate = context.messagesToReplicate;
            if (AepEngine.this.someDebugTrace) {
                if (((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..doEnvironmentChangeMessageReplicatePrepare", Tracer.Level.DEBUG);
                }
                if (((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Preparing environment change messages...", Tracer.Level.DEBUG);
                }
            }
            for (int i = 0; i < AepEngine.this.numEnvironmentProviderProxies; ++i) {
                if (messagesToReplicate[i] == null) continue;
                messagesToReplicate[i] = context.prepareInboundMessageForLoggingAndOrReplication(messagesToReplicate[i]);
                if (!AepEngine.this.someDebugTrace || !((AepEngine)AepEngine.this).msgTracer.debug) continue;
                AepEngine.this.msgTrace("[MSG-REPL-OUT]", (IRogNode)messagesToReplicate[i]);
            }
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Prepared " + AepEngine.this.numEnvironmentProviderProxies + " environment change messages for replication.", Tracer.Level.DEBUG);
            }
            return context;
        }

        private final void persistMessage(IRogMessage message, IStorePersister persister, CommitContext context, boolean commitStart, boolean commitEnd) {
            this.messagePersisterCommitEntry.init(IStoreBinding.Operation.Send, message.getOid(), message.getOfid(), message.getObjectType(), context.id, context.stableId, 0L, (IStoreObject)message, message.getContentEncodingType(), commitStart, commitEnd);
            try {
                persister.writeCommitEntry(this.messagePersisterCommitEntry.serializedObject, false);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                this.messagePersisterCommitEntry.serializedObject.dispose();
            }
        }

        private final CommitContext doInboundMessageReplicatePrepare(CommitContext context) {
            Event[] array;
            if (AepEngine.this.someDebugTrace) {
                if (((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..doInboundMessageReplicatePrepare", Tracer.Level.DEBUG);
                }
                if (((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Replicating inbound messages...", Tracer.Level.DEBUG);
                }
            }
            EventList events = context.events;
            int numPrepared = 0;
            if (events != null && (array = events.array()) != null) {
                int count = events.count();
                for (int i = 0; i < count; ++i) {
                    MessageEvent messageEvent;
                    MessageView view;
                    if (!(array[i] instanceof MessageEvent) || !((view = (messageEvent = (MessageEvent)array[i]).getMessageView()) instanceof IRogMessage)) continue;
                    ((CommitContext)context).messagesToReplicate[((CommitContext)context).messagesToReplicateCount++] = context.prepareInboundMessageForLoggingAndOrReplication((IRogMessage)view);
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).msgTracer.debug) {
                        AepEngine.this.msgTrace("[MSG-REPL-OUT]", (IRogNode)((IRogMessage)view));
                    }
                    ++numPrepared;
                }
            }
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Prepared " + numPrepared + " inbound messages for replication.", Tracer.Level.DEBUG);
            }
            return context;
        }

        private final CommitContext doOutboundMessageReplicatePrepare(CommitContext context) {
            BusConnectionList busConnections;
            if (AepEngine.this.someDebugTrace) {
                if (((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..doOutboundMessageReplicatePrepare", Tracer.Level.DEBUG);
                }
                if (((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Replicating outbound messages...", Tracer.Level.DEBUG);
                }
            }
            if ((busConnections = context.busConnections) != null && busConnections.count() > 0) {
                for (AepBusConnection busConnection : busConnections.array()) {
                    if (busConnection == null) continue;
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + "... replicating messages enqueued in '" + (Object)((Object)busConnection) + "'...", Tracer.Level.DEBUG);
                    }
                    AepBusConnection.OutboundQueue.Slice slice = busConnections.saved(busConnection, false);
                    UtlList elements = slice.elements();
                    int numSent = 0;
                    for (AepBusConnection.OutboundQueue.SliceElement element = (AepBusConnection.OutboundQueue.SliceElement)elements.first(); element != null; element = (AepBusConnection.OutboundQueue.SliceElement)element.next()) {
                        if (!AepEngine.this.replicateSolicitedSends && !element.message.getIsInternal() || element.message.isPossibleDuplicate()) continue;
                        AepEngine.this.store.send((IStoreObject)context.prepareOutboundMessageForLoggingAndOrReplication(element.message));
                        if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).msgTracer.debug) {
                            AepEngine.this.msgTrace("[MSG-REPL-OUT]", (IRogNode)element.message);
                        }
                        ++numSent;
                    }
                    if (!AepEngine.this.someDebugTrace || !((AepEngine)AepEngine.this).tracer.debug) continue;
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...... prepared " + numSent + " outbound messages for replication (replicateSolicitedSends=" + AepEngine.this.replicateSolicitedSends + ").", Tracer.Level.DEBUG);
                }
            }
            return context;
        }

        private final CommitContext doSendComplete(CommitContext context) {
            BusConnectionList busConnections;
            if (AepEngine.this.someDebugTrace) {
                if (((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..doSendComplete", Tracer.Level.DEBUG);
                }
                if (((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Completing outbound messages...", Tracer.Level.DEBUG);
                }
            }
            if ((busConnections = context.busConnections) != null && busConnections.count() > 0) {
                for (AepBusConnection busConnection : busConnections.array()) {
                    if (busConnection != null && busConnections.saved(busConnection, false) == null) {
                        if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                            AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Completing messages enqueued in " + (Object)((Object)busConnection) + "...", Tracer.Level.DEBUG);
                        }
                        busConnections.save(busConnection, busConnection.complete(busConnections.saved(busConnection, true)));
                        continue;
                    }
                    if (busConnection != null) {
                        busConnection.resetSavepoint();
                    }
                    if (!AepEngine.this.someDebugTrace || !((AepEngine)AepEngine.this).tracer.debug) continue;
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Already completed messages enqueued in " + (Object)((Object)busConnection) + "...", Tracer.Level.DEBUG);
                }
            }
            return context;
        }

        private final void doSendCommit(CommitContext context) {
            BusConnectionList busConnections;
            if (AepEngine.this.someDebugTrace) {
                if (((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..doSendCommit", Tracer.Level.DEBUG);
                }
                if (((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Committing outbound messages...", Tracer.Level.DEBUG);
                }
            }
            ++((AepEngine)AepEngine.this).stats.numSendCommitsStarted;
            if (AepEngine.this.recordTxnLegLatencies || AepEngine.this.capturePerTxnStats || AepEngine.this.recordMsgLegWaypoints) {
                long now = UtlTime.now();
                if (AepEngine.this.recordTxnLegLatencies) {
                    if (AepEngine.this.store != null) {
                        ((AepEngine)AepEngine.this).stats.commitTransitionLatencies.add((double)(now - context.storeCommitCompleteTs));
                    } else {
                        ((AepEngine)AepEngine.this).stats.commitPrologueLatencies.add((double)(now - context.commitStartTs));
                    }
                }
                context.sendCommitStartTs = now;
            }
            if ((busConnections = context.busConnections) != null && busConnections.count() > 0) {
                for (AepBusConnection busConnection : busConnections.array()) {
                    if (busConnection == null) continue;
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Committing messages enqueued in " + (Object)((Object)busConnection) + "...", Tracer.Level.DEBUG);
                    }
                    AepSendCommitCompletionEvent sendCommitCompletionEvent = busConnections.sendCommitCompletionEvents[busConnection.getId()];
                    sendCommitCompletionEvent.setAttachment(context);
                    sendCommitCompletionEvent.clear().init(busConnection.getBusBinding(), false, AepEngine.this.capturePerTxnStats && context.perTransactionStats != null);
                    busConnection.commit(busConnections.saved(busConnection, true), sendCommitCompletionEvent, context.sendCommitStartTs);
                }
            } else {
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " No outbound messages to commit.", Tracer.Level.DEBUG);
                }
                AepSendCommitCompletionEvent sendCommitCompletionEvent = context.zeroSendCommitCompletionEvent;
                sendCommitCompletionEvent.setAttachment(context);
                sendCommitCompletionEvent.setDelay(-1000);
                sendCommitCompletionEvent.clear().init(null, false, false);
                AepEngine.this.multiplexer.scheduleEvent((Event)sendCommitCompletionEvent);
            }
            if (AepEngine.this.capturePerTxnStats && context.perTransactionStats != null) {
                context.perTransactionStats.setSendCommitStartTsMicros(context.sendCommitStartTs / 1000L);
                context.perTransactionStats.setSendCommitStartedTsMicros(UtlTime.nowInMicros());
            }
        }

        private final void doStoreCommitCore(CommitContext context) {
            if (AepEngine.this.store != null) {
                try {
                    switch (AepEngine.this.replicationPolicy) {
                        case Pipelined: {
                            long storeCommitStartTs = AepEngine.this.capturePerTxnStats ? UtlTime.now() : 0L;
                            IStoreCommitCompletionEvent completionEvent = AepEngine.this.store.createCommitCompletionEvent();
                            completionEvent.setAttachment((Object)context);
                            AepEngine.this.store.commit(context.id, context.stableId, (IStoreObject[])context.messagesToReplicate, context.messagesToReplicateCount, completionEvent.setDispatch(true), 8);
                            if (completionEvent.wasSyncComplete()) {
                                completionEvent.dispose();
                                context.storeCommitState.set(1);
                            }
                            if (!AepEngine.this.capturePerTxnStats || context.perTransactionStats == null) break;
                            context.perTransactionStats.setStoreCommitStartTsMicros(storeCommitStartTs / 1000L);
                            context.perTransactionStats.setStoreCommitStartedTsMicros(UtlTime.nowInMicros());
                            break;
                        }
                        case Asynchronous: {
                            AepEngine.this.store.commit(context.id, context.stableId, (IStoreObject[])context.messagesToReplicate, context.messagesToReplicateCount, null, 0);
                            context.storeCommitState.set(1);
                        }
                    }
                }
                catch (OdsException e) {
                    throw new InternalError("failure encountered in committing the application store [" + e.toString() + "]");
                }
            } else {
                context.storeCommitState.set(1);
            }
        }

        private final void doStoreCommit(CommitContext context) {
            if (AepEngine.this.someDebugTrace) {
                if (((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..doStoreCommit", Tracer.Level.DEBUG);
                }
                if (((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Committing store...", Tracer.Level.DEBUG);
                }
            }
            ++((AepEngine)AepEngine.this).stats.numStoreCommitsStarted;
            if (AepEngine.this.recordTxnLegLatencies) {
                long now = UtlTime.now();
                ((AepEngine)AepEngine.this).stats.commitPrologueLatencies.add((double)(now - context.commitStartTs));
                context.storeCommitStartTs = now;
            }
            if (!AepEngine.this.replicateInParallel) {
                this.doStoreCommitCore(context);
            }
            if (context.storeCommitState.decrementAndGet() == 0) {
                this.onStoreCommitComplete(context);
            }
        }

        private final CommitContext doInboundMessageLogging(CommitContext context, boolean prepareMessage) {
            Event[] array;
            EventList events;
            if (AepEngine.this.someDebugTrace) {
                if (((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..doInboundMessageLogging", Tracer.Level.DEBUG);
                }
                if (((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Logging inbound messages (prepare=" + prepareMessage + ")...", Tracer.Level.DEBUG);
                }
            }
            if (AepEngine.this.inboundMessageLogger != null && (events = context.events) != null && (array = events.array()) != null) {
                int count = events.count();
                for (int i = 0; i < count; ++i) {
                    MessageEvent messageEvent;
                    MessageView view;
                    if (!(array[i] instanceof MessageEvent) || !((view = (messageEvent = (MessageEvent)array[i]).getMessageView()) instanceof IRogMessage)) continue;
                    IRogMessage message = (IRogMessage)view;
                    try {
                        if (prepareMessage) {
                            context.prepareInboundMessageForLoggingAndOrReplication(message);
                        }
                        AepEngine.this.inboundMessageLogger.log(message, false, i == count - 1);
                        continue;
                    }
                    catch (Throwable e) {
                        AepEngine.this.handleInboundMessageLoggerException(e, view);
                    }
                }
            }
            return context;
        }

        private final void doOutboundMessageLogging(CommitContext context, boolean prepareMessage) {
            if (AepEngine.this.someDebugTrace) {
                if (((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..doOutboundMessageLogging", Tracer.Level.DEBUG);
                }
                if (((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Logging outbound messages (prepare=" + prepareMessage + ")...", Tracer.Level.DEBUG);
                }
            }
            if (AepEngine.this.outboundMessageLogger != null) {
                try {
                    int count = AepEngine.this.outboundMessagingContext.flushLogQueue(context, prepareMessage);
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ..." + count + " messages were dispatched for logging.", Tracer.Level.DEBUG);
                    }
                    if (AepEngine.this.store == null || !AepEngine.this.store.isPersistenceQuorumMet()) {
                        if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                            AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...flushing the log (sync=false).", Tracer.Level.DEBUG);
                        }
                        AepEngine.this.outboundMessageLogger.flush(false);
                    } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...not flushing the log (persistence quorum is met).", Tracer.Level.DEBUG);
                    }
                }
                catch (Throwable e) {
                    AepEngine.this.handleOutboundMessageLoggerException(e, null);
                }
            } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...outbound message logging is not enabled", Tracer.Level.DEBUG);
            }
        }

        private final void onSendCommitCompleteOrdered(CommitContext context) {
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).txnTracer.debug) {
                AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..onSendCommitCompleteOrdered", Tracer.Level.DEBUG);
            }
            ++((AepEngine)AepEngine.this).stats.numSendCommitsCompleted;
            if (AepEngine.this.recordTxnLegLatencies && context.sendCommitStartTs > 0L) {
                long now = UtlTime.now();
                ((AepEngine)AepEngine.this).stats.commitSendLatencies.add((double)(now - context.sendCommitStartTs));
                context.sendCommitCompleteTs = now;
            }
            if (AepEngine.this.capturePerTxnStats && context.perTransactionStats != null) {
                context.perTransactionStats.setSendCommitCompleteTsMicros(UtlTime.nowInMicros());
            }
            this.onCommitComplete(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void onSendCommitComplete(CommitContext context) {
            EventList events;
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).txnTracer.debug) {
                AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..onSendCommitComplete", Tracer.Level.DEBUG);
            }
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " All send commits are complete (txn #" + context.id + ").", Tracer.Level.DEBUG);
            }
            long meanInTs = (events = context.events) != null ? events.meanInTs : 0L;
            long meanOutTs = context.meanOutTs;
            if (meanInTs > 0L && meanOutTs > 0L) {
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...in-out latency = " + (meanOutTs - meanInTs) / 1000L + " us.", Tracer.Level.DEBUG);
                }
                ((AepEngine)AepEngine.this).stats.inOutLatencies.add((double)(meanOutTs - meanInTs));
            } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...in-out latency not calculated.", Tracer.Level.DEBUG);
            }
            AepEngine.this.outboundMessagingContext.setStableSno(context.lastOutboundSno);
            context.sendCommitComplete = true;
            this.dispatchTransactionStageEvent(context, AepTransactionStageEvent.TransactionStage.SendCommitComplete);
            try {
                UtlPlist.Element element;
                long thisTxnId = context.id;
                boolean thisHasOutboundMsgs = context.hasOutboundMsgs;
                boolean thisHasGuarOutboundMsgs = context.hasGuarOutboundMsgs;
                boolean terminatedAheadOfIncompleteOutOfOrder = false;
                boolean thisReleased = false;
                boolean releasedAfterThis = false;
                boolean releasedAfterThisOutOfOrder = false;
                long firstReleasedTxnId = -1L;
                long lastReleasedTxnId = -1L;
                long firstIncompleteTxnId = -1L;
                BusConnectionList busConnectionList = context.busConnections;
                if (busConnectionList != null) {
                    busConnectionList.acquire();
                }
                while ((element = this.sendCommitCompletionQueue.first()) != null) {
                    CommitContext queueContext = (CommitContext)element.getObject();
                    if (!queueContext.sendCommitComplete) {
                        if (!AepEngine.this.enableSendCommitCompleteSequenceAlerts) break;
                        firstIncompleteTxnId = queueContext.id;
                        terminatedAheadOfIncompleteOutOfOrder = !queueContext.canSendCommmitCompleteAfter(context);
                        break;
                    }
                    if (AepEngine.this.enableSendCommitCompleteSequenceAlerts) {
                        firstReleasedTxnId = firstReleasedTxnId == -1L ? queueContext.id : firstReleasedTxnId;
                        lastReleasedTxnId = queueContext.id;
                        if ((releasedAfterThis |= (thisReleased |= queueContext == context)) && !releasedAfterThisOutOfOrder) {
                            releasedAfterThisOutOfOrder = thisHasOutboundMsgs && queueContext.hasOutboundMsgs && thisHasGuarOutboundMsgs == queueContext.hasGuarOutboundMsgs && !busConnectionList.canCompleteAfter(queueContext.busConnections);
                        }
                    }
                    this.sendCommitCompletionQueue.remove(element);
                    this.onSendCommitCompleteOrdered(queueContext);
                }
                if (busConnectionList != null) {
                    busConnectionList.dispose();
                }
                if (AepEngine.this.enableSendCommitCompleteSequenceAlerts && thisHasOutboundMsgs && (!thisReleased && terminatedAheadOfIncompleteOutOfOrder || releasedAfterThis && releasedAfterThisOutOfOrder)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n").append(AepEngine.this.getDescriptor().getName()).append(": Received an out-of-order send commit completion").append("\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)new Exception()));
                    sb.append("Transaction ids {").append("\n");
                    sb.append("...completed=").append(thisTxnId).append("\n");
                    sb.append("...first released=").append(firstReleasedTxnId).append("\n");
                    sb.append("...last released=").append(lastReleasedTxnId).append("\n");
                    sb.append("...first incomplete=").append(firstIncompleteTxnId).append("\n");
                    sb.append("}").append("\n");
                    sb.append("Logging exception and continuing...").append("\n");
                    AepEngine.this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    try {
                        AepEngine.this.multiplexer.multiplexEvent((Event)AepOutOfOrderSendCommitCompletionAlertEvent.create(thisTxnId, firstReleasedTxnId, lastReleasedTxnId, firstIncompleteTxnId), 0);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                ((AepEngine)AepEngine.this).stats.sendCommitCompletionQueueSize = this.sendCommitCompletionQueue.count();
            }
        }

        private final void onStoreCommitComplete(CommitContext context) {
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).txnTracer.debug) {
                AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..onStoreCommitComplete", Tracer.Level.DEBUG);
            }
            ++((AepEngine)AepEngine.this).stats.numStoreCommitsCompleted;
            if (context.storeCommitStartTs > 0L) {
                long now = UtlTime.now();
                ((AepEngine)AepEngine.this).stats.commitStoreLatencies.add((double)(now - context.storeCommitStartTs));
                context.storeCommitCompleteTs = now;
            }
            if (AepEngine.this.capturePerTxnStats && context.perTransactionStats != null) {
                context.perTransactionStats.setStoreCommitCompleteTsMicros(UtlTime.nowInMicros());
            }
            this.dispatchTransactionStageEvent(context, AepTransactionStageEvent.TransactionStage.StoreCommitComplete);
            if (AepEngine.this.ackOnStoreCommit) {
                this.logAndAckInboundEvents(context);
            }
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Store commit is complete (txn #" + context.id + ").", Tracer.Level.DEBUG);
            }
            this.doSendCommit(context);
        }

        private final void onCommitComplete(CommitContext context) {
            BusConnectionList busConnections;
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).txnTracer.debug) {
                AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..CommitComplete", Tracer.Level.DEBUG);
            }
            try {
                if (!context.eventsAcked || AepEngine.this.store == null) {
                    this.logAndAckInboundEvents(context);
                }
            }
            finally {
                context.clearInboundEventList();
            }
            this.doOutboundMessageLogging(context, AepEngine.this.haPolicy == HAPolicy.EventSourcing);
            if (AepEngine.this.role == IStoreBinding.Role.Primary) {
                this.dispatchTransactionStageEvent(context, AepTransactionStageEvent.TransactionStage.Complete);
            }
            if ((busConnections = context.busConnections) != null) {
                busConnections.dispose();
            }
            IRogMessage[] messagesToReplicate = context.messagesToReplicate;
            for (int i = 0; i < AepEngine.this.numEnvironmentProviderProxies; ++i) {
                if (messagesToReplicate[i] == null) continue;
                messagesToReplicate[i].dispose();
                messagesToReplicate[i] = null;
            }
            context.messagesToReplicateCount = AepEngine.this.numEnvironmentProviderProxies;
            if (AepEngine.this.capturePerTxnStats && context.perTransactionStats != null) {
                context.perTransactionStats.setCommitStartTsMicros(context.commitStartTs / 1000L);
                context.perTransactionStats.setCommitCompleteTsMicros(UtlTime.nowInMicros());
                if (AepEngine.this.perTransactionStatsLogger != null && AepEngine.this.state == State.Started && AepEngine.this.isPrimary()) {
                    try {
                        AepEngine.this.perTransactionStatsLogger.log((IRogMessage)context.perTransactionStats, true, true);
                        AepEngine.this.perTransactionStatsLogger.flush(false);
                    }
                    catch (Throwable thrown) {
                        AepEngine.this.handlePerTransactionStatsLoggerException(thrown, (MessageView)context.perTransactionStats);
                    }
                }
                context.perTransactionStats.dispose();
            }
            ++((AepEngine)AepEngine.this).stats.numCommitsCompleted;
            AepEngine.this.lastCommitCompleteTs = System.currentTimeMillis();
            if (AepEngine.this.recordTxnLegLatencies) {
                long now = UtlTime.now();
                if (context.sendCommitCompleteTs > 0L) {
                    ((AepEngine)AepEngine.this).stats.commitEpilogueLatencies.add((double)(now - context.sendCommitCompleteTs));
                }
                ((AepEngine)AepEngine.this).stats.commitFullLatencies.add((double)(now - context.commitStartTs));
            }
            if (AepEngine.this.lastTransactionContext != null && ((AepEngine)AepEngine.this).lastTransactionContext.transactionId == context.id) {
                if (((AepEngine)AepEngine.this).lastTransactionContext.shutdownAfterThisTransaction) {
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Transaction #" + ((AepEngine)AepEngine.this).lastTransactionContext.transactionId + " is last transaction. Stopping engine...", Tracer.Level.DEBUG);
                    }
                    AepEngine.this.stop(((AepEngine)AepEngine.this).lastTransactionContext.cause, false);
                } else {
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Transaction #" + ((AepEngine)AepEngine.this).lastTransactionContext.transactionId + " is penultimate transaction. Scheduling shutdown transaction...", Tracer.Level.DEBUG);
                    }
                    AepShutdownMessage shutdownMessage = AepShutdownMessage.create();
                    shutdownMessage.setAsInternal(true);
                    if (((AepEngine)AepEngine.this).lastTransactionContext.cause != null) {
                        shutdownMessage.setCause(((AepEngine)AepEngine.this).lastTransactionContext.cause.getMessage() != null ? ((AepEngine)AepEngine.this).lastTransactionContext.cause.getMessage() : ((AepEngine)AepEngine.this).lastTransactionContext.cause.toString());
                    }
                    shutdownMessage.setShutdownCluster(((AepEngine)AepEngine.this).lastTransactionContext.shutdownCluster);
                    AepEngine.this.injectMessage((IRogMessage)shutdownMessage, true);
                }
            }
            this.stableId(context.id);
            context.dispose();
        }

        private final void logAndAckInboundEvents(CommitContext context) {
            EventList events;
            long meanInTs;
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Transaction #" + context.id + " is complete.", Tracer.Level.DEBUG);
            }
            long l = meanInTs = (events = context.events) != null ? events.meanInTs : 0L;
            if (meanInTs > 0L) {
                long currTs = UtlTime.now();
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...in-ack latency = " + (currTs - meanInTs) / 1000L + " us.", Tracer.Level.DEBUG);
                }
                ((AepEngine)AepEngine.this).stats.inAckLatencies.add((double)(currTs - meanInTs));
            } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...in-ack latency not calculated.", Tracer.Level.DEBUG);
            }
            if (AepEngine.this.role == IStoreBinding.Role.Primary) {
                this.doInboundMessageLogging(context, AepEngine.this.haPolicy == HAPolicy.StateReplication);
            }
            if (events != null) {
                Event[] array = events.array();
                int count = events.count();
                if (array != null) {
                    for (int i = 0; i < count; ++i) {
                        if (AepEngine.this.capturePerTxnStats && context.perTransactionStats != null && array[i] instanceof MessageEvent) {
                            IRogMessage view = (IRogMessage)((MessageEvent)array[i]).getMessageView();
                            AepMonInboundMessageTimings inboundTimings = AepMonInboundMessageTimings.create();
                            inboundTimings.setTransactionInSequenceNumber(view.getTransactionInSequenceNumber());
                            if (view.getPostWireTs() > 0L) {
                                inboundTimings.setSMAPostWireTsMicros(view.getPostWireTs());
                            }
                            if (view.getPreDeserializeTs() > 0L) {
                                inboundTimings.setSMAPreDeserializeTsMicros(view.getPreDeserializeTs());
                            }
                            if (view.getPostDeserializeTs() > 0L) {
                                inboundTimings.setSMAPostDeserializeTsMicros(view.getPostDeserializeTs());
                            }
                            if (view.getCreateTs() > 0L) {
                                inboundTimings.setSMACreateTsMicros(view.getCreateTs());
                            }
                            if (view.getEnqueueTs() > 0L) {
                                inboundTimings.setAEPInputQueueOfferTsMicros(view.getEnqueueTsMicros());
                            }
                            if (view.getReceiveTs() > 0L) {
                                inboundTimings.setAEPInputQueuePollTsMicros(view.getReceiveTs());
                            }
                            if (view.getPreProcessingTsMicros() > 0L) {
                                inboundTimings.setAEPPreProcessingTsMicros(view.getPreProcessingTsMicros());
                            }
                            if (view.getPostProcessingTsMicros() > 0L) {
                                inboundTimings.setAEPPostProcessingTsMicros(view.getPostProcessingTsMicros());
                            }
                            context.perTransactionStats.addInboundMessageTimings(inboundTimings);
                        }
                        this.ackEvent(array[i]);
                    }
                }
            }
            context.eventsAcked = true;
        }

        final void id(long id) {
            this.id = id;
        }

        final long id() {
            return this.id;
        }

        final void stableId(long id) {
            this.stableId = id;
        }

        final long stableId() {
            return this.stableId;
        }

        final void addFlow(AepFlow flow) {
            if (!flow.isLinked()) {
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Adding flow '" + flow.getFlowId() + "' to current transaction...", Tracer.Level.DEBUG);
                }
                this.flows.append((UtlListElement)flow);
            } else {
                if (flow.head != this.flows) {
                    throw new InternalError("flow is in a list but not transaction's flow list!");
                }
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Flow '" + flow.getFlowId() + "' is already in current transaction...", Tracer.Level.DEBUG);
                }
            }
        }

        final void addEvent(Event event) {
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Adding event to current transaction...", Tracer.Level.DEBUG);
            }
            this.currentCommitContext.events.append(event);
        }

        final void addBusConnection(AepBusConnection busConnection) {
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Adding bus connection '" + busConnection.getBusBinding().getName() + "' to current transaction...", Tracer.Level.DEBUG);
            }
            this.currentCommitContext.busConnections.add(busConnection);
        }

        final boolean isStarted() {
            return this.currentCommitContext != null;
        }

        final void start() {
            this.currentCommitContext = (CommitContext)this.commitContextPool.get(null);
            this.currentCommitContext.id = this.id;
            this.currentCommitContext.stableId = this.stableId;
            if (AepEngine.this.capturePerTxnStats && AepEngine.this.state == State.Started) {
                this.currentCommitContext.perTransactionStats = AepMonTransactionStatsMessage.create();
                this.currentCommitContext.perTransactionStats.setTransactionId(this.id);
            }
        }

        final void launchCommit(CommitContext context, boolean appResumed) {
            block9: {
                block7: {
                    block8: {
                        this.doSendComplete(context);
                        if (!appResumed && AepEngine.this.dispatchTransactionStageEvents && this.dispatchTransactionStageEvent(context, AepTransactionStageEvent.TransactionStage.Start)) break block7;
                        this.sendCommitCompletionQueue.append((Object)context);
                        ++((AepEngine)AepEngine.this).stats.sendCommitCompletionQueueSize;
                        if (AepEngine.this.store != null) break block8;
                        this.doSendCommit(context);
                        break block9;
                    }
                    switch (AepEngine.this.haPolicy) {
                        case EventSourcing: {
                            if (AepEngine.this.replicateInParallel) {
                                this.doStoreCommit(context);
                            } else {
                                this.doStoreCommit(this.doInboundMessageReplicatePrepare(this.doEnvironmentChangeMessageReplicatePrepare(context)));
                            }
                            break block9;
                        }
                        case StateReplication: {
                            this.doStoreCommit(this.doOutboundMessageReplicatePrepare(this.doEnvironmentChangeMessageReplicatePrepare(context)));
                            break block9;
                        }
                        default: {
                            throw new InternalError("unknown HA policy '" + (Object)((Object)AepEngine.this.haPolicy) + "'");
                        }
                    }
                }
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).txnTracer.debug) {
                    AepEngine.this.txnTracer.log("Txn #" + context.id + "(" + context.stableId + ")..suspend", Tracer.Level.DEBUG);
                }
            }
        }

        final void commit(AepFlow flow) {
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...flow=" + flow.getFlowId() + "...", Tracer.Level.DEBUG);
            }
            flow.unlink();
            flow.rollfwd();
        }

        final void commit() throws Exception {
            long commitStartTs = 0L;
            if (AepEngine.this.recordTxnLegLatencies || AepEngine.this.capturePerTxnStats) {
                commitStartTs = UtlTime.now();
                if (this.postLastMessageProcessingTs > 0L) {
                    ((AepEngine)AepEngine.this).stats.commitStartLatencies.add((double)(commitStartTs - this.postLastMessageProcessingTs));
                    this.postLastMessageProcessingTs = 0L;
                }
                this.cumulativeProcessingTimeBeforeCommit = 0;
                if (AepEngine.this.capturePerTxnStats && this.startTs > 0L && this.currentCommitContext.perTransactionStats != null) {
                    this.currentCommitContext.perTransactionStats.setTransactionStartTsMicros(this.startTs / 1000L);
                }
            }
            if (AepEngine.this.enableReplayOnRollback) {
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Committing event instruction pointers...", Tracer.Level.DEBUG);
                }
                if (this.flows.count() > 0) {
                    if (AepEngine.this.enableMultipleFlows) {
                        AepFlow flow = null;
                        while ((flow = (AepFlow)this.flows.first()) != null) {
                            this.commit(flow);
                        }
                    } else {
                        this.commit(AepEngine.this.singletonFlow);
                    }
                } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...no flows in transaction.", Tracer.Level.DEBUG);
                }
            } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...Not committing event instruction pointers (no events enquueed since replay on rollback is not enabled).", Tracer.Level.DEBUG);
            }
            CommitContext commitContext = this.currentCommitContext;
            this.currentCommitContext = null;
            commitContext.id = this.id;
            commitContext.stableId = this.stableId;
            commitContext.hasGuarOutboundMsgs = this.numGuaranteedMsgsEnqueued > 0;
            commitContext.lastOutboundSno = AepEngine.this.outboundMessagingContext.sno();
            ((AepEngine)AepEngine.this).stats.numMsgsSentBestEffort += (long)this.numBestEffortMsgsEnqueued;
            ((AepEngine)AepEngine.this).stats.numMsgsSentGuaranteed += (long)this.numGuaranteedMsgsEnqueued;
            ++((AepEngine)AepEngine.this).stats.numTransactions;
            ++((AepEngine)AepEngine.this).stats.numCommitsStarted;
            this.numBestEffortMsgsEnqueued = 0;
            this.numGuaranteedMsgsEnqueued = 0;
            this.inboundSno = 0;
            this.outboundSno = 0;
            this.savepoint = 0;
            this.storeSavepointOffset = 0;
            this.boundarySavepoint = 0;
            commitContext.commitStartTs = commitStartTs;
            this.startTs = 0L;
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).txnTracer.debug) {
                AepEngine.this.txnTracer.log("Txn #" + this.id + "(" + this.stableId + ")..Commit", Tracer.Level.DEBUG);
            }
            ++this.id;
            if (AepEngine.this.role == IStoreBinding.Role.Primary) {
                for (int i = 0; i < AepEngine.this.numEnvironmentProviderProxies; ++i) {
                    if (!AepEngine.this.environmentProviderProxies[i].inRecord()) continue;
                    try {
                        ((CommitContext)commitContext).messagesToReplicate[i] = AepEngine.this.environmentProviderProxies[i].endRecording();
                        if (commitContext.messagesToReplicate[i] == null) continue;
                        commitContext.messagesToReplicate[i].setTransactionId(commitContext.id);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Application ('" + AepEngine.this.engineDescriptor.getName() + "') environment provider faulted with error [" + e.toString() + "] on transaction commit.", e);
                    }
                }
                this.launchCommit(commitContext, false);
            } else {
                if (AepEngine.this.checked && commitContext.busConnections != null && commitContext.busConnections.count() > 0) {
                    throw new InternalError("transaction contains bus connections when operating in backup mode!");
                }
                for (int i = 0; i < AepEngine.this.numEnvironmentProviderProxies; ++i) {
                    if (!AepEngine.this.environmentProviderProxies[i].inPlayback()) continue;
                    AepEngine.this.environmentProviderProxies[i].endPlayback();
                }
                int pruned = AepEngine.this.outboundMessagingContext.pruneOutboundQueue(this.stableId());
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log("Pruned " + pruned + " message from outbound queue from txid " + this.stableId(), Tracer.Level.DEBUG);
                }
                this.onCommitComplete(commitContext);
            }
        }

        final int createSavepoint(boolean setBoundary) {
            BusConnectionList busConnections;
            if (!AepEngine.this.enableTransactionSavepoints) {
                return this.savepoint - this.boundarySavepoint;
            }
            ++this.savepoint;
            if (AepEngine.this.store != null && AepEngine.this.role == IStoreBinding.Role.Primary && AepEngine.this.state == State.Started) {
                this.storeSavepointOffset = this.savepoint - AepEngine.this.store.createSavepoint();
            }
            if ((busConnections = this.currentCommitContext.busConnections) != null && busConnections.count() > 0) {
                AepBusConnection[] busConnectionArray = busConnections.array();
                for (int i = 0; i < busConnectionArray.length; ++i) {
                    if (busConnectionArray[i] == null) continue;
                    busConnectionArray[i].setSavepoint(this.savepoint);
                }
            }
            if (setBoundary) {
                this.boundarySavepoint = this.savepoint;
            }
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + "Txn #" + this.id + " created savepoint [sp=" + this.savepoint + ", storeSP=" + (this.savepoint - this.storeSavepointOffset) + ", externalSP=" + (this.savepoint - this.boundarySavepoint) + "]", Tracer.Level.DEBUG);
            }
            return this.getExternalSavepoint();
        }

        final int getExternalSavepoint() {
            return this.savepoint - this.boundarySavepoint;
        }

        final void rollback(AepFlow flow, boolean replay) {
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...flow=" + flow.getFlowId() + "...", Tracer.Level.DEBUG);
            }
            flow.unlink();
            if (replay) {
                flow.rollback();
            } else {
                flow.rollfwd();
            }
        }

        final void rollback(int externalSavepoint, boolean replay) {
            if (externalSavepoint == -1) {
                BusConnectionList busConnections;
                if (AepEngine.this.enableReplayOnRollback) {
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Rolling back event instruction pointers...", Tracer.Level.DEBUG);
                    }
                    if (this.flows.count() > 0) {
                        if (AepEngine.this.enableMultipleFlows) {
                            AepFlow flow = null;
                            while ((flow = (AepFlow)this.flows.first()) != null) {
                                this.rollback(flow, replay);
                            }
                        } else {
                            this.rollback(AepEngine.this.singletonFlow, replay);
                        }
                    } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...no flows in transaction.", Tracer.Level.DEBUG);
                    }
                } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...Not rolling back event instruction pointers (no events enqueued since replay on rollback is not enabled).", Tracer.Level.DEBUG);
                }
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Rolling back outbound messages...", Tracer.Level.DEBUG);
                }
                if ((busConnections = this.currentCommitContext.busConnections) != null && busConnections.count() > 0) {
                    AepBusConnection[] busConnectionArray = busConnections.array();
                    for (int i = 0; i < busConnectionArray.length; ++i) {
                        if (busConnectionArray[i] == null) continue;
                        busConnectionArray[i].rollback();
                    }
                }
                if (this.currentCommitContext.events != null) {
                    this.currentCommitContext.events.clear();
                }
                if (AepEngine.this.store != null) {
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Rolling back store changes...", Tracer.Level.DEBUG);
                    }
                    AepEngine.this.store.rollback();
                } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " No store changes to roll back (engine is not attached to a store).", Tracer.Level.DEBUG);
                }
                ++((AepEngine)AepEngine.this).stats.numTransactions;
                ++((AepEngine)AepEngine.this).stats.numRollbacks;
                AepEngine.this.outboundMessagingContext.clearLogQueue(false);
                this.inboundSno = 0;
                this.outboundSno = 0;
                this.numBestEffortMsgsEnqueued = 0;
                this.numGuaranteedMsgsEnqueued = 0;
                this.savepoint = 0;
                this.storeSavepointOffset = 0;
                this.boundarySavepoint = 0;
            } else {
                if (!AepEngine.this.enableTransactionSavepoints) {
                    throw new IllegalStateException("Transaction savepoints are not enabled for this aep engine");
                }
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + "Txn #" + this.id + " rolling back to external savepoint " + externalSavepoint + " [sp=" + this.savepoint + ", storeSP=" + (this.savepoint - this.storeSavepointOffset) + ", externalSP=" + (this.savepoint - this.boundarySavepoint) + "]", Tracer.Level.DEBUG);
                }
                int internalSavepoint = this.boundarySavepoint + externalSavepoint;
                try {
                    BusConnectionList busConnections;
                    if (AepEngine.this.store != null && AepEngine.this.role == IStoreBinding.Role.Primary && AepEngine.this.state == State.Started) {
                        if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                            AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Rolling back store changes to store savepoint '" + (internalSavepoint - this.storeSavepointOffset) + "'...", Tracer.Level.DEBUG);
                        }
                        AepEngine.this.store.rollback(internalSavepoint - this.storeSavepointOffset);
                    } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " No store changes to roll back (engine is not attached to a store).", Tracer.Level.DEBUG);
                    }
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Rolling back outbound messages...", Tracer.Level.DEBUG);
                    }
                    if ((busConnections = this.currentCommitContext.busConnections) != null && busConnections.count() > 0) {
                        AepBusConnection[] busConnectionArray = busConnections.array();
                        for (int i = 0; i < busConnectionArray.length; ++i) {
                            if (busConnectionArray[i] == null) continue;
                            busConnectionArray[i].rollback(internalSavepoint);
                        }
                    }
                    AepEngine.this.outboundMessagingContext.rollbackLogQueue(this.id, internalSavepoint);
                    this.outboundSno -= AepEngine.this.outboundMessagingContext.rollbackOutboundQueue(this.id, internalSavepoint);
                }
                catch (Throwable thrown) {
                    throw new EAepRollbackError("Error rolling back transaction to savepoint " + externalSavepoint + " [sp=" + this.savepoint + ", storeSP=" + AepEngine.this.store.getLastSavepoint() + ", externalSP=" + this.getExternalSavepoint() + "]", thrown);
                }
                ++((AepEngine)AepEngine.this).stats.numPartialRollbacks;
                this.savepoint = internalSavepoint;
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + "Txn #" + this.id + " savepoint roll back to external savepoint " + externalSavepoint + " [sp=" + this.savepoint + ", storeSP=" + AepEngine.this.store.getLastSavepoint() + ", externalSP=" + this.getExternalSavepoint() + "]", Tracer.Level.DEBUG);
                }
            }
        }

        final void rollback() {
            this.rollback(-1, false);
        }

        final boolean onSendCommitComplete(AepSendCommitCompletionEvent event) {
            CommitContext context = (CommitContext)event.getAttachment();
            if (AepEngine.this.capturePerTxnStats && context.perTransactionStats != null) {
                UtlPlist<AepMonOutboundMessageTimings> timings = event.getTimings();
                while (timings.count() > 0) {
                    UtlPlist.Element e = timings.first();
                    context.perTransactionStats.addOutboundMessageTimings((AepMonOutboundMessageTimings)e.getObject());
                    timings.remove(e);
                }
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                    AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " All send commits are not yet complete (remaining=" + context.busConnections.count() + ").", Tracer.Level.DEBUG);
                }
            } else {
                UtlPlist<AepMonOutboundMessageTimings> timings = event.getTimings();
                while (timings.count() > 0) {
                    UtlPlist.Element e = timings.first();
                    ((AepMonOutboundMessageTimings)e.getObject()).dispose();
                    timings.remove(e);
                }
            }
            if (context.onSendCommitComplete(event)) {
                this.onSendCommitComplete(context);
                return true;
            }
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " All send commits are not yet complete (remaining=" + context.busConnections.count() + ").", Tracer.Level.DEBUG);
            }
            return false;
        }

        final boolean onStoreCommitComplete(IStoreCommitCompletionEvent event) {
            Object attachment = event.getAttachment();
            if (attachment instanceof CommitContext) {
                CommitContext context = (CommitContext)attachment;
                if (!AepEngine.this.replicateInParallel || context.storeCommitState.incrementAndGet() == 0) {
                    this.onStoreCommitComplete(context);
                }
                return true;
            }
            return false;
        }

        final void close() {
            this.commitContextPool.close();
        }

        final class CommitContextFactory
        implements UtlPool.Factory<CommitContext> {
            CommitContextFactory() {
            }

            public final CommitContext createItem(Object object) {
                return new CommitContext();
            }

            public final CommitContext[] createItemArray(int size) {
                return new CommitContext[size];
            }
        }

        final class CommitContext
        implements UtlPool.Item<CommitContext>,
        AepTransactionStageEvent.ICommitContext {
            private long id;
            private long stableId;
            private final EventList events;
            private final BusConnectionList busConnections;
            private final AepSendCommitCompletionEvent zeroSendCommitCompletionEvent;
            private boolean eventsAcked;
            private UtlPool<CommitContext> pool;
            private long commitStartTs;
            private AtomicInteger storeCommitState;
            private long storeCommitStartTs;
            private long storeCommitCompleteTs;
            private boolean sendCommitComplete;
            private long sendCommitStartTs;
            private long sendCommitCompleteTs;
            private boolean hasInboundMsgs;
            private boolean hasOutboundMsgs;
            private boolean hasGuarOutboundMsgs;
            private long lastOutboundSno;
            private long meanOutTs;
            private int meanOutTsMsgCount;
            private int sendCommitCompletionProcTime;
            private int messagesToReplicateCount;
            private AepMonTransactionStatsMessage perTransactionStats;
            private final IRogMessage[] messagesToReplicate;

            CommitContext() {
                this.events = new EventList();
                this.busConnections = new BusConnectionList();
                this.zeroSendCommitCompletionEvent = AepSendCommitCompletionEvent.create();
                this.storeCommitState = new AtomicInteger(0);
                this.messagesToReplicate = new IRogMessage[AepEngine.this.numEnvironmentProviderProxies + Math.max(1, AepEngine.this.adaptiveCommitBatchCeiling)];
                this.messagesToReplicateCount = AepEngine.this.numEnvironmentProviderProxies;
            }

            final boolean onSendCommitComplete(AepSendCommitCompletionEvent event) {
                if (event.getStatus() == null || AepEngine.this.sendStabilityFailureHandlingPolicy == MessageSendStabilityFailureHandlingPolicy.LogExceptionAndContinue) {
                    MessageBusBinding busBinding;
                    long ts;
                    if (event.getStatus() != null) {
                        try {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Received send stability failure '[" + event.getStatus().toString() + "].\n");
                            sb.append("Stack trace:\n");
                            sb.append(UtlThrowable.prepareStackTrace((Throwable)event.getStatus()));
                            sb.append("Logging exception and continuing...\n");
                            AepEngine.this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    if ((ts = event.getMeanOutTs()) > 0L) {
                        this.meanOutTs = ((long)this.meanOutTsMsgCount * this.meanOutTs + ts) / (long)(++this.meanOutTsMsgCount);
                    }
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Out timestamp = " + this.meanOutTs + ".", Tracer.Level.DEBUG);
                    }
                    if ((busBinding = (MessageBusBinding)event.getSource()) == null) {
                        return true;
                    }
                    AepBusConnection busConnection = (AepBusConnection)((Object)busBinding.getAttachment());
                    return this.busConnections.remove(busConnection).count() == 0;
                }
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Outbound send failed [" + event.getStatus().toString() + "]. Shutting down...", Tracer.Level.SEVERE);
                AepEngine.this.stop(event.getStatus(), false);
                return false;
            }

            final IRogMessage prepareInboundMessageForLoggingAndOrReplication(IRogMessage message) {
                message.setStableTransactionId(this.stableId);
                message.setOutMsgsInTransaction(this.hasOutboundMsgs);
                return message;
            }

            final IRogMessage prepareOutboundMessageForLoggingAndOrReplication(IRogMessage message) {
                message.setStableTransactionId(this.stableId);
                return message;
            }

            final void dispose() {
                if (this.pool != null) {
                    this.pool.put((UtlPool.Item)this);
                }
            }

            public final CommitContext init() {
                if (this.events.count() != 0) {
                    throw new InternalError("a commit context's event list is non-empty when its wrapper context is released to its pool!");
                }
                if (this.busConnections.count() != 0) {
                    throw new InternalError("a commit context's bus connection list is non-empty when its wrapper context is released to its pool!");
                }
                this.id = 0L;
                this.sendCommitComplete = false;
                this.storeCommitState.set(0);
                this.hasGuarOutboundMsgs = false;
                this.hasOutboundMsgs = false;
                this.hasInboundMsgs = false;
                this.lastOutboundSno = 0L;
                this.meanOutTs = 0L;
                this.meanOutTsMsgCount = 0;
                this.commitStartTs = 0L;
                this.storeCommitStartTs = 0L;
                this.storeCommitCompleteTs = 0L;
                this.sendCommitStartTs = 0L;
                this.sendCommitCompleteTs = 0L;
                this.sendCommitCompletionProcTime = 0;
                this.eventsAcked = false;
                this.perTransactionStats = null;
                return this;
            }

            public final CommitContext setPool(UtlPool<CommitContext> pool) {
                this.pool = pool;
                return this;
            }

            public final UtlPool<CommitContext> getPool() {
                return this.pool;
            }

            @Override
            public final long getTransactionId() {
                return this.id;
            }

            @Override
            public final int getInboundEventCount() {
                return this.events != null ? this.events.count() : 0;
            }

            @Override
            public final Event[] getInboundEvents() {
                return this.events != null && this.events.count() > 0 ? this.events.array() : null;
            }

            final EventList getInboundEventList() {
                return this.events;
            }

            final void clearInboundEventList() {
                this.events.clear();
            }

            public final boolean canSendCommmitCompleteAfter(CommitContext other) {
                return !this.hasOutboundMsgs || !other.hasOutboundMsgs || this.hasGuarOutboundMsgs && !other.hasGuarOutboundMsgs || this.busConnections.canCompleteAfter(other.busConnections);
            }
        }

        private final class BusConnectionList {
            private final AepBusConnection[] array;
            private final AepBusConnection.OutboundQueue.Slice[] saved;
            private final AepSendCommitCompletionEvent[] sendCommitCompletionEvents;
            private final BitVector involved;
            private int size;
            private int referenceCount;

            BusConnectionList() {
                this.array = new AepBusConnection[AepEngine.this.busConnections.size()];
                this.sendCommitCompletionEvents = new AepSendCommitCompletionEvent[AepEngine.this.busConnections.size()];
                for (int i = 0; i < this.sendCommitCompletionEvents.length; ++i) {
                    this.sendCommitCompletionEvents[i] = AepSendCommitCompletionEvent.create();
                }
                this.involved = AepEngine.this.enableSendCommitCompleteSequenceAlerts ? new BitVector(AepEngine.this.busConnections.size()) : null;
                this.saved = new AepBusConnection.OutboundQueue.Slice[AepEngine.this.busConnections.size()];
                this.init();
            }

            private final void init() {
                if (this.size > 0) {
                    throw new InternalError("a transaction's bus connection list was not empty when released to its pool!");
                }
                if (AepEngine.this.enableSendCommitCompleteSequenceAlerts) {
                    this.involved.clear();
                }
                this.referenceCount = 1;
            }

            final BusConnectionList add(AepBusConnection connection) {
                int id = connection.getId();
                if (this.array[id] == null) {
                    this.array[id] = connection;
                    connection.setSavepoint(Transaction.this.savepoint);
                    if (AepEngine.this.enableSendCommitCompleteSequenceAlerts) {
                        this.involved.set(id);
                    }
                    ++this.size;
                } else if (this.array[id] != connection) {
                    throw new InternalError("duplicate bus connection with same id!");
                }
                return this;
            }

            final BusConnectionList remove(AepBusConnection connection) {
                if (this.array[connection.getId()] != null) {
                    this.array[connection.getId()] = null;
                    --this.size;
                    return this;
                }
                throw new InternalError("attempt to remove an absent bus connection from transaction bus connection list");
            }

            final BusConnectionList save(AepBusConnection connection, AepBusConnection.OutboundQueue.Slice slice) {
                int id = connection.getId();
                if (this.saved[id] != null) {
                    throw new InternalError("overrwriting saved transaction context!");
                }
                this.saved[id] = slice;
                return this;
            }

            final AepBusConnection.OutboundQueue.Slice saved(AepBusConnection connection, boolean clear) {
                int id = connection.getId();
                AepBusConnection.OutboundQueue.Slice slice = this.saved[id];
                if (clear) {
                    this.saved[id] = null;
                }
                return slice;
            }

            final AepBusConnection[] array() {
                return this.array;
            }

            final int count() {
                return this.size;
            }

            final boolean canCompleteAfter(BusConnectionList other) {
                if (AepEngine.this.enableSendCommitCompleteSequenceAlerts) {
                    if (this.involved.equals((Object)other.involved)) {
                        return false;
                    }
                    BitVector check = this.involved.copy();
                    check.and(other.involved);
                    if (check.cardinality() == 0) {
                        return true;
                    }
                    check.or(this.involved);
                    return check.equals((Object)this.involved);
                }
                return true;
            }

            final void acquire() {
                ++this.referenceCount;
            }

            final void dispose() {
                if (--this.referenceCount == 0) {
                    this.init();
                }
            }
        }

        private final class EventList {
            private Event[] array;
            private int size;
            private long meanInTs;
            private int meanInTsMsgCount;

            private EventList() {
            }

            final EventList append(Event event) {
                if (event.getType() == 105) {
                    long ts = ((MessageEvent)event).getMessageView().getPostWireTs();
                    if (ts > 0L) {
                        this.meanInTs = ((long)this.meanInTsMsgCount * this.meanInTs + ts) / (long)(++this.meanInTsMsgCount);
                    }
                    if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                        AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " In timestamp = " + this.meanInTs + ".", Tracer.Level.DEBUG);
                    }
                }
                if (this.array == null) {
                    this.array = new Event[256];
                }
                if (this.size == this.array.length) {
                    this.array = Arrays.copyOf(this.array, this.array.length * 2);
                }
                this.array[this.size++] = event;
                return this;
            }

            final Event[] array() {
                return this.array;
            }

            final int count() {
                return this.size;
            }

            final void clear() {
                this.size = 0;
                this.meanInTs = 0L;
                this.meanInTsMsgCount = 0;
            }
        }
    }

    private static final class InjectedRequestContextFactory
    implements UtlPool.Factory<InjectedRequestContext> {
        private InjectedRequestContextFactory() {
        }

        public final InjectedRequestContext createItem(Object object) {
            return new InjectedRequestContext();
        }

        public final InjectedRequestContext[] createItemArray(int size) {
            return new InjectedRequestContext[size];
        }
    }

    private static final class InjectedRequestContext
    extends UtlListElement
    implements UtlPool.Item<InjectedRequestContext> {
        private long requestId;
        private MessageEvent requestMessageEvent;
        private IRogMessage reply;
        private UtlPool<InjectedRequestContext> pool;

        InjectedRequestContext() {
        }

        final InjectedRequestContext init(long requestId, MessageEvent requestMessageEvent) {
            this.requestId = requestId;
            this.requestMessageEvent = requestMessageEvent;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onReply(IRogMessage message) {
            InjectedRequestContext injectedRequestContext = this;
            synchronized (injectedRequestContext) {
                if (this.reply != null) {
                    throw new IllegalStateException("reply already received");
                }
                if (message == null) {
                    throw new IllegalArgumentException("reply cannot be null");
                }
                this.reply = message;
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final IRogMessage waitForReply(int timeout) {
            if (timeout <= 0) {
                timeout = Integer.MAX_VALUE;
            }
            InjectedRequestContext injectedRequestContext = this;
            synchronized (injectedRequestContext) {
                long remaining;
                long ts = System.currentTimeMillis();
                while (this.reply == null && (remaining = (long)timeout - (System.currentTimeMillis() - ts)) > 0L) {
                    try {
                        ((Object)((Object)this)).wait(remaining);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.reply;
            }
        }

        final void dispose() {
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }

        public final InjectedRequestContext init() {
            this.requestId = 0L;
            if (this.requestMessageEvent != null) {
                this.requestMessageEvent.dispose();
                this.requestMessageEvent = null;
            }
            if (this.reply != null) {
                this.reply.dispose();
                this.reply = null;
            }
            return this;
        }

        public final InjectedRequestContext setPool(UtlPool<InjectedRequestContext> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<InjectedRequestContext> getPool() {
            return this.pool;
        }
    }

    private final class AlertEventHandler {
        private AlertEventHandler() {
        }

        @EventHandler
        private final void onApplicationAlert(IAlertEvent alert) {
            if (((AepEngine)AepEngine.this).alertTracer.getLevel().val > Tracer.Level.WARNING.val) {
                return;
            }
            if (alert instanceof AepBusBindingOpenFailedEvent && AepEngine.this.engineDescriptor.getMessagingStartFailPolicy() == MessagingStartFailPolicy.NeverFail) {
                return;
            }
            if (alert instanceof AepEngineStoppedEvent && ((AepEngineStoppedEvent)alert).getCause() == null) {
                return;
            }
            if (alert instanceof AepEngineStoppingEvent && ((AepEngineStoppingEvent)alert).getCause() == null) {
                return;
            }
            AepEngine.this.alertTracer.log(AepEngine.this.tracePrefix + " [ALERT]: " + alert.toString(), Tracer.Level.WARNING);
        }
    }

    private final class LastTransactionContext {
        long transactionId;
        Exception cause;
        boolean shutdownCluster;
        boolean shutdownAfterThisTransaction;

        private LastTransactionContext() {
        }

        final void init(long transactionId, Exception cause, boolean shutdownCluster, boolean shutdownAfterThisTransaction) {
            this.transactionId = transactionId;
            this.cause = cause;
            this.shutdownCluster = shutdownCluster;
            this.shutdownAfterThisTransaction = shutdownAfterThisTransaction;
        }
    }

    private final class ScheduleRecoverer
    implements LongObjectProcedure {
        private int reactivated;

        private ScheduleRecoverer() {
        }

        final ScheduleRecoverer reset() {
            this.reactivated = 0;
            return this;
        }

        final int reactivated() {
            return this.reactivated;
        }

        public final boolean apply(long first, Object second) {
            AepScheduleEvent event = (AepScheduleEvent)((Object)second);
            switch (event.getState()) {
                case NotActivated: 
                case Activated: {
                    switch (event.getHAPolicy()) {
                        case Cancel: {
                            AepEngine.this.cancelledSchedules.add(event);
                            break;
                        }
                        case Reactivate: 
                        case Resume: {
                            ++this.reactivated;
                            AepEngine.this.activateSchedule(event.setState(AepScheduleEvent.State.NotActivated));
                        }
                    }
                    break;
                }
                case Cancelling: 
                case Cancelled: {
                    AepEngine.this.cancelledSchedules.add(event);
                    break;
                }
                default: {
                    throw new InternalError("unknown schedule event state '" + (Object)((Object)event.getState()) + "'");
                }
            }
            return true;
        }
    }

    private final class MessagingStartCompletionNotifier {
        private EAepException status;

        private MessagingStartCompletionNotifier() {
        }

        final MessagingStartCompletionNotifier status(EAepException status) {
            this.status = status;
            return this;
        }

        final EAepException status() {
            return this.status;
        }
    }

    private final class BusConnectionMessageTracer
    implements AepBusConnection.MessageTracer {
        private BusConnectionMessageTracer() {
        }

        @Override
        public final boolean debug() {
            return ((AepEngine)AepEngine.this).msgTracer.debug;
        }

        @Override
        public final void trace(String stage, IRogMessage msg) {
            AepEngine.this.msgTrace(stage, (IRogNode)msg);
        }
    }

    private final class BusConnectionEventHandler
    implements IEventHandler {
        private final boolean scheduleInboundMessageEvents;
        private final boolean nonBlockingInboundMessageDispatch;
        private final int inboundMessageEventPriority;
        private final boolean scheduleSendCommitCompletionEvents;
        private final int sendCommitCompletionEventPriority;

        BusConnectionEventHandler(Properties props) {
            this.scheduleInboundMessageEvents = UtlProps.getValue((Properties)props, (String)"scheduleInboundMessageEvents", (boolean)false);
            this.nonBlockingInboundMessageDispatch = UtlProps.getValue((Properties)props, (String)"nonBlockingInboundMessageDispatch", (boolean)false);
            this.inboundMessageEventPriority = UtlProps.getValue((Properties)props, (String)"inboundMessageEventPriority", (int)0);
            this.scheduleSendCommitCompletionEvents = UtlProps.getValue((Properties)props, (String)"scheduleSendCommitCompletionEvents", (boolean)false);
            this.sendCommitCompletionEventPriority = UtlProps.getValue((Properties)props, (String)"sendCommitCompletionEventPriority", (int)0);
        }

        public final void onEvent(Event event) {
            boolean nonBlockingDispatch = false;
            boolean schedule = false;
            State engineState = AepEngine.this.getState();
            switch (event.getType()) {
                case 105: {
                    if (engineState == State.Stopped || engineState == State.Stopping) {
                        ((MessageEvent)event).setAutoAck(false);
                        if (((AepEngine)AepEngine.this).tracer.verbose) {
                            AepEngine.this.tracer.log(AepEngine.this.tracePrefix + "Dropping message event received while engine is " + (Object)((Object)engineState), Tracer.Level.VERBOSE);
                        }
                        return;
                    }
                    ((MessageEvent)event).getMessageView().setEnqueueTsMicros(UtlTime.nowInMicros());
                    nonBlockingDispatch = this.nonBlockingInboundMessageDispatch;
                    schedule = this.scheduleInboundMessageEvents;
                    event.setDelay(this.inboundMessageEventPriority);
                    break;
                }
                case 111: {
                    if (engineState == State.Stopped || engineState == State.Stopping) {
                        ((UnhandledMessageEvent)event).setAutoAck(false);
                        if (((AepEngine)AepEngine.this).tracer.verbose) {
                            AepEngine.this.tracer.log(AepEngine.this.tracePrefix + "Dropping unhandled message event received while engine is " + (Object)((Object)engineState), Tracer.Level.VERBOSE);
                        }
                        return;
                    }
                    nonBlockingDispatch = this.nonBlockingInboundMessageDispatch;
                    event.setDelay(this.inboundMessageEventPriority);
                    break;
                }
                case 103: 
                case 104: 
                case 512: {
                    nonBlockingDispatch = true;
                    break;
                }
                case 506: {
                    nonBlockingDispatch = true;
                    schedule = this.scheduleSendCommitCompletionEvents;
                    event.setDelay(this.sendCommitCompletionEventPriority);
                    break;
                }
            }
            if (schedule) {
                AepEngine.this.multiplexer.scheduleEvent(event);
            } else {
                if (!nonBlockingDispatch) {
                    switch (engineState) {
                        case Stopping: 
                        case Stopped: {
                            nonBlockingDispatch = true;
                            break;
                        }
                    }
                }
                AepEngine.this.multiplexer.multiplexEvent(event, nonBlockingDispatch ? 1 : 0);
            }
        }
    }

    private final class OutboundMessagingContext
    implements MessageBusBinding.SequenceNumberGenerator {
        private final UtlList queue = UtlList.create();
        private final UtlPool<OutboundQueueElement> outboundQueueElementPool;
        private final UtlList logqueue = UtlList.create();
        private final Map<String, Map<String, DefaultMessageChannelKeyResolver>> messageKeyResolvers = new HashMap<String, Map<String, DefaultMessageChannelKeyResolver>>();
        private long sno;
        private long stableSno;

        OutboundMessagingContext() throws SmaException {
            if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Initializing channel keys in outbound messaging context...", Tracer.Level.DEBUG);
            }
            if (AepEngine.this.busDescriptors.size() > 0) {
                for (MessageBusDescriptor busDescriptor : AepEngine.this.busDescriptors.values()) {
                    HashMap<String, DefaultMessageChannelKeyResolver> map = new HashMap<String, DefaultMessageChannelKeyResolver>();
                    this.messageKeyResolvers.put(busDescriptor.getName(), map);
                    for (MessageChannelDescriptor channelDescriptor : busDescriptor.getChannels()) {
                        DefaultMessageChannelKeyResolver resolver = DefaultMessageChannelKeyResolver.create((MessageChannelDescriptor)channelDescriptor);
                        map.put(channelDescriptor.getName(), resolver);
                    }
                }
            } else if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " ...no channels", Tracer.Level.DEBUG);
            }
            this.outboundQueueElementPool = UtlPool.create((String)"aep.outboundqueue.element", (String)AepEngine.this.getName(), (UtlPool.Factory)new OutboundQueueElementFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        }

        final void setSno(long sno) {
            ((AepEngine)AepEngine.this).stats.outboundSno = this.sno = sno;
        }

        final long sno() {
            return this.sno;
        }

        final void setStableSno(long sno) {
            ((AepEngine)AepEngine.this).stats.outboundStableSno = this.stableSno = sno;
            if (this.stableSno > sno) {
                throw new InternalError("outbound stable sequence number is greater than outbound sequence number (sno=" + sno + "stable=" + this.stableSno + ")!");
            }
        }

        final DefaultMessageChannelKeyResolver getMessageKeyResolver(IRogMessage message) {
            String busName = message.getMessageBus();
            String channelName = message.getMessageChannel();
            Map<String, DefaultMessageChannelKeyResolver> map = this.messageKeyResolvers.get(busName);
            if (map != null) {
                DefaultMessageChannelKeyResolver resolver = map.get(channelName);
                if (resolver != null) {
                    return resolver;
                }
                throw new IllegalArgumentException("invalid channel name in message: " + channelName + "@" + busName);
            }
            throw new IllegalArgumentException("invalid bus name in message: " + busName);
        }

        final void enqueInOutboundQueue(IRogMessage message, int savepoint) {
            OutboundQueueElement last = (OutboundQueueElement)this.queue.last();
            if (last == null || last.message.getMessageSequenceNumber() < message.getMessageSequenceNumber()) {
                OutboundQueueElement element = ((OutboundQueueElement)this.outboundQueueElementPool.get(null)).init(message, savepoint);
                this.queue.append((UtlListElement)element);
            }
            ((AepEngine)AepEngine.this).stats.backupOutboundQueueSize = this.queue.count();
        }

        final int pruneOutboundQueue(long stableTransactionId) {
            IRogMessage message;
            OutboundQueueElement element;
            int count = 0;
            while ((element = (OutboundQueueElement)this.queue.first()) != null && (message = element.message).getTransactionId() <= stableTransactionId) {
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).snoTracer.debug) {
                    AepEngine.this.snoTracer.log("--- [" + message.getMessageSequenceNumber() + "] QX", Tracer.Level.DEBUG);
                }
                element.unlink();
                element.dispose(true);
                ++count;
            }
            ((AepEngine)AepEngine.this).stats.backupOutboundQueueSize = this.queue.count();
            return count;
        }

        final int rollbackOutboundQueue(long transactionId, int savepoint) {
            int rolledback = 0;
            OutboundQueueElement element = (OutboundQueueElement)this.queue.last();
            while (element != null && element.message.getTransactionId() >= transactionId) {
                if (element.message.getTransactionId() > transactionId) {
                    element = (OutboundQueueElement)element.previous();
                    continue;
                }
                OutboundQueueElement previous = (OutboundQueueElement)element.previous();
                if (element.savepoint == -1) {
                    element = previous;
                    continue;
                }
                if (element.savepoint < savepoint) break;
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).msgTracer.debug) {
                    AepEngine.this.msgTrace("[MSG-OUT-Q-ROLLBACK]", (IRogNode)element.message);
                }
                element.unlink();
                element.dispose(true);
                ++rolledback;
                element = previous;
            }
            ((AepEngine)AepEngine.this).stats.backupOutboundQueueSize = this.queue.count();
            return rolledback;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void retransmitOutboundQueue() {
            OutboundQueueElement element;
            while ((element = (OutboundQueueElement)this.queue.first()) != null) {
                IRogMessage message = element.message;
                if (!message.getIsInternal()) {
                    String busName = message.getMessageBus();
                    String channelName = message.getMessageChannel();
                    AepBusConnection busConnection = (AepBusConnection)((Object)AepEngine.this.busConnections.get(busName));
                    if (busConnection == null) throw new InternalError("bus '" + busName + "' not found in engine's bus connection set during retransmit");
                    MessageChannel channel = busConnection.getChannel(channelName);
                    if (channel == null) throw new InternalError("channel '" + channelName + "' not found in engine's bus connection ('" + (Object)((Object)busConnection) + "') during retransmit");
                    message.setPossibleDuplicate();
                    AepEngine.this.sendMessageSolicited(channel, message);
                    AepEngineStats.MessageTypeStats typeStats = AepEngine.this.getMessageTypeStats((MessageView)message, false);
                    ++((AepEngine)AepEngine.this).stats.numMsgsResent;
                    if (typeStats != null) {
                        ++typeStats.numMsgsResent;
                    }
                }
                element.unlink();
                element.dispose(true);
            }
            ((AepEngine)AepEngine.this).stats.backupOutboundQueueSize = this.queue.count();
        }

        final void enqueForLogging(IRogMessage message, int savepoint) {
            if (AepEngine.this.outboundMessageLogger != null) {
                OutboundQueueElement element = ((OutboundQueueElement)this.outboundQueueElementPool.get(null)).init(message, savepoint);
                this.logqueue.append((UtlListElement)element);
                ((AepEngine)AepEngine.this).stats.backupOutboundLogQueueSize = this.logqueue.count();
            }
        }

        final int rollbackLogQueue(long transactionId, int savepoint) {
            int rolledback = 0;
            OutboundQueueElement element = (OutboundQueueElement)this.logqueue.last();
            while (element != null && element.message.getTransactionId() >= transactionId) {
                if (element.message.getTransactionId() > transactionId) {
                    element = (OutboundQueueElement)element.previous();
                    continue;
                }
                OutboundQueueElement previous = (OutboundQueueElement)element.previous();
                if (element.savepoint == -1) {
                    element = previous;
                    continue;
                }
                if (element.savepoint < savepoint) break;
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).msgTracer.debug) {
                    AepEngine.this.msgTrace("[MSG-PER-ROLLBACK]", (IRogNode)element.message);
                }
                element.unlink();
                element.dispose(true);
                ++rolledback;
                element = previous;
            }
            ((AepEngine)AepEngine.this).stats.backupOutboundLogQueueSize = this.queue.count();
            return rolledback;
        }

        final int flushLogQueue(Transaction.CommitContext context, boolean prepareMessage) {
            OutboundQueueElement element;
            int count = 0;
            boolean commitEnd = false;
            while ((element = (OutboundQueueElement)this.logqueue.first()) != null && element.message.getTransactionId() <= context.id) {
                boolean bl = commitEnd = element.next() == null || element.message.getTransactionId() != ((OutboundQueueElement)element.next()).message.getTransactionId();
                if (AepEngine.this.someDebugTrace && ((AepEngine)AepEngine.this).msgTracer.debug) {
                    AepEngine.this.msgTrace("[MSG-PER]", (IRogNode)element.message);
                }
                if (prepareMessage) {
                    context.prepareOutboundMessageForLoggingAndOrReplication(element.message);
                }
                AepEngine.this.outboundMessageLogger.log(element.message, false, commitEnd);
                element.unlink();
                element.dispose(true);
                ++count;
            }
            ((AepEngine)AepEngine.this).stats.backupOutboundLogQueueSize = this.logqueue.count();
            return count;
        }

        final void clearLogQueue(boolean disposeMessages) {
            OutboundQueueElement element;
            while ((element = (OutboundQueueElement)this.logqueue.first()) != null) {
                element.unlink();
                element.dispose(disposeMessages);
            }
        }

        final void close() {
            this.outboundQueueElementPool.close();
        }

        public final long nextSno(MessageView view) {
            ((AepEngine)AepEngine.this).stats.outboundSno = ++this.sno;
            return this.sno;
        }
    }

    private static final class OutboundQueueElementFactory
    implements UtlPool.Factory<OutboundQueueElement> {
        private OutboundQueueElementFactory() {
        }

        public final OutboundQueueElement createItem(Object object) {
            return new OutboundQueueElement();
        }

        public final OutboundQueueElement[] createItemArray(int size) {
            return new OutboundQueueElement[size];
        }
    }

    private static final class OutboundQueueElement
    extends UtlListElement
    implements UtlPool.Item<OutboundQueueElement> {
        private UtlPool<OutboundQueueElement> pool;
        private int refcount;
        IRogMessage message;
        int savepoint;

        OutboundQueueElement() {
        }

        final OutboundQueueElement init(IRogMessage message, int savepoint) {
            this.message = message;
            if (this.message != null) {
                message.acquire();
            }
            this.refcount = 1;
            this.savepoint = savepoint;
            return this;
        }

        final void dispose(boolean disposeMessage) {
            if (this.refcount == 0) {
                throw new InternalError("attempt to dispose an already disposed outbound queue element!");
            }
            if (--this.refcount == 0) {
                if (this.message != null) {
                    if (disposeMessage) {
                        this.message.dispose();
                    }
                    this.message = null;
                }
                if (this.pool != null) {
                    this.pool.put((UtlPool.Item)this);
                }
            }
        }

        public final OutboundQueueElement init() {
            this.savepoint = -1;
            this.refcount = 1;
            this.message = null;
            return this;
        }

        public final OutboundQueueElement setPool(UtlPool<OutboundQueueElement> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<OutboundQueueElement> getPool() {
            return this.pool;
        }
    }

    private static final class HealthCheckScheduler {
        private static final AtomicInteger threadCount = new AtomicInteger(0);
        private static ScheduledExecutorService executor;

        private HealthCheckScheduler() {
        }

        private static synchronized void init() {
            if (executor == null) {
                executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                    @Override
                    public Thread newThread(final Runnable runnable) {
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                UtlThread.setDefaultCPUAffinityMask();
                                runnable.run();
                            }
                        }, "X-Scheduler-" + threadCount.incrementAndGet());
                        thread.setDaemon(true);
                        return thread;
                    }
                });
            }
        }

        static final ScheduledExecutorService getExecutor() {
            if (executor == null) {
                HealthCheckScheduler.init();
            }
            return executor;
        }
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public final void run() {
            if (((AepEngine)AepEngine.this).tracer.debug) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Shutdown hook invoked. Stopping engine (state='" + (Object)((Object)AepEngine.this.state) + "')...", Tracer.Level.DEBUG);
            }
            AepEngine.this.inJVMShutdown = true;
            try {
                AepEngine.this.stop(new Exception("JVM shutting down"));
            }
            catch (Throwable e) {
                AepEngine.this.tracer.log(AepEngine.this.tracePrefix + " Engine stop invoked during shutdown hook threw exception [" + UtlThrowable.prepareStackTrace((Throwable)e) + "].", Tracer.Level.WARNING);
            }
        }
    }

    private static enum ExceptionHandlingPolicy {
        TrapAndDiscard,
        TrapAndFail,
        PassThrough;

    }
}

