/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.ci.ManifestProductInfo;
import com.neeve.controller.Controller;
import com.neeve.controller.XVM;
import com.neeve.ddl.jaxb.XvmConfig;
import com.neeve.deploy.App;
import com.neeve.deploy.AppBus;
import com.neeve.deploy.AppChannel;
import com.neeve.deploy.AppClient;
import com.neeve.deploy.AppFlow;
import com.neeve.deploy.Host;
import com.neeve.deploy.Server;
import com.neeve.server.admin.EAdminOpTimeoutException;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.cnc.ISrvMonCommandDescription;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.util.SrvMonHeartbeatTracer;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.tools.ControllerToolHostCollectionHandler;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.tools.interactive.commands.Command;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ControllerTool {
    @InteractiveTool.ConfigProperty(name="currentSystem", defaultValue="", description="Sets the value of the current system")
    private String currentSystem;
    private final InteractiveTool _interactiveTool = new InteractiveTool("The Rumi Controller Interactive Tool", null, ManifestProductInfo.loadProductInfo((String)"nvx-rumi-controller"));
    private Controller _controller;
    private ControllerToolHostCollectionHandler _hostCollectionHandler;
    private Map<String, SystemContext> _systems;
    private com.neeve.controller.System _system;
    private com.neeve.controller.Script _script;

    private ControllerTool() throws Exception {
        this._interactiveTool.registerAnnotatedCommands((Object)this);
        this._interactiveTool.registerCommand((Command)new Assume());
        this._interactiveTool.registerCommand((Command)new Cleanup());
        this._interactiveTool.registerCommand((Command)new Collect());
        this._interactiveTool.registerCommand((Command)new Configure());
        this._interactiveTool.registerCommand((Command)new Deploy());
        this._interactiveTool.registerCommand((Command)new Instruct());
        this._interactiveTool.registerCommand((Command)new Launch());
        this._interactiveTool.registerCommand((Command)new Provision());
        this._interactiveTool.registerCommand((Command)new Shutdown());
        this._interactiveTool.registerCommand((Command)new Validate());
        this._interactiveTool.registerCommand((Command)new Wait());
        this._interactiveTool.addPreCommandLoopTask(new Runnable(){

            @Override
            public void run() {
                try {
                    ControllerTool.this._controller = new Controller();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error starting controller: " + e.getMessage(), e);
                }
                ControllerTool.this._controller.checkAndDeployNewXars();
                try {
                    (ControllerTool.this._hostCollectionHandler = new ControllerToolHostCollectionHandler(ControllerTool.this._interactiveTool, ControllerTool.this._controller)).open();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error opening the host collection listener: " + e.getMessage(), e);
                }
                ControllerTool.this._systems = new HashMap();
                for (String systemName : ControllerTool.this._controller.getSystemNames()) {
                    try {
                        com.neeve.controller.System system = ControllerTool.this._controller.getSystem(systemName);
                        com.neeve.controller.Script script = ControllerTool.this._controller.createScript(system);
                        ControllerTool.this._systems.put(systemName, new SystemContext(system, script));
                    }
                    catch (Exception e) {
                        ControllerTool.this._interactiveTool.error("Error parsing system '" + systemName + "': " + e.getMessage(), (Throwable)e);
                    }
                }
                if (ControllerTool.this.currentSystem != null && ControllerTool.this.currentSystem.trim().length() > 0) {
                    ControllerTool.this._interactiveTool.executeCommand("switch " + ControllerTool.this.currentSystem);
                }
            }
        });
        this._interactiveTool.addCloseHook(new Runnable(){

            @Override
            public void run() {
                try {
                    ControllerTool.this._hostCollectionHandler.close();
                }
                catch (Exception e) {
                    ControllerTool.this._interactiveTool.error("Error closing host collection listener", (Throwable)e);
                }
                ControllerTool.this._controller.close();
            }
        });
    }

    private final void run() throws Exception {
        Thread.currentThread().setName("X-ControllerTool");
        this._interactiveTool.run();
    }

    public static void main(String[] args) {
        try {
            new ControllerTool().run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @AnnotatedCommand.Command(parseOptions=false, keywords={"invoke"}, description="This command invokes a command on an App. Issue 'listAppCommands <xvm> <app>' to see the list of commands an app supports")
    public final class XvmInvokeAppCommand
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="xvmName", required=true, description="The name of the XVM in which the app is running")
        String xvmName;
        @AnnotatedCommand.Argument(position=2, name="appName", required=true, description="The name of the app on which the command should be invoked")
        String appName;
        @AnnotatedCommand.RemainingArgs(name="command", requoteForSingleString=true, required=true, description="The command and arguments to invoke on the server (in the form of <command> <args1> ... <argN>).")
        String command;

        public final void execute() throws Exception {
            Server server = ControllerTool.this._controller.getModel().getServer(this.xvmName);
            App app = null;
            if (server != null) {
                app = server.getApp(this.appName);
                if (app == null) {
                    this.console().error("<unknown XVM '" + this.xvmName + "'>");
                    return;
                }
            } else {
                this.console().error("<unknown XVM '" + this.xvmName + "'>");
                return;
            }
            int pos = this.command.indexOf(" ");
            String commandName = pos > 1 ? this.command.substring(0, pos) : null;
            try {
                Object result = app.invokeCommand(this.command);
                if (result != null) {
                    this.console().info("Success: " + result);
                } else {
                    this.console().info("Success.");
                }
            }
            catch (EAdminOpTimeoutException e) {
                this.console().error("Command timed out. Try issuing 'set xvmCommandTimeout <seconds>' to a higher value?");
            }
            catch (Exception e) {
                this.console().error("Error invoking app command: " + e.getMessage() + " ... issue 'listAppCommands -u " + this.xvmName + " " + this.appName + " " + commandName + "' for usage", (Throwable)e);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"listAppCommands"}, description="This lists the commands available for an app")
    public final class XvmListAppCommands
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=117, longForm="usage", defaultValue="false", description="Flag that can be specified to additionally show usage for the commands.")
        boolean showUsage = false;
        @AnnotatedCommand.Argument(position=1, name="xvmName", required=true, description="The name of the XVM in which the app is running")
        String xvmName;
        @AnnotatedCommand.Argument(position=2, name="appName", required=true, description="The name of the app on which to list commands")
        String appName;
        @AnnotatedCommand.Argument(position=3, name="filter", required=false, defaultValue="*", description="Optionally can be specified to list only commands that contain this filter in their name. '*' indicates that all commands should be displayed")
        String filter = "*";

        public final void execute() throws Exception {
            Server server = ControllerTool.this._controller.getModel().getServer(this.xvmName);
            App app = null;
            if (server != null) {
                app = server.getApp(this.appName);
                if (app == null) {
                    this.console().error("<unknown XVM '" + this.xvmName + "'>");
                    return;
                }
            } else {
                this.console().error("<unknown XVM '" + this.xvmName + "'>");
                return;
            }
            boolean showAll = this.filter.equals("*");
            this.filter = this.filter.toLowerCase();
            int commandsMatched = 0;
            StringBuilder sb = new StringBuilder();
            for (ISrvMonCommandDescription command : app.getCommands()) {
                boolean show = showAll;
                if (!show) {
                    if (command.getName().toLowerCase().indexOf(this.filter) >= 0) {
                        show = true;
                    }
                    if (!show) {
                        for (String alias : command.getAliasesEmptyIfNull()) {
                            if (alias.toLowerCase().indexOf(this.filter) < 0) continue;
                            show = true;
                            break;
                        }
                    }
                }
                if (!show) continue;
                ++commandsMatched;
                if (this.showUsage) {
                    SrvMonUtil.printCommmandUsage((ISrvMonCommandDescription)command, (Appendable)sb);
                    sb.append("\n");
                    continue;
                }
                if (commandsMatched > 1) {
                    sb.append(", ");
                }
                sb.append(command.getName());
            }
            this.console().info("Found '" + commandsMatched + " command" + (commandsMatched == 1 ? ":" : "s:"));
            this.console().info(sb.toString());
            if (commandsMatched == 0 && app.getCommands().length > 0) {
                this.console().info("Issue 'listAppCommands " + this.xvmName + " " + this.appName + " *' to show all commands.");
            } else if (!this.showUsage) {
                this.console().info("Issue 'listAppCommands -u " + this.xvmName + " " + this.appName + " <commandName>' to show usage.");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"kill"}, description="This command kills an XVM")
    public final class XvmKill
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="xvmName", required=true, description="The name of the XVM to kill")
        String xvmName;

        public final void execute() throws Exception {
            Server server = ControllerTool.this._controller.getModel().getServer(this.xvmName);
            if (server != null) {
                server.kill();
            } else {
                this.console().error("<unknown XVM '" + this.xvmName + "'>");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"stop"}, description="This command stops an XVM")
    public final class XvmStop
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="xvmName", required=true, description="The name of the XVM to stop")
        String xvmName;

        public final void execute() throws Exception {
            Server server = ControllerTool.this._controller.getModel().getServer(this.xvmName);
            if (server != null) {
                server.stop();
            } else {
                this.console().error("<unknown XVM '" + this.xvmName + "'>");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"stats"}, description="Dumps stats from XVM heartbeats")
    public final class Stats
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="xvmName", required=true, description="The name of the XVM")
        String xvmName;
        @AnnotatedCommand.Argument(position=2, name="appName", required=false, description="The name of the app whose stats to dump (ignored for all except -a and -u)")
        String appName;
        @AnnotatedCommand.Argument(position=3, name="entityType", required=false, description="The entity type whose stats to dump (only applies to -a))")
        SrvMonHeartbeatTracer.Apps.EntityType entityType;
        @AnnotatedCommand.Argument(position=4, name="entityName", required=false, description="The nsme of the entity whose stats to dump (only applies to -a))")
        String entityName;
        @AnnotatedCommand.Option(shortForm=115, longForm="sysStats", defaultValue="true", description="Prints system stats")
        boolean sysStats;
        @AnnotatedCommand.Option(shortForm=97, longForm="appStats", defaultValue="false", description="Prints app (engine) stats")
        boolean appStats;
        @AnnotatedCommand.Option(shortForm=112, longForm="poolStats", defaultValue="false", description="Prints pool stats")
        boolean poolStats;
        @AnnotatedCommand.Option(shortForm=99, longForm="adminClientStats", defaultValue="false", description="Prints admin client stats")
        boolean adminClientStats;
        @AnnotatedCommand.Option(shortForm=116, longForm="threadStats", defaultValue="false", description="Prints system stats")
        boolean threadStats;
        @AnnotatedCommand.Option(shortForm=117, longForm="userStats", defaultValue="false", description="Prints user application defined stats")
        boolean userStats;
        private final SrvMonHeartbeatTracer tracer = new SrvMonHeartbeatTracer();

        Stats() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void execute(String xvmName, Server.EventHandler eventHandler) throws Exception {
            block13: {
                ControllerToolHostCollectionHandler.ServerHandler handler = ControllerTool.this._hostCollectionHandler.getServerHandler(xvmName);
                if (handler != null) {
                    this.console().info("*** Press CTRL-C to stop ***");
                    handler.addDelegate(eventHandler);
                    try (SigINTHandler sigintHandler = new SigINTHandler();){
                        SigINTHandler sigINTHandler = sigintHandler;
                        synchronized (sigINTHandler) {
                            while (!sigintHandler.signalled()) {
                                try {
                                    sigintHandler.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            break block13;
                        }
                    }
                    finally {
                        handler.removeDelegate(eventHandler);
                    }
                }
                this.console().info("<unknown XVM '" + xvmName + "'>");
            }
        }

        public final void execute() throws Exception {
            this.tracer.setTraceAdminClientStats(this.adminClientStats);
            this.tracer.setTraceAppStats(this.appStats);
            this.tracer.setTraceSysStats(this.sysStats);
            this.tracer.setTraceThreadStats(this.threadStats);
            this.tracer.setTraceUserStats(this.userStats);
            this.tracer.setTracePoolStats(this.poolStats);
            this.execute(this.xvmName, new EventHandler());
        }

        private final class EventHandler
        implements Server.EventHandler {
            private EventHandler() {
            }

            public final void onStateChange(Server.State state) {
            }

            public final void onAppUp(App app) {
            }

            public final void onAppDown(App app) {
            }

            public final void onTraceRecord(SrvMonTraceRecord record) {
            }

            public final void onHeartbeat(SrvMonHeartbeatMessage message) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n");
                Stats.this.tracer.printStats(message, Stats.this.appName, Stats.this.entityType, Stats.this.entityName, sb);
                Stats.this.console().info(sb.toString());
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"trace"}, description="Listens for and outputs XVM trace ")
    public final class XvmTrace
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="xvmName", required=true, description="The name of the XVM whose trace to output")
        String xvmName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void execute(String xvmName, Server.EventHandler eventHandler) throws Exception {
            block13: {
                ControllerToolHostCollectionHandler.ServerHandler handler = ControllerTool.this._hostCollectionHandler.getServerHandler(xvmName);
                if (handler != null) {
                    this.console().info("*** Press CTRL-C to stop ***");
                    handler.addDelegate(eventHandler);
                    handler.getServer().startTraceWatch();
                    try (SigINTHandler sigintHandler = new SigINTHandler();){
                        SigINTHandler sigINTHandler = sigintHandler;
                        synchronized (sigINTHandler) {
                            while (!sigintHandler.signalled()) {
                                try {
                                    sigintHandler.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            break block13;
                        }
                    }
                    finally {
                        handler.getServer().stopTraceWatch();
                        handler.removeDelegate(eventHandler);
                    }
                }
                this.console().info("<unknown XVM '" + xvmName + "'>");
            }
        }

        public final void execute() throws Exception {
            this.execute(this.xvmName, new EventHandler());
        }

        private final class EventHandler
        implements Server.EventHandler {
            private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss:SSS");

            private EventHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void formatForPrint(SrvMonTraceRecord record, StringBuilder sb) {
                sb.append("<");
                sb.append(record.getThreadId());
                sb.append(",");
                sb.append(record.getProcessId());
                sb.append(",");
                sb.append(record.getHostAddress());
                sb.append("> ");
                SimpleDateFormat simpleDateFormat = this.dateFormat;
                synchronized (simpleDateFormat) {
                    sb.append(this.dateFormat.format(new Date(record.getTimestamp())));
                }
                sb.append(" (");
                sb.append(record.getLevel().toString());
                sb.append(")...");
                sb.append(record.getTrace());
            }

            public final void onStateChange(Server.State state) {
            }

            public final void onAppUp(App app) {
            }

            public final void onAppDown(App app) {
            }

            public final void onTraceRecord(SrvMonTraceRecord record) {
                StringBuilder sb = new StringBuilder();
                this.formatForPrint(record, sb);
                XvmTrace.this.console().info(sb.toString());
            }

            public final void onHeartbeat(SrvMonHeartbeatMessage message) {
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"xvms"}, description="This command describes the running state of the current system (selected via the 'switch' command)")
    public final class Xvms
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            HashMap<String, XVM> undiscoveredXvms = new HashMap<String, XVM>();
            if (ControllerTool.this._system != null) {
                for (XVM xvm : ControllerTool.this._system.getXVMs()) {
                    undiscoveredXvms.put(xvm.name(), xvm);
                }
            }
            this.console().info("");
            this.console().info("XVMs Discovered");
            this.console().info("---------------");
            if (ControllerTool.this._controller.getModel().getHostCollection().getHosts().size() > 0) {
                for (Host host : ControllerTool.this._controller.getModel().getHostCollection().getHosts()) {
                    this.console().info("Host '" + host.getAddress().toString() + "' {");
                    int xvmCount = 0;
                    for (Server server : host.getServers()) {
                        XVM xvm = (XVM)undiscoveredXvms.remove(server.getName());
                        boolean xvmInConfig = xvm != null;
                        ++xvmCount;
                        this.console().info("...XVM '" + server.getName() + "' (" + (xvmInConfig ? "Y" : "N") + ", " + server.getState() + ") {");
                        HashSet<String> unloadedApps = new HashSet<String>();
                        if (xvm != null) {
                            for (XvmConfig.Apps.App app : xvm.ddlElement().getApps().getApp()) {
                                unloadedApps.add(app.getName());
                            }
                        }
                        int appCount = 0;
                        for (App app : server.getApps()) {
                            boolean appInConfig = unloadedApps.remove(app.getName());
                            ++appCount;
                            this.console().info("......App '" + app.getName() + "' (" + (app.getName().equalsIgnoreCase("Admin") ? "Y" : (xvm != null ? (appInConfig ? "Y" : "N") : "?")) + ", " + app.getState() + ") {");
                            this.console().info(".........Clients");
                            if (app.getClients().size() > 0) {
                                for (AppClient client : app.getClients()) {
                                    this.console().info(".............'" + client.getName() + "'");
                                }
                            } else {
                                this.console().info(".............<no clients>'");
                            }
                            this.console().info(".........Flows");
                            if (app.getFlows().size() > 0) {
                                for (AppFlow flow : app.getFlows()) {
                                    this.console().info(".............'" + flow.getId() + "'");
                                }
                            } else {
                                this.console().info(".............<no flows>'");
                            }
                            this.console().info(".........Bus Connections");
                            if (app.getBuses().size() > 0) {
                                for (AppBus bus : app.getBuses()) {
                                    this.console().info(".............'" + bus.getName() + "' (" + bus.getState() + ")");
                                    if (bus.getChannels().size() > 0) {
                                        for (AppChannel channel : bus.getChannels()) {
                                            this.console().info("................'" + channel.getName() + "'");
                                        }
                                        continue;
                                    }
                                    this.console().info("................<no channels>'");
                                }
                            } else {
                                this.console().info(".............<no buses>'");
                            }
                            this.console().info("......}");
                        }
                        for (String appName : unloadedApps) {
                            ++appCount;
                            this.console().info("......App '" + appName + "' (in xvm, " + App.State.Unloaded + ")");
                        }
                        if (appCount == 0) {
                            this.console().info("......<no apps>");
                        }
                        this.console().info("...}");
                    }
                    if (xvmCount == 0) {
                        this.console().info("...<no discovered xvms>");
                    }
                    this.console().info("}");
                }
            } else {
                this.console().info("<none>");
            }
            this.console().info("");
            this.console().info("XVMs In Config But Not Discovered");
            this.console().info("---------------------------------");
            if (ControllerTool.this._system != null) {
                if (undiscoveredXvms.size() > 0) {
                    for (XVM xvm : undiscoveredXvms.values()) {
                        this.console().info("...XVM '" + xvm.name() + "' {");
                        int appCount = 0;
                        for (XvmConfig.Apps.App app : xvm.ddlElement().getApps().getApp()) {
                            ++appCount;
                            this.console().info("......App '" + app.getName() + "' ");
                        }
                        if (appCount == 0) {
                            this.console().info("......<no apps>");
                        }
                        this.console().info("...}");
                    }
                } else {
                    this.console().info("<none>");
                }
            } else {
                this.console().info("<no selected working system>");
            }
            this.console().info("");
        }
    }

    public final class Cleanup
    extends ScriptCommand {
        Cleanup() {
            super("cleanup");
        }

        public final void help() {
            this.console().info("cleanup\n  This command adds a 'cleanup' command to the working script. A cleanup command executes cleanup for each of the executed commands in \n  reverse order in the working script.\nUsage:\n  cleanup\n");
        }

        public final String[] keywords() {
            return new String[]{"cleanup"};
        }
    }

    public final class Shutdown
    extends ScriptCommand {
        Shutdown() {
            super("shutdown");
        }

        public final void help() {
            this.console().info("shutdown\n  This command adds a 'shutdown' command to the working script. A shutdown command shuts down all xvms started by the working script.\nUsage:\n  shutdown\n");
        }

        public final String[] keywords() {
            return new String[]{"shutdown"};
        }
    }

    public final class Collect
    extends ScriptCommand {
        Collect() {
            super("collect");
        }

        public final void help() {
            this.console().info("collect\n  This command adds a 'collect' command to the working script. A collect command collects artifacts from an application.\n  running in an XVM\nUsage:\n  collect <command> from the <appName> app in the <xvmName> xvm record as <identifier>\n");
        }

        public final String[] keywords() {
            return new String[]{"collect"};
        }
    }

    public final class Validate
    extends ScriptCommand {
        Validate() {
            super("validate");
        }

        public final void help() {
            this.console().info("validate\n  This command adds a 'validate' command to the working script. A validate command validates that the return value \n  of a command issued to an application running in an XVM matches a specified value.\nUsage:\n  validate the <appName> app in the <xvmName> xvm <command> is <value>\n");
        }

        public final String[] keywords() {
            return new String[]{"validate"};
        }
    }

    public final class Wait
    extends ScriptCommand {
        Wait() {
            super("wait");
        }

        public final void help() {
            this.console().info("wait\n  This command adds a 'wait' command to the working script. A wait command repeatedly issues a command to an \n  application running in an XVM app until the app responds with success.\nUsage:\n  wait until the <appName> app in the <xvmName> xvm is <command> [with <params>]\n");
        }

        public final String[] keywords() {
            return new String[]{"wait"};
        }
    }

    public final class Instruct
    extends ScriptCommand {
        Instruct() {
            super("instruct");
        }

        public final void help() {
            this.console().info("instruct\n  This command adds an instruct command to the working script. An instruct command sends an instruction to \n  an application running in an XVM.\nUsage:\n  instruct the <appName> app in the <xvmName> xvm to <command> [with <params>]\n");
        }

        public final String[] keywords() {
            return new String[]{"instruct"};
        }
    }

    public final class Launch
    extends ScriptCommand {
        Launch() {
            super("launch");
        }

        public final void help() {
            this.console().info("launch\n  This command adds a 'launch' command to the working script. A launch command launches an XVM.\nUsage:\n  launch the <xvmName> xvm\n");
        }

        public final String[] keywords() {
            return new String[]{"launch"};
        }
    }

    public final class Deploy
    extends ScriptCommand {
        Deploy() {
            super("deploy");
        }

        public final void help() {
            this.console().info("deploy\n  This command adds a 'deploy' command to the working script. A deploy command deploys a system's jars and resources\n  to an XVM's location.\nUsage:\n  deploy to the <xvmName> xvm | to all xvms\n");
        }

        public final String[] keywords() {
            return new String[]{"deploy"};
        }
    }

    public final class Configure
    extends ScriptCommand {
        Configure() {
            super("configure");
        }

        public final void help() {
            this.console().info("configure\n  This adds a 'configure' command to the working script. A configure command configures a specified \n  XVM or all XVMs configured in the working system.\nUsage:\n  configure the <xvmName> xvm | all xvms\n");
        }

        public final String[] keywords() {
            return new String[]{"configure"};
        }
    }

    public final class Provision
    extends ScriptCommand {
        Provision() {
            super("provision");
        }

        public final void help() {
            this.console().info("provision\n  This command adds a 'provision' command to the working script. A provision command \n  provisions one or more XVMs. Provisioning an existing XVM will wipe the XVM clean and \n  reinitialize it. Provisioning a non-existent XVM will provision the XVM fresh. The \n  specified XVM must be one of XVMs in the current system description. Use the 'xvms' \n  command to view configured XVMs\nUsage:\n  provision the <xvmName> xvm | all xvms");
        }

        public final String[] keywords() {
            return new String[]{"provision"};
        }
    }

    public final class Assume
    extends ScriptCommand {
        Assume() {
            super("assume");
        }

        public final void help() {
            this.console().info("assume\n  This command adds an assume command to the working script. The assume command does a mock\n  run of the script name supplied to the assume command to bring the working script state to \n  a point as if the specified script was indeed run. This allows for commands such as shutdown \n  and cleanup to work correctly\nUsage:\n  assume <scriptName> has run");
        }

        public final String[] keywords() {
            return new String[]{"assume"};
        }
    }

    @AnnotatedCommand.Command(keywords={"script"}, description="This command outputs the contents of the working script to the console")
    public final class Script
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            if (ControllerTool.this._script == null) {
                throw new IllegalStateException("no working script. select a system or load a script");
            }
            List<com.neeve.controller.Command> commands = ControllerTool.this._script.commands();
            if (commands.size() > 0) {
                for (int i = 0; i < commands.size(); ++i) {
                    com.neeve.controller.Command command = commands.get(i);
                    if (i == ControllerTool.this._script.current()) {
                        this.console().info("* " + command.lineNum() + ":" + command.line());
                        continue;
                    }
                    this.console().info("  " + command.lineNum() + ":" + command.line());
                }
            } else {
                this.console().info("<script is empty>");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"run"}, description="This command runs a script from a file. It does not change the working script")
    public final class Run
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="scriptName", required=true, description="The name of the script. A script file with this name is expected to be in the <systemHome>/scripts directory.")
        String scriptName;
        @AnnotatedCommand.Argument(position=2, name="scriptParameters", required=false, description="A comma delimited string of key value pairs to resolve script parameters. If supplied, script parameters will be resolved using the supplied values. If any parameter cannot be resolved using the supplied parameters, then the parameter will be resolved using system environment variables and system properties")
        String scriptParameters;

        public final void execute() throws Exception {
            if (ControllerTool.this._system == null) {
                throw new IllegalStateException("no working system. set a working system via the 'switch' command");
            }
            ControllerTool.this._controller.createScript(ControllerTool.this._system).parseFromFile(this.scriptName, this.scriptParameters).run();
        }
    }

    @AnnotatedCommand.Command(keywords={"step"}, description="This command runs a specified number of script commands starting from the script's current command")
    public final class Step
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="count", required=false, defaultValue="1", description="The number of commands to run")
        int count;

        public final void execute() throws Exception {
            if (ControllerTool.this._script == null) {
                throw new IllegalStateException("no working script. select a system or load a script");
            }
            if (ControllerTool.this._script.current() < ControllerTool.this._script.commands().size()) {
                ControllerTool.this._script.run(this.count);
            } else {
                this.console().info("end of script");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"go"}, description="This command runs all script commands entered since the last prior invocation of 'go'. If 'rewind' was invoked since the last 'go' invocation, then all commands from the beginning of the script will be invoked")
    public final class Go
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            if (ControllerTool.this._script == null) {
                throw new IllegalStateException("no working script. select a system or load a script");
            }
            if (ControllerTool.this._script.current() < ControllerTool.this._script.commands().size()) {
                ControllerTool.this._script.run();
            } else {
                this.console().info("end of script");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"truncate"}, description="This command truncates the working script's command set from a specified point (inclusive) to the end of the script")
    public final class Truncate
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="pos", required=true, description="The position in the script from which point on the script is truncated")
        int pos;

        public final void execute() throws Exception {
            if (ControllerTool.this._script == null) {
                throw new IllegalStateException("no working script. select a system or load a script");
            }
            ControllerTool.this._script.truncate(this.pos);
        }
    }

    @AnnotatedCommand.Command(keywords={"clear"}, description="This command clears the working script's command set")
    public final class Clear
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            if (ControllerTool.this._script == null) {
                throw new IllegalStateException("no working script. select a system or load a script");
            }
            ControllerTool.this._script.clear();
        }
    }

    @AnnotatedCommand.Command(keywords={"rewind"}, description="This command rewinds the working script's current command pointer to the beginning of the script. Thiswill cause a subsequent invocation of the 'run' command to start from the beginning of the script")
    public final class Rewind
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            if (ControllerTool.this._script == null) {
                throw new IllegalStateException("no working script. select a system or load a script");
            }
            ControllerTool.this._script.rewind();
        }
    }

    @AnnotatedCommand.Command(keywords={"load"}, description="This command loads a script from a file and sets the loaded script as the working script")
    public final class Load
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="scriptName", required=true, description="The name of the script. A script file with this name is expected to be in the <systemHome>/scripts directory.")
        String scriptName;
        @AnnotatedCommand.Argument(position=2, name="scriptParameters", required=false, description="A comma delimited string of key value pairs to resolve script parameters. If supplied, script parameters will be resolved using the supplied values. If any parameter cannot be resolved using the supplied parameters, then the parameter will be resolved using system environment variables and system properties")
        String scriptParameters;

        public final void execute() throws Exception {
            if (ControllerTool.this._system == null) {
                throw new IllegalStateException("no working system. set a working system via the 'switch' command");
            }
            ControllerTool.this._script = ControllerTool.this._controller.createScript(ControllerTool.this._system).parseFromFile(this.scriptName, this.scriptParameters);
        }
    }

    @AnnotatedCommand.Command(keywords={"switch"}, description="This command sets the current working system and switches the working script to the current working system's working script.")
    public final class Switch
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="systemName", required=true, description="The name of the system.")
        String systemName;

        public final void execute() throws Exception {
            SystemContext context;
            if (ControllerTool.this._script != null) {
                this.console().info("Cleaning up current...");
                ControllerTool.this._script.cleanup();
            }
            if ((context = (SystemContext)ControllerTool.this._systems.get(this.systemName)) == null) {
                throw new IllegalArgumentException("invalid system '" + this.systemName + "'");
            }
            ControllerTool.this._system = context._system;
            ControllerTool.this._script = context._script;
            this.console().info("Switched to system '" + this.systemName + "'");
            ControllerTool.this._interactiveTool.executeCommand("set currentSystem " + this.systemName);
        }
    }

    @AnnotatedCommand.Command(keywords={"systems"}, description="This command lists the deployed systems")
    public final class Systems
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            if (ControllerTool.this._systems.size() > 0) {
                for (String str : ControllerTool.this._systems.keySet()) {
                    if (ControllerTool.this._system != null && str.equals(ControllerTool.this._system.getName())) {
                        this.console().info("* " + str);
                        continue;
                    }
                    this.console().info("  " + str);
                }
            } else {
                this.console().info("<no systems>");
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"distribution"}, description="This command lists the Rumi distribution being used by the underlying Rumi controller for to provision XVMs")
    public final class Distribution
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            this.console().info(ControllerTool.this._controller.getDistribution().toString());
        }
    }

    @AnnotatedCommand.Command(keywords={"config"}, description="This command dumps the controllers configuration property set")
    public final class Configuration
    extends AnnotatedCommand {
        public final void execute() throws Exception {
            Properties config = ControllerTool.this._controller.getConfig();
            this.console().info("Controller configuration {");
            for (Object key : config.keySet()) {
                this.console().info("..." + key + "=" + config.getProperty((String)key));
            }
            this.console().info("}");
        }
    }

    private final class SystemContext {
        final com.neeve.controller.System _system;
        final com.neeve.controller.Script _script;

        SystemContext(com.neeve.controller.System system, com.neeve.controller.Script script) {
            this._system = system;
            this._script = script;
        }
    }

    private abstract class ScriptCommand
    extends Command {
        final String _command;

        ScriptCommand(String command) {
            this._command = command;
        }

        public final void run(String[] args) {
            if (ControllerTool.this._script != null) {
                StringBuilder sb = new StringBuilder(this._command);
                for (String arg : args) {
                    sb.append(" ").append(arg);
                }
                try {
                    ControllerTool.this._script.parseCommandLine(sb.toString(), -1, false);
                    this.console().info("Command added.");
                    new Script().execute();
                    this.console().info("Use 'go' or 'step' to execute.");
                }
                catch (Throwable e) {
                    this.error("Error executing '" + this._command + "': " + e.getMessage(), e);
                }
            } else {
                System.err.println("No working script. select a system or load a script");
            }
        }
    }

    private final class SigINTHandler
    implements SignalHandler {
        private final Signal signal = new Signal("INT");
        private final SignalHandler oldHandler = Signal.handle(this.signal, this);
        private boolean signalled;

        SigINTHandler() {
        }

        final boolean signalled() {
            return this.signalled;
        }

        final void close() {
            Signal.handle(this.signal, this.oldHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handle(Signal sig) {
            SigINTHandler sigINTHandler = this;
            synchronized (sigINTHandler) {
                this.signalled = true;
                this.notifyAll();
            }
        }
    }
}

