/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.util.UtlUnit;
import java.util.concurrent.TimeUnit;

final class Sleep
extends Command {
    private long _interval;

    Sleep(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: sleep for <time> seconds");
    }

    @Override
    final String name() {
        return "sleep";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("for")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        String duration = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            duration = duration + " " + tokenizer.nextToken();
        }
        this._interval = (long)UtlUnit.parseDuration((String)duration, (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
        if (this._interval < 0L) {
            this.error("Line " + this.lineNum() + ": Sleep interval must be >= 0");
        }
        return true;
    }

    @Override
    final void execute() {
        if (!this.mock()) {
            try {
                Thread.sleep(this._interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    final void cleanup() {
    }
}

