/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.AbortedError;
import com.neeve.controller.Assume;
import com.neeve.controller.Cleanup;
import com.neeve.controller.Collect;
import com.neeve.controller.Command;
import com.neeve.controller.Configure;
import com.neeve.controller.Controller;
import com.neeve.controller.ControllerError;
import com.neeve.controller.Deploy;
import com.neeve.controller.Instruct;
import com.neeve.controller.Launch;
import com.neeve.controller.ProgressMonitor;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Provision;
import com.neeve.controller.Shutdown;
import com.neeve.controller.Sleep;
import com.neeve.controller.Start;
import com.neeve.controller.Stop;
import com.neeve.controller.System;
import com.neeve.controller.Validate;
import com.neeve.controller.Wait;
import com.neeve.server.mon.cnc.SrvMonArgumentType;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTailoring;
import com.neeve.util.UtlText;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Script {
    private final Controller _controller;
    private final System _system;
    private final List<Command> _commands = new ArrayList<Command>();
    private final ProgressMonitorHelper _progressMonitorHelper;
    private final boolean _scriptParseDebug;
    private int _current = -1;
    private boolean _abort;
    private boolean _done;
    private String _runId;
    private String _displayName;
    private String _description;
    private Map<String, ParameterMetadata> _parameterMetadata = new HashMap<String, ParameterMetadata>();

    Script(Controller controller, System system, ProgressMonitor progressMonitor) throws Exception {
        if (controller == null) {
            throw new IllegalArgumentException("controller cannot be null");
        }
        if (system == null) {
            throw new IllegalArgumentException("system cannot be null");
        }
        this._controller = controller;
        this._system = system;
        this._progressMonitorHelper = new ProgressMonitorHelper(controller, progressMonitor);
        this._scriptParseDebug = UtlProps.getValue((Properties)this._controller.getConfig(), (String)"nv.controller.debugscriptparsing", (boolean)false);
    }

    private final Command createCommand(String commandStr, int lineNum, String line) {
        if (commandStr.equalsIgnoreCase("assume")) {
            return new Assume(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("provision")) {
            return new Provision(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("configure")) {
            return new Configure(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("deploy")) {
            return new Deploy(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("launch")) {
            return new Launch(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("start")) {
            return new Start(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("stop")) {
            return new Stop(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("instruct")) {
            return new Instruct(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("wait")) {
            return new Wait(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("validate")) {
            return new Validate(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("sleep")) {
            return new Sleep(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("collect")) {
            return new Collect(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("shutdown")) {
            return new Shutdown(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        if (commandStr.equalsIgnoreCase("cleanup")) {
            return new Cleanup(this._controller, this._progressMonitorHelper, this._system, this, lineNum, line);
        }
        return null;
    }

    private final void execute(int numCommands, String runId) {
        try {
            this._progressMonitorHelper.info("");
            this._progressMonitorHelper.info("Script execute (runId=" + runId + ")");
            int i = this._current + 1;
            while (i < this._commands.size() && (numCommands < 0 || numCommands-- > 0)) {
                if (this._abort) {
                    this.abortNow();
                }
                Command cmd = this._commands.get(i);
                this._progressMonitorHelper.info("..." + cmd.lineNum() + ":" + cmd.line() + (cmd.mock() ? " (previously run)" : "") + "...");
                cmd.execute();
                this._current = i++;
            }
            this._progressMonitorHelper.info("Done.\n");
        }
        catch (ControllerError e) {
            throw e;
        }
        catch (Throwable e) {
            this._progressMonitorHelper.error("Failure encountered while executing the script file [" + e.toString() + "]", e);
        }
    }

    final void abortNow() {
        this._progressMonitorHelper.troubleshootingSevere("ERROR: aborted");
        throw new AbortedError();
    }

    final void parse(File scriptFile, UtlTailoring.PropertySource primaryParameterResolver, boolean mock) {
        this.parse(scriptFile, primaryParameterResolver, mock, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void parse(File scriptFile, UtlTailoring.PropertySource primaryParameterResolver, boolean mock, boolean fromAssume) {
        ParameterResolver parameterResolver = new ParameterResolver(primaryParameterResolver);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(scriptFile));
            try {
                String line;
                int lineNum = 0;
                if (this._scriptParseDebug) {
                    this._progressMonitorHelper.info("");
                }
                if (this._scriptParseDebug) {
                    this._progressMonitorHelper.info("Script parse");
                }
                while ((line = reader.readLine()) != null) {
                    if (this._abort) {
                        this.abortNow();
                    }
                    ++lineNum;
                    if (!(line = line.trim()).startsWith("//") && !line.startsWith("#")) {
                        this.extractScriptParams(line, parameterResolver);
                        line = UtlTailoring.substitute((String)line, (UtlTailoring.PropertySource)parameterResolver);
                        if (line.length() > 0) {
                            if (this._scriptParseDebug) {
                                this._progressMonitorHelper.info("..." + lineNum + ":" + line + "...");
                            }
                            this.parseCommandLine(line, lineNum, mock);
                        }
                    }
                    if (!fromAssume && line.startsWith("##DISPLAYNAME")) {
                        this._displayName = line.substring("##DISPLAYNAME".length()).trim();
                        continue;
                    }
                    if (!fromAssume && line.startsWith("##DESCRIPTION")) {
                        this._description = line.substring("##DESCRIPTION".length()).trim();
                        continue;
                    }
                    if (!line.startsWith("##VAR")) continue;
                    this.parseVarMetadata(line.substring("##VAR".length()).trim(), lineNum, parameterResolver);
                }
            }
            catch (ControllerError e) {
                throw e;
            }
            catch (Throwable e) {
                this._progressMonitorHelper.error("Failure encountered while parsing the script file '" + scriptFile.getAbsolutePath() + "' [" + e.toString() + "]", e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            this._progressMonitorHelper.error("Script file '" + scriptFile.getAbsolutePath() + "' does not exist.");
        }
    }

    private void parseVarMetadata(String commandLine, int lineNum, ParameterResolver parameterResolver) {
        try {
            HashMap<String, String> variableProperties = new HashMap<String, String>();
            int propOpenBracket = commandLine.indexOf("[");
            if (propOpenBracket != -1) {
                variableProperties.put("name", commandLine.substring(0, propOpenBracket).trim());
                int propCloseBracket = commandLine.lastIndexOf("]");
                String csvProps = commandLine.substring(propOpenBracket + 1, propCloseBracket).trim();
                ArrayList<String> props = new ArrayList<String>();
                Script.tokenizeCsvString(csvProps, ',', props);
                for (String pair : props) {
                    int eq = pair.indexOf("=");
                    if (eq == -1) {
                        throw new Exception("Expect comma separated key=value properties, but was '" + pair + "'");
                    }
                    String propName = pair.substring(0, eq).trim();
                    String value = pair.substring(eq + 1).trim();
                    variableProperties.put(propName, value);
                }
            } else {
                variableProperties.put("name", commandLine.trim());
            }
            String name = (String)variableProperties.get("name");
            ParameterMetadata param = this._parameterMetadata.get(variableProperties.get(name));
            if (param == null) {
                param = new ParameterMetadata();
                this._parameterMetadata.put(name, param);
            }
            if (!variableProperties.containsKey("displayName") && param.getDisplayName() == null) {
                variableProperties.put("displayName", UtlText.deCamelCase((String)name));
            }
            for (Map.Entry entry : variableProperties.entrySet()) {
                if (((String)entry.getKey()).equals("validValues")) {
                    ArrayList<String> validValues = new ArrayList<String>();
                    Script.tokenizeCsvString((String)entry.getValue(), ',', validValues);
                    param.setValidValues(validValues.toArray(new String[0]));
                    continue;
                }
                UtlReflection.setNonNestedProperty((Object)param, (String)((String)entry.getKey()), entry.getValue());
            }
            param.setDefaultValue(parameterResolver.getValue(name, param.getDefaultValue()));
        }
        catch (Throwable thrown) {
            this._progressMonitorHelper.error("Error parsing script parameter variable '" + commandLine + "' (line " + lineNum + ") [" + thrown.getMessage() + "]", thrown);
        }
    }

    private static void tokenizeCsvString(String s, char delimiter, List<String> tokens) throws ParseException {
        int pos = 0;
        boolean inQuote = false;
        boolean inEscape = false;
        String token = "";
        while (pos < s.length()) {
            char c = s.charAt(pos);
            if (inQuote) {
                if (inEscape) {
                    inEscape = false;
                    token = token + c;
                    ++pos;
                    continue;
                }
                if (c == '\"') {
                    inQuote = false;
                    ++pos;
                    continue;
                }
                if (c == '\\') {
                    inEscape = true;
                    ++pos;
                    continue;
                }
                if (c == ',') {
                    token = token + c;
                    ++pos;
                    continue;
                }
            } else if (c == '\"') {
                inQuote = true;
                ++pos;
                continue;
            }
            if (c == ',') {
                tokens.add(token);
                ++pos;
                token = "";
                continue;
            }
            token = token + c;
            ++pos;
        }
        if (token.length() > 0) {
            if (inQuote) {
                throw new ParseException("Unbalanced quote around '" + token + "'", s.length() - token.length());
            }
            if (inEscape) {
                throw new ParseException("Incomplete escape sequence around '" + token + "'", s.length() - token.length());
            }
            tokens.add(token);
        }
    }

    private void extractScriptParams(String commandLine, UtlTailoring.PropertySource paramResolver) {
        int pos = 0;
        while (pos < commandLine.length() && (pos = commandLine.indexOf("${", pos)) != -1) {
            ParameterMetadata param;
            String defaultValue;
            String name;
            int defaultDelimiterPos = commandLine.indexOf("::", pos += 2);
            int endPos = commandLine.indexOf(125, pos);
            if (defaultDelimiterPos != -1 && defaultDelimiterPos < endPos) {
                if (endPos != -1) {
                    name = commandLine.substring(pos, defaultDelimiterPos);
                    defaultValue = commandLine.substring(defaultDelimiterPos + 2, endPos);
                    param = this._parameterMetadata.get(name);
                    if (param == null) {
                        param = new ParameterMetadata();
                        param.setName(name);
                        param.setType(SrvMonArgumentType.STRING);
                        param.setDisplayName(UtlText.deCamelCase((String)name));
                        this._parameterMetadata.put(name, param);
                    }
                    param.setDefaultValue(paramResolver.getValue(name, defaultValue));
                    pos = endPos + 1;
                    continue;
                }
                ++pos;
                continue;
            }
            if (endPos != -1) {
                name = commandLine.substring(pos, endPos);
                defaultValue = null;
                param = this._parameterMetadata.get(name);
                if (param == null) {
                    param = new ParameterMetadata();
                    param.setName(name);
                    param.setType(SrvMonArgumentType.STRING);
                    param.setDisplayName(UtlText.deCamelCase((String)name));
                    this._parameterMetadata.put(name, param);
                }
                param.setDefaultValue(paramResolver.getValue(name, defaultValue));
                pos = endPos + 1;
                continue;
            }
            ++pos;
        }
    }

    public final List<Command> commands() {
        return this._commands;
    }

    public final int current() {
        return this._current + 1;
    }

    public final void rewind() {
        this._current = -1;
    }

    public final void clear() {
        this._commands.clear();
        this._current = -1;
        if (this._system.isConfigStale()) {
            try {
                this._system.configure(true);
            }
            catch (Exception e) {
                this._progressMonitorHelper.error("Error (re) configuring '" + this._system.getName() + "'.", e);
            }
        }
    }

    public final void truncate(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("pos must be >= 0");
        }
        for (int i = pos; i < this._commands.size(); ++i) {
            this._commands.remove(i);
        }
        this._current = Math.min(this._current, this._commands.size() - 1);
    }

    public final Script parseCommandLine(String line, int lineNum, boolean mock) {
        String[] parsed = UtlText.parseAsArgs((String)line, (boolean)false);
        if (parsed.length > 0) {
            Command.Args args = new Command.Args(parsed, 0);
            String commandStr = args.nextToken();
            Command command = this.createCommand(commandStr, lineNum >= 0 ? lineNum : (this._commands.size() > 0 ? this._commands.get(this._commands.size() - 1).lineNum() + 1 : 0), line);
            if (command != null) {
                if (command.mock(mock).parse(args)) {
                    this._commands.add(command);
                }
            } else {
                this._progressMonitorHelper.error("Line " + lineNum + ": Unknown script command '" + commandStr + "'.");
            }
        }
        return this;
    }

    public final Script parseFromFile(String scriptFilename, UtlTailoring.PropertySource primaryParameterResolver) throws IOException {
        File scriptFile = this._system.getScriptFile(scriptFilename);
        if (!scriptFile.exists()) {
            this._progressMonitorHelper.error("Script '" + scriptFile.getAbsolutePath() + "' does not exist.");
        }
        this._runId = UtlProps.getValue((Properties)this._controller.getConfig(), (String)"nv.controller.run.id", (String)new SimpleDateFormat("MM-dd-yyyy_hh-mm-ss").format(new Date(java.lang.System.currentTimeMillis())));
        if (this._scriptParseDebug) {
            this._progressMonitorHelper.info("Script=" + scriptFile.getAbsolutePath() + " [runId = " + this._runId + "]");
        }
        this._commands.clear();
        this.parse(scriptFile, primaryParameterResolver, false);
        return this;
    }

    public final Script parseFromFile(String scriptFilename, String commaDelimitedKeyValuePairs) throws IOException {
        if (commaDelimitedKeyValuePairs == null || commaDelimitedKeyValuePairs.equalsIgnoreCase("null")) {
            return this.parseFromFile(scriptFilename);
        }
        Properties props = new Properties();
        StringTokenizer tokenizer = new StringTokenizer(commaDelimitedKeyValuePairs, ",");
        while (tokenizer.hasMoreTokens()) {
            String keyValuePair = tokenizer.nextToken().trim();
            int idx = keyValuePair.indexOf(61);
            if (idx > 0 && idx < keyValuePair.length() - 1) {
                String key = keyValuePair.substring(0, idx).trim();
                String value = keyValuePair.substring(idx + 1).trim();
                props.setProperty(key, value);
                continue;
            }
            throw new IllegalArgumentException("'" + keyValuePair + "' is not a valid key value pair (must be of the form key=value)");
        }
        return this.parseFromFile(scriptFilename, new PropertiesPropSource(props));
    }

    public final Script parseFromFile(String scriptFilename) throws IOException {
        return this.parseFromFile(scriptFilename, (UtlTailoring.PropertySource)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(int numCommands) {
        this._done = false;
        try {
            this.execute(numCommands, this._runId);
        }
        catch (AbortedError e) {
            this.cleanup();
            this._progressMonitorHelper.warning("Aborted.");
        }
        catch (ControllerError e) {
            this.cleanup();
            throw e;
        }
        finally {
            Script e = this;
            synchronized (e) {
                this._done = true;
                this.notifyAll();
            }
        }
    }

    public final void run() {
        this.run(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort() {
        Script script = this;
        synchronized (script) {
            this._progressMonitorHelper.warning("Aborting...");
            this._abort = true;
            while (!this._done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public final boolean aborted() {
        return this._abort;
    }

    public final void cleanup() {
        this._progressMonitorHelper.info("...0:cleanup...");
        new Cleanup(this._controller, this._progressMonitorHelper, this._system, this, 0, "cleanup").execute();
    }

    public String getRunId() {
        return this._runId;
    }

    public final String getDisplayName() {
        return this._displayName;
    }

    public final void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public final String getDescription() {
        return this._description;
    }

    public final void setDescription(String description) {
        this._description = description;
    }

    public final Map<String, ParameterMetadata> getScriptParameterMetadata() {
        return Collections.unmodifiableMap(this._parameterMetadata);
    }

    public static final class ParameterMetadata {
        String name;
        String displayName;
        String description;
        String defaultValue;
        String[] validValues;
        SrvMonArgumentType type;

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String[] getValidValues() {
            return this.validValues;
        }

        public final void setValidValues(String ... validValues) {
            this.validValues = validValues;
        }

        public final SrvMonArgumentType getType() {
            return this.type;
        }

        public final void setType(SrvMonArgumentType type) {
            this.type = type;
        }

        public void appendUsage(Appendable out) {
            try {
                out.append(this.name);
                boolean first = true;
                if (this.displayName != null) {
                    first = this.delim(out, first);
                    out.append("displayName=\"").append(this.displayName).append("\"");
                }
                if (this.type != null) {
                    first = this.delim(out, first);
                    out.append("type=\"").append(this.type.name()).append("\"");
                }
                if (this.validValues != null && this.validValues.length > 0) {
                    first = this.delim(out, first);
                    out.append("validValues=").append(Arrays.asList(this.validValues).toString());
                }
                if (this.description != null) {
                    first = this.delim(out, first);
                    out.append("description=\"").append(this.description).append("\"");
                }
                if (this.defaultValue != null) {
                    first = this.delim(out, first);
                    out.append("defaul=\"").append(this.defaultValue).append("\"");
                }
                if (!first) {
                    out.append("]");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error appending usage: " + e.getMessage(), e);
            }
        }

        private final boolean delim(Appendable out, boolean first) throws IOException {
            if (first) {
                out.append(" [");
            } else {
                out.append(", ");
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendUsage(sb);
            return sb.toString();
        }
    }

    private final class ParameterResolver
    implements UtlTailoring.PropertySource {
        final UtlTailoring.PropertySource resolver;

        ParameterResolver(UtlTailoring.PropertySource resolver) {
            this.resolver = resolver;
        }

        public final String getValue(String key, String defValue) {
            String value;
            String string = value = this.resolver != null ? this.resolver.getValue(key, null) : null;
            if (value == null) {
                try {
                    value = Script.this._controller.getConfig().getProperty(key);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return value == null ? defValue : value;
        }
    }

    private final class PropertiesPropSource
    implements UtlTailoring.PropertySource {
        final Properties props;

        PropertiesPropSource(Properties props) {
            this.props = props;
        }

        public final String getValue(String key, String defaultValue) {
            return this.props.getProperty(key, defaultValue);
        }
    }
}

