/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.controller.util.ProcessHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

final class Provision
extends Command {
    private String _sshUser;
    private String _sshKeyFile;
    private File _distribution;
    private XVM _xvm;

    Provision(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: provision all xvms | the <xvmName> xvm");
    }

    private final ProcessBuilder createProvisioner() {
        if (!(this._xvm.host().equals(".") || this._sshUser != null && this._sshKeyFile != null)) {
            this.error("ssh user and key file needs to be provided for remote execution");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.resolveScript("rucprep"));
        command.add(this._xvm.host().equals(".") ? "sh" : "ssh");
        command.add((this._distribution.getParent() == null ? new File(".") : this._distribution.getParentFile()).getAbsolutePath());
        command.add(this._distribution.getName());
        command.add(this._xvm.runDir());
        if (!this._xvm.host().equals(".")) {
            command.add(this._sshUser + "@" + this._xvm.host());
            command.add(this._sshKeyFile);
            command.add(String.valueOf(this._xvm.sshPort()));
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        ProcessHelper.cleanEnvironment(pb.environment());
        return pb;
    }

    @Override
    final String name() {
        return "provision";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        String token;
        this._sshUser = this.getSshUser();
        this._sshKeyFile = this.getSshKeyFile();
        this._distribution = this.getDistribution();
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        if ((token = tokenizer.nextToken()).equals("the")) {
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            token = tokenizer.nextToken();
            this._xvm = this.system().getXVM(token);
            if (this._xvm == null) {
                this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
            }
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
                this.syntaxError(this.lineNum());
            }
        } else if (token.equals("all")) {
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvms")) {
                this.syntaxError(this.lineNum());
            }
        } else {
            this.syntaxError(this.lineNum());
        }
        return true;
    }

    @Override
    final void execute() {
        try {
            if (this._xvm == null) {
                Iterator<XVM> iterator = this.system().getXVMs().iterator();
                while (iterator.hasNext()) {
                    XVM xvm;
                    this._xvm = xvm = iterator.next();
                    this.execute();
                }
                return;
            }
            if (!this.mock()) {
                String line;
                this.info("......provisioning '" + this._xvm.name() + "' ('" + this._xvm.toString() + "')...");
                ProcessBuilder pb = this.createProvisioner();
                Process process = pb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    this.troubleshootingInfo(line);
                    sb.append(line).append("\n");
                }
                while (true) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                if (process.exitValue() != 0) {
                    this.error("Provision failed [exit code '" + process.exitValue() + "']:\n" + sb);
                }
            }
            this._xvm.provisioned(true);
        }
        catch (Exception e) {
            this.error("Provision failed [" + e.toString() + "]", e);
        }
    }

    @Override
    final void cleanup() {
    }
}

