/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.controller.XVMUnreachableException;
import com.neeve.util.UtlText;

final class Instruct
extends Command {
    private String _appName;
    private XVM _xvm;
    private String _command;
    private String _args;

    Instruct(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: instruct the <appName> app in the <xvmName> xvm to <command> [with <params>]");
    }

    @Override
    final String name() {
        return "instruct";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._appName = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("app")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("in")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        String token = tokenizer.nextToken();
        this._xvm = this.system().getXVM(token);
        if (this._xvm == null) {
            this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("to")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._command = tokenizer.nextToken();
        int index = 0;
        String[] remainingArgs = this.getRemainingArgs(tokenizer);
        if (index < remainingArgs.length && !"with".equalsIgnoreCase(remainingArgs[index++])) {
            this.syntaxError(this.lineNum());
        }
        if (index < remainingArgs.length) {
            StringBuilder sb = new StringBuilder();
            while (index < remainingArgs.length) {
                sb.append(UtlText.quoteAndEscape((String)remainingArgs[index++]));
                if (index >= remainingArgs.length) continue;
                sb.append(" ");
            }
            this._args = sb.toString();
        } else {
            this._args = "null";
        }
        return true;
    }

    @Override
    final void execute() {
        if (!this.mock()) {
            try {
                Object result = this.remoteCommand(this._xvm.name(), this._appName, this._args.equalsIgnoreCase("null") ? this._command : this._command + " " + this._args, true, 5);
                this.troubleshootingInfo("...completed (response: " + result + ")");
            }
            catch (Exception e) {
                if (e instanceof XVMUnreachableException && this.isTreatUnreachableXVMAsNonFatal()) {
                    this.info("......xvm '" + this._xvm.name() + "' is unreachable. configured to ignore...");
                }
                this.error("Line " + this.lineNum() + ": Failed to execute command [" + e.toString() + "].", e);
            }
        }
    }

    @Override
    final void cleanup() {
    }
}

