/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import java.io.File;
import java.io.PrintWriter;
import java.util.StringTokenizer;

final class Collect
extends Command {
    private String _command;
    private String _appName;
    private XVM _xvm;
    private File _resultsDir;

    Collect(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: collect <command> from the <appName> app in the <xvmName> xvm record as <identifier>");
    }

    @Override
    final String name() {
        return "collect";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._command = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("from")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._appName = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("app")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("in")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        String token = tokenizer.nextToken();
        this._xvm = this.system().getXVM(token);
        if (this._xvm == null) {
            this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("record")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("as")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._resultsDir = this.system().getResultsDir(this.script(), tokenizer.nextToken());
        if (this._resultsDir.exists()) {
            this.error("Line " + this.lineNum() + ": Results directory '" + this._resultsDir + " already exists. Delete the existing directory or use a different run id (nv.controller.run.id).");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void execute() {
        if (!this.mock()) {
            try {
                this._resultsDir.mkdirs();
                String result = (String)this.remoteCommand(this._xvm.name(), this._appName, this._command, true, 1);
                StringTokenizer tokenizer1 = new StringTokenizer(result.trim(), "|");
                while (tokenizer1.hasMoreTokens()) {
                    String token = tokenizer1.nextToken();
                    StringTokenizer tokenizer2 = new StringTokenizer(token, "^");
                    try (PrintWriter resultWriter = new PrintWriter(this._resultsDir.getAbsolutePath() + File.separator + tokenizer2.nextToken());){
                        resultWriter.println(tokenizer2.hasMoreTokens() ? tokenizer2.nextToken() : "");
                    }
                }
            }
            catch (Exception e) {
                this.error("Line " + this.lineNum() + ": Failed to collect stats [" + e.toString() + "].", e);
            }
        }
    }

    @Override
    final void cleanup() {
    }
}

