/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.build;

import com.neeve.util.UtlFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;

public final class Packager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void archive(File root, String source, TarArchiveOutputStream out) throws Exception {
        File sourceFile = source == null ? root : new File(root + "/" + source);
        File[] files = sourceFile.listFiles();
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                String relativeFilename;
                String string = relativeFilename = source == null ? files[i].getName() : source + '/' + files[i].getName();
                if (files[i].isDirectory()) {
                    Packager.archive(root, relativeFilename, out);
                    continue;
                }
                TarArchiveEntry archiveEntry = new TarArchiveEntry(files[i], relativeFilename);
                archiveEntry.setSize(files[i].length());
                out.putArchiveEntry((ArchiveEntry)archiveEntry);
                try {
                    FileInputStream in = new FileInputStream(files[i]);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        continue;
                    }
                    finally {
                        out.flush();
                        in.close();
                    }
                }
                finally {
                    out.closeArchiveEntry();
                }
            }
        } else if (source != null) {
            out.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(sourceFile, source));
            out.closeArchiveEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void archive(File sourceDir, File target) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)bos);
        tar.setLongFileMode(2);
        try {
            Packager.archive(sourceDir, null, tar);
        }
        catch (Exception e) {
            throw new IOException("Error creating archive [" + e.getMessage() + "]", e);
        }
        tar.close();
        try {
            CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)new FileOutputStream(target));
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            try {
                IOUtils.copy((InputStream)bis, (OutputStream)cos);
            }
            finally {
                bis.close();
                cos.close();
            }
        }
        catch (CompressorException e) {
            throw new IOException("Error compressing xar: " + e.getMessage(), e);
        }
    }

    public static File extract(File source, File targetDir) throws IOException {
        return Packager.extract(source, targetDir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extract(File source, File targetDir, boolean verbose) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            CompressorInputStream cis = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)new FileInputStream(source));
            try {
                IOUtils.copy((InputStream)cis, (OutputStream)bos);
            }
            finally {
                bos.close();
                cis.close();
            }
        }
        catch (CompressorException e) {
            throw new IOException("Error decompressing xar: " + e.getMessage(), e);
        }
        TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        targetDir.mkdirs();
        try {
            TarArchiveEntry tarEntry = tis.getNextTarEntry();
            while (tarEntry != null) {
                File destPath = new File(targetDir, tarEntry.getName());
                if (tarEntry.isDirectory()) {
                    destPath.mkdirs();
                } else {
                    if (!destPath.getParentFile().exists()) {
                        destPath.getParentFile().mkdirs();
                    }
                    if (!destPath.exists()) {
                        destPath.createNewFile();
                    }
                    try (BufferedOutputStream entryOut = new BufferedOutputStream(new FileOutputStream(destPath, false));){
                        IOUtils.copy((InputStream)tis, (OutputStream)entryOut);
                    }
                    if (verbose) {
                        System.out.println(destPath + " [" + UtlFile.readableFileSize((long)destPath.length()) + "]");
                    }
                }
                tarEntry = tis.getNextTarEntry();
            }
        }
        finally {
            tis.close();
        }
        return targetDir;
    }
}

