/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.equinix;

import com.neeve.cloud.equinix.EquinixClient;
import com.neeve.cloud.equinix.messages.CreateNetworkRequestMessage;
import com.neeve.cloud.equinix.messages.CreateNetworkResponseMessage;
import com.neeve.cloud.equinix.messages.DeleteNetworkResponseMessage;
import com.neeve.cloud.equinix.messages.GetNetworksRequestMessage;
import com.neeve.cloud.equinix.messages.GetNetworksResponseMessage;
import com.neeve.trace.Tracer;

public final class EquinixProvisioner {
    private final Tracer tracer = Tracer.get((String)"nv.cloud");
    private final EquinixClient client = new EquinixClient();

    private EquinixProvisioner() {
    }

    public static EquinixProvisioner create() {
        return new EquinixProvisioner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getNetworks(String apiKey, String projectId, String metro) {
        GetNetworksRequestMessage request = GetNetworksRequestMessage.create();
        request.setMetro(metro);
        try {
            String string;
            GetNetworksResponseMessage response = this.client.getNetworks(apiKey, projectId, request, this.tracer);
            try {
                string = response.serializeToJson();
                response.dispose();
            }
            catch (Throwable throwable) {
                response.dispose();
                throw throwable;
            }
            return string;
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String createNetwork(String apiKey, String projectId, String metro, String description, String[] tags) {
        CreateNetworkRequestMessage request = CreateNetworkRequestMessage.create();
        request.setMetro(metro);
        request.setDescription(description);
        if (tags != null) {
            request.setTags(tags);
        }
        try {
            String string;
            CreateNetworkResponseMessage response = this.client.createNetwork(apiKey, projectId, request, this.tracer);
            try {
                string = response.serializeToJson();
                response.dispose();
            }
            catch (Throwable throwable) {
                response.dispose();
                throw throwable;
            }
            return string;
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String deleteNetwork(String apiKey, String id) {
        DeleteNetworkResponseMessage response = this.client.deleteNetwork(apiKey, id, this.tracer);
        try {
            String string = response.serializeToJson();
            return string;
        }
        finally {
            response.dispose();
        }
    }
}

