/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.civo;

import com.neeve.cloud.civo.CivoHttpClient;
import com.neeve.cloud.civo.CivoRequestType;
import com.neeve.cloud.civo.messages.CreateFirewallRequestMessage;
import com.neeve.cloud.civo.messages.CreateFirewallResponseMessage;
import com.neeve.cloud.civo.messages.CreateFirewallRuleRequestMessage;
import com.neeve.cloud.civo.messages.CreateFirewallRuleResponseMessage;
import com.neeve.cloud.civo.messages.CreateInstanceRequestMessage;
import com.neeve.cloud.civo.messages.CreateInstanceResponseMessage;
import com.neeve.cloud.civo.messages.CreateNetworkRequestMessage;
import com.neeve.cloud.civo.messages.CreateNetworkResponseMessage;
import com.neeve.cloud.civo.messages.DeleteFirewallRequestMessage;
import com.neeve.cloud.civo.messages.DeleteFirewallResponseMessage;
import com.neeve.cloud.civo.messages.DeleteFirewallRuleRequestMessage;
import com.neeve.cloud.civo.messages.DeleteFirewallRuleResponseMessage;
import com.neeve.cloud.civo.messages.DeleteInstanceRequestMessage;
import com.neeve.cloud.civo.messages.DeleteInstanceResponseMessage;
import com.neeve.cloud.civo.messages.DeleteNetworkRequestMessage;
import com.neeve.cloud.civo.messages.DeleteNetworkResponseMessage;
import com.neeve.cloud.civo.messages.GetDiskImagesResponseMessage;
import com.neeve.cloud.civo.messages.GetFirewallRulesRequestMessage;
import com.neeve.cloud.civo.messages.GetFirewallRulesResponseMessage;
import com.neeve.cloud.civo.messages.GetFirewallsRequestMessage;
import com.neeve.cloud.civo.messages.GetFirewallsResponseMessage;
import com.neeve.cloud.civo.messages.GetInstanceRequestMessage;
import com.neeve.cloud.civo.messages.GetInstanceResponseMessage;
import com.neeve.cloud.civo.messages.GetInstanceSizesResponseMessage;
import com.neeve.cloud.civo.messages.GetInstancesRequestMessage;
import com.neeve.cloud.civo.messages.GetInstancesResponseMessage;
import com.neeve.cloud.civo.messages.GetNetworksRequestMessage;
import com.neeve.cloud.civo.messages.GetNetworksResponseMessage;
import com.neeve.cloud.civo.messages.GetSSHKeysResponseMessage;
import com.neeve.cloud.civo.messages.StartInstanceRequestMessage;
import com.neeve.cloud.civo.messages.StartInstanceResponseMessage;
import com.neeve.cloud.civo.messages.StopInstanceRequestMessage;
import com.neeve.cloud.civo.messages.StopInstanceResponseMessage;
import com.neeve.cloud.util.HttpClient;
import com.neeve.trace.Tracer;

final class CivoClient
extends CivoHttpClient {
    private final String GET_SSHKEYS_URL;
    private final String CREATE_NETWORK_URL;
    private final String GET_NETWORKS_URL;
    private final String DELETE_NETWORK_URL;
    private final String CREATE_FIREWALL_URL;
    private final String CREATE_FIREWALL_RULE_URL;
    private final String GET_FIREWALL_RULES_URL;
    private final String DELETE_FIREWALL_RULE_URL;
    private final String GET_FIREWALLS_URL;
    private final String DELETE_FIREWALL_URL;
    private final String GET_DISKIMAGES_URL;
    private final String GET_INSTANCESIZES_URL;
    private final String CREATE_INSTANCE_URL;
    private final String START_INSTANCE_URL;
    private final String STOP_INSTANCE_URL;
    private final String GET_INSTANCE_URL;
    private final String GET_INSTANCES_URL;
    private final String DELETE_INSTANCE_URL;

    CivoClient() {
        this.GET_SSHKEYS_URL = this.CIVO_BASE_URL + "/sshkeys";
        this.CREATE_NETWORK_URL = this.CIVO_BASE_URL + "/networks";
        this.GET_NETWORKS_URL = this.CIVO_BASE_URL + "/networks";
        this.DELETE_NETWORK_URL = this.CIVO_BASE_URL + "/networks";
        this.CREATE_FIREWALL_URL = this.CIVO_BASE_URL + "/firewalls";
        this.CREATE_FIREWALL_RULE_URL = this.CIVO_BASE_URL + "/firewalls/%s/rules";
        this.GET_FIREWALL_RULES_URL = this.CIVO_BASE_URL + "/firewalls/%s/rules";
        this.DELETE_FIREWALL_RULE_URL = this.CIVO_BASE_URL + "/firewalls/%s/rules/%s";
        this.GET_FIREWALLS_URL = this.CIVO_BASE_URL + "/firewalls";
        this.DELETE_FIREWALL_URL = this.CIVO_BASE_URL + "/firewalls";
        this.GET_DISKIMAGES_URL = this.CIVO_BASE_URL + "/disk_images";
        this.GET_INSTANCESIZES_URL = this.CIVO_BASE_URL + "/sizes";
        this.CREATE_INSTANCE_URL = this.CIVO_BASE_URL + "/instances";
        this.START_INSTANCE_URL = this.CIVO_BASE_URL + "/instances/%s/start";
        this.STOP_INSTANCE_URL = this.CIVO_BASE_URL + "/instances/%s/stop";
        this.GET_INSTANCE_URL = this.CIVO_BASE_URL + "/instances";
        this.GET_INSTANCES_URL = this.CIVO_BASE_URL + "/instances";
        this.DELETE_INSTANCE_URL = this.CIVO_BASE_URL + "/instances";
    }

    final GetSSHKeysResponseMessage getSSHKeys(String apiKey, Tracer tracer) {
        return (GetSSHKeysResponseMessage)this.executeRequest(this.GET_SSHKEYS_URL, CivoRequestType.GetSSHKeys, HttpClient.HttpMethod.GET, null, apiKey, tracer);
    }

    final CreateNetworkResponseMessage createNetwork(String apiKey, CreateNetworkRequestMessage request, Tracer tracer) {
        return (CreateNetworkResponseMessage)this.executeRequest(this.CREATE_NETWORK_URL, CivoRequestType.CreateNetwork, HttpClient.HttpMethod.POST, request, apiKey, tracer);
    }

    final GetNetworksResponseMessage getNetworks(String apiKey, GetNetworksRequestMessage request, Tracer tracer) {
        return (GetNetworksResponseMessage)this.executeRequest(this.GET_NETWORKS_URL, CivoRequestType.GetNetworks, HttpClient.HttpMethod.GET, request, apiKey, tracer);
    }

    final DeleteNetworkResponseMessage deleteNetwork(String apiKey, DeleteNetworkRequestMessage request, Tracer tracer) {
        return (DeleteNetworkResponseMessage)this.executeRequest(this.DELETE_NETWORK_URL + "/" + request.getId(), CivoRequestType.DeleteNetwork, HttpClient.HttpMethod.DELETE, request, apiKey, tracer);
    }

    final CreateFirewallResponseMessage createFirewall(String apiKey, CreateFirewallRequestMessage request, Tracer tracer) {
        return (CreateFirewallResponseMessage)this.executeRequest(this.CREATE_FIREWALL_URL, CivoRequestType.CreateFirewall, HttpClient.HttpMethod.POST, request, apiKey, tracer);
    }

    final CreateFirewallRuleResponseMessage createFirewallRule(String apiKey, String firewallId, CreateFirewallRuleRequestMessage request, Tracer tracer) {
        return (CreateFirewallRuleResponseMessage)this.executeRequest(String.format(this.CREATE_FIREWALL_RULE_URL, firewallId), CivoRequestType.CreateFirewallRule, HttpClient.HttpMethod.POST, request, apiKey, tracer);
    }

    final GetFirewallRulesResponseMessage getFirewallRules(String apiKey, GetFirewallRulesRequestMessage request, Tracer tracer) {
        return (GetFirewallRulesResponseMessage)this.executeRequest(String.format(this.GET_FIREWALL_RULES_URL, request.getFirewallId()), CivoRequestType.GetFirewallRules, HttpClient.HttpMethod.GET, request, apiKey, tracer);
    }

    final DeleteFirewallRuleResponseMessage deleteFirewallRule(String apiKey, DeleteFirewallRuleRequestMessage request, Tracer tracer) {
        return (DeleteFirewallRuleResponseMessage)this.executeRequest(String.format(this.DELETE_FIREWALL_RULE_URL, request.getFirewallId(), request.getId()), CivoRequestType.DeleteFirewallRule, HttpClient.HttpMethod.DELETE, request, apiKey, tracer);
    }

    final GetFirewallsResponseMessage getFirewalls(String apiKey, GetFirewallsRequestMessage request, Tracer tracer) {
        return (GetFirewallsResponseMessage)this.executeRequest(this.GET_FIREWALLS_URL, CivoRequestType.GetFirewalls, HttpClient.HttpMethod.GET, request, apiKey, tracer);
    }

    final DeleteFirewallResponseMessage deleteFirewall(String apiKey, DeleteFirewallRequestMessage request, Tracer tracer) {
        return (DeleteFirewallResponseMessage)this.executeRequest(this.DELETE_FIREWALL_URL + "/" + request.getId(), CivoRequestType.DeleteFirewall, HttpClient.HttpMethod.DELETE, request, apiKey, tracer);
    }

    final GetDiskImagesResponseMessage getDiskImages(String apiKey, Tracer tracer) {
        return (GetDiskImagesResponseMessage)this.executeRequest(this.GET_DISKIMAGES_URL, CivoRequestType.GetDiskImages, HttpClient.HttpMethod.GET, null, apiKey, tracer);
    }

    final GetInstanceSizesResponseMessage getInstanceSizes(String apiKey, Tracer tracer) {
        return (GetInstanceSizesResponseMessage)this.executeRequest(this.GET_INSTANCESIZES_URL, CivoRequestType.GetInstanceSizes, HttpClient.HttpMethod.GET, null, apiKey, tracer);
    }

    final CreateInstanceResponseMessage createInstance(String apiKey, CreateInstanceRequestMessage request, Tracer tracer) {
        return (CreateInstanceResponseMessage)this.executeRequest(this.CREATE_INSTANCE_URL, CivoRequestType.CreateInstance, HttpClient.HttpMethod.POST, request, apiKey, tracer);
    }

    final StartInstanceResponseMessage startInstance(String apiKey, StartInstanceRequestMessage request, Tracer tracer) {
        return (StartInstanceResponseMessage)this.executeRequest(String.format(this.START_INSTANCE_URL, request.getId()), CivoRequestType.StartInstance, HttpClient.HttpMethod.PUT, request, apiKey, tracer);
    }

    final StopInstanceResponseMessage stopInstance(String apiKey, StopInstanceRequestMessage request, Tracer tracer) {
        return (StopInstanceResponseMessage)this.executeRequest(String.format(this.STOP_INSTANCE_URL, request.getId()), CivoRequestType.StopInstance, HttpClient.HttpMethod.PUT, request, apiKey, tracer);
    }

    final GetInstanceResponseMessage getInstance(String apiKey, GetInstanceRequestMessage request, Tracer tracer) {
        return (GetInstanceResponseMessage)this.executeRequest(this.GET_INSTANCE_URL + "/" + request.getId(), CivoRequestType.GetInstance, HttpClient.HttpMethod.GET, request, apiKey, tracer);
    }

    final GetInstancesResponseMessage getInstances(String apiKey, GetInstancesRequestMessage request, Tracer tracer) {
        return (GetInstancesResponseMessage)this.executeRequest(this.GET_INSTANCES_URL, CivoRequestType.GetInstances, HttpClient.HttpMethod.GET, request, apiKey, tracer);
    }

    final DeleteInstanceResponseMessage deleteInstance(String apiKey, DeleteInstanceRequestMessage request, Tracer tracer) {
        return (DeleteInstanceResponseMessage)this.executeRequest(this.DELETE_INSTANCE_URL + "/" + request.getId(), CivoRequestType.DeleteInstance, HttpClient.HttpMethod.DELETE, request, apiKey, tracer);
    }
}

