/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import cern.colt.function.ObjectProcedure;
import cern.colt.list.ObjectArrayList;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.tools.interactive.commands.Command;

public final class Links
extends Command {
    private final LnkContainer container;

    public Links(LnkContainer container) {
        this.container = container;
    }

    private void processLinks() {
        System.out.printf("\n%-40s%-40s%-10s%-30s%s\n", "Name", "Internal Name", "Type", "Created", "State");
        System.out.printf("-------------------------------------------------------------------------------------------------------------------------------------------\n", new Object[0]);
        ObjectArrayList list = this.container.getLinks();
        if (list.size() > 0) {
            list.forEach(new ObjectProcedure(){

                public final boolean apply(Object element) {
                    ILnkPeerEndpoint pep = (ILnkPeerEndpoint)element;
                    System.out.printf("%-40s%-40s%-10s%-30s%s\n", pep.getName(), pep.getNameInternal(), pep.getType(), pep.getWhenCreated().toString(), pep.getState().toString());
                    return true;
                }
            });
        } else {
            System.out.printf("<No entries>\n", new Object[0]);
        }
        System.out.printf("\n", new Object[0]);
    }

    public final void run(String[] args) {
        if (args != null && args.length != 0) {
            System.out.println("Syntax error: links");
        } else {
            this.processLinks();
        }
    }

    public final void help() {
        System.out.println("links");
        System.out.println("  List connected links.");
    }

    public final String[] keywords() {
        return new String[]{"links"};
    }
}

