/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkSTRContainer;
import com.neeve.tools.interactive.commands.Command;

public final class Flush
extends Command {
    private final LnkSTRContainer container;

    public Flush(LnkSTRContainer container) {
        this.container = container;
    }

    private void processFlush(String name, int flushType) {
        ILnkPeerEndpoint pep = this.container.getLink(name);
        if (pep != null) {
            System.out.println("Flushing link ['" + name + "] [flushType=" + flushType + "]...");
            ILnkPeerEndpoint.FlushContext flushContext = flushType == 0 ? new ILnkPeerEndpoint.SynchronousBlockingFlushContext() : (flushType == 1 ? new ILnkPeerEndpoint.SynchronousNonBlockingFlushContext() : new ILnkPeerEndpoint.AsynchronousFlushContext(this.container.getReader()));
            try {
                pep.flush((short)-1, flushContext);
                System.out.println("Flush context after flush " + flushContext);
            }
            catch (Exception e) {
                System.out.println("Failure [" + e.toString() + "]");
            }
        } else {
            System.out.println("Invalid link ['" + name + "'].");
        }
    }

    public final void run(String[] args) {
        if (args.length != 2) {
            System.out.println("Syntax error: flush <name> <flushType>");
        } else {
            this.processFlush(args[0], Integer.parseInt(args[1]));
        }
    }

    public final void help() {
        System.out.println("flush <name> <flushType>");
        System.out.println("  Flush a link.");
    }

    public final String[] keywords() {
        return new String[]{"flush"};
    }
}

