/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.eaio.uuid.UUID;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderVariable;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class PktSubheaderODS
extends PktSubheaderVariable {
    public static final byte V1 = 1;
    public static final byte V2 = 2;
    public static final byte VERSION = 2;
    private static int VERSION_POS = 1;
    private int OBJID_HI_POS;
    private int OBJID_LO_POS;
    private int OFID_POS;
    private int OTYPE_POS;
    private int CONTENT_ENC_POS;
    private int ENTTYPE_POS;
    private int TIMESTAMP_POS;
    private int FLAGS_POS;
    private int TXN_ID_POS;
    private int STABLE_TXN_ID_POS;
    private int CHECKPOINT_VERSION_POS;
    private int OBJMETADATALEN_POS;
    private int OBJMETADATA_POS;
    private int PERMETADATALEN_POS;
    private int PERMETADATA_POS;
    private final UUID objectId = new UUID(0L, 0L);
    private boolean objectIdInitialized = false;
    private short objectMetadataLen = 0;
    private short persisterMetadataLen = 0;
    private boolean inGetSubheaderVersion;
    public static final int FLAG_COMMIT_START = 2;
    public static final int FLAG_COMMIT_END = 1;
    public static final int FLAG_COMMIT_ACK_REQUIRED = 4;
    public static final int FLAG_COMMIT_ENTRY_IS_PUT = 8;
    public static final int FLAG_COMMIT_ENTRY_IS_UPDATE = 16;
    public static final int FLAG_COMMIT_ENTRY_IS_REMOVE = 32;
    public static final int FLAG_COMMIT_ENTRY_IS_SEND = 64;
    public static final int FLAG_COMMIT_ENTRY_IN_INIT = 128;
    public static final short ENTRY_TYPE_PUT = 1;
    public static final short ENTRY_TYPE_UPDATE = 2;
    public static final short ENTRY_TYPE_REMOVE = 3;
    public static final short ENTRY_TYPE_SEND = 4;
    public static final short ENTRY_TYPE_MESSAGE = 5;

    private PktSubheaderODS(Properties props) {
        super(7);
    }

    public static PktBody create(Properties props) {
        return new PktSubheaderODS(props);
    }

    public static PktBody create() {
        return PktSubheaderODS.create(null);
    }

    public static PktBody create(short version) {
        PktSubheaderODS subheader = (PktSubheaderODS)PktSubheaderODS.create();
        subheader.setSubheaderVersion(version);
        subheader.setFieldOffsets(version, false);
        return subheader;
    }

    private static final int getSerializedLength(short version, short objectMetadataLen, short persisterMetadataLen) {
        switch (version) {
            case 1: {
                return 57 + (2 + objectMetadataLen);
            }
            case 2: {
                return 57 + (2 + objectMetadataLen) + (2 + persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + version + " subheader is not supported");
    }

    private final short setFieldOffsets(short version, boolean onDeserialize) {
        switch (version) {
            case 1: {
                this.OBJID_HI_POS = VERSION_POS + 1;
                this.OBJID_LO_POS = this.OBJID_HI_POS + 8;
                this.OFID_POS = this.OBJID_LO_POS + 8;
                this.OTYPE_POS = this.OFID_POS + 2;
                this.CONTENT_ENC_POS = this.OTYPE_POS + 2;
                this.ENTTYPE_POS = this.CONTENT_ENC_POS + 1;
                this.TIMESTAMP_POS = this.ENTTYPE_POS + 1;
                this.FLAGS_POS = this.TIMESTAMP_POS + 8;
                this.TXN_ID_POS = this.FLAGS_POS + 1;
                this.STABLE_TXN_ID_POS = this.TXN_ID_POS + 8;
                this.CHECKPOINT_VERSION_POS = this.STABLE_TXN_ID_POS + 8;
                this.OBJMETADATALEN_POS = this.CHECKPOINT_VERSION_POS + 8;
                this.OBJMETADATA_POS = this.OBJMETADATALEN_POS + 2;
                break;
            }
            case 2: {
                this.OBJID_HI_POS = VERSION_POS + 1;
                this.OBJID_LO_POS = this.OBJID_HI_POS + 8;
                this.OFID_POS = this.OBJID_LO_POS + 8;
                this.OTYPE_POS = this.OFID_POS + 2;
                this.CONTENT_ENC_POS = this.OTYPE_POS + 2;
                this.TIMESTAMP_POS = this.CONTENT_ENC_POS + 1 + 1;
                this.FLAGS_POS = this.TIMESTAMP_POS + 8;
                this.TXN_ID_POS = this.FLAGS_POS + 1;
                this.STABLE_TXN_ID_POS = this.TXN_ID_POS + 8;
                this.CHECKPOINT_VERSION_POS = this.STABLE_TXN_ID_POS + 8;
                this.OBJMETADATALEN_POS = this.CHECKPOINT_VERSION_POS + 8;
                this.OBJMETADATA_POS = this.OBJMETADATALEN_POS + 2;
                this.PERMETADATALEN_POS = this.OBJMETADATA_POS + (onDeserialize ? (int)this.buffer.getShort(this.OBJMETADATALEN_POS) : 0);
                this.PERMETADATA_POS = this.PERMETADATALEN_POS + 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("V" + version + " subheader is not supported");
            }
        }
        return version;
    }

    private final void setPersisterMetadataFieldOffsets() {
        this.PERMETADATALEN_POS = this.OBJMETADATA_POS + this.objectMetadataLen;
        this.PERMETADATA_POS = this.PERMETADATALEN_POS + 2;
    }

    private final void setSubheaderVersion(IOElasticBuffer buffer, short version) {
        buffer.put(VERSION_POS, (byte)version);
    }

    private final short getSubheaderVersion(IOElasticBuffer buffer) {
        if (this.inGetSubheaderVersion) {
            return 2;
        }
        this.inGetSubheaderVersion = true;
        try {
            short s = (short)(0xFF & buffer.get(VERSION_POS));
            return s;
        }
        finally {
            this.inGetSubheaderVersion = false;
        }
    }

    private static final short getSubheaderVersion(ByteBuffer buffer, int offset) {
        return (short)(0xFF & buffer.get(offset + VERSION_POS));
    }

    private static final short getSubheaderVersion(IOBuffer buffer, int offset) {
        return (short)(0xFF & buffer.getByte(offset + VERSION_POS));
    }

    private static final short getSubheaderVersion(long addr, int offset) {
        return (short)(0xFF & IOBuffer.getByte((long)addr, (int)(offset + VERSION_POS)));
    }

    private final void setObjectId(IOElasticBuffer buffer, UUID id) {
        if (id != null) {
            this.objectId.time = id.time;
            this.objectId.clockSeqAndNode = id.clockSeqAndNode;
            buffer.putLong(this.OBJID_HI_POS, id.getTime());
            buffer.putLong(this.OBJID_LO_POS, id.getClockSeqAndNode());
            this.objectIdInitialized = true;
        } else {
            this.objectId.time = 0L;
            this.objectId.clockSeqAndNode = 0L;
            buffer.putLong(this.OBJID_HI_POS, 0L);
            buffer.putLong(this.OBJID_LO_POS, 0L);
            this.objectIdInitialized = false;
        }
    }

    private final void setObjectFactoryId(IOElasticBuffer buffer, short ofid) {
        buffer.putShort(this.OFID_POS, ofid);
    }

    private final void setObjectType(IOElasticBuffer buffer, short otype) {
        buffer.putShort(this.OTYPE_POS, otype);
    }

    private final void setContentEncodingType(IOElasticBuffer buffer, short contentEncodingType) {
        buffer.put(this.CONTENT_ENC_POS, (byte)contentEncodingType);
    }

    private final void setTimestamp(IOElasticBuffer buffer, long timestamp) {
        buffer.putLong(this.TIMESTAMP_POS, timestamp);
    }

    private final void setCommitEntryType(IOElasticBuffer buffer, short entryType) {
        block0 : switch (this.getSubheaderVersion()) {
            case 1: {
                buffer.put(this.ENTTYPE_POS, (byte)entryType);
                break;
            }
            default: {
                switch (entryType) {
                    case 1: {
                        this.setFlagCommitEntryIsPut(true);
                        break block0;
                    }
                    case 2: {
                        this.setFlagCommitEntryIsUpdate(true);
                        break block0;
                    }
                    case 3: {
                        this.setFlagCommitEntryIsRemove(true);
                        break block0;
                    }
                    case 4: {
                        this.setFlagCommitEntryIsSend(true);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("unknown commit entry type '" + entryType + "'");
            }
        }
    }

    private final void setFlags(IOElasticBuffer buffer, byte flags) {
        buffer.put(this.FLAGS_POS, flags);
    }

    public static void prepare(PktPacket packet, UUID objectId, short ofid, short otype, short contentEncodingType, long transactionId, long stableTransactionId, long checkpointVersion, long timestamp, byte flags) {
        PktSubheaderODS subheaderODS = packet.getHeader().activateODSSubheader(false);
        IOElasticBuffer buffer = subheaderODS.getBuffer();
        subheaderODS.setObjectId(buffer, objectId);
        subheaderODS.setObjectFactoryId(buffer, ofid);
        subheaderODS.setObjectType(buffer, otype);
        subheaderODS.setContentEncodingType(buffer, contentEncodingType);
        subheaderODS.setTransactionId(transactionId);
        subheaderODS.setStableTransactionId(stableTransactionId);
        subheaderODS.setCheckpointVersion(checkpointVersion);
        subheaderODS.setTimestamp(timestamp);
        subheaderODS.setFlags(buffer, flags);
    }

    public static final short getLatestSubheaderVersion() {
        return 2;
    }

    @Override
    protected final void initialize() {
        this.setFieldOffsets((short)2, false);
    }

    public static final int calcSerializedLength(ByteBuffer buffer, int offset) {
        int objmetadatalen_pos;
        short version = PktSubheaderODS.getSubheaderVersion(buffer, offset);
        switch (version) {
            case 1: 
            case 2: {
                objmetadatalen_pos = 57;
                break;
            }
            default: {
                throw new UnsupportedOperationException("V" + version + " subheader is not supported");
            }
        }
        short objectMetadataLen = buffer.getShort(offset + objmetadatalen_pos);
        switch (version) {
            case 1: {
                return PktSubheaderODS.getSerializedLength((short)1, objectMetadataLen, (short)0);
            }
            case 2: {
                short persisterMetadataLen = buffer.getShort(offset + objmetadatalen_pos + 2 + objectMetadataLen);
                return PktSubheaderODS.getSerializedLength((short)2, objectMetadataLen, persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + version + " subheader is not supported");
    }

    public static final int calcSerializedLength(IOBuffer buffer, int offset) {
        int objmetadatalen_pos;
        short version = PktSubheaderODS.getSubheaderVersion(buffer, offset);
        switch (version) {
            case 1: 
            case 2: {
                objmetadatalen_pos = 57;
                break;
            }
            default: {
                throw new UnsupportedOperationException("V" + version + " subheader is not supported");
            }
        }
        short objectMetadataLen = buffer.getShort(offset + objmetadatalen_pos);
        switch (version) {
            case 1: {
                return PktSubheaderODS.getSerializedLength((short)1, objectMetadataLen, (short)0);
            }
            case 2: {
                short persisterMetadataLen = buffer.getShort(offset + objmetadatalen_pos + 2 + objectMetadataLen);
                return PktSubheaderODS.getSerializedLength((short)2, objectMetadataLen, persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + version + " subheader is not supported");
    }

    public static final int calcSerializedLength(long addr, int offset) {
        int objmetadatalen_pos;
        short version = PktSubheaderODS.getSubheaderVersion(addr, offset);
        switch (version) {
            case 1: 
            case 2: {
                objmetadatalen_pos = 57;
                break;
            }
            default: {
                throw new UnsupportedOperationException("V" + version + " subheader is not supported");
            }
        }
        short objectMetadataLen = IOBuffer.getShort((long)addr, (int)(offset + objmetadatalen_pos));
        switch (version) {
            case 1: {
                return PktSubheaderODS.getSerializedLength((short)1, objectMetadataLen, (short)0);
            }
            case 2: {
                short persisterMetadataLen = IOBuffer.getShort((long)addr, (int)(offset + objmetadatalen_pos + 2 + objectMetadataLen));
                return PktSubheaderODS.getSerializedLength((short)2, objectMetadataLen, persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + version + " subheader is not supported");
    }

    @Override
    public final int doGetSerializedLength() {
        return PktSubheaderODS.getSerializedLength(this.getSubheaderVersion(), this.objectMetadataLen, this.persisterMetadataLen);
    }

    @Override
    public final int getSerializedLength(ByteBuffer buffer, int offset) {
        short objectMetadataLen = buffer.getShort(offset + this.OBJMETADATALEN_POS);
        switch (PktSubheaderODS.getSubheaderVersion(buffer, offset)) {
            case 1: {
                return PktSubheaderODS.getSerializedLength((short)1, objectMetadataLen, (short)0);
            }
            case 2: {
                short persisterMetadataLen = buffer.getShort(offset + this.OBJMETADATALEN_POS + 2 + objectMetadataLen);
                return PktSubheaderODS.getSerializedLength((short)2, objectMetadataLen, persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + PktSubheaderODS.getSubheaderVersion(buffer, offset) + " subheader is not supported");
    }

    @Override
    public final int getSerializedLength(IOBuffer buffer, int offset) {
        short objectMetadataLen = buffer.getShort(offset + this.OBJMETADATALEN_POS);
        switch (PktSubheaderODS.getSubheaderVersion(buffer, offset)) {
            case 1: {
                return PktSubheaderODS.getSerializedLength((short)1, objectMetadataLen, (short)0);
            }
            case 2: {
                short persisterMetadataLen = buffer.getShort(offset + this.OBJMETADATALEN_POS + 2 + objectMetadataLen);
                return PktSubheaderODS.getSerializedLength((short)2, objectMetadataLen, persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + PktSubheaderODS.getSubheaderVersion(buffer, offset) + " subheader is not supported");
    }

    @Override
    public final int getSerializedLength(long addr, int offset) {
        short objectMetadataLen = IOBuffer.getShort((long)addr, (int)(offset + this.OBJMETADATALEN_POS));
        switch (PktSubheaderODS.getSubheaderVersion(addr, offset)) {
            case 1: {
                return PktSubheaderODS.getSerializedLength((short)1, objectMetadataLen, (short)0);
            }
            case 2: {
                short persisterMetadataLen = IOBuffer.getShort((long)addr, (int)(offset + this.OBJMETADATALEN_POS + 2 + objectMetadataLen));
                return PktSubheaderODS.getSerializedLength((short)2, objectMetadataLen, persisterMetadataLen);
            }
        }
        throw new UnsupportedOperationException("V" + PktSubheaderODS.getSubheaderVersion(addr, offset) + " subheader is not supported");
    }

    @Override
    protected final void doDesync(int len) {
        VERSION_POS = 1;
        short version = this.getSubheaderVersion();
        this.setFieldOffsets(version, true);
        this.objectIdInitialized = false;
        this.objectMetadataLen = this.buffer.getShort(this.OBJMETADATALEN_POS);
        if (version > 1) {
            this.persisterMetadataLen = this.buffer.getShort(this.PERMETADATALEN_POS);
        }
    }

    @Override
    protected final boolean isResettable() {
        return true;
    }

    @Override
    protected final void doReset() {
        this.objectId.clockSeqAndNode = 0L;
        this.objectId.time = 0L;
        this.objectIdInitialized = false;
        this.objectMetadataLen = 0;
        this.persisterMetadataLen = 0;
    }

    @Override
    public final int doGetInitialBufferLength() {
        return PktSubheaderODS.getSerializedLength((short)2, (short)0, (short)0);
    }

    private final void setSubheaderVersion(short version) {
        this.setSubheaderVersion(this.buffer, version);
    }

    public final short getSubheaderVersion() {
        return this.getSubheaderVersion(this.buffer);
    }

    public final void setObjectId(UUID objectId) {
        this.setObjectId(this.buffer, objectId);
    }

    public final UUID getObjectId() {
        if (!this.objectIdInitialized) {
            long objectIdLo = this.buffer.getLong(this.OBJID_LO_POS);
            if (objectIdLo != 0L) {
                this.objectId.time = this.buffer.getLong(this.OBJID_HI_POS);
                this.objectId.clockSeqAndNode = objectIdLo;
                this.objectIdInitialized = true;
                return this.objectId;
            }
            return null;
        }
        return this.objectId;
    }

    public static final short getObjectFactoryId(long addr, int offset) {
        return IOBuffer.getShort((long)addr, (int)(offset + 1 + 1 + 8 + 8));
    }

    public final void setObjectFactoryId(short ofid) {
        this.buffer.putShort(this.OFID_POS, ofid);
    }

    public final short getObjectFactoryId() {
        return this.buffer.getShort(this.OFID_POS);
    }

    public static final short getObjectType(long addr, int offset) {
        return IOBuffer.getShort((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2));
    }

    public final void setObjectType(short otype) {
        this.buffer.putShort(this.OTYPE_POS, otype);
    }

    public final short getObjectType() {
        return this.buffer.getShort(this.OTYPE_POS);
    }

    public static final short getContentEncodingType(long addr, int offset) {
        return (short)(0xFF & IOBuffer.getByte((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2)));
    }

    public final void setContentEncodingType(short contentEncodingType) {
        this.setContentEncodingType(this.buffer, contentEncodingType);
    }

    public final short getContentEncodingType() {
        return (short)(0xFF & this.buffer.get(this.CONTENT_ENC_POS));
    }

    public final void setTimestamp(long timestamp) {
        this.setTimestamp(this.buffer, timestamp);
    }

    public final long getTimestamp() {
        return this.buffer.getLong(this.TIMESTAMP_POS);
    }

    public static final short getCommitEntryType(long addr, int offset) {
        switch (PktSubheaderODS.getSubheaderVersion(addr, offset)) {
            case 1: {
                return IOBuffer.getByte((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1));
            }
        }
        int flags = PktSubheaderODS.getFlags(addr, offset);
        if ((flags & 8) == 8) {
            return 1;
        }
        if ((flags & 0x10) == 16) {
            return 2;
        }
        if ((flags & 0x20) == 32) {
            return 3;
        }
        if ((flags & 0x40) == 64) {
            return 4;
        }
        return 0;
    }

    public final void setCommitEntryType(short entryType) {
        this.setCommitEntryType(this.buffer, entryType);
    }

    public final short getCommitEntryType() {
        switch (this.getSubheaderVersion()) {
            case 1: {
                return (short)(0xFF & this.buffer.get(this.ENTTYPE_POS));
            }
        }
        int flags = this.getFlags();
        if ((flags & 8) == 8) {
            return 1;
        }
        if ((flags & 0x10) == 16) {
            return 2;
        }
        if ((flags & 0x20) == 32) {
            return 3;
        }
        if ((flags & 0x40) == 64) {
            return 4;
        }
        return 0;
    }

    public static final void setTransactionId(long addr, int offset, long val) {
        IOBuffer.putLong((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1 + 1 + 8 + 1), (long)val);
    }

    public static final long getTransactionId(long addr, int offset) {
        return IOBuffer.getLong((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1 + 1 + 8 + 1));
    }

    public final void setTransactionId(long transactionId) {
        this.buffer.putLong(this.TXN_ID_POS, transactionId);
    }

    public final long getTransactionId() {
        return this.buffer.getLong(this.TXN_ID_POS);
    }

    public static final void setStableTransactionId(long addr, int offset, long val) {
        IOBuffer.putLong((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1 + 1 + 8 + 1 + 8), (long)val);
    }

    public static final long getStableTransactionId(long addr, int offset) {
        return IOBuffer.getLong((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1 + 1 + 8 + 1 + 8));
    }

    public final void setStableTransactionId(long stableTransactionId) {
        this.buffer.putLong(this.STABLE_TXN_ID_POS, stableTransactionId);
    }

    public final long getStableTransactionId() {
        return this.buffer.getLong(this.STABLE_TXN_ID_POS);
    }

    public static final void setCheckpointVersion(long addr, int offset, long val) {
        IOBuffer.putLong((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1 + 1 + 8 + 1 + 8 + 8), (long)val);
    }

    public static final long getCheckpointVersion(long addr, int offset) {
        return IOBuffer.getLong((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1 + 1 + 8 + 1 + 8 + 8));
    }

    public final void setCheckpointVersion(long checkpointVersion) {
        this.buffer.putLong(this.CHECKPOINT_VERSION_POS, checkpointVersion);
    }

    public final long getCheckpointVersion() {
        if (this.getSubheaderVersion() == 0) {
            return 0L;
        }
        return this.buffer.getLong(this.CHECKPOINT_VERSION_POS);
    }

    public static final void setFlags(long addr, int offset, byte val) {
        IOBuffer.putByte((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1 + 1 + 8), (byte)val);
    }

    public static final int getFlags(long addr, int offset) {
        return IOBuffer.getByte((long)addr, (int)(offset + 1 + 1 + 8 + 8 + 2 + 2 + 1 + 1 + 8));
    }

    public final void setFlags(byte flags) {
        this.setFlags(this.buffer, flags);
    }

    public final int getFlags() {
        return this.buffer.get(this.FLAGS_POS);
    }

    public final void setFlagCommitStart(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        flags = val ? (byte)(flags | 2) : (byte)(flags & 0xFFFFFFFD);
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitStart() {
        return (this.buffer.get(this.FLAGS_POS) & 2) == 2;
    }

    public final void setFlagCommitEnd(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        flags = val ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEnd() {
        return (this.buffer.get(this.FLAGS_POS) & 1) == 1;
    }

    public final void setFlagCommitAckRequired(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        flags = val ? (byte)(flags | 4) : (byte)(flags & 0xFFFFFFFB);
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitAckRequired() {
        return (this.buffer.get(this.FLAGS_POS) & 4) == 4;
    }

    public final void setFlagCommitEntryIsPut(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        if (val) {
            flags = (byte)(flags | 8);
            flags = (byte)(flags & 0xFFFFFFEF);
            flags = (byte)(flags & 0xFFFFFFDF);
            flags = (byte)(flags & 0xFFFFFFBF);
        } else {
            flags = (byte)(flags & 0xFFFFFFF7);
        }
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryIsPut() {
        return (this.buffer.get(this.FLAGS_POS) & 8) == 8;
    }

    public final void setFlagCommitEntryIsUpdate(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        if (val) {
            flags = (byte)(flags & 0xFFFFFFF7);
            flags = (byte)(flags | 0x10);
            flags = (byte)(flags & 0xFFFFFFDF);
            flags = (byte)(flags & 0xFFFFFFBF);
        } else {
            flags = (byte)(flags & 0xFFFFFFEF);
        }
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryIsUpdate() {
        return (this.buffer.get(this.FLAGS_POS) & 0x10) == 16;
    }

    public final void setFlagCommitEntryIsRemove(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        if (val) {
            flags = (byte)(flags & 0xFFFFFFF7);
            flags = (byte)(flags & 0xFFFFFFEF);
            flags = (byte)(flags | 0x20);
            flags = (byte)(flags & 0xFFFFFFBF);
        } else {
            flags = (byte)(flags & 0xFFFFFFDF);
        }
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryIsRemove() {
        return (this.buffer.get(this.FLAGS_POS) & 0x20) == 32;
    }

    public final void setFlagCommitEntryIsSend(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        if (val) {
            flags = (byte)(flags & 0xFFFFFFF7);
            flags = (byte)(flags & 0xFFFFFFEF);
            flags = (byte)(flags & 0xFFFFFFDF);
            flags = (byte)(flags | 0x40);
        } else {
            flags = (byte)(flags & 0xFFFFFFBF);
        }
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryIsSend() {
        return (this.buffer.get(this.FLAGS_POS) & 0x40) == 64;
    }

    public final void setFlagCommitEntryInInit(boolean val) {
        byte flags = this.buffer.get(this.FLAGS_POS);
        flags = val ? (byte)(flags | 0x80) : (byte)(flags & 0xFFFFFF7F);
        this.buffer.put(this.FLAGS_POS, flags);
    }

    public final boolean getFlagCommitEntryInInit() {
        return (this.buffer.get(this.FLAGS_POS) & 0x80) == 128;
    }

    public final void setObjectMetadataLengthUnsafe(short val) {
        this.objectMetadataLen = val;
        this.buffer.putShort(this.OBJMETADATALEN_POS, this.objectMetadataLen);
        this.setPersisterMetadataFieldOffsets();
        this.persisterMetadataLen = 0;
        this.buffer.putShort(this.PERMETADATALEN_POS, (short)0);
    }

    public final int getObjectMetadataLength() {
        return this.objectMetadataLen;
    }

    public final int getObjectMetadataOffset() {
        return this.OBJMETADATA_POS;
    }

    public final void copyObjectMetadataFrom(IOElasticBuffer metadata) {
        if (metadata != null && metadata.getLength() == 0) {
            throw new IllegalArgumentException("serialized metadata cannot be empty");
        }
        this.objectMetadataLen = (short)(metadata == null ? 0 : metadata.getLength());
        this.buffer.putShort(this.OBJMETADATALEN_POS, this.objectMetadataLen);
        if (this.objectMetadataLen > 0) {
            this.buffer.putFrom(this.OBJMETADATA_POS, metadata, 0, (int)this.objectMetadataLen);
        }
        this.setPersisterMetadataFieldOffsets();
        this.persisterMetadataLen = 0;
        this.buffer.putShort(this.PERMETADATALEN_POS, (short)0);
    }

    public final void copyObjectMetadataTo(IOElasticBuffer buffer, int offset) {
        buffer.putFrom(offset, this.buffer, this.OBJMETADATA_POS, (int)this.objectMetadataLen);
    }

    public final boolean hasPersisterMetadata() {
        return this.getSubheaderVersion() > 1;
    }

    public final int getPersisterMetadataOffset() {
        if (!this.hasPersisterMetadata()) {
            throw new IllegalStateException("header version does not support persister metadata");
        }
        return this.PERMETADATA_POS;
    }

    public final int getPersisterMetadataLength() {
        if (!this.hasPersisterMetadata()) {
            throw new IllegalStateException("header version does not support persister metadata");
        }
        return this.persisterMetadataLen;
    }

    public final void copyPersisterMetadataFrom(IOElasticBuffer metadata) {
        if (!this.hasPersisterMetadata()) {
            throw new IllegalStateException("header version does not support persister metadata");
        }
        if (metadata != null && metadata.getLength() == 0) {
            throw new IllegalArgumentException("serialized metadata cannot be empty");
        }
        this.persisterMetadataLen = (short)(metadata == null ? 0 : metadata.getLength());
        this.buffer.putShort(this.PERMETADATALEN_POS, this.persisterMetadataLen);
        if (this.persisterMetadataLen > 0) {
            this.buffer.putFrom(this.PERMETADATA_POS, metadata, 0, (int)this.persisterMetadataLen);
        }
    }

    public final void copyPersisterMetadataTo(IOElasticBuffer buffer, int offset) {
        if (!this.hasPersisterMetadata()) {
            throw new IllegalStateException("header version does not support persister metadata");
        }
        buffer.putFrom(offset, this.buffer, this.PERMETADATA_POS, (int)this.persisterMetadataLen);
    }

    @Override
    public final void initializeBuffer() {
        this.setSubheaderVersion((short)2);
    }

    public final String toString() {
        switch (this.getSubheaderVersion()) {
            case 1: 
            case 2: {
                return "ODS{" + this.getSubheaderVersion() + " " + (this.getObjectId() == null ? "null" : this.getObjectId().toString()) + " " + this.getObjectFactoryId() + " " + this.getObjectType() + " " + this.getContentEncodingType() + " " + this.getCommitEntryType() + " " + this.getTimestamp() + " " + this.getFlags() + " " + this.getTransactionId() + " " + this.getStableTransactionId() + " " + this.getCheckpointVersion() + " " + this.objectMetadataLen + " " + this.persisterMetadataLen + "}";
            }
        }
        return "ODS{Unknown version " + this.getSubheaderVersion() + "}";
    }
}

