/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public final class PktPacket
extends UtlListElement
implements UtlPool.Item<PktPacket>,
UtlReferenceTracker.HasReferenceTracker {
    private UtlReferenceTracker refTracker;
    private AtomicInteger ownershipCount;
    private PktHeader header;
    private PktBody body;
    private Object[] tags;
    private UtlPool<PktPacket> pool;
    private long inTs;
    private long outTs;

    private PktPacket(PktHeader header, PktBody body, Parameters parameters, int flags) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("body cannot be null");
        }
        if (header.getBody() != body) {
            throw new IllegalStateException("supplied body does not match with body associated with supplied header");
        }
        this.init(header, body, parameters == null ? new Parameters() : parameters, new Object[5]);
    }

    static PktPacket create(PktHeader header, PktBody body, Parameters parameters, int flags) {
        return new PktPacket(header, body, parameters, flags);
    }

    private final void init(PktHeader header, PktBody body, Parameters parameters, Object[] tags) {
        this.ownershipCount = new AtomicInteger(0);
        this.header = header;
        this.body = body;
        this.tags = tags;
        this.refTracker = UtlReferenceTracker.enabled(((Object)((Object)this)).getClass()) ? new UtlReferenceTracker((Object)this) : null;
    }

    public final PktHeader getHeader() {
        return this.header;
    }

    public final PktBody getBody() {
        return this.body;
    }

    public final void setTag(int id, Object tag) {
        if (id < 0 || id >= 5) {
            throw new IllegalArgumentException("invalid tag id=" + id);
        }
        this.tags[id] = tag;
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null && id == 3) {
            if (tag == null) {
                this.refTracker.setAssociatedTracker(null);
            } else if (tag instanceof UtlReferenceTracker.HasReferenceTracker) {
                this.refTracker.setAssociatedTracker(((UtlReferenceTracker.HasReferenceTracker)tag).referenceTracker());
            }
        }
    }

    public final Object getTag(int id) {
        if (id < 0 || id >= 5) {
            throw new IllegalArgumentException("invalid tag id=" + id);
        }
        return this.tags[id];
    }

    public final PktPacket acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed packet (packet='" + ((Object)((Object)this.body)).getClass().getName() + "')");
        }
        return this;
    }

    public final int getOwnerCount() {
        return this.ownershipCount.get();
    }

    public final void dispose() {
        int val = this.ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed packet (packet='" + ((Object)((Object)this.body)).getClass().getName() + "')");
        }
        if (val == 0 && this.pool != null) {
            this.pool.put((UtlPool.Item)this);
        }
    }

    final PktPacket undispose() {
        int val = this.ownershipCount.getAndSet(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onInit(1);
        }
        if (val != 0 && this.pool != null) {
            throw new IllegalStateException("attempt to undispose a packet that's not disposed (packet='" + ((Object)((Object)this.body)).getClass().getName() + "')");
        }
        return this;
    }

    public final UtlReferenceTracker referenceTracker() {
        return this.refTracker;
    }

    public final int getSerializedLength() {
        return this.header.getSerializedLength() + this.body.getSerializedLength();
    }

    public final int sync() {
        int serializedLength = this.body.sync();
        return serializedLength += this.header.sync();
    }

    public final void desync() {
        this.body.desync();
        this.header.desync();
    }

    public final PktPacket syncf() {
        this.sync();
        return this;
    }

    public final int getTo(ByteBuffer buf, int bufOffset, boolean withMagic) {
        int serializedLength = this.header.getTo(buf, bufOffset, withMagic);
        serializedLength += this.body.getTo(buf, bufOffset + serializedLength);
        return serializedLength;
    }

    public final int getTo(ByteBuffer buf, int bufOffset) {
        return this.getTo(buf, bufOffset, true);
    }

    public final int getTo(ByteBuffer buf, boolean withMagic) {
        return this.getTo(buf, buf.position(), withMagic);
    }

    public final int getTo(ByteBuffer buf) {
        return this.getTo(buf, true);
    }

    public final int getTo(byte[] array, int arrayOffset, boolean withMagic) {
        int serializedLength = this.header.getTo(array, arrayOffset, withMagic);
        serializedLength += this.body.getTo(array, arrayOffset + serializedLength);
        return serializedLength;
    }

    public final int getTo(byte[] array, int arrayOffset) {
        return this.getTo(array, arrayOffset, true);
    }

    public final int getTo(IOBuffer iobuf, int iobufOffset, boolean withMagic) {
        int serializedLength = this.header.getTo(iobuf, iobufOffset, withMagic);
        serializedLength += this.body.getTo(iobuf, iobufOffset + serializedLength);
        return serializedLength;
    }

    public final int getTo(IOBuffer iobuf, int iobufOffset) {
        return this.getTo(iobuf, iobufOffset, true);
    }

    public final int getTo(IOElasticBuffer iobuf, int iobufOffset, boolean withMagic) {
        int serializedLength = this.header.getTo(iobuf, iobufOffset, withMagic);
        serializedLength += this.body.getTo(iobuf, iobufOffset + serializedLength);
        return serializedLength;
    }

    public final int getTo(IOElasticBuffer iobuf, int iobufOffset) {
        return this.getTo(iobuf, iobufOffset, true);
    }

    public final int getTo(long addr, int addrOffset, boolean withMagic) {
        int serializedLength = this.header.getTo(addr, addrOffset, withMagic);
        serializedLength += this.body.getTo(addr, addrOffset + serializedLength);
        return serializedLength;
    }

    public final int getTo(long addr, int addrOffset) {
        return this.getTo(addr, addrOffset, true);
    }

    public final int putFrom(ByteBuffer buf, int bufOffset) {
        int headerSerializedLength = this.header.putFrom(buf, bufOffset);
        int bodySerializedLength = this.header.getLength() - headerSerializedLength;
        this.body.putFrom(buf, bufOffset + headerSerializedLength, bodySerializedLength);
        return headerSerializedLength + bodySerializedLength;
    }

    public final int putFrom(IOBuffer iobuf, int iobufOffset, boolean wrapHeader, boolean wrapBody) {
        int headerSerializedLength = this.header.putFrom(iobuf, iobufOffset, wrapHeader);
        int bodySerializedLength = this.header.getLength() - headerSerializedLength;
        this.body.putFrom(iobuf, iobufOffset + headerSerializedLength, bodySerializedLength, wrapBody);
        return headerSerializedLength + bodySerializedLength;
    }

    public final int putFrom(IOBuffer iobuf, int iobufOffset, boolean wrap) {
        return this.putFrom(iobuf, iobufOffset, wrap, wrap);
    }

    public final int putFrom(IOBuffer iobuf, int iobufOffset) {
        return this.putFrom(iobuf, iobufOffset, false, false);
    }

    public final int putFrom(long addr, int addrOffset) {
        int headerSerializedLength = this.header.putFrom(addr, addrOffset);
        int bodySerializedLength = this.header.getLength() - headerSerializedLength;
        this.body.putFrom(addr, addrOffset + headerSerializedLength, bodySerializedLength);
        return headerSerializedLength + bodySerializedLength;
    }

    public final int putFrom(PktPacket packet) {
        this.getBody().putFrom(packet.getBody());
        return this.getHeader().putFrom(packet.getHeader()) + this.getBody().getSerializedLength();
    }

    public final int serialize(ByteBuffer buf, int bufOffset, boolean withMagic) {
        return this.syncf().getTo(buf, bufOffset, withMagic);
    }

    public final int serialize(ByteBuffer buf, int bufOffset) {
        return this.serialize(buf, bufOffset, true);
    }

    public final int serialize(ByteBuffer buf, boolean withMagic) {
        return this.serialize(buf, buf.position(), withMagic);
    }

    public final int serialize(ByteBuffer buf) {
        return this.serialize(buf, true);
    }

    public final int serialize(byte[] array, int arrayOffset, boolean withMagic) {
        return this.syncf().getTo(array, arrayOffset, withMagic);
    }

    public final int serialize(byte[] array, int arrayOffset) {
        return this.serialize(array, arrayOffset, true);
    }

    public final int serialize(IOBuffer iobuf, int iobufOffset, boolean withMagic) {
        return this.syncf().getTo(iobuf, iobufOffset, withMagic);
    }

    public final int serialize(IOBuffer iobuf, int iobufOffset) {
        return this.serialize(iobuf, iobufOffset, true);
    }

    public final int serialize(IOElasticBuffer iobuf, int iobufOffset, boolean withMagic) {
        return this.syncf().getTo(iobuf, iobufOffset, withMagic);
    }

    public final int serialize(IOElasticBuffer iobuf, int iobufOffset) {
        return this.serialize(iobuf, iobufOffset, true);
    }

    public final int serialize(long addr, int addrOffset, boolean withMagic) {
        return this.syncf().getTo(addr, addrOffset, withMagic);
    }

    public final int serialize(long addr, int addrOffset) {
        return this.serialize(addr, addrOffset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deserialize(ByteBuffer buf, int bufOffset) {
        try {
            int n = this.putFrom(buf, bufOffset);
            return n;
        }
        finally {
            this.desync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deserialize(IOBuffer iobuf, int iobufOffset, boolean wrapHeader, boolean wrapBody) {
        try {
            int n = this.putFrom(iobuf, iobufOffset, wrapHeader, wrapBody);
            return n;
        }
        finally {
            this.desync();
        }
    }

    public final int deserialize(PktPacket packet) {
        try {
            int n = this.putFrom(packet);
            return n;
        }
        finally {
            this.desync();
        }
    }

    public final int deserialize(IOBuffer iobuf, int iobufOffset, boolean wrap) {
        return this.deserialize(iobuf, iobufOffset, wrap, wrap);
    }

    public final int deserialize(IOBuffer iobuf, int iobufOffset) {
        return this.deserialize(iobuf, iobufOffset, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int deserialize(long addr, int addrOffset) {
        try {
            int n = this.putFrom(addr, addrOffset);
            return n;
        }
        finally {
            this.desync();
        }
    }

    public final PktPacket reset(boolean initBackingBuffers) {
        this.header.reset(initBackingBuffers);
        if (!this.body.isResettable()) {
            throw new IllegalStateException("packet type '" + PktFactory.getInstance().getPacketTypeNameFromId(this.body.getType()) + "' is not a poolable packet type");
        }
        this.body.reset(initBackingBuffers);
        this.outTs = 0L;
        this.inTs = 0L;
        return this;
    }

    public final PktPacket init() {
        return this.reset(true);
    }

    public final PktPacket setPool(UtlPool<PktPacket> pool) {
        if (pool != null && this.pool != pool && this.refTracker == null) {
            UtlReferenceTracker utlReferenceTracker = this.refTracker = UtlReferenceTracker.enabled((String)pool.type()) ? new UtlReferenceTracker((Object)this) : null;
            if (this.refTracker != null) {
                this.refTracker.onInit(this.ownershipCount.get());
            }
        }
        this.pool = pool;
        return this;
    }

    public final UtlPool<PktPacket> getPool() {
        return this.pool;
    }

    public final String toString() {
        return "pkt<hdr=" + (Object)((Object)this.header) + " body=" + (Object)((Object)this.body) + ">";
    }

    static final class Parameters
    implements Cloneable {
        private Parameters() {
        }

        static Parameters create() {
            return new Parameters();
        }

        public final Object clone() {
            Parameters clonee;
            try {
                clonee = (Parameters)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("Received CloneNotSupportedException even when Cloneable is implemented!");
            }
            return clonee;
        }
    }
}

