/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.ucx;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkInetAddrFormatException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkInetAddr;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxNwAcceptReadyEvent;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.ucx.EmxUcx;
import com.neeve.emx.ucx.EmxUcxNwLnkPeerEndpoint;
import com.neeve.emx.ucx.EmxUcxObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;

public final class EmxUcxNwLnkServerEndpoint
extends EmxUcxObject
implements IEmxNwLnkServerEndpoint {
    private final String localIfAddr;
    private final short localPort;
    private final long sep;
    private boolean closed;

    private EmxUcxNwLnkServerEndpoint(UtlAddressDescriptor descriptor) throws EEmxException {
        EmxNwLnkInetAddr inetAddr;
        try {
            inetAddr = EmxNwLnkInetAddr.parse(descriptor.address);
        }
        catch (IllegalArgumentException e) {
            throw new EEmxNwLnkInetAddrFormatException(descriptor.address);
        }
        this.localIfAddr = inetAddr.host;
        this.localPort = (short)inetAddr.port;
        this.sep = EmxUcx.createServerEndpoint();
        try {
            EmxUcx.listen(this.sep, this.localIfAddr, this.localPort);
        }
        catch (Exception e) {
            EmxUcx.destroyServerEndpoint(this.sep);
            throw new EEmxNwLnkOpFailedException(e);
        }
    }

    public static IEmxNwLnkServerEndpoint create(UtlAddressDescriptor descriptor) throws EEmxException {
        return new EmxUcxNwLnkServerEndpoint(descriptor);
    }

    private final IEmxNwLnkPeerEndpoint acceptInternal() throws EEmxNwLnkOpFailedException {
        if (this.tracer.fine) {
            this.tracer.log("Accepting through UCX network link server endpoint " + this.localIfAddr + ":" + this.localPort + "...", Tracer.Level.FINE);
        }
        try {
            long ep = EmxUcx.createEndpoint();
            try {
                EmxUcx.accept(this.sep, ep);
                if (this.tracer.fine) {
                    this.tracer.log("Accept successfully completed.", Tracer.Level.FINE);
                }
                return new EmxUcxNwLnkPeerEndpoint(ep, true);
            }
            catch (Exception e) {
                EmxUcx.destroyEndpoint(ep);
                this.tracer.log("Accept failed [" + e.toString() + "]", Tracer.Level.WARNING);
                throw new EEmxNwLnkOpFailedException(e);
            }
        }
        catch (Exception e) {
            this.tracer.log("Failed to create an endpoint for the accept operation [" + e.toString() + "]", Tracer.Level.SEVERE);
            throw new EEmxNwLnkOpFailedException(e);
        }
    }

    private final void closeInternal() {
        EmxUcx.destroyServerEndpoint(this.sep);
    }

    @Override
    public final void configureBlocking(boolean blocking) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (!blocking) {
                throw new UnsupportedOperationException("non-blocking IO is not supported");
            }
        } else {
            throw new EEmxInvalidStateException("configureBlocking", "closed");
        }
    }

    @Override
    public final boolean isBlocking() throws EEmxInvalidStateException {
        if (!this.closed) {
            return true;
        }
        throw new EEmxInvalidStateException("isBlocking", "closed");
    }

    @Override
    public final IEmxNwLnkPeerEndpoint accept(EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (waitCond != null) {
                throw new UnsupportedOperationException("non-blocking IO is not supported");
            }
            return this.acceptInternal();
        }
        throw new EEmxInvalidStateException("network link server endpoint accept", "closed");
    }

    @Override
    public final IEmxNwLnkPeerEndpoint accept() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        return this.accept(null);
    }

    @Override
    public final IEmxNwAcceptReadyEvent getAcceptReadyEvent() {
        return null;
    }

    @Override
    public final void close() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            this.tracer.log("Closing UCX network link server endpoint...", Tracer.Level.FINE);
            try {
                this.closeInternal();
            }
            catch (Exception e) {
                this.tracer.log("Failure in closing UCX network link server endpoint [" + e.toString() + "].", Tracer.Level.WARNING);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

