/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.ucx;

import com.neeve.NativeRdma;
import com.neeve.config.Config;
import com.neeve.emx.EmxConfig;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.lang.XLongLinkedHashMap;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;

final class EmxUcx {
    private static final Tracer tracer;
    private static final XLongLinkedHashMap<IEmxNwLnkPeerEndpoint.IDataReceiver> dataReceivers;

    EmxUcx() {
    }

    static final void registerDataReceiver(long ep, IEmxNwLnkPeerEndpoint.IDataReceiver receiver) {
        dataReceivers.put(ep, (Object)receiver);
    }

    static final void deregisterDataReceiver(long ep) {
        dataReceivers.remove(ep);
    }

    public static final void onData(long ep, long addr, int len) {
        IEmxNwLnkPeerEndpoint.IDataReceiver receiver = (IEmxNwLnkPeerEndpoint.IDataReceiver)dataReceivers.get(ep);
        if (receiver != null) {
            receiver.onData(addr, 0, len);
        } else {
            tracer.log("[EmxUcx] No listener found for received data on endpoint " + ep, Tracer.Level.WARNING);
        }
    }

    static final native void init();

    static final native long createServerEndpoint();

    static final native long createEndpoint();

    static final native void listen(long var0, String var2, short var3) throws Exception;

    static final native void accept(long var0, long var2) throws Exception;

    static final native void connect(long var0, String var2, short var3, String var4, short var5) throws Exception;

    static final native void send(long var0, long var2, int var4, int var5) throws Exception;

    static final native void recv(long var0) throws Exception;

    static final native void destroyEndpoint(long var0);

    static final native void destroyServerEndpoint(long var0);

    static {
        try {
            NativeRdma.initialize();
            EmxUcx.init();
            tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)EmxConfig.getConfig());
            Config.setTraceLevel((Tracer)tracer, (String)"nv.emx.ucx.trace");
            dataReceivers = new XLongLinkedHashMap();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }
}

