/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio;

import com.neeve.config.Config;
import com.neeve.emx.EEmxAlreadyScheduledException;
import com.neeve.emx.EEmxDispatcherFatalError;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxNotOwnerException;
import com.neeve.emx.EEmxNotScheduledException;
import com.neeve.emx.EEmxTimeoutException;
import com.neeve.emx.EmxThread;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxDispatcherRunCompletionChecker;
import com.neeve.emx.IEmxDispatcherStats;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxNwAcceptReadyEvent;
import com.neeve.emx.IEmxNwConnectReadyEvent;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.emx.IEmxNwWriteReadyEvent;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.emx.nio.EmxNioAlarmEvent;
import com.neeve.emx.nio.EmxNioDispatcherReadyQueue;
import com.neeve.emx.nio.EmxNioDispatcherStats;
import com.neeve.emx.nio.EmxNioDispatcherWaitQueueAlarm;
import com.neeve.emx.nio.EmxNioDispatcherWaitQueueNetwork;
import com.neeve.emx.nio.EmxNioEvent;
import com.neeve.emx.nio.EmxNioNwAcceptReadyEvent;
import com.neeve.emx.nio.EmxNioNwConnectReadyEvent;
import com.neeve.emx.nio.EmxNioNwReadReadyEvent;
import com.neeve.emx.nio.EmxNioNwWriteReadyEvent;
import com.neeve.emx.nio.EmxNioObject;
import com.neeve.emx.nio.EmxNioUserEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlThrowable;
import java.io.IOException;
import java.nio.channels.Selector;

public final class EmxNioDispatcher
extends EmxNioObject
implements IEmxDispatcher {
    private final String name;
    private final IEmxDispatcher.Params params;
    private final Selector selector;
    private final EmxNioDispatcherWaitQueueAlarm waitqa;
    private final EmxNioDispatcherWaitQueueNetwork waitqn;
    private final EmxNioDispatcherReadyQueue readyq;
    private final EmxNioDispatcherStats stats;
    private volatile Thread owner;
    private volatile boolean isInRun;
    private UtlList dispatchq;
    private UtlList triggeredqa;
    private UtlList triggeredqn;
    private boolean forceSchedNwReadyEvAsCritical;
    private Object attachment;

    public EmxNioDispatcher(String name, IEmxDispatcher.Params params) throws EEmxException {
        if (params == null) {
            throw new IllegalArgumentException("params parameter must be non-null");
        }
        this.name = name == null ? "<noname>" : name;
        this.params = params;
        this.threaded = params.getThreaded();
        this.setOwner();
        Config.setTraceLevel((Tracer)this.tracer, (String)"nv.emx.nio.dispatcher.trace");
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new EEmxException(e);
        }
        this.waitqa = new EmxNioDispatcherWaitQueueAlarm();
        this.waitqn = new EmxNioDispatcherWaitQueueNetwork(this.selector);
        this.readyq = new EmxNioDispatcherReadyQueue();
        this.stats = new EmxNioDispatcherStats(name, "nv.emx.dispatcher.stats.interval");
        this.dispatchq = UtlList.create();
        this.triggeredqa = UtlList.create();
        this.triggeredqn = UtlList.create();
        if (this.tracer.debug) {
            this.tracer.log("Created dispatcher " + name + " with params " + params, Tracer.Level.DEBUG);
        }
    }

    private final void schedUserEvUnprotected(EmxNioUserEvent event) {
        if (this.params.getTimestampEvents()) {
            event.setScheduleTime(System.currentTimeMillis());
        }
        event.setDispatcher(this);
        this.readyq.add(event, event.getPriority());
        ++this.stats.numUserEvSched;
        ++this.stats.numUserEvReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int dispatchReadyEvents() {
        EmxNioEvent event;
        if (this.dispatchq.count() == 0) {
            if (this.threaded) {
                EmxNioDispatcher emxNioDispatcher = this;
                synchronized (emxNioDispatcher) {
                    this.dispatchq = this.readyq.get(this.dispatchq);
                }
            } else {
                this.dispatchq = this.readyq.get(this.dispatchq);
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Received " + this.dispatchq.count() + " ready events for dispatch.", Tracer.Level.DEBUG);
        }
        int dispatched = 0;
        while ((event = (EmxNioEvent)this.dispatchq.next()) != null) {
            IEmxEventHandler handler;
            event.unlink();
            switch (event.getType()) {
                case USER: {
                    --this.stats.numUserEvReady;
                    break;
                }
                case ALARM: {
                    --this.stats.numAlarmEvReady;
                    break;
                }
                case NW_ACCEPT_READY: {
                    --this.stats.numNwAcceptReadyEvReady;
                    break;
                }
                case NW_CONNECT_READY: {
                    --this.stats.numNwConnectReadyEvReady;
                    break;
                }
                case NW_READ_READY: {
                    --this.stats.numNwReadReadyEvReady;
                    break;
                }
                case NW_WRITE_READY: {
                    --this.stats.numNwWriteReadyEvReady;
                    break;
                }
                default: {
                    throw new InternalError("Unknown event type [" + (Object)((Object)event.getType()) + "]");
                }
            }
            if (this.params.getTimestampEvents()) {
                event.setDispatchTime(System.currentTimeMillis());
            }
            event.setDispatcher(null);
            if (this.tracer.debug) {
                this.tracer.log("Dispatching event " + event + "...", Tracer.Level.DEBUG);
            }
            if ((handler = event.getHandler()) != null) {
                try {
                    if (handler.onEvent(this, event)) {
                        if (this.tracer.debug) {
                            this.tracer.log("Handler requested for reschedule.", Tracer.Level.DEBUG);
                        }
                        this.schedEv(event);
                    } else if (this.tracer.debug) {
                        this.tracer.log("Handler did not request for reschedule.", Tracer.Level.DEBUG);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("EMX dispatcher event handler [" + handler + "] faulted with [" + e.toString() + "] with the following stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("No handler associated with event. Discarding...", Tracer.Level.DEBUG);
            }
            switch (event.getType()) {
                case USER: {
                    ++this.stats.numUserEvDispatched;
                    break;
                }
                case ALARM: {
                    ++this.stats.numAlarmEvDispatched;
                    break;
                }
                case NW_ACCEPT_READY: {
                    ++this.stats.numNwAcceptReadyEvDispatched;
                    break;
                }
                case NW_CONNECT_READY: {
                    ++this.stats.numNwConnectReadyEvDispatched;
                    break;
                }
                case NW_READ_READY: {
                    ++this.stats.numNwReadReadyEvDispatched;
                    break;
                }
                case NW_WRITE_READY: {
                    ++this.stats.numNwWriteReadyEvDispatched;
                    break;
                }
                default: {
                    throw new InternalError("Unknown event type [" + (Object)((Object)event.getType()) + "]");
                }
            }
            ++dispatched;
        }
        if (this.tracer.debug) {
            this.tracer.log("Total ready events dispatched=" + dispatched, Tracer.Level.DEBUG);
        }
        return dispatched;
    }

    private final void addReadyNetworkEventsToReadyQ(UtlList list) {
        EmxNioEvent event;
        block6: while ((event = (EmxNioEvent)list.next()) != null) {
            event.unlink();
            this.readyq.add(event, event.getPriority());
            switch (event.getType()) {
                case NW_ACCEPT_READY: {
                    --this.stats.numNwAcceptReadyEvWait;
                    ++this.stats.numNwAcceptReadyEvReady;
                    continue block6;
                }
                case NW_CONNECT_READY: {
                    --this.stats.numNwConnectReadyEvWait;
                    ++this.stats.numNwConnectReadyEvReady;
                    continue block6;
                }
                case NW_READ_READY: {
                    --this.stats.numNwReadReadyEvWait;
                    ++this.stats.numNwReadReadyEvReady;
                    continue block6;
                }
                case NW_WRITE_READY: {
                    --this.stats.numNwWriteReadyEvWait;
                    ++this.stats.numNwWriteReadyEvReady;
                    continue block6;
                }
            }
            throw new InternalError("Unknown event type [" + (Object)((Object)event.getType()) + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int procReadyNetworkEventsInWaitQ(int timeout) throws IOException {
        int numSelected;
        boolean waitqnFlushed = false;
        int triggered = 0;
        waitqnFlushed = this.waitqn.flush();
        int selectTimeout = Math.min(timeout, this.waitqa.getMinTriggerTime());
        if (this.tracer.debug) {
            this.tracer.log("Select timeout=" + selectTimeout, Tracer.Level.DEBUG);
        }
        if (selectTimeout == 0 && (waitqnFlushed || this.waitqn.count() > 0)) {
            ++this.stats.numSelectsNow;
            numSelected = this.selector.selectNow();
        } else if (selectTimeout > 0) {
            ++this.stats.numSelects;
            numSelected = this.selector.select(selectTimeout == Integer.MAX_VALUE ? 0L : (long)selectTimeout);
        } else {
            numSelected = 0;
        }
        if (this.tracer.debug) {
            this.tracer.log("Num selected=" + numSelected, Tracer.Level.DEBUG);
        }
        if (numSelected > 0) {
            if (this.triggeredqn.count() != 0) {
                throw new InternalError("Triggered network event queue is non-empty (size=" + this.triggeredqn.count() + ") at the start of processing ready events in network wait queue!");
            }
            this.triggeredqn = this.waitqn.get(this.selector.selectedKeys().iterator(), this.triggeredqn);
            if (this.tracer.debug) {
                this.tracer.log("Received " + this.triggeredqn.count() + " triggered network events.", Tracer.Level.DEBUG);
            }
        }
        if ((triggered = this.triggeredqn.count()) > 0) {
            if (this.threaded) {
                EmxNioDispatcher emxNioDispatcher = this;
                synchronized (emxNioDispatcher) {
                    this.addReadyNetworkEventsToReadyQ(this.triggeredqn);
                }
            } else {
                this.addReadyNetworkEventsToReadyQ(this.triggeredqn);
            }
        }
        return triggered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int procReadyAlarmEventsInWaitQ() {
        int triggered = 0;
        if (this.triggeredqa.count() != 0) {
            throw new InternalError("Triggered alarm event queue is non-empty (size=" + this.triggeredqa.count() + ") at the start of processing ready events in alarm wait queue!");
        }
        this.triggeredqa = this.waitqa.get(this.triggeredqa);
        if (this.tracer.debug) {
            this.tracer.log("Received " + this.triggeredqa.count() + " triggered alarm events.", Tracer.Level.DEBUG);
        }
        if ((triggered = this.triggeredqa.count()) > 0) {
            if (this.threaded) {
                EmxNioDispatcher emxNioDispatcher = this;
                synchronized (emxNioDispatcher) {
                    this.readyq.add(this.triggeredqa);
                }
            } else {
                this.readyq.add(this.triggeredqa);
            }
            this.stats.numAlarmEvWait -= (long)triggered;
            this.stats.numAlarmEvReady += (long)triggered;
        }
        return triggered;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setOwner(int flags) {
        boolean tagToOwner = (flags & 1) == 1;
        this.owner = Thread.currentThread();
        if (tagToOwner) {
            EmxThread.dispatcher.set(this);
        }
    }

    @Override
    public final void setOwner() {
        this.setOwner(0);
    }

    @Override
    public final Thread getOwner() {
        return this.owner;
    }

    @Override
    public final IEmxDispatcher.Params getParams() {
        return this.params;
    }

    @Override
    public final IEmxDispatcherStats getStats() {
        return this.stats;
    }

    @Override
    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public final int getWaitEvCount() throws EEmxNotOwnerException {
        if (this.checked && Thread.currentThread() != this.owner) {
            throw new EEmxNotOwnerException();
        }
        return this.waitqa.count() + this.waitqn.count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getReadyEvCount() throws EEmxNotOwnerException {
        if (this.checked && Thread.currentThread() != this.owner) {
            throw new EEmxNotOwnerException();
        }
        if (this.threaded) {
            EmxNioDispatcher emxNioDispatcher = this;
            synchronized (emxNioDispatcher) {
                return this.readyq.count();
            }
        }
        return this.readyq.count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void schedUserEv(IEmxUserEvent event) throws EEmxAlreadyScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioUserEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioUserEvent'");
            }
            if (event.getDispatcher() != null) {
                throw new EEmxAlreadyScheduledException();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Scheduling user event " + event + "...", Tracer.Level.DEBUG);
        }
        if (this.threaded) {
            EmxNioDispatcher emxNioDispatcher = this;
            synchronized (emxNioDispatcher) {
                this.schedUserEvUnprotected((EmxNioUserEvent)event);
                if (this.isInRun && Thread.currentThread() != this.owner) {
                    ++this.stats.numSelectWakeups;
                    this.selector.wakeup();
                }
            }
        } else {
            this.schedUserEvUnprotected((EmxNioUserEvent)event);
        }
    }

    @Override
    public final void schedAlarmEv(IEmxAlarmEvent event) throws EEmxNotOwnerException, EEmxAlreadyScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioAlarmEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioAlarmEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != null) {
                throw new EEmxAlreadyScheduledException();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Scheduling alarm event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioAlarmEvent nioEvent = (EmxNioAlarmEvent)event;
        if (this.params.getTimestampEvents()) {
            nioEvent.setScheduleTime(System.currentTimeMillis());
        }
        nioEvent.setDispatcher(this);
        this.waitqa.add(nioEvent);
        ++this.stats.numAlarmEvSched;
        ++this.stats.numAlarmEvWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resetAlarmEv(IEmxAlarmEvent event, long lastDispatchTime) throws EEmxNotOwnerException, EEmxNotScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioAlarmEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioAlarmEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != this) {
                throw new EEmxNotScheduledException();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Resetting alarm event " + event + " to " + lastDispatchTime + "...", Tracer.Level.DEBUG);
        }
        EmxNioAlarmEvent nioEvent = (EmxNioAlarmEvent)event;
        boolean removed = false;
        if (this.threaded) {
            EmxNioDispatcher emxNioDispatcher = this;
            synchronized (emxNioDispatcher) {
                removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
                if (removed) {
                    --this.stats.numAlarmEvReady;
                }
            }
        } else {
            removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
            if (removed) {
                --this.stats.numAlarmEvReady;
            }
        }
        if (removed) {
            this.schedAlarmEv(nioEvent);
        }
        this.waitqa.reset(nioEvent, lastDispatchTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unschedAlarmEv(IEmxAlarmEvent event) throws EEmxNotOwnerException, EEmxNotScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioAlarmEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioAlarmEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != this) {
                throw new EEmxNotScheduledException();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Unscheduling alarm event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioAlarmEvent nioEvent = (EmxNioAlarmEvent)event;
        boolean removed = false;
        removed = this.waitqa.remove(nioEvent);
        if (removed) {
            --this.stats.numAlarmEvWait;
        } else if (this.threaded) {
            EmxNioDispatcher emxNioDispatcher = this;
            synchronized (emxNioDispatcher) {
                removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
                if (removed) {
                    --this.stats.numAlarmEvReady;
                }
            }
        } else {
            removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
            if (removed) {
                --this.stats.numAlarmEvReady;
            }
        }
        if (!removed && (removed = nioEvent.head == this.dispatchq)) {
            if (this.tracer.debug) {
                this.tracer.log("Removing event " + nioEvent + " from the dispatch queue", Tracer.Level.DEBUG);
            }
            nioEvent.unlink();
        }
        if (!removed) {
            throw new InternalError("A schedule alarm event [" + event + "] was not found in the wait, ready or dispatch queue!");
        }
        nioEvent.setDispatcher(null);
    }

    @Override
    public final void forceSchedNwReadyEvAsCritical() {
        this.forceSchedNwReadyEvAsCritical = true;
    }

    @Override
    public final boolean isForceSchedNwReadyEvAsCritical() {
        return this.forceSchedNwReadyEvAsCritical;
    }

    @Override
    public final void clearForceSchedNwReadyEvAsCritical() {
        this.forceSchedNwReadyEvAsCritical = false;
    }

    @Override
    public final void schedNwAcceptReadyEv(IEmxNwAcceptReadyEvent event) throws EEmxNotOwnerException, EEmxAlreadyScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioNwAcceptReadyEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioNwAcceptReadyEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != null) {
                throw new EEmxAlreadyScheduledException();
            }
            if (((EmxNioNwAcceptReadyEvent)event).getChannel() == null) {
                throw new IllegalArgumentException("Event not generated by a network link");
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Scheduling network accept ready event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioNwAcceptReadyEvent nioEvent = (EmxNioNwAcceptReadyEvent)event;
        if (this.forceSchedNwReadyEvAsCritical) {
            nioEvent.setCritical(true);
        }
        if (this.params.getTimestampEvents()) {
            nioEvent.setScheduleTime(System.currentTimeMillis());
        }
        nioEvent.setDispatcher(this);
        this.waitqn.add(nioEvent);
        ++this.stats.numNwAcceptReadyEvSched;
        ++this.stats.numNwAcceptReadyEvWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unschedNwAcceptReadyEv(IEmxNwAcceptReadyEvent event) throws EEmxNotOwnerException, EEmxNotScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioNwAcceptReadyEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioNwAcceptReadyEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != this) {
                throw new EEmxNotScheduledException();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Unscheduling network accept ready event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioNwAcceptReadyEvent nioEvent = (EmxNioNwAcceptReadyEvent)event;
        boolean removed = false;
        removed = this.waitqn.remove(nioEvent);
        if (removed) {
            --this.stats.numNwAcceptReadyEvWait;
        } else if (this.threaded) {
            EmxNioDispatcher emxNioDispatcher = this;
            synchronized (emxNioDispatcher) {
                removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
                if (removed) {
                    --this.stats.numNwAcceptReadyEvReady;
                }
            }
        } else {
            removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
            if (removed) {
                --this.stats.numNwAcceptReadyEvReady;
            }
        }
        if (!removed && (removed = nioEvent.head == this.dispatchq)) {
            if (this.tracer.debug) {
                this.tracer.log("Removing event " + nioEvent + " from the dispatch queue", Tracer.Level.DEBUG);
            }
            nioEvent.unlink();
        }
        if (!removed) {
            throw new InternalError("A schedule network accept ready event [" + event + " ] was not found in the wait, ready or dispatch queue!");
        }
        nioEvent.setDispatcher(null);
    }

    @Override
    public final void schedNwConnectReadyEv(IEmxNwConnectReadyEvent event) throws EEmxNotOwnerException, EEmxAlreadyScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioNwConnectReadyEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioNwConnectReadyEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != null) {
                throw new EEmxAlreadyScheduledException();
            }
            if (((EmxNioNwConnectReadyEvent)event).getChannel() == null) {
                throw new IllegalArgumentException("Event not generated by a network link");
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Scheduling network connect ready event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioNwConnectReadyEvent nioEvent = (EmxNioNwConnectReadyEvent)event;
        if (this.forceSchedNwReadyEvAsCritical) {
            nioEvent.setCritical(true);
        }
        if (this.params.getTimestampEvents()) {
            nioEvent.setScheduleTime(System.currentTimeMillis());
        }
        nioEvent.setDispatcher(this);
        this.waitqn.add(nioEvent);
        ++this.stats.numNwConnectReadyEvSched;
        ++this.stats.numNwConnectReadyEvWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unschedNwConnectReadyEv(IEmxNwConnectReadyEvent event) throws EEmxNotOwnerException, EEmxNotScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioNwConnectReadyEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioNwConnectReadyEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != this) {
                throw new EEmxNotScheduledException();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Unscheduling network connect ready event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioNwConnectReadyEvent nioEvent = (EmxNioNwConnectReadyEvent)event;
        boolean removed = false;
        removed = this.waitqn.remove(nioEvent);
        if (removed) {
            --this.stats.numNwConnectReadyEvWait;
        } else if (this.threaded) {
            EmxNioDispatcher emxNioDispatcher = this;
            synchronized (emxNioDispatcher) {
                removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
                if (removed) {
                    --this.stats.numNwConnectReadyEvReady;
                }
            }
        } else {
            removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
            if (removed) {
                --this.stats.numNwConnectReadyEvReady;
            }
        }
        if (!removed && (removed = nioEvent.head == this.dispatchq)) {
            if (this.tracer.debug) {
                this.tracer.log("Removing event " + nioEvent + " from the dispatch queue", Tracer.Level.DEBUG);
            }
            nioEvent.unlink();
        }
        if (!removed) {
            throw new InternalError("A schedule network connect ready event [" + event + " ] was not found in the wait, ready or dispatch queue!");
        }
        nioEvent.setDispatcher(null);
    }

    @Override
    public final void schedNwReadReadyEv(IEmxNwReadReadyEvent event) throws EEmxNotOwnerException, EEmxAlreadyScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioNwReadReadyEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioNwReadReadyEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != null) {
                throw new EEmxAlreadyScheduledException();
            }
            if (((EmxNioNwReadReadyEvent)event).getChannel() == null) {
                throw new IllegalArgumentException("Event not generated by a network link");
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Scheduling network read ready event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioNwReadReadyEvent nioEvent = (EmxNioNwReadReadyEvent)event;
        if (this.forceSchedNwReadyEvAsCritical) {
            nioEvent.setCritical(true);
        }
        if (this.params.getTimestampEvents()) {
            nioEvent.setScheduleTime(System.currentTimeMillis());
        }
        nioEvent.setDispatcher(this);
        this.waitqn.add(nioEvent);
        ++this.stats.numNwReadReadyEvSched;
        ++this.stats.numNwReadReadyEvWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unschedNwReadReadyEv(IEmxNwReadReadyEvent event) throws EEmxNotOwnerException, EEmxNotScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioNwReadReadyEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioNwReadReadyEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != this) {
                throw new EEmxNotScheduledException();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Unscheduling network read ready event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioNwReadReadyEvent nioEvent = (EmxNioNwReadReadyEvent)event;
        boolean removed = false;
        removed = this.waitqn.remove(nioEvent);
        if (removed) {
            --this.stats.numNwReadReadyEvWait;
        } else if (this.threaded) {
            EmxNioDispatcher emxNioDispatcher = this;
            synchronized (emxNioDispatcher) {
                removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
                if (removed) {
                    --this.stats.numNwReadReadyEvReady;
                }
            }
        } else {
            removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
            if (removed) {
                --this.stats.numNwReadReadyEvReady;
            }
        }
        if (!removed && (removed = nioEvent.head == this.dispatchq)) {
            if (this.tracer.debug) {
                this.tracer.log("Removing event " + nioEvent + " from the dispatch queue", Tracer.Level.DEBUG);
            }
            nioEvent.unlink();
        }
        if (!removed) {
            throw new InternalError("A schedule network read ready event [" + event + " ] was not found in the wait, ready or dispatch queue!");
        }
        nioEvent.setDispatcher(null);
    }

    @Override
    public final void schedNwWriteReadyEv(IEmxNwWriteReadyEvent event) throws EEmxNotOwnerException, EEmxAlreadyScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioNwWriteReadyEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioNwWriteReadyEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != null) {
                throw new EEmxAlreadyScheduledException();
            }
            if (((EmxNioNwWriteReadyEvent)event).getChannel() == null) {
                throw new IllegalArgumentException("Event not generated by a network link");
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Scheduling network write ready event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioNwWriteReadyEvent nioEvent = (EmxNioNwWriteReadyEvent)event;
        if (this.forceSchedNwReadyEvAsCritical) {
            nioEvent.setCritical(true);
        }
        if (this.params.getTimestampEvents()) {
            nioEvent.setScheduleTime(System.currentTimeMillis());
        }
        nioEvent.setDispatcher(this);
        this.waitqn.add(nioEvent);
        ++this.stats.numNwWriteReadyEvSched;
        ++this.stats.numNwWriteReadyEvWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unschedNwWriteReadyEv(IEmxNwWriteReadyEvent event) throws EEmxNotOwnerException, EEmxNotScheduledException {
        if (this.checked) {
            if (event == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (!(event instanceof EmxNioNwWriteReadyEvent)) {
                throw new IllegalArgumentException("Event must be of type 'EmxNioNwWriteReadyEvent'");
            }
            if (Thread.currentThread() != this.owner) {
                throw new EEmxNotOwnerException();
            }
            if (event.getDispatcher() != this) {
                throw new EEmxNotScheduledException();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Unscheduling network write ready event " + event + "...", Tracer.Level.DEBUG);
        }
        EmxNioNwWriteReadyEvent nioEvent = (EmxNioNwWriteReadyEvent)event;
        boolean removed = false;
        removed = this.waitqn.remove(nioEvent);
        if (removed) {
            --this.stats.numNwWriteReadyEvWait;
        } else if (this.threaded) {
            EmxNioDispatcher emxNioDispatcher = this;
            synchronized (emxNioDispatcher) {
                removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
                if (removed) {
                    --this.stats.numNwWriteReadyEvReady;
                }
            }
        } else {
            removed = this.readyq.remove(nioEvent, nioEvent.getPriority());
            if (removed) {
                --this.stats.numNwWriteReadyEvReady;
            }
        }
        if (!removed && (removed = nioEvent.head == this.dispatchq)) {
            if (this.tracer.debug) {
                this.tracer.log("Removing event " + nioEvent + " from the dispatch queue", Tracer.Level.DEBUG);
            }
            nioEvent.unlink();
        }
        if (!removed) {
            throw new InternalError("A schedule network write ready event [" + event + " ] was not found in the wait, ready or dispatch queue!");
        }
        nioEvent.setDispatcher(null);
    }

    @Override
    public final void schedEv(IEmxEvent event) throws EEmxNotOwnerException, EEmxNotScheduledException {
        switch (event.getType()) {
            case USER: {
                this.schedUserEv((IEmxUserEvent)event);
                break;
            }
            case ALARM: {
                this.schedAlarmEv((IEmxAlarmEvent)event);
                break;
            }
            case NW_ACCEPT_READY: {
                this.schedNwAcceptReadyEv((IEmxNwAcceptReadyEvent)event);
                break;
            }
            case NW_CONNECT_READY: {
                this.schedNwConnectReadyEv((IEmxNwConnectReadyEvent)event);
                break;
            }
            case NW_READ_READY: {
                this.schedNwReadReadyEv((IEmxNwReadReadyEvent)event);
                break;
            }
            case NW_WRITE_READY: {
                this.schedNwWriteReadyEv((IEmxNwWriteReadyEvent)event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event type [" + (Object)((Object)event.getType()) + "]");
            }
        }
    }

    @Override
    public final void unschedEv(IEmxEvent event) throws EEmxNotOwnerException, EEmxNotScheduledException {
        switch (event.getType()) {
            case ALARM: {
                this.unschedAlarmEv((IEmxAlarmEvent)event);
                break;
            }
            case NW_ACCEPT_READY: {
                this.unschedNwAcceptReadyEv((IEmxNwAcceptReadyEvent)event);
                break;
            }
            case NW_CONNECT_READY: {
                this.unschedNwConnectReadyEv((IEmxNwConnectReadyEvent)event);
                break;
            }
            case NW_READ_READY: {
                this.unschedNwReadReadyEv((IEmxNwReadReadyEvent)event);
                break;
            }
            case NW_WRITE_READY: {
                this.unschedNwWriteReadyEv((IEmxNwWriteReadyEvent)event);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event type [" + (Object)((Object)event.getType()) + "]");
            }
        }
    }

    @Override
    public final int run(int timeout) throws EEmxNotOwnerException {
        if (this.owner == Thread.currentThread()) {
            int dispatched = 0;
            int triggered = 0;
            long timestamp = 0L;
            this.isInRun = true;
            if (this.tracer.debug) {
                this.tracer.log("Entering dispatcher run loop (timeout=" + timeout + ")...", Tracer.Level.DEBUG);
            }
            try {
                int n = timeout = timeout < 0 ? Integer.MAX_VALUE : timeout;
                do {
                    if (this.tracer.debug) {
                        this.tracer.log("Going through a dispatch interation (timeout=" + timeout + ")...", Tracer.Level.DEBUG);
                    }
                    if (timeout != Integer.MAX_VALUE) {
                        timestamp = System.nanoTime();
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Dispatching ready events...", Tracer.Level.DEBUG);
                    }
                    if ((dispatched = this.dispatchReadyEvents()) == 0 || this.waitqn.critCount() > 0) {
                        if (this.tracer.debug) {
                            this.tracer.log("Checking for ready network events in wait queue...", Tracer.Level.DEBUG);
                        }
                        triggered += this.procReadyNetworkEventsInWaitQ(dispatched > 0 ? 0 : Math.min(timeout, 1000));
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Checking for ready alarm events in wait queue...", Tracer.Level.DEBUG);
                    }
                    if ((triggered += this.procReadyAlarmEventsInWaitQ()) > 0) {
                        if (this.tracer.debug) {
                            this.tracer.log("Some events in wait queue have triggered. Dispatching ready events again...", Tracer.Level.DEBUG);
                        }
                        dispatched += this.dispatchReadyEvents();
                    }
                    if (dispatched > 0) {
                        if (this.tracer.debug) {
                            this.tracer.log("Some ready events have dispatched to user. Done.", Tracer.Level.DEBUG);
                        }
                        break;
                    }
                    if (timeout == Integer.MAX_VALUE) continue;
                    timeout = (int)((long)timeout - (System.nanoTime() - timestamp) / 1000000L);
                } while (timeout > 0);
            }
            catch (Throwable e) {
                if (!(e instanceof OutOfMemoryError)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Unhandled fault [" + e.toString() + "] encountered in dispatcher run loop. Stack trace:");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    sb.append("Throwing fatal error...");
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    throw new EEmxDispatcherFatalError(e);
                }
                throw (OutOfMemoryError)e;
            }
            finally {
                this.isInRun = false;
                if (this.tracer.debug) {
                    this.tracer.log("Exiting dispatcher run loop (dispatched=" + dispatched + ")...", Tracer.Level.DEBUG);
                }
            }
            return dispatched;
        }
        throw new EEmxNotOwnerException();
    }

    @Override
    public Object run(int timeout, IEmxDispatcherRunCompletionChecker completionChecker) throws EEmxNotOwnerException, EEmxTimeoutException, EEmxException {
        int remaining;
        long start;
        long current = start = timeout < 0 ? 0L : System.currentTimeMillis();
        int n = remaining = timeout < 0 ? -1 : timeout - (int)(current - start);
        while (completionChecker == null || !completionChecker.isDone()) {
            this.run(remaining);
            if (timeout < 0 || (remaining = timeout - (int)((current = System.currentTimeMillis()) - start)) > 0) continue;
            throw new EEmxTimeoutException();
        }
        try {
            return completionChecker.getCompletion();
        }
        catch (Exception e) {
            if (e instanceof EEmxException) {
                throw (EEmxException)((Object)e);
            }
            throw new EEmxException(e);
        }
    }

    @Override
    public final void flush() throws EEmxNotOwnerException {
        if (this.owner == Thread.currentThread()) {
            while (this.dispatchReadyEvents() > 0) {
            }
        } else {
            throw new EEmxNotOwnerException();
        }
    }

    @Override
    public final void close(boolean flush) throws EEmxNotOwnerException, EEmxException {
        if (!flush || this.owner == Thread.currentThread()) {
            if (flush) {
                this.flush();
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                throw new EEmxException(e);
            }
        } else {
            throw new EEmxNotOwnerException();
        }
        this.stats.close();
    }

    protected final void finalize() throws Exception {
        this.selector.close();
    }
}

