/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.neeve.io.IOBuffer;
import com.neeve.io.IONativePacket;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XIterator;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.StoreBinding;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.EPktLogCorruptException;
import com.neeve.pkt.log.EPktLogInvalidPositionException;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogMessageLogger;
import com.neeve.rog.RogObject;
import com.neeve.rog.log.RogLog;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RogMessageLog
extends RogObject
implements IRogMessageLogger {
    public static final String PROP_LOG_LOCATION = "storeRoot";
    public static final String PROP_LOG_MODE = "logMode";
    public static final String PROP_LOG_PRESENCE_EXPECTATION = "presenceExpectation";
    public static final String PROP_LOG_EMPTINESS_EXPECTATION = "emptinessExpectation";
    public static final String PROP_INTEGRITY_CHECK = "integrityCheck";
    public static final String PROP_AUTO_REPAIR = "autoRepair";
    public static final String PROP_INITIAL_LOG_LENGTH = "initialLogLength";
    public static final String PROP_ZERO_OUT_INITIAL = "zeroOutInitial";
    public static final String PROP_READ_BUFFER_SIZE = "readBufferSize";
    public static final String PROP_WRITE_BUFFER_SIZE = "writeBufferSize";
    public static final String PROP_PAGE_SIZE = "pageSize";
    public static final String PROP_FLUSH_ON_COMMIT = "flushOnCommit";
    public static final String PROP_FLUSH_USING_MAPPED_MEMORY = "flushUsingMappedMemory";
    public static final String PROP_DETACHED = "detachedPersist";
    public static final String PROP_DETACHED_QUEUE_DEPTH = "queueDepth";
    public static final String PROP_DETACHED_QUEUE_OFFER_STRATEGY = "queueOfferStrategy";
    public static final String PROP_DETACHED_QUEUE_WAIT_STRATEGY = "queueWaitStrategy";
    public static final String PROP_DETACHED_QUEUE_DRAINER_CPU_AFFINITIZATION_MASK = "queueDrainerCpuAffinityMask";
    private final PktPacket packet;
    private final RogLog log;
    private final PacketReceiver packetReceiver;
    private final AtomicBoolean readInProgress;
    private final StatsImpl stats;
    private PktRecoveryLog.MemoryMappedReader packetReader;
    private volatile IRogMessageLogger.ErrorHandler errorHandler;
    private volatile Throwable failure;

    private RogMessageLog(String name, Properties props) {
        try {
            this.packet = PktFactory.getInstance().createPacket(257);
            this.log = RogLog.create(name, this.preparePropsForRogLog(props)).setAsMessageLog();
            this.packetReceiver = new PacketReceiver();
            this.readInProgress = new AtomicBoolean();
            this.stats = new StatsImpl();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static final RogMessageLog create(String name, Properties props) {
        return new RogMessageLog(name, props);
    }

    public static final RogMessageLog create(String name) {
        return RogMessageLog.create(name, null);
    }

    private final Properties preparePropsForRogLog(Properties props) {
        Properties logProps = new Properties();
        if (props != null) {
            if (props.containsKey(PROP_LOG_LOCATION)) {
                logProps.setProperty(PROP_LOG_LOCATION, props.getProperty(PROP_LOG_LOCATION));
            }
            if (props.containsKey(PROP_LOG_MODE)) {
                logProps.setProperty(PROP_LOG_MODE, props.getProperty(PROP_LOG_MODE));
            }
            if (props.containsKey(PROP_LOG_PRESENCE_EXPECTATION)) {
                logProps.setProperty(PROP_LOG_PRESENCE_EXPECTATION, props.getProperty(PROP_LOG_PRESENCE_EXPECTATION));
            }
            if (props.containsKey(PROP_LOG_EMPTINESS_EXPECTATION)) {
                logProps.setProperty(PROP_LOG_EMPTINESS_EXPECTATION, props.getProperty(PROP_LOG_EMPTINESS_EXPECTATION));
            }
            if (props.containsKey(PROP_INTEGRITY_CHECK)) {
                logProps.setProperty(PROP_INTEGRITY_CHECK, props.getProperty(PROP_INTEGRITY_CHECK));
            }
            if (props.containsKey(PROP_AUTO_REPAIR)) {
                logProps.setProperty(PROP_AUTO_REPAIR, props.getProperty(PROP_AUTO_REPAIR));
            }
            if (props.containsKey(PROP_INITIAL_LOG_LENGTH)) {
                logProps.setProperty(PROP_INITIAL_LOG_LENGTH, props.getProperty(PROP_INITIAL_LOG_LENGTH));
            }
            if (props.containsKey(PROP_ZERO_OUT_INITIAL)) {
                logProps.setProperty(PROP_ZERO_OUT_INITIAL, props.getProperty(PROP_ZERO_OUT_INITIAL));
            }
            if (props.containsKey(PROP_READ_BUFFER_SIZE)) {
                logProps.setProperty(PROP_READ_BUFFER_SIZE, props.getProperty(PROP_READ_BUFFER_SIZE));
            }
            if (props.containsKey(PROP_WRITE_BUFFER_SIZE)) {
                logProps.setProperty(PROP_WRITE_BUFFER_SIZE, props.getProperty(PROP_WRITE_BUFFER_SIZE));
            }
            if (props.containsKey(PROP_PAGE_SIZE)) {
                logProps.setProperty(PROP_PAGE_SIZE, props.getProperty(PROP_PAGE_SIZE));
            }
            if (props.containsKey(PROP_FLUSH_ON_COMMIT)) {
                logProps.setProperty(PROP_FLUSH_ON_COMMIT, props.getProperty(PROP_FLUSH_ON_COMMIT));
            }
            if (props.containsKey(PROP_FLUSH_USING_MAPPED_MEMORY)) {
                logProps.setProperty(PROP_FLUSH_USING_MAPPED_MEMORY, props.getProperty(PROP_FLUSH_USING_MAPPED_MEMORY));
            }
            logProps.setProperty(PROP_DETACHED, "false");
        }
        logProps.setProperty("txnIntegrityCheck", "false");
        return logProps;
    }

    private final void dumpStackTraceBeforeFail(String str, Throwable e) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(str).append("\n");
            sb.append("Stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            sb.append("Failing logger...\n");
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final void fail(String str, Throwable cause, boolean rethrow) {
        this.dumpStackTraceBeforeFail(str, cause);
        this.failure = cause;
        IRogMessageLogger.ErrorHandler errorHandler = this.errorHandler;
        if (errorHandler != null) {
            errorHandler.onError(this.failure);
        }
        if (rethrow) {
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    @Override
    public final String getName() {
        return this.log.getName();
    }

    @Override
    public final void setErrorHandler(IRogMessageLogger.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final IRogMessageLogger.ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public final void open() throws Exception {
        this.log.open();
        this.packetReader = this.log.getPacketLog().createMemoryMappedReader((PktRecoveryLog.IPacketBufferReceiver)this.packetReceiver);
    }

    @Override
    public final boolean isOpen() {
        return this.log.isOpen();
    }

    @Override
    public final boolean wasRepaired() {
        return this.log.wasRepaired();
    }

    @Override
    public final IRogMessageLogger.Stats getStats() {
        return this.stats;
    }

    @Override
    public final boolean isReadInProgress() {
        return this.readInProgress.get();
    }

    @Override
    public final IRogMessage readAt(long pos) {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (pos < 0L) {
            throw new IllegalArgumentException("pos must be >= 0");
        }
        if (!this.readInProgress.compareAndSet(false, true)) {
            throw new IllegalStateException("read already in progress");
        }
        try {
            this.packetReceiver.init(null);
            try {
                this.packetReader.readAt(pos);
                IRogMessage iRogMessage = this.packetReceiver.message;
                return iRogMessage;
            }
            catch (EPktLogInvalidPositionException e) {
                try {
                    throw new IllegalArgumentException("invalid position '" + pos + "'");
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        finally {
            this.readInProgress.set(false);
        }
    }

    @Override
    public final IRogMessage readOne() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (!this.readInProgress.compareAndSet(false, true)) {
            throw new IllegalStateException("read already in progress");
        }
        try {
            this.packetReceiver.init(null);
            this.packetReader.readOne();
            IRogMessage iRogMessage = this.packetReceiver.message;
            return iRogMessage;
        }
        finally {
            this.readInProgress.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void readFrom(long pos, IRogMessageLogger.IMessageReceiver receiver) {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (pos < 0L) {
            throw new IllegalArgumentException("pos must be >= 0");
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        if (!this.readInProgress.compareAndSet(false, true)) {
            throw new IllegalStateException("read already in progress");
        }
        try {
            this.packetReceiver.init(receiver);
            try {
                if (pos == 0L) {
                    this.packetReader.reset();
                } else if (!this.packetReader.isValidAt(pos)) {
                    throw new IllegalArgumentException("invalid position '" + pos + "'");
                }
                this.packetReader.read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.readInProgress.set(false);
        }
    }

    @Override
    public final void read(IRogMessageLogger.IMessageReceiver receiver) {
        this.readFrom(0L, receiver);
    }

    @Override
    public final void stopRead() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (!this.readInProgress.get()) {
            throw new IllegalStateException("read not in progress");
        }
        try {
            this.packetReader.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public final long getPositionInLog(IRogMessage message) {
        MessageLogInfo messageLogInfo = (MessageLogInfo)message.getTag(7);
        if (messageLogInfo == null) {
            throw new IllegalArgumentException("message was not read using the message logger");
        }
        return messageLogInfo.positionInLog;
    }

    @Override
    public final int getSizeInLog(IRogMessage message) {
        MessageLogInfo messageLogInfo = (MessageLogInfo)message.getTag(7);
        if (messageLogInfo == null) {
            throw new IllegalArgumentException("message was not read using the message logger");
        }
        return messageLogInfo.sizeInLog;
    }

    @Override
    public final void log(IRogMessage message, boolean commitStart, boolean commitEnd, boolean sync) {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        try {
            message.serializeTo(this.packet);
            StoreBinding.prepareStorePacketHeader(message, this.packet, IStoreBinding.Operation.Send, message.getOid(), message.getOfid(), message.getObjectType(), message.getTransactionId(), message.getStableTransactionId(), message.getCheckpointVersion(), message.getContentEncodingType(), commitStart, commitEnd, null);
            this.packet.sync();
            this.log.getPacketLog().write(this.packet, 0);
            ++this.stats.numMessagesLogged;
            if (commitEnd || sync) {
                if (commitEnd) {
                    ++this.stats.numCommits;
                }
                if (sync || this.log.getParameters().isFlushOnCommit()) {
                    this.log.getPacketLog().flush(sync ? 1 : 0);
                }
            }
        }
        catch (Throwable e) {
            this.fail("message logging failure", e, true);
        }
    }

    @Override
    public final void log(IRogMessage message, boolean commitStart, boolean commitEnd) {
        this.log(message, commitStart, commitEnd, false);
    }

    @Override
    public final void log(IRogMessage message) {
        this.log(message, true, true);
    }

    @Override
    public final void flush(boolean sync) {
        if (this.failure != null) {
            throw new RuntimeException(this.failure);
        }
        try {
            this.log.getPacketLog().flush(sync ? 1 : 0);
        }
        catch (Throwable e) {
            this.fail("log flush failure", e, true);
        }
    }

    public final void fail(Exception cause) {
        this.fail("force fail", cause, false);
    }

    @Override
    public final void delete() throws IOException {
        this.log.delete();
    }

    @Override
    public final void close() {
        this.packetReader.close();
        this.packetReceiver.close();
        this.log.close();
        this.stats.close();
    }

    private final class StatsImpl
    extends Stats
    implements IRogMessageLogger.Stats {
        private final NumberFormat format;
        private long startTime;
        private long deltaStartTime;
        private long numMessagesLoggedLast;
        private long numCommitsLast;
        private long numFlushesImplicitLast;
        private long numFlushesExplicitLast;
        long numMessagesLogged;
        long numCommits;
        long numFlushesImplicit;
        long numFlushesExplicit;
        final Stats.LatencyManager o2p;

        StatsImpl() {
            super("nv.rog.log", RogMessageLog.this.log.getName(), "nv.rog.log.stats", "nv.rog.log." + RogMessageLog.this.log.getName() + ".stats.interval");
            this.o2p = new Stats.LatencyManager("o2p");
            this.format = NumberFormat.getInstance();
            this.format.setMaximumFractionDigits(2);
            this.startPeriodicOutputIfConfigured();
        }

        private final void stamp() {
            this.deltaStartTime = System.currentTimeMillis();
            this.numMessagesLoggedLast = this.numMessagesLogged;
            this.numCommitsLast = this.numCommits;
            this.numFlushesImplicitLast = this.numFlushesImplicit;
            this.numFlushesExplicitLast = this.numFlushesExplicit;
        }

        protected final void init() {
            this.startTime = System.currentTimeMillis();
            this.stamp();
        }

        public final void get(StringBuilder sb) {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - this.deltaStartTime;
            long deltaTotalTime = currentTime - this.startTime;
            long numMessagesLoggedCurrent = this.numMessagesLogged;
            long numCommitsCurrent = this.numCommits;
            long numFlushesImplicitCurrent = this.numFlushesImplicit;
            long numFlushesExplicitCurrent = this.numFlushesExplicit;
            String numMessagesLoggedStr = this.format.format(numMessagesLoggedCurrent);
            String deltaNumMessagesLoggedStr = this.format.format(numMessagesLoggedCurrent - this.numMessagesLoggedLast);
            String messageLogRateStr = this.format.format(numMessagesLoggedCurrent * 1000L / deltaTotalTime);
            String deltaMessageLogRateStr = this.format.format((numMessagesLoggedCurrent - this.numMessagesLoggedLast) * 1000L / deltaTime);
            String numCommitsStr = this.format.format(numCommitsCurrent);
            String deltaNumCommitsStr = this.format.format(numCommitsCurrent - this.numCommitsLast);
            String commitRateStr = this.format.format(numCommitsCurrent * 1000L / deltaTotalTime);
            String deltaCommitRateStr = this.format.format((numCommitsCurrent - this.numCommitsLast) * 1000L / deltaTime);
            String numFlushesImplicitStr = this.format.format(numFlushesImplicitCurrent);
            String deltaNumFlushesImplicitStr = this.format.format(numFlushesImplicitCurrent - this.numFlushesImplicitLast);
            String flushImplicitRateStr = this.format.format(numFlushesImplicitCurrent * 1000L / deltaTotalTime);
            String deltaFlushImplicitRateStr = this.format.format((numFlushesImplicitCurrent - this.numFlushesImplicitLast) * 1000L / deltaTime);
            String numFlushesExplicitStr = this.format.format(numFlushesExplicitCurrent);
            String deltaNumFlushesExplicitStr = this.format.format(numFlushesExplicitCurrent - this.numFlushesExplicitLast);
            String flushExplicitRateStr = this.format.format(numFlushesExplicitCurrent * 1000L / deltaTotalTime);
            String deltaFlushExplicitRateStr = this.format.format((numFlushesExplicitCurrent - this.numFlushesExplicitLast) * 1000L / deltaTime);
            int disruptorCapacityCurrent = this.getDisruptorCapacity();
            int disruptorRemainingCurrent = this.getDisruptorRemaining();
            int disruptorUsedCurrent = disruptorCapacityCurrent - disruptorRemainingCurrent;
            int disruptorUsagePctCurrent = disruptorCapacityCurrent > 0 ? disruptorUsedCurrent * 100 / disruptorCapacityCurrent : 0;
            String disruptorCapacityStr = this.format.format(disruptorCapacityCurrent);
            String disruptorUsedStr = this.format.format(disruptorUsedCurrent);
            String disruptorUsagePctStr = this.format.format(disruptorUsagePctCurrent);
            String claimStrategyStr = this.getDisruptorClaimStrategy();
            String waitStrategyStr = this.getDisruptorWaitStrategy();
            this.o2p.compute();
            sb.append("Log {");
            sb.append(numMessagesLoggedStr).append("(").append(messageLogRateStr).append(" ").append(deltaMessageLogRateStr).append(")");
            sb.append("} ");
            sb.append("Commits {");
            sb.append(numCommitsStr).append("(").append(commitRateStr).append(" ").append(deltaCommitRateStr).append(")");
            sb.append("} ");
            sb.append("Flushes {");
            sb.append(numFlushesImplicitStr).append("(").append(flushImplicitRateStr).append(" ").append(deltaFlushImplicitRateStr).append("), ").append(numFlushesExplicitStr).append("(").append(flushExplicitRateStr).append(" ").append(deltaFlushExplicitRateStr);
            sb.append("} ");
            sb.append("Disruptor (").append(claimStrategyStr).append(", ").append(waitStrategyStr).append(") {");
            sb.append("[").append(disruptorUsedStr).append(" of ").append(disruptorCapacityStr).append("] ").append(disruptorUsagePctStr).append("%");
            sb.append("}").append("\n");
            this.o2p.get(sb);
            this.stamp();
        }

        @Override
        public final long getNumMessagesLogged() {
            return this.numMessagesLogged;
        }

        @Override
        public final long getNumCommits() {
            return this.numCommits;
        }

        @Override
        public final long getNumFlushesImplicit() {
            return this.numFlushesImplicit;
        }

        @Override
        public final long getNumFlushesExplicit() {
            return this.numFlushesExplicit;
        }

        @Override
        public final boolean isDetached() {
            return false;
        }

        @Override
        public final int getDisruptorCapacity() {
            return 0;
        }

        @Override
        public final int getDisruptorRemaining() {
            return 0;
        }

        @Override
        public final String getDisruptorClaimStrategy() {
            return null;
        }

        @Override
        public final String getDisruptorWaitStrategy() {
            return null;
        }

        @Override
        public final IStats.Latencies getOfferToPollLatencies() {
            return null;
        }

        @Override
        public final long getFileSize() {
            if (RogMessageLog.this.isOpen()) {
                try {
                    return RogMessageLog.this.log.getPacketLog().getAllocatedSize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return -1L;
        }

        @Override
        public final long getFileSizeUsed() {
            if (RogMessageLog.this.isOpen()) {
                try {
                    return RogMessageLog.this.log.getPacketLog().getSize();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return -1L;
        }
    }

    private final class PacketReceiver
    implements PktRecoveryLog.IPacketBufferReceiver {
        private final IONativePacket packet = new IONativePacket();
        private final XIntLinkedHashMap<IRogMessage> cache = new XIntLinkedHashMap();
        private final MessageLogInfo messageLogInfo;
        private IRogMessageLogger.IMessageReceiver receiver;
        private IRogMessage message;

        PacketReceiver() {
            this.messageLogInfo = new MessageLogInfo();
        }

        private final int key(short vfid, short mtype) {
            return vfid << 16 | mtype;
        }

        final PacketReceiver init(IRogMessageLogger.IMessageReceiver receiver) {
            this.receiver = receiver;
            this.message = null;
            return this;
        }

        final void close() {
            XIterator iterator = this.cache.reuseableValueIterator();
            while (iterator.hasNext()) {
                ((IRogMessage)iterator.next()).dispose();
            }
            this.cache.clear();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void onPacket(IOBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
            long bufferAddr = buffer.getNativeAddress();
            int odsSubheaderPosition = PktHeader.getSubheaderOffset((long)bufferAddr, (int)bufferPosition, (int)7);
            if (odsSubheaderPosition < 0) {
                throw new EPktLogCorruptException("missing ODS subheader");
            }
            short vfid = PktSubheaderODS.getObjectFactoryId((long)bufferAddr, (int)odsSubheaderPosition);
            short mtype = PktSubheaderODS.getObjectType((long)bufferAddr, (int)odsSubheaderPosition);
            short cenc = PktSubheaderODS.getContentEncodingType((long)bufferAddr, (int)odsSubheaderPosition);
            int headersSerializedLength = PktHeader.getSerializedLength((long)bufferAddr, (int)bufferPosition);
            int bodyPosition = bufferPosition + headersSerializedLength;
            int bodyLength = packetLength - headersSerializedLength;
            int key = this.key(vfid, mtype);
            this.message = (IRogMessage)this.cache.get(key);
            if (this.message == null) {
                MessageViewFactory factory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory(vfid);
                if (factory == null) {
                    throw new RuntimeException("message view factory '" + vfid + "' is not registered");
                }
                MessageView view = factory.wrap(mtype, (int)cenc, (Object)this.packet.init(bufferAddr, bodyPosition, bodyLength));
                if (!(view instanceof IRogMessage)) throw new RuntimeException("message ('class=" + view.getClass().getName() + "') in the log is not of IRogMessage type");
                this.message = (IRogMessage)view;
                this.cache.put(key, (Object)this.message);
                this.message.setTag(7, this.messageLogInfo);
            } else {
                this.message.deserializeFrom(bufferAddr, bodyPosition, bodyLength);
            }
            this.messageLogInfo.positionInLog = filePosition;
            this.messageLogInfo.sizeInLog = packetLength;
            if (this.receiver == null) return;
            this.receiver.handleMessage(this.message);
        }

        public final void onBufferChange(IOBuffer from, IOBuffer to) {
        }
    }

    private final class MessageLogInfo {
        long positionInLog;
        int sizeInLog;

        private MessageLogInfo() {
        }
    }
}

