/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.google.common.collect.Maps;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.config.Config;
import com.neeve.config.ConfigTool;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.query.impl.util.UtlQueryReflection;
import com.neeve.query.index.IdxField;
import com.neeve.rog.IRogJsonizable;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogContainerNode;
import com.neeve.rog.impl.RogRootNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogQueryResultSet;
import com.neeve.rog.log.RogLogReader;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sto.StoTypeFactoryRegistry;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDistinctProxy;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlJar;
import com.neeve.util.UtlObjectGraph;
import com.neeve.util.UtlTableFormatter;
import com.neeve.util.UtlText;
import com.neeve.util.UtlTime;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.compress.utils.IOUtils;

public class RogLogUtil {
    public static final String DIVERGENCE_FILTERS_RESOUCE_PATH = "META-INF/com/neeve/rog/divergence.filters";
    public static final String JSON_CUSTOM_PRETTY_PRINTER_PROP = "nv.json.customPrettyPrinter";
    public static final String JSON_SORT_PROPERTIES_ALPHABETICALLY_PROP = "nv.json.sortAlphabetically";
    static final boolean JSON_SORT_PROPERTIES_ALPHABETICALLY = Config.getValue((String)"nv.json.sortAlphabetically", (boolean)true);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String ARCHIVED_LOG_PATH = "x-archived-logs";
    private static final String ARCHIVED_EXTRA_PATH = "x-archived-extra";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final String JSON_ROG_COLLECTION_FILTER_ID = "CollectionFilter";
    private static final String JSON_ENTITY_FILTER_ID = "EntityFilter";
    private static final String JSONLOG_ENTRY_FILTER_ID = "LogEntryFilter";
    private static final SimpleFilterProvider jsonLogEntryObjectFilter = new SimpleFilterProvider();
    private static final SimpleFilterProvider jsonHasFieldsFilter = new SimpleFilterProvider();
    private static final SimpleFilterProvider jsonUnfilteredFilter = new SimpleFilterProvider();
    private static final HashSet<Class<?>> jsonBitMaskMethodChecked = new HashSet();
    private static final HashMap<Class<?>, Method> jsonBitMaskSyncMethods = new HashMap();
    private static final HashMap<String, PrettyPrinter> jsonCustomPrettyPrinters = new HashMap();
    private static final DefaultPrettyPrinter jsonDefaultPrettyPrinter = new DefaultPrettyPrinter();
    private static final MinimalPrettyPrinter jsonMinimalPrettyPrinter = new MinimalPrettyPrinter();
    private static final MinimalPrettyPrinter jsonSingleLinePrettyPrinter = new MinimalPrettyPrinter(){
        private static final long serialVersionUID = 1L;

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw(": ");
        }
    };
    private static final ThreadLocal<ReusableStringWriter> TRACE_WRITERS = new ThreadLocal();
    private static HashSet<Class<?>> cachedComparisonInterfaces;
    private static HashSet<String> cachedComparisonInterfaceSources;

    public static File createExecutableArchive(File archiveFolder, String archiveName, PrintStream out, Tracer tracer, RogLog ... logs) throws Exception {
        return RogLogUtil.createExecutableArchive(archiveFolder, archiveName, out, tracer, null, logs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createExecutableArchive(File archiveFolder, String archiveName, PrintStream out, Tracer tracer, List<String> additionalContent, RogLog ... logs) throws Exception {
        String archiveTimestamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
        archiveName = archiveName + "-" + archiveTimestamp;
        if (logs == null || logs.length == 0) {
            throw new IllegalArgumentException("No logs were specified. You must specify at least one to include in the archive");
        }
        File jarArchive = new File(archiveFolder, archiveName + ".jar");
        File archiveTempFolder = new File(archiveFolder, "." + archiveName + ".tmp");
        archiveTempFolder.mkdirs();
        try {
            File systemXCS;
            StringBuilder archiveLogManifest = new StringBuilder();
            File rdatArchiveFolder = new File(archiveTempFolder, ARCHIVED_LOG_PATH);
            rdatArchiveFolder.mkdirs();
            for (RogLog log : logs) {
                if (out != null) {
                    out.println("Archiving " + log.getName() + "...");
                }
                File archived = log.archive(rdatArchiveFolder, archiveTimestamp);
                archiveLogManifest.append(UtlFile.relativePath((File)archiveTempFolder, (File)archived)).append("\n");
            }
            if (additionalContent != null && !additionalContent.isEmpty()) {
                if (out != null) {
                    out.println("Adding additional content...");
                }
                File archiveAdditionalRoot = new File(archiveTempFolder, ARCHIVED_EXTRA_PATH);
                archiveAdditionalRoot.mkdirs();
                for (String additional : additionalContent) {
                    String[] keyValue = additional.split("=");
                    if (keyValue.length != 2) {
                        throw new IllegalArgumentException("Invalid key/value pair for additional archive content. Expected <archive-target-path>=<source-file-or-dir> but got: " + additional);
                    }
                    File targetDir = new File(archiveAdditionalRoot, keyValue[0]);
                    File source = new File(keyValue[1]);
                    if (out != null) {
                        out.println("Archiving '" + keyValue[1] + "'...");
                    }
                    if (source.isDirectory()) {
                        UtlFile.copyDirectory((File)source, (File)new File(targetDir, source.getName()));
                        continue;
                    }
                    UtlFile.copyFile((File)source, (File)new File(targetDir, source.getName()));
                }
            }
            if (out != null) {
                out.println("Writing archive metadata...");
            }
            if (out != null) {
                out.println("Extracting classpath...");
            }
            UtlJar.extractClasspathToDirectory((ClassLoader)RogLogUtil.class.getClassLoader(), (File)archiveTempFolder);
            ProductInfo info = ManifestProductInfo.loadProductInfo((String)"nvx-rumi-ods");
            StringBuilder sb = new StringBuilder();
            sb.append("Manifest-Version: 1.0\n");
            sb.append("Specification-Title: ").append(info.getProductName()).append("\n");
            sb.append("Specification-Version: ").append(info.getComponentVersionString()).append("\n");
            sb.append("Specification-Vendor: ").append(info.getVendorName()).append("\n");
            sb.append("Implementation-Title: ").append(info.getProductName()).append("\n");
            sb.append("Implementation-Version: ").append(info.getComponentVersionString()).append("\n");
            sb.append("Implementation-Vendor: ").append(info.getVendorName()).append("\n");
            sb.append("Main-Class: com.neeve.tools.TransactionLogTool\n");
            String manifest = sb.toString();
            File manifestFile = new File(archiveTempFolder, "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                manifestFile.delete();
            }
            manifestFile.getParentFile().mkdirs();
            manifestFile.createNewFile();
            try (FileOutputStream fos = new FileOutputStream(manifestFile);){
                fos.write(manifest.getBytes("utf-8"));
            }
            File archiveContents = new File(archiveTempFolder, "META-INF/x-archived-logs.mf");
            if (archiveContents.exists()) {
                archiveContents.delete();
            }
            manifestFile.createNewFile();
            fos = new FileOutputStream(archiveContents);
            try {
                fos.write(archiveLogManifest.toString().getBytes("utf-8"));
            }
            finally {
                fos.close();
            }
            if (out != null) {
                out.println("Writing embedded archive config repository...");
            }
            if ((systemXCS = new File(archiveTempFolder, "META-INF/system.xcs")).exists()) {
                systemXCS.delete();
            }
            ConfigTool tool = new ConfigTool(Config.getRepository(), Tracer.Level.WARNING);
            tool.run((InputStream)new ByteArrayInputStream(("repo_scriptify " + systemXCS.getAbsolutePath()).getBytes()));
            if (out != null) {
                out.println("Creating archive jar...");
            }
            UtlJar.jar((File)archiveTempFolder, (File)jarArchive);
        }
        finally {
            UtlFile.deleteDirectory((File)archiveTempFolder);
        }
        return jarArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> extractArchivedLogs(PrintStream out, File extractionFolder) throws IOException {
        URL codeSource = RogLogUtil.class.getProtectionDomain().getCodeSource().getLocation();
        URL archivedLogManifest = RogLogUtil.class.getClassLoader().getResource("META-INF/x-archived-logs.mf");
        if (archivedLogManifest != null) {
            if (!codeSource.getPath().endsWith(".jar")) {
                System.err.println("Not able to extract embedded archives from: " + codeSource);
            }
            out.println("Extracting archived logs from " + codeSource + "...");
            UtlJar.extractFolder((URL)codeSource, (String)ARCHIVED_LOG_PATH, (File)extractionFolder);
            out.println("Extracting any additional archive content " + codeSource + "...");
            UtlJar.extractFolder((URL)codeSource, (String)ARCHIVED_EXTRA_PATH, (File)extractionFolder);
            String[] logPaths = new String[]{};
            try (InputStream is = archivedLogManifest.openStream();){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)is, (OutputStream)baos);
                String manifest = new String(baos.toByteArray(), "utf-8");
                logPaths = manifest.split("\\n");
            }
            if (logPaths.length == 0) {
                return null;
            }
            ArrayList<File> extractedFiles = new ArrayList<File>(logPaths.length);
            for (String logPath : logPaths) {
                File extracted = new File(extractionFolder, logPath.substring(ARCHIVED_LOG_PATH.length() + 1));
                if (!extracted.exists()) {
                    System.err.println("Archived log file not found: " + extracted);
                    continue;
                }
                extractedFiles.add(extracted);
            }
            return extractedFiles;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean compareEntries(RogLog source, RogLog target, FieldFilter filter, BufferedWriter summary, int diffLimit, boolean metadata, boolean verbose, UtlTableFormatter.Format format) throws Exception {
        HashSet<Class<?>> comparisonInterfaces = RogLogUtil.getComparisonInterfaces(metadata);
        if (verbose) {
            System.out.println("Interfaces used for comparison: " + comparisonInterfaces);
        }
        if (source == null) throw new IllegalArgumentException("Source and target logs must be specified");
        if (target == null) {
            throw new IllegalArgumentException("Source and target logs must be specified");
        }
        if (source.getLogFile().equals(target.getLogFile())) {
            return true;
        }
        FilterComparisonFactory comparatorFactory = null;
        if (filter != null) {
            comparatorFactory = new FilterComparisonFactory(filter);
        }
        try (RogLogReader sourceReader = source.createReader();
             RogLogReader targetReader = target.createReader();){
            sourceReader.rewind();
            targetReader.rewind();
            RogLogReader.Entry sourceEntry = null;
            RogLogReader.Entry targetEntry = null;
            int entryCount = 0;
            int divergentEntryCount = 0;
            while (true) {
                sourceEntry = sourceReader.next();
                targetEntry = targetReader.next();
                if (sourceEntry == null && targetEntry == null) {
                    if (divergentEntryCount == 0) {
                        summary.append("Logs are not divergent ... " + entryCount + " entries compared");
                    } else {
                        summary.append("Logs are divergent ... found " + divergentEntryCount + " divergent entries out of " + entryCount + " entries compared");
                    }
                    summary.newLine();
                    summary.flush();
                    boolean bl = divergentEntryCount == 0;
                    return bl;
                }
                Date sourceTimestamp = null;
                if (sourceEntry != null && sourceEntry.getTimestamp() > 0L) {
                    sourceTimestamp = new Date(sourceEntry.getTimestamp());
                }
                Date targetTimestamp = null;
                if (targetEntry != null && targetEntry.getTimestamp() > 0L) {
                    targetTimestamp = new Date(targetEntry.getTimestamp());
                }
                if (sourceEntry == null) {
                    if (divergentEntryCount == 0) {
                        summary.append("Logs are not divergent, but '" + target.getLogFile() + " continues beyond '" + source.getLogFile() + "' after " + entryCount + " entries");
                    } else {
                        summary.append("Logs are divergent, and '" + target.getLogFile() + " continues beyond '" + source.getLogFile() + "' after " + entryCount + " entries");
                    }
                    if (targetTimestamp != null) {
                        summary.append(" at ").append(UtlTime.format((Date)targetTimestamp));
                    }
                    summary.newLine();
                    summary.flush();
                    boolean bl = false;
                    return bl;
                }
                if (targetEntry == null) {
                    if (divergentEntryCount == 0) {
                        summary.append("Logs are not divergent, but '" + source.getLogFile() + " continues beyond '" + target.getLogFile() + "' after " + entryCount + " entries");
                    } else {
                        summary.append("Logs are divergent, and '" + source.getLogFile() + " continues beyond '" + target.getLogFile() + "' after " + entryCount + " entries");
                    }
                    if (sourceTimestamp != null) {
                        summary.append(" at ").append(UtlTime.format((Date)sourceTimestamp));
                    }
                    summary.newLine();
                    summary.flush();
                    boolean bl = false;
                    return bl;
                }
                if (divergentEntryCount > diffLimit) {
                    summary.append("Logs are divergent ... summarized first " + divergentEntryCount + " divergent entries out of " + entryCount + " entries compared");
                    summary.flush();
                    boolean bl = false;
                    return bl;
                }
                ++entryCount;
                StringBuffer diffBuffer = new StringBuffer();
                boolean divergent = false;
                if (sourceEntry.getEntryType() != targetEntry.getEntryType()) {
                    diffBuffer.append("Source entry type " + (Object)((Object)sourceEntry.getEntryType()) + " doesn't match target entry type: " + (Object)((Object)targetEntry.getEntryType()));
                    divergent = true;
                }
                if (sourceEntry.getEntryType() == RogLogReader.Entry.Type.Remove) {
                    if (!UtlObjectGraph.deepApiEquals((Object)sourceEntry.getMetadata(), (Object)targetEntry.getMetadata(), (StringBuffer)diffBuffer, (UtlTableFormatter.Format)format, Arrays.asList(IRogMetadata.class), (UtlObjectGraph.ComparatorFactory)comparatorFactory)) {
                        divergent = true;
                    }
                } else if (!UtlObjectGraph.deepApiEquals((Object)sourceEntry.getObject(), (Object)targetEntry.getObject(), (StringBuffer)diffBuffer, (UtlTableFormatter.Format)format, comparisonInterfaces, (UtlObjectGraph.ComparatorFactory)comparatorFactory)) {
                    divergent = true;
                }
                if (!divergent) continue;
                summary.newLine();
                summary.append("DIVERGENT ENTRY DETECTED. LOG ENTRY #" + entryCount);
                ++divergentEntryCount;
                summary.newLine();
                summary.append("Source '").append(sourceEntry.getEntryType().toString()).append("' Entry");
                if (sourceEntry.getObject() != null) {
                    summary.append(", a ").append(sourceEntry.getObject().getClass().getSimpleName());
                }
                if (sourceEntry.getTimestamp() > 0L) {
                    summary.append(" logged at: " + UtlTime.format((Date)sourceTimestamp));
                }
                summary.newLine();
                summary.append("Target '").append(targetEntry.getEntryType().toString()).append("' Entry");
                if (targetEntry.getObject() != null) {
                    summary.append(", a ").append(targetEntry.getObject().getClass().getSimpleName());
                }
                if (targetEntry.getTimestamp() > 0L) {
                    summary.append(" logged at: " + UtlTime.format((Date)targetTimestamp));
                    summary.newLine();
                }
                summary.append(diffBuffer);
                summary.newLine();
                summary.flush();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static final boolean compareState(RogLog source, RogLog target, FieldFilter filter, BufferedWriter summary, boolean metadata, boolean verbose, UtlTableFormatter.Format format) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final boolean compareRogNodes(IRogNode node1, IRogNode node2, FieldFilter filter, StringBuffer diffBuffer) throws Exception {
        HashSet<Class<?>> comparisonInterfaces = RogLogUtil.getComparisonInterfaces(true);
        if (filter == null) {
            filter = RogLogUtil.loadComparisonFilter();
        }
        FilterComparisonFactory comparator = null;
        if (filter != null) {
            comparator = new FilterComparisonFactory(filter);
        }
        return UtlObjectGraph.deepApiEquals((Object)node1, (Object)node2, (StringBuffer)diffBuffer, (UtlTableFormatter.Format)UtlTableFormatter.Format.TABULAR, comparisonInterfaces, (UtlObjectGraph.ComparatorFactory)comparator);
    }

    private static void extractModelInterfaces(String factoryClass, HashSet<Class<?>> comparisonInterfaces) throws ClassNotFoundException {
        Class<?> factoryClazz = Class.forName(factoryClass);
        Package factoryPackage = factoryClazz.getPackage();
        for (Class<?> intf : RogLogUtil.getClassesForPackage(factoryClazz, factoryPackage)) {
            if (intf.isInterface()) {
                comparisonInterfaces.add(intf);
                continue;
            }
            if (IRogMetadata.class.isAssignableFrom(intf)) continue;
            try {
                intf.getMethod("serializeToNative", Long.TYPE, Integer.TYPE);
                comparisonInterfaces.add(intf);
            }
            catch (Exception exception) {}
        }
    }

    public static final FileBasedFieldFilter loadComparisonFilter() throws IOException {
        FileBasedFieldFilter filter = new FileBasedFieldFilter();
        Enumeration<URL> filterUrls = RogLogUtil.class.getClassLoader().getResources(DIVERGENCE_FILTERS_RESOUCE_PATH);
        while (filterUrls.hasMoreElements()) {
            URL filterUrl = filterUrls.nextElement();
            try (InputStream is = filterUrl.openStream();){
                filter.addFilterEntries(is);
            }
        }
        return filter;
    }

    private static final HashSet<Class<?>> getComparisonInterfaces(boolean includeMetadata) throws ClassNotFoundException {
        if (includeMetadata) {
            cachedComparisonInterfaces.add(IRogMetadata.class);
        }
        cachedComparisonInterfaces.add(IStoreObject.class);
        HashSet<String> factories = new HashSet<String>();
        MessageViewFactoryRegistry.getInstance().getMessageViewFactoryNames(factories);
        for (String factory : factories) {
            if (cachedComparisonInterfaceSources.contains(factory)) continue;
            RogLogUtil.extractModelInterfaces(factory, cachedComparisonInterfaces);
            cachedComparisonInterfaceSources.add(factory);
        }
        factories.clear();
        StoreObjectFactoryRegistry.getInstance().getStoreObjectFactoryNames(factories);
        for (String factory : factories) {
            if (cachedComparisonInterfaceSources.contains(factory)) continue;
            RogLogUtil.extractModelInterfaces(factory, cachedComparisonInterfaces);
            cachedComparisonInterfaceSources.add(factory);
        }
        factories.clear();
        StoTypeFactoryRegistry.getInstance().getTypeFactoryNames(factories);
        for (String factory : factories) {
            if (cachedComparisonInterfaceSources.contains(factory)) continue;
            RogLogUtil.extractModelInterfaces(factory, cachedComparisonInterfaces);
            cachedComparisonInterfaceSources.add(factory);
        }
        return cachedComparisonInterfaces;
    }

    private static void processDirectory(File directory, String pkgname, ArrayList<Class<?>> classes) {
        String[] files = directory.list();
        for (int i = 0; i < files.length; ++i) {
            File subdir;
            String fileName = files[i];
            String className = null;
            if (fileName.endsWith(".class")) {
                className = pkgname + '.' + fileName.substring(0, fileName.length() - 6);
            }
            if (className != null) {
                classes.add(RogLogUtil.loadClass(className));
            }
            if (!(subdir = new File(directory, fileName)).isDirectory()) continue;
            RogLogUtil.processDirectory(subdir, pkgname + '.' + fileName, classes);
        }
    }

    private static void processJarfile(URL resource, String pkgname, ArrayList<Class<?>> classes) {
        JarFile jarFile;
        String relPath = pkgname.replace('.', '/');
        String resPath = resource.getPath();
        String jarPath = resPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException reading JAR File '" + jarPath + "'", e);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String className = null;
            if (entryName.endsWith(".class") && entryName.startsWith(relPath) && entryName.length() > relPath.length() + "/".length()) {
                className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            }
            if (className == null) continue;
            classes.add(RogLogUtil.loadClass(className));
        }
    }

    private static final ArrayList<Class<?>> getClassesForPackage(Class<?> factoryClass, Package pkg) {
        ArrayList classes = new ArrayList();
        String pkgname = pkg.getName();
        String relPath = pkgname.replace('.', '/');
        URL resource = ClassLoader.getSystemClassLoader().getResource(relPath);
        if (resource == null && (resource = factoryClass.getClassLoader().getResource(relPath)) == null && (resource = Thread.currentThread().getContextClassLoader().getResource(relPath)) == null) {
            Exception cause = null;
            try {
                URL codeSource = factoryClass.getProtectionDomain().getCodeSource().getLocation();
                resource = codeSource.getFile().endsWith(".jar") ? new URL("jar:" + codeSource.toString() + "!/" + relPath) : new URL(codeSource.toString() + "/" + relPath);
            }
            catch (Exception e) {
                cause = e;
            }
            if (resource == null) {
                throw new RuntimeException("Unexpected problem: No resource for " + relPath, cause);
            }
        }
        resource.getPath();
        if (resource.toString().startsWith("jar:")) {
            RogLogUtil.processJarfile(resource, pkgname, classes);
        } else {
            RogLogUtil.processDirectory(new File(resource.getPath()), pkgname, classes);
        }
        return classes;
    }

    private static final Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unexpected ClassNotFoundException loading class '" + className + "'");
        }
    }

    private static final Object extractApplicationState(RogRootNode srcRoot) throws Exception {
        try {
            Method m = srcRoot.getClass().getDeclaredMethod("getApplicationState", new Class[0]);
            m.setAccessible(true);
            return m.invoke((Object)srcRoot, new Object[0]);
        }
        catch (Exception e) {
            throw new Exception("Error extracting application state from " + srcRoot.getClass() + ": " + e.getMessage(), e);
        }
    }

    private static final PrettyPrinter getPrettyPrinter(JsonPrettyPrintStyle style, ObjectWriter jsonWriter) {
        switch (style) {
            case Custom: {
                String prettyPrinterClassName = Config.getValue((String)JSON_CUSTOM_PRETTY_PRINTER_PROP, null);
                if (prettyPrinterClassName == null) {
                    throw new IllegalArgumentException("No pretty pretter class name found in runtime properties under: nv.json.customPrettyPrinter");
                }
                PrettyPrinter customPrettyPrinter = jsonCustomPrettyPrinters.get(prettyPrinterClassName);
                if (customPrettyPrinter == null) {
                    try {
                        customPrettyPrinter = (PrettyPrinter)Class.forName(prettyPrinterClassName).newInstance();
                        jsonCustomPrettyPrinters.put(prettyPrinterClassName, customPrettyPrinter);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error instantiating custom json pretty printer class: " + prettyPrinterClassName, e);
                    }
                }
                return customPrettyPrinter;
            }
            case Minimal: {
                return jsonMinimalPrettyPrinter;
            }
            case SingleLine: {
                return jsonSingleLinePrettyPrinter;
            }
            case Default: 
            case PrettyPrint: {
                return jsonDefaultPrettyPrinter;
            }
        }
        throw new IllegalArgumentException("Unknown json pretty print style: " + (Object)((Object)style));
    }

    public static final void dumpLogEntryJson(RogLogReader.Entry entry, boolean includeMetadata, boolean includePayload, boolean filterUnsetFields, JsonPrettyPrintStyle style, Writer writer) {
        ObjectWriter jsonWriter = JSON_MAPPER.writer().with(UtlTime.getCachedTimestampFormatter());
        PrettyPrinter formatter = RogLogUtil.getPrettyPrinter(style, jsonWriter);
        jsonWriter = jsonWriter.with(formatter);
        if (filterUnsetFields) {
            jsonWriter = jsonWriter.with((FilterProvider)jsonHasFieldsFilter);
        }
        try {
            if (!includeMetadata) {
                writer.append(entry.getClassName() + ": ");
                if (style == JsonPrettyPrintStyle.Default) {
                    writer.append(NEWLINE);
                }
                RogLogUtil.prepareForJsonization(entry.getObject());
                jsonWriter.writeValue(writer, RogLogUtil.ensureJsonizable(entry.getObject()));
            } else if (!includePayload) {
                jsonWriter = jsonWriter.with((FilterProvider)jsonLogEntryObjectFilter);
                jsonWriter.writeValue(writer, (Object)entry);
            } else {
                RogLogUtil.prepareForJsonization(entry.getObject());
                jsonWriter.writeValue(writer, (Object)entry);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void dumpResultSetRowJson(RogLogQueryResultSet resultSet, boolean includeMetadata, boolean includePayload, boolean filterUnsetFields, JsonPrettyPrintStyle style, Writer writer) {
        ObjectWriter jsonWriter = JSON_MAPPER.writer().with(UtlTime.getCachedTimestampFormatter());
        PrettyPrinter formatter = RogLogUtil.getPrettyPrinter(style, jsonWriter);
        jsonWriter = jsonWriter.with(formatter);
        if (filterUnsetFields) {
            jsonWriter = jsonWriter.with((FilterProvider)jsonHasFieldsFilter);
        }
        LinkedHashMap columnMap = Maps.newLinkedHashMap();
        int columnIndex = 0;
        for (int f = 0; f < resultSet.getSelectedFields().size(); ++f) {
            IdxField field = resultSet.getSelectedFields().get(f);
            String fieldName = resultSet.getSelectedFieldNames().get(f);
            String canonicalName = field.getName().equals(fieldName) ? field.getCanonicalName() : fieldName;
            Object columnValue = resultSet.getObject(++columnIndex);
            columnMap.put(UtlDistinctProxy.of((CharSequence)canonicalName), columnValue);
        }
        try {
            jsonWriter.writeValue(writer, (Object)columnMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void dumpResultSetRowCsv(RogLogQueryResultSet resultSet, Writer writer) {
        int columnIndex = 0;
        boolean first = true;
        for (IdxField field : resultSet.getSelectedFields()) {
            Class<?> fieldType = field.getFieldType();
            Object columnValue = resultSet.getObject(++columnIndex);
            try {
                if (!first) {
                    writer.append(",");
                }
                if (columnValue != null) {
                    writer.append(columnValue.toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            first = false;
        }
    }

    public static void dumpResultSetRowTabular(RogLogQueryResultSet resultSet, Writer writer) {
        int columnIndex = 0;
        boolean first = true;
        for (IdxField field : resultSet.getSelectedFields()) {
            Class<?> fieldType = field.getFieldType();
            Object columnValue = resultSet.getObject(++columnIndex);
            try {
                if (!first) {
                    writer.append(" | ");
                }
                if (columnValue != null) {
                    writer.append(columnValue.toString());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            first = false;
        }
    }

    private static void prepareForJsonization(IStoreObject object) {
        if (object == null) {
            return;
        }
        if (object instanceof IRogJsonizable) {
            Method m = jsonBitMaskSyncMethods.get(object.getClass());
            if (m == null && !jsonBitMaskMethodChecked.contains(object.getClass())) {
                try {
                    m = object.getClass().getMethod("syncFieldBitmask", new Class[0]);
                    jsonBitMaskSyncMethods.put(object.getClass(), m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jsonBitMaskMethodChecked.add(object.getClass());
            }
            if (m != null) {
                try {
                    m.invoke((Object)object, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error syncing object's json field bitmask");
                }
            }
        }
    }

    public static final void traceObjectJson(String prefix, IRogNode object, MetadataDisplayPolicy metadataDisplay, boolean filterUnsetFields, JsonPrettyPrintStyle style, Tracer tracer, Tracer.Level traceLevel) {
        if (tracer.getLevel().val < traceLevel.val) {
            return;
        }
        tracer.log(RogLogUtil.objectToJson(prefix, object, metadataDisplay, filterUnsetFields, style), traceLevel);
    }

    public static final String objectToJson(String prefix, IRogNode object, MetadataDisplayPolicy metadataDisplay, boolean filterUnsetFields, JsonPrettyPrintStyle style) {
        ReusableStringWriter writer = TRACE_WRITERS.get();
        if (writer == null) {
            writer = new ReusableStringWriter();
            TRACE_WRITERS.set(writer);
        } else {
            writer.reset();
        }
        writer.write(prefix);
        writer.write(" ");
        RogLogUtil.dumpObjectAsJson(metadataDisplay != MetadataDisplayPolicy.Off ? object.getMetadata() : null, object, metadataDisplay != MetadataDisplayPolicy.Off, metadataDisplay != MetadataDisplayPolicy.Only, true, style, writer);
        return writer.toString();
    }

    public static final void dumpObjectAsJson(IRogMetadata metadata, IStoreObject object, boolean dumpMetadata, boolean dumpObject, boolean filterUnsetFields, JsonPrettyPrintStyle style, Writer writer) {
        ObjectWriter jsonWriter = JSON_MAPPER.writer().with(UtlTime.getCachedTimestampFormatter());
        PrettyPrinter formatter = RogLogUtil.getPrettyPrinter(style, jsonWriter);
        jsonWriter = jsonWriter.with(formatter);
        if (filterUnsetFields) {
            jsonWriter = jsonWriter.with((FilterProvider)jsonHasFieldsFilter);
        }
        try {
            if (dumpMetadata && dumpObject) {
                RogLogUtil.prepareForJsonization(object);
                jsonWriter.writeValue(writer, (Object)new JsonStoreObjectView(metadata, object));
            } else if (dumpObject) {
                RogLogUtil.prepareForJsonization(object);
                writer.append(object == null ? "object" : object.getClass().getName() + ": ");
                if (style.usesNewLine()) {
                    writer.append(NEWLINE);
                }
                jsonWriter.writeValue(writer, RogLogUtil.ensureJsonizable(object));
            } else if (dumpMetadata) {
                writer.append("metadata: ");
                if (style.usesNewLine()) {
                    writer.append(NEWLINE);
                }
                jsonWriter.writeValue(writer, (Object)metadata);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final Object ensureJsonizable(Object object) {
        if (object != null && !(object instanceof IRogJsonizable)) {
            return new JsonNonJsonizableObject(object);
        }
        return object;
    }

    static {
        JSON_MAPPER.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, JSON_SORT_PROPERTIES_ALPHABETICALLY).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JSON_MAPPER.setAnnotationIntrospector((AnnotationIntrospector)new JsonFilterIntrospector());
        jsonLogEntryObjectFilter.addFilter(JSONLOG_ENTRY_FILTER_ID, (SimpleBeanPropertyFilter)new JsonLogEntryObjectFilter());
        jsonLogEntryObjectFilter.addFilter(JSON_ENTITY_FILTER_ID, SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0]));
        jsonLogEntryObjectFilter.addFilter(JSON_ROG_COLLECTION_FILTER_ID, SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"xRogType"}));
        jsonHasFieldsFilter.addFilter(JSONLOG_ENTRY_FILTER_ID, SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0]));
        jsonHasFieldsFilter.addFilter(JSON_ENTITY_FILTER_ID, (SimpleBeanPropertyFilter)new JsonHasFieldPropertyFilter());
        jsonHasFieldsFilter.addFilter(JSON_ROG_COLLECTION_FILTER_ID, SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"xRogType"}));
        jsonUnfilteredFilter.addFilter(JSONLOG_ENTRY_FILTER_ID, SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0]));
        jsonUnfilteredFilter.addFilter(JSON_ENTITY_FILTER_ID, SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0]));
        jsonUnfilteredFilter.addFilter(JSON_ROG_COLLECTION_FILTER_ID, SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{"xRogType"}));
        JSON_MAPPER.setFilters((FilterProvider)jsonUnfilteredFilter);
        JSON_MAPPER.getFactory().configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        cachedComparisonInterfaces = new HashSet();
        cachedComparisonInterfaceSources = new HashSet();
    }

    private static final class ReusableStringWriter
    extends Writer {
        private StringBuilder buf = new StringBuilder();

        public final void reset() {
            this.buf.setLength(0);
        }

        @Override
        public void write(int c) {
            this.buf.append((char)c);
        }

        @Override
        public final void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.buf.append(cbuf, off, len);
        }

        @Override
        public final void write(String str) {
            this.buf.append(str);
        }

        @Override
        public final void write(String str, int off, int len) {
            this.buf.append(str.substring(off, off + len));
        }

        @Override
        public final ReusableStringWriter append(CharSequence csq) {
            if (csq == null) {
                this.write("null");
            } else {
                this.write(csq.toString());
            }
            return this;
        }

        @Override
        public final ReusableStringWriter append(CharSequence csq, int start, int end) {
            CharSequence cs = csq == null ? "null" : csq;
            this.write(cs.subSequence(start, end).toString());
            return this;
        }

        @Override
        public final ReusableStringWriter append(char c) {
            this.write(c);
            return this;
        }

        public String toString() {
            return this.buf.toString();
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static final class JsonHasFieldPropertyFilter
    extends SimpleBeanPropertyFilter {
        private JsonHasFieldPropertyFilter() {
        }

        public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            boolean hasField = true;
            if (!UtlQueryReflection.getHasPropertyCheckerValue((Object)pojo, (String)UtlText.toFirstLetterLowercase((String)writer.getName()))) {
                hasField = false;
            }
            if (writer.getName().startsWith("xRog") || writer.getName().startsWith("_x")) {
                hasField = false;
            }
            if (hasField && this.include(writer)) {
                writer.serializeAsField(pojo, jgen, provider);
            } else if (!jgen.canOmitFields()) {
                writer.serializeAsOmittedField(pojo, jgen, provider);
            }
        }

        protected final boolean include(BeanPropertyWriter writer) {
            return true;
        }

        protected final boolean include(PropertyWriter writer) {
            if (writer instanceof BeanPropertyWriter) {
                return this.include((BeanPropertyWriter)writer);
            }
            return true;
        }
    }

    private static final class JsonLogEntryObjectFilter
    extends SimpleBeanPropertyFilter {
        private JsonLogEntryObjectFilter() {
        }

        protected boolean include(BeanPropertyWriter writer) {
            return !writer.getName().equals("object");
        }

        protected boolean include(PropertyWriter writer) {
            return !writer.getName().equals("object");
        }
    }

    private static class JsonFilterIntrospector
    extends JacksonAnnotationIntrospector {
        private static final long serialVersionUID = 1L;

        private JsonFilterIntrospector() {
        }

        public Object findFilterId(Annotated ac) {
            Object id = super.findFilterId(ac);
            if (id == null) {
                id = ac.getRawType() == RogLogReader.Entry.class ? RogLogUtil.JSONLOG_ENTRY_FILTER_ID : (RogContainerNode.class.isAssignableFrom(ac.getRawType()) ? (Map.class.isAssignableFrom(ac.getRawType()) || Collection.class.isAssignableFrom(ac.getRawType()) ? RogLogUtil.JSON_ROG_COLLECTION_FILTER_ID : RogLogUtil.JSON_ENTITY_FILTER_ID) : RogLogUtil.JSON_ENTITY_FILTER_ID);
            }
            return id;
        }
    }

    private static final class JsonNonJsonizableObject {
        private final Object object;

        private JsonNonJsonizableObject(Object object) {
            this.object = object;
        }

        @JsonProperty
        public final String getNonJsonToString() {
            return this.object == null ? null : this.object.toString();
        }
    }

    @JsonPropertyOrder(value={"className", "metadata", "object"})
    private static final class JsonStoreObjectView {
        private final IRogMetadata metadata;
        private final IStoreObject object;

        JsonStoreObjectView(IRogMetadata metadata, IStoreObject object) {
            this.metadata = metadata;
            this.object = object;
        }

        @JsonProperty
        public final String getClassName() {
            if (this.object != null) {
                return this.object.getClass().getName();
            }
            return null;
        }

        @JsonProperty
        public final IRogMetadata getMetadata() {
            return this.metadata;
        }

        @JsonProperty
        public final Object getObject() {
            return RogLogUtil.ensureJsonizable(this.object);
        }
    }

    public static class FilterComparisonFactory
    implements UtlObjectGraph.ComparatorFactory {
        final FieldFilter filter;
        final AlwaysEqualComparator ignoreComparator = new AlwaysEqualComparator();

        public FilterComparisonFactory(FieldFilter filter) {
            this.filter = filter;
        }

        public Comparator<?> getComparator(Class<?> type, Stack<String> getterStack) {
            if (this.filter.filter(type, UtlObjectGraph.unwindStack(getterStack))) {
                return this.ignoreComparator;
            }
            return null;
        }

        public boolean treatEmptyAndNullArraysAsSame() {
            return true;
        }
    }

    public static enum MetadataDisplayPolicy {
        On,
        Off,
        Only;

    }

    public static enum JsonPrettyPrintStyle {
        Default(true),
        PrettyPrint(true),
        Minimal(false),
        SingleLine(false),
        Custom(false);

        private final boolean usesNewLine;

        private JsonPrettyPrintStyle(boolean usesNewLine) {
            this.usesNewLine = usesNewLine;
        }

        public boolean usesNewLine() {
            return this.usesNewLine;
        }
    }

    public static class AlwaysEqualComparator<T>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            return 0;
        }
    }

    public static final class FileBasedFieldFilter
    implements FieldFilter {
        Map<String, Set<String>> classBasedFilterPaths = new HashMap<String, Set<String>>();
        Set<String> classExclusions = new HashSet<String>();
        Set<String> pathExclusions = new HashSet<String>();

        FileBasedFieldFilter() {
        }

        public void addFilterEntries(InputStream is) throws IOException {
            BufferedReader bs = new BufferedReader(new InputStreamReader(is));
            String line = null;
            int lineNum = 0;
            while ((line = bs.readLine()) != null) {
                Set<String> classFilters;
                ++lineNum;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("//")) continue;
                String[] tokens = line.split(" ");
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Invalid filter definition at line + " + lineNum + ": '" + line + "', expected 'className|* fieldPath|*'");
                }
                if (tokens[0].equals("*")) {
                    this.pathExclusions.add(tokens[1]);
                }
                if (tokens[1].equals("*")) {
                    this.classExclusions.add(tokens[1]);
                }
                if ((classFilters = this.classBasedFilterPaths.get(tokens[0])) == null) {
                    classFilters = new HashSet<String>();
                    this.classBasedFilterPaths.put(tokens[0], classFilters);
                }
                classFilters.add(tokens[1]);
            }
        }

        @Override
        public boolean filter(Class<?> type, String path) {
            if (!this.classExclusions.isEmpty() && this.classExclusions.contains(type.getCanonicalName()) || this.classExclusions.contains(type.getSimpleName())) {
                return true;
            }
            if (!this.pathExclusions.isEmpty() && this.pathExclusions.contains(path)) {
                return true;
            }
            Set<String> classFilters = this.classBasedFilterPaths.get(type.getCanonicalName());
            if (classFilters == null) {
                classFilters = this.classBasedFilterPaths.get(type.getSimpleName());
            }
            return classFilters != null && classFilters.contains(path);
        }
    }

    public static interface FieldFilter {
        public boolean filter(Class<?> var1, String var2);
    }
}

