/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIndexedList;
import com.neeve.ods.OdsException;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.EPktLogCorruptException;
import com.neeve.rog.RogObject;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogReader;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlTime;
import com.neeve.util.UtlUnit;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;

final class RogLogCompactingReader
extends RogObject {
    private final RogLog log;
    private final ReadHandler handler;
    private final Tracer tracer;
    private final LogObjectTable logObjectTable;
    private final UtlPool<LogObject> logObjectPool;
    private final MemoryMappedBuffers memoryMappedBuffers;
    private final ReadStats readStats;
    private volatile boolean running = false;
    private volatile boolean closed = false;

    private RogLogCompactingReader(RogLog log, ReadHandler handler, Tracer tracer) {
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        this.log = log;
        this.handler = handler;
        this.tracer = tracer;
        this.logObjectTable = new LogObjectTable();
        this.logObjectPool = UtlPool.create((String)"rog.log.compactor.logobject", (String)log.getName(), (UtlPool.Factory)new LogObjectPoolFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.memoryMappedBuffers = new MemoryMappedBuffers();
        this.readStats = new ReadStats();
        if (tracer.debug) {
            tracer.log("[Compaction Reader] Created.", Tracer.Level.DEBUG);
        }
    }

    static final RogLogCompactingReader create(RogLog log, ReadHandler handler, Tracer tracer) {
        return new RogLogCompactingReader(log, handler, tracer);
    }

    private static final void throwPktCorruptionError(String message, PktPacket packet, long filePosition, int sizeOnDisk) throws EPktLogCorruptException {
        StringBuilder sb = new StringBuilder();
        sb.append(message).append(", Corrupt Packet Dump:\n");
        IOElasticBuffer headerBuffer = packet.getHeader().getBuffer();
        IOElasticBuffer bodyBuffer = packet.getBody().getBuffer();
        sb.append(headerBuffer != null ? headerBuffer.dump("  Header Buffer: ", 0, headerBuffer.getLength()) : " no header buffer!").append("\n  ");
        sb.append(headerBuffer != null ? bodyBuffer.dump("  Body Buffer: ", 0, bodyBuffer.getLength()) : " no body buffer!");
        sb.append("  Packet: " + packet.toString()).append("\n");
        sb.append("  ...FP=").append(filePosition);
        sb.append(", ...SZ=").append(sizeOnDisk);
        throw new EPktLogCorruptException(sb.toString());
    }

    private static final PktSubheaderODS getOdsSubheader(PktPacket packet, long filePosition, int sizeOnDisk) throws EPktLogCorruptException {
        PktSubheaderODS odsHeader = packet.getHeader().getODSSubheader();
        if (odsHeader == null) {
            RogLogCompactingReader.throwPktCorruptionError("Logged packet is missing ODS subheader", packet, filePosition, sizeOnDisk);
        }
        return odsHeader;
    }

    private final int process(PktPacket packet, int bufferPosition, int bufferPos, long filePosition, int sizeOnDisk, ReadStats readStats) throws EPktLogCorruptException {
        LogObject logObject;
        boolean updateEntry;
        short commitEntryType;
        long stableTransactionId;
        long transactionId;
        int ret;
        block15: {
            UUID oid;
            block14: {
                ret = 0;
                PktSubheaderODS subheaderODS = RogLogCompactingReader.getOdsSubheader(packet, filePosition, sizeOnDisk);
                oid = subheaderODS.getObjectId();
                transactionId = subheaderODS.getTransactionId();
                stableTransactionId = subheaderODS.getStableTransactionId();
                long checkpointVersion = subheaderODS.getCheckpointVersion();
                commitEntryType = subheaderODS.getCommitEntryType();
                updateEntry = false;
                logObject = (LogObject)this.logObjectTable.get(oid);
                if (logObject != null) break block14;
                switch (commitEntryType) {
                    case 1: 
                    case 2: {
                        if (commitEntryType == 2) {
                            this.tracer.log("[Compaction Reader] *** Encountered an UPDATE entry in log without a preceding PUT [id=" + oid + ", fp=" + filePosition + "]. Treating as PUT... ***", Tracer.Level.WARNING);
                        }
                        logObject = (LogObject)this.logObjectPool.get(null);
                        logObject.init(oid, transactionId, stableTransactionId, checkpointVersion);
                        this.logObjectTable.put(logObject.getOid(), logObject);
                        ret = 1;
                        updateEntry = true;
                        break block15;
                    }
                    case 3: {
                        this.tracer.log("[Compaction Reader] *** Encountered a REMOVE entry in log without a preceding PUT [id=" + oid + ", fp=" + filePosition + "]. Ignoring... ***", Tracer.Level.WARNING);
                        break block15;
                    }
                    case 4: 
                    case 5: {
                        break block15;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported commit entry type [" + commitEntryType + "]");
                    }
                }
            }
            switch (commitEntryType) {
                case 1: {
                    this.tracer.log("[Compaction Reader] *** Encountered a duplicate PUT entry in log (without preceding REMOVE) [id=" + oid + ", fp=" + filePosition + "]. Treating as UPDATE... ***", Tracer.Level.WARNING);
                    updateEntry = true;
                    break;
                }
                case 2: {
                    updateEntry = true;
                    break;
                }
                case 3: {
                    this.logObjectTable.updateCumulativeObjectSerializedSize(0 - logObject.getLogEntry().getSize());
                    this.logObjectTable.remove(oid);
                    logObject.dispose();
                    ret = -1;
                    break;
                }
                case 4: {
                    this.tracer.log("[Compaction Reader] *** Encountered a SEND entry in log for object that has PUT/UPDATE/REMOVE entries [id=" + oid + ", fp=" + filePosition + "]. Ignoring... ***", Tracer.Level.WARNING);
                    break;
                }
                case 5: {
                    this.tracer.log("[Compaction Reader] *** Encountered a MESSAGE entry in log for object that has PUT/UPDATE/REMOVE entries [id=" + oid + ", fp=" + filePosition + "]. Ignoring... ***", Tracer.Level.WARNING);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported commit entry type [" + commitEntryType + "]");
                }
            }
        }
        if (updateEntry) {
            this.logObjectTable.updateCumulativeObjectSerializedSize(sizeOnDisk - logObject.getLogEntry().getSize());
            logObject.getLogEntry().update(filePosition, bufferPosition, bufferPos, sizeOnDisk);
        }
        this.logObjectTable.updateLastTransactionIds(transactionId, stableTransactionId);
        readStats.update(commitEntryType);
        return ret;
    }

    private final RunCompletionReason onRunCompletion(RunCompletionReason reason) throws Exception {
        this.readStats.outputStats(true, System.currentTimeMillis());
        if (reason != RunCompletionReason.Closed) {
            this.handler.handleCompacted(this.logObjectTable);
        }
        return reason;
    }

    private final void closeCore() {
        this.memoryMappedBuffers.close();
        this.logObjectPool.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final RunCompletionReason run(int logNumber, long maxFilePointer) throws Exception {
        if (logNumber < 0) {
            throw new IllegalArgumentException("log number cannot be negative");
        }
        try {
            var4_3 = this;
            synchronized (var4_3) {
                block23: {
                    if (this.running) {
                        throw new IllegalStateException("already running");
                    }
                    this.running = true;
                    if (!this.closed) break block23;
                    if (this.tracer.debug) {
                        this.tracer.log("[Compaction Reader] Done (closed).", Tracer.Level.DEBUG);
                    }
                    var5_4 = RunCompletionReason.Closed;
                    return var5_4;
                }
                ** try [egrp 3[TRYBLOCK] [1 : 119->125)] { 
                {
                }
            }
lbl20:
            // 1 sources

            this.tracer.log("[Compaction Reader] Started run [logNumber=" + logNumber + ", maxFilePointer=" + this.readStats.format.format(maxFilePointer) + "]", Tracer.Level.INFO);
            raf = new RandomAccessFile(new File(this.log.getLogFile().getParentFile(), this.log.logFilename(logNumber)), "r");
            fileChannel = raf.getChannel();
            packet = PktFactory.getInstance().createPacket(257);
            try {
                this.logObjectTable.init();
                this.memoryMappedBuffers.open();
                this.readStats.start();
                filePosition = 9L;
                bufferPosition = this.memoryMappedBuffers.map(fileChannel, filePosition, maxFilePointer);
                ioBuffer = this.memoryMappedBuffers.getIOBuffer(bufferPosition);
                bufferPos = 0;
                while (!this.closed) {
                    if (filePosition < maxFilePointer) {
                        remaining = ioBuffer.getLength() - bufferPos;
                        packetLength = PktHeader.getSerializedPacketLength((IOBuffer)ioBuffer, (int)bufferPos, (int)remaining);
                        if (packetLength > 0 && packetLength <= remaining) {
                            packet.deserialize(ioBuffer, bufferPos, true);
                            this.readStats.ocount += (long)this.process(packet, bufferPosition, bufferPos, filePosition, packetLength, this.readStats);
                            bufferPos += packetLength;
                            filePosition += (long)packetLength;
                            ++this.readStats.dcount;
                            this.readStats.dbytes += (long)packetLength;
                            this.readStats.tbytes += (long)packetLength;
                        } else {
                            if (this.tracer.debug) {
                                this.tracer.log("[Compaction Reader] End of buffer (filePosition=" + filePosition + ", remaining=" + remaining + "). Mapping new buffer.", Tracer.Level.DEBUG);
                            }
                            bufferPosition = this.memoryMappedBuffers.map(fileChannel, filePosition, maxFilePointer);
                            ioBuffer = this.memoryMappedBuffers.getIOBuffer(bufferPosition);
                            bufferPos = 0;
                        }
                        this.readStats.checkAndOutputStats();
                        continue;
                    }
                    var12_13 = this.onRunCompletion(RunCompletionReason.MaxFilePointerReached);
                }
            }
            catch (Throwable var14_16) {
                raf.close();
                throw var14_16;
            }
            {
                raf.close();
                return var12_13;
            }
            var12_14 = this.onRunCompletion(RunCompletionReason.Closed);
            raf.close();
            return var12_14;
        }
        finally {
            if (this.tracer.debug) {
                this.tracer.log("[Compaction Reader] Exiting run...", Tracer.Level.DEBUG);
            }
            if (this.closed) {
                this.closeCore();
            }
            this.running = false;
        }
    }

    final RunCompletionReason run() throws Exception {
        return this.run(this.log.getMetadata().getLiveLogNumber(), Long.MAX_VALUE);
    }

    final ReadStats readStats() {
        return this.readStats;
    }

    final void close() {
        this.closed = true;
        if (!this.running) {
            this.closeCore();
        }
    }

    public final class LogObjectTable
    extends UtlLinkedHashMap<UUID, LogObject> {
        private long cumulativeObjectSerializedSize;
        private long lastTransactionId;
        private long lastStableTransactionId;

        final void init() {
            if (this.size() > 0) {
                this.clear();
            }
            this.cumulativeObjectSerializedSize = 0L;
            this.lastTransactionId = 0L;
            this.lastStableTransactionId = 0L;
        }

        final void updateCumulativeObjectSerializedSize(int val) {
            this.cumulativeObjectSerializedSize += (long)val;
        }

        final void updateLastTransactionIds(long transactionId, long stableTransactionId) {
            this.lastTransactionId = transactionId;
            this.lastStableTransactionId = stableTransactionId;
        }

        final long getCumulativeObjectSerializedSize() {
            return this.cumulativeObjectSerializedSize;
        }

        public final long getLastTransactionId() {
            return this.lastTransactionId;
        }

        public final long getLastStableTransactionId() {
            return this.lastStableTransactionId;
        }

        public final void done() {
            if (this.size() > 0) {
                RogLogCompactingReader.this.tracer.log("[Compaction Reader] *** LOG OBJECT TABLE NOT EMPTY AFTER PROCESSING. CLEARING TABLE (NOT A GARBAGE FREE OPERATION) ***", Tracer.Level.WARNING);
            }
            RogLogCompactingReader.this.memoryMappedBuffers.close();
        }
    }

    public final class LogObject
    implements UtlPool.Item<LogObject> {
        final UUID oid = new UUID(0L, 0L);
        final LogEntry logEntry;
        private long transactionId;
        private long stableTransactionId;
        private long checkpointVersion;
        private UtlPool<LogObject> pool;

        LogObject() {
            this.logEntry = new LogEntry();
        }

        final LogObject init(UUID oid, long transactionId, long stableTransactionId, long checkpointVersion) {
            this.oid.clockSeqAndNode = oid.clockSeqAndNode;
            this.oid.time = oid.time;
            this.logEntry.init();
            this.transactionId = transactionId;
            this.stableTransactionId = stableTransactionId;
            this.checkpointVersion = checkpointVersion;
            return this;
        }

        public final UUID getOid() {
            return this.oid;
        }

        public final long getTransactionId() {
            return this.transactionId;
        }

        public final long getStableTransactionId() {
            return this.stableTransactionId;
        }

        public final long getCheckpointVersion() {
            return this.checkpointVersion;
        }

        public final LogEntry getLogEntry() {
            return this.logEntry;
        }

        public final void dispose() {
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            } else {
                this.init();
            }
        }

        public LogObject init() {
            this.oid.clockSeqAndNode = 0L;
            this.oid.time = 0L;
            return this;
        }

        public LogObject setPool(UtlPool<LogObject> pool) {
            this.pool = pool;
            return this;
        }

        public UtlPool<LogObject> getPool() {
            return this.pool;
        }
    }

    public final class LogEntry {
        private long filePosition;
        private int bufferPosition;
        private int bufferPos;
        private int size;

        final void init() {
            this.filePosition = 0L;
            this.bufferPosition = 0;
            this.bufferPos = 0;
            this.size = 0;
        }

        final LogEntry update(long filePosition, int bufferPosition, int bufferPos, int size) {
            this.filePosition = filePosition;
            this.bufferPosition = bufferPosition;
            this.bufferPos = bufferPos;
            this.size = size;
            return this;
        }

        public final IOBuffer getBuffer() {
            return RogLogCompactingReader.this.memoryMappedBuffers.getIOBuffer(this.bufferPosition);
        }

        public final int getBufferPos() {
            return this.bufferPos;
        }

        public final int getSize() {
            return this.size;
        }

        public final PktPacket getPacket() {
            IOBuffer buffer = RogLogCompactingReader.this.memoryMappedBuffers.getIOBuffer(this.bufferPosition);
            return PktFactory.getInstance().createPacket(buffer, this.bufferPos, this.size, true);
        }

        public final RogLogReader.Entry getLogEntry() throws OdsException {
            return RogLogReader.Entry.create(RogLogCompactingReader.this.log, this.getPacket(), this.filePosition, this.size);
        }
    }

    public static enum RunCompletionReason {
        EndOfFile,
        MaxFilePointerReached,
        Closed;

    }

    public static interface ReadHandler {
        public void handleCompacted(LogObjectTable var1) throws Exception;

        public void onWait();
    }

    final class ReadStats {
        final NumberFormat format = NumberFormat.getInstance();
        long start;
        long ts;
        long puts;
        long updates;
        long removes;
        long sends;
        long messages;
        long ocount;
        long tbytes;
        long dcount;
        long dbytes;

        ReadStats() {
            this.format.setMaximumFractionDigits(0);
        }

        final long tcount() {
            return this.puts + this.updates + this.removes + this.sends + this.messages;
        }

        final void start() {
            this.puts = 0L;
            this.updates = 0L;
            this.removes = 0L;
            this.sends = 0L;
            this.messages = 0L;
            this.ocount = 0L;
            this.tbytes = 0L;
            this.dcount = 0L;
            this.dbytes = 0L;
            this.start = this.ts = UtlTime.now();
        }

        final void update(int commitEntryType) {
            switch (commitEntryType) {
                case 1: {
                    ++this.puts;
                    break;
                }
                case 2: {
                    ++this.updates;
                    break;
                }
                case 3: {
                    ++this.removes;
                    break;
                }
                case 4: {
                    ++this.sends;
                    break;
                }
                case 5: {
                    ++this.messages;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported commit entry type [" + commitEntryType + "]");
                }
            }
        }

        final void outputStats(boolean endOfRun, long ts) {
            long brate;
            long elapsed = endOfRun ? ts - this.start : ts - this.ts;
            long prate = endOfRun ? this.tcount() * 1000000000L / elapsed : this.dcount * 1000000000L / elapsed;
            long l = brate = endOfRun ? this.tbytes * 1000000000L / elapsed : this.dbytes * 1000000000L / elapsed;
            if (endOfRun) {
                RogLogCompactingReader.this.tracer.log("[Compaction Reader] READ STATS (T) [time=" + UtlUnit.formatDuration((double)elapsed, (TimeUnit)TimeUnit.NANOSECONDS) + ", prate=" + this.format.format(prate) + ", brate=" + UtlUnit.readableBytesSize((long)brate) + ", count=" + this.format.format(this.tcount()) + ", bytes=" + UtlUnit.readableBytesSize((long)this.tbytes) + ", puts=" + this.format.format(this.puts) + ", updates=" + this.format.format(this.updates) + ", removes=" + this.format.format(this.removes) + ", sends=" + this.format.format(this.sends) + ", messages=" + this.format.format(this.messages) + ", objects=" + this.format.format(this.ocount) + "]", Tracer.Level.INFO);
            } else if (((RogLogCompactingReader)RogLogCompactingReader.this).tracer.verbose) {
                RogLogCompactingReader.this.tracer.log("[Compaction Reader] READ STATS (D) [time=" + UtlUnit.formatDuration((double)elapsed, (TimeUnit)TimeUnit.NANOSECONDS) + ", prate=" + this.format.format(prate) + ", brate=" + UtlUnit.readableBytesSize((long)brate) + ", count=" + this.format.format(this.dcount) + ", bytes=" + UtlUnit.readableBytesSize((long)this.dbytes) + ", puts=" + this.format.format(this.puts) + ", updates=" + this.format.format(this.updates) + ", removes=" + this.format.format(this.removes) + ", sends=" + this.format.format(this.sends) + ", messages=" + this.format.format(this.messages) + ", objects=" + this.format.format(this.ocount) + "]", Tracer.Level.VERBOSE);
            }
            this.dcount = 0L;
            this.dbytes = 0L;
            this.ts = UtlTime.now();
        }

        final void checkAndOutputStats() {
            long ts = UtlTime.now();
            if (ts - this.ts >= 5000000000L) {
                this.outputStats(false, ts);
            }
        }
    }

    private final class LogObjectPoolFactory
    implements UtlPool.Factory<LogObject> {
        private LogObjectPoolFactory() {
        }

        public final LogObject createItem(Object object) {
            return new LogObject();
        }

        public final LogObject[] createItemArray(int size) {
            return new LogObject[size];
        }
    }

    private final class MemoryMappedBuffers {
        private final XIndexedList<MappedByteBuffer> mapBuffers = new XIndexedList();
        private final XIndexedList<IOBuffer> ioBuffers = new XIndexedList();

        MemoryMappedBuffers() {
        }

        final void open() {
            if (this.mapBuffers.size() > 0) {
                throw new InternalError("map buffer list is not empty");
            }
            if (this.ioBuffers.size() > 0) {
                throw new InternalError("IO buffer list is not empty");
            }
        }

        final MappedByteBuffer getMapBuffer(int index) {
            return (MappedByteBuffer)this.mapBuffers.get(index);
        }

        final IOBuffer getIOBuffer(int index) {
            return (IOBuffer)this.ioBuffers.get(index);
        }

        final int map(FileChannel fileChannel, long position, long maxFilePointer) throws IOException {
            long logSize = RogLogCompactingReader.this.log.getSize();
            int bytesToMap = (int)Math.min(Math.min(logSize, maxFilePointer) - position, Integer.MAX_VALUE);
            MappedByteBuffer mapBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, position, bytesToMap);
            if (((RogLogCompactingReader)RogLogCompactingReader.this).tracer.debug) {
                RogLogCompactingReader.this.tracer.log("[Compaction Reader] Created new mapped buffer [position=" + position + ", maxFilePointer=" + maxFilePointer + ", logSize=" + logSize + ", bytesMapped=" + bytesToMap + "]", Tracer.Level.DEBUG);
            }
            IOBuffer ioBuffer = IOBuffer.wrap((ByteBuffer)mapBuffer);
            this.mapBuffers.add((Object)mapBuffer);
            this.ioBuffers.add((Object)ioBuffer);
            if (((RogLogCompactingReader)RogLogCompactingReader.this).tracer.debug) {
                RogLogCompactingReader.this.tracer.log("[Compaction Reader] Number of mapped buffers is " + this.mapBuffers.size(), Tracer.Level.DEBUG);
            }
            return this.mapBuffers.size() - 1;
        }

        final void close() {
            if (((RogLogCompactingReader)RogLogCompactingReader.this).tracer.debug) {
                RogLogCompactingReader.this.tracer.log("[Compaction Reader] Closing mapped buffer list [count=" + this.mapBuffers.size() + "]", Tracer.Level.DEBUG);
            }
            for (int i = 0; i < this.mapBuffers.size(); ++i) {
                UtlBuffer.releaseBuffer((ByteBuffer)this.getMapBuffer(i));
                this.getIOBuffer(i).dispose();
            }
            this.mapBuffers.clear();
            this.ioBuffers.clear();
        }
    }
}

