/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlUnit;
import java.util.Properties;

public class RogLogCheckpointReaderParams {
    static final Properties defaultProps = new Properties();
    public static final String PROP_ENTRY_RETENTION_THRESHOLD = "entryRetentionThreshold";
    public static final int PROP_ENTRY_RETENTION_THRESHOLD_DEFAULT = 100;
    public static final String PROP_CONFLATE_CHECKPOINTS = "conflateCheckpoints";
    public static final boolean PROP_CONFLATE_CHECKPOINTS_DEFAULT = false;
    public static final String PROP_SKIP_CDC_CHECKPOINTED = "skipCdcCheckpointed";
    public static final boolean PROP_SKIP_CDC_CHECKPOINTED_DEFAULT = false;
    public static final String PROP_OFF_HEAP_BUFFERING = "offheapBuffering";
    public static final boolean PROP_OFF_HEAP_BUFFERING_DEFAULT = false;
    public static final String PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY = "offheapBufferingLoadStrategy";
    public static final OffheapBufferingLoadStrategy PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY_DEFAULT;
    public static final String PROP_OFF_HEAP_BUFFERING_MAX_PAGE_SIZE = "offheapBufferingMaxPageSize";
    public static final String PROP_OFF_HEAP_BUFFERING_MAX_PAGE_SIZE_DEFAULT = "128kb";
    public static final String PROP_MEM_MAPPED_READ_BUFFER_LOAD = "memMappedReadBufferLoad";
    public static final boolean PROP_MEM_MAPPED_READ_BUFFER_LOAD_DEFAULT = false;
    public static final String PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE = "memMappedReadBufferMaxSize";
    public static final String PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE_DEFAULT = "1gb";
    final int entryRetentionThreshold;
    final boolean offheapBuffering;
    final boolean conflateCheckpoints;
    final boolean skipCdcCheckpointed;
    final OffheapBufferingLoadStrategy offHeapBufferingLoadStrategy;
    final int offHeapBufferingMaxPageSize;
    final boolean memMappedReadBufferLoad;
    final int memMappedReadBufferMaxSize;

    RogLogCheckpointReaderParams(Properties props) {
        this.conflateCheckpoints = UtlProps.getValue((Properties)props, (String)PROP_CONFLATE_CHECKPOINTS, (boolean)false);
        this.entryRetentionThreshold = UtlProps.getValue((Properties)props, (String)PROP_ENTRY_RETENTION_THRESHOLD, (int)100);
        this.skipCdcCheckpointed = UtlProps.getValue((Properties)props, (String)PROP_SKIP_CDC_CHECKPOINTED, (boolean)false);
        this.offheapBuffering = UtlProps.getValue((Properties)props, (String)PROP_OFF_HEAP_BUFFERING, (boolean)false);
        this.offHeapBufferingLoadStrategy = (OffheapBufferingLoadStrategy)((Object)UtlDataTypes.convert(OffheapBufferingLoadStrategy.class, (Object)UtlProps.getValue((Properties)props, (String)PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY, (String)PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY_DEFAULT.name())));
        this.memMappedReadBufferLoad = UtlProps.getValue((Properties)props, (String)PROP_MEM_MAPPED_READ_BUFFER_LOAD, (boolean)false);
        this.memMappedReadBufferMaxSize = Math.max(8192, (int)Math.min(2.147483647E9, UtlUnit.parseBytes((String)UtlProps.getValue((Properties)props, (String)PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE, (String)PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE_DEFAULT), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes)));
        this.offHeapBufferingMaxPageSize = Math.max(8192, (int)Math.min(2.147483647E9, UtlUnit.parseBytes((String)UtlProps.getValue((Properties)props, (String)PROP_OFF_HEAP_BUFFERING_MAX_PAGE_SIZE, (String)PROP_OFF_HEAP_BUFFERING_MAX_PAGE_SIZE_DEFAULT), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes)));
    }

    final void dump(StringBuilder sb, String prefix) {
        sb.append(prefix).append(PROP_CONFLATE_CHECKPOINTS).append("=").append(this.conflateCheckpoints).append("\n");
        sb.append(prefix).append(PROP_ENTRY_RETENTION_THRESHOLD).append("=").append(this.entryRetentionThreshold).append("\n");
        sb.append(prefix).append(PROP_OFF_HEAP_BUFFERING).append("=").append(this.offheapBuffering).append(" {\n");
        sb.append(prefix).append("...").append(PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY).append("=").append(this.offheapBuffering ? this.offHeapBufferingLoadStrategy : "none").append("\n");
        sb.append(prefix).append("...").append(PROP_OFF_HEAP_BUFFERING_MAX_PAGE_SIZE).append("=").append(this.offHeapBufferingMaxPageSize).append(" (").append(UtlUnit.readableBytesSize((long)this.offHeapBufferingMaxPageSize)).append(")").append("\n");
        sb.append(prefix).append("...").append(PROP_MEM_MAPPED_READ_BUFFER_LOAD).append("=").append(this.memMappedReadBufferLoad).append("\n");
        sb.append(prefix).append("...").append(PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE).append("=").append(this.memMappedReadBufferMaxSize).append(" (").append(UtlUnit.readableBytesSize((long)this.memMappedReadBufferMaxSize)).append(")").append("\n");
        sb.append(prefix).append("}\n");
        sb.append(prefix).append(PROP_SKIP_CDC_CHECKPOINTED).append("=").append(this.skipCdcCheckpointed).append("\n");
    }

    static {
        defaultProps.put(PROP_ENTRY_RETENTION_THRESHOLD, (Object)100);
        defaultProps.put(PROP_CONFLATE_CHECKPOINTS, (Object)false);
        defaultProps.put(PROP_SKIP_CDC_CHECKPOINTED, (Object)false);
        defaultProps.put(PROP_OFF_HEAP_BUFFERING, (Object)false);
        PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY_DEFAULT = OffheapBufferingLoadStrategy.RandomAccessFile;
        defaultProps.put(PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY, PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY_DEFAULT.name());
        defaultProps.put(PROP_OFF_HEAP_BUFFERING_MAX_PAGE_SIZE, PROP_OFF_HEAP_BUFFERING_MAX_PAGE_SIZE_DEFAULT);
        defaultProps.put(PROP_MEM_MAPPED_READ_BUFFER_LOAD, String.valueOf(false));
        defaultProps.put(PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE, PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE_DEFAULT);
    }

    public static enum OffheapBufferingLoadStrategy {
        PktReader,
        RandomAccessFile,
        MemoryMappedRead,
        Disabled;

    }
}

