/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.util;

import com.neeve.query.QueryResultSet;
import com.neeve.query.index.IdxField;
import com.neeve.util.UtlTableFormatter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class UtlQueryResultFormatter {
    private static final String newline = System.getProperty("line.separator");
    private static final UtlTableFormatter tableFormatter = new UtlTableFormatter(false);

    public static final String getHeader(QueryResultSet<?> result, UtlTableFormatter.Format format) {
        String fieldName;
        IdxField<?, ?> field;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (format == UtlTableFormatter.Format.HTML) {
            sb.append("<table border=\"1\">").append(newline);
            sb.append("  <thead>\n").append(newline);
            sb.append("     <tr>").append(newline);
        }
        for (int i = 0; i < result.getSelectedFields().size(); ++i) {
            field = result.getSelectedFields().get(i);
            fieldName = result.getSelectedFieldNames().get(i);
            int length = fieldName.length();
            switch (format) {
                case CSV: {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(fieldName);
                    break;
                }
                case TABULAR: {
                    sb.append('|');
                    length = tableFormatter.calculateFieldLength(fieldName, field.getFieldType());
                    sb.append(String.format("%" + length + "s", fieldName));
                    break;
                }
                case HTML: {
                    sb.append("<th>").append(fieldName).append("</th>");
                }
            }
            first = false;
        }
        switch (format) {
            case CSV: {
                sb.append(newline);
                break;
            }
            case HTML: {
                sb.append("     </tr>").append(newline);
                sb.append("  </thead>").append(newline);
                sb.append("  <tbody>").append(newline);
                break;
            }
            case TABULAR: {
                sb.append("|\n");
                for (int f = 0; f < result.getSelectedFields().size(); ++f) {
                    field = result.getSelectedFields().get(f);
                    fieldName = result.getSelectedFieldNames().get(f);
                    sb.append('+');
                    for (int i = 0; i < tableFormatter.calculateFieldLength(fieldName, field.getFieldType()); ++i) {
                        sb.append("-");
                    }
                }
                sb.append("+").append(newline);
            }
        }
        return sb.toString();
    }

    public static final String getRowFormatString(QueryResultSet<?> result, UtlTableFormatter.Format format) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (format == UtlTableFormatter.Format.HTML) {
            sb.append("     <tr>");
        }
        for (int i = 0; i < result.getSelectedFields().size(); ++i) {
            IdxField<?, ?> field = result.getSelectedFields().get(i);
            String fieldName = result.getSelectedFieldNames().get(i);
            switch (format) {
                case CSV: {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append("%s");
                    break;
                }
                case HTML: {
                    sb.append("<td>%s</td>");
                    break;
                }
                case TABULAR: {
                    sb.append('|');
                    sb.append(tableFormatter.getColumnFormat(fieldName, field.getFieldType(), tableFormatter.calculateFieldLength(fieldName, field.getFieldType())));
                }
            }
            first = false;
        }
        switch (format) {
            case CSV: {
                sb.append(newline);
                break;
            }
            case HTML: {
                sb.append("</tr>").append(newline);
                break;
            }
            case TABULAR: {
                sb.append("|").append(newline);
            }
        }
        return sb.toString();
    }

    public static final String getFooter(QueryResultSet<?> result, UtlTableFormatter.Format format) {
        StringBuilder sb = new StringBuilder();
        switch (format) {
            case CSV: {
                break;
            }
            case HTML: {
                sb.append("</table>").append(newline);
                break;
            }
            case TABULAR: {
                for (int f = 0; f < result.getSelectedFields().size(); ++f) {
                    IdxField<?, ?> field = result.getSelectedFields().get(f);
                    String fieldName = result.getSelectedFieldNames().get(f);
                    sb.append('+');
                    for (int i = 0; i < tableFormatter.calculateFieldLength(fieldName, field.getFieldType()); ++i) {
                        sb.append("-");
                    }
                }
                sb.append("+").append(newline);
            }
        }
        return sb.toString();
    }

    public static final <T> String formatRow(QueryResultSet<T> result, String formatString, UtlTableFormatter.Format format) {
        Object[] values = new Object[result.getSelectedFields().size()];
        List<IdxField<T, ?>> fields = result.getSelectedFields();
        for (int i = 0; i < values.length; ++i) {
            values[i] = tableFormatter.formatColumn(result.getSelectedFieldNames().get(i), fields.get(i).getFieldType(), result.getObject(i + 1), format);
        }
        return String.format(formatString, values);
    }

    public static String formatResults(QueryResultSet<?> result, int count, UtlTableFormatter.Format format) {
        StringWriter rc = new StringWriter();
        try {
            UtlQueryResultFormatter.dumpResults(result, count, format, new BufferedWriter(rc));
        }
        catch (IOException e) {
            throw new RuntimeException("Error dumping results");
        }
        return rc.toString();
    }

    public static void dumpNext(QueryResultSet<?> result, int count, UtlTableFormatter.Format format, PrintStream out) {
        try {
            UtlQueryResultFormatter.dumpResults(result, count, format, new BufferedWriter(new PrintWriter(out)));
        }
        catch (IOException e) {
            throw new RuntimeException("Error dumping results");
        }
    }

    public static void dumpResults(QueryResultSet<?> result, int count, UtlTableFormatter.Format format, BufferedWriter writer) throws IOException {
        writer.append(UtlQueryResultFormatter.getHeader(result, format));
        String rowFormat = UtlQueryResultFormatter.getRowFormatString(result, format);
        for (int i = 0; (count < 0 || i < count) && result.next(); ++i) {
            writer.append(UtlQueryResultFormatter.formatRow(result, rowFormat, format));
        }
        writer.append(UtlQueryResultFormatter.getFooter(result, format));
        writer.flush();
    }

    public static void dumpNext(QueryResultSet<?> result, int count, UtlTableFormatter.Format format, StringBuilder builder) {
        builder.append(UtlQueryResultFormatter.getHeader(result, format));
        String rowFormat = UtlQueryResultFormatter.getRowFormatString(result, format);
        for (int i = 0; (count < 0 || i < count) && result.next(); ++i) {
            builder.append(UtlQueryResultFormatter.formatRow(result, rowFormat, format));
        }
        builder.append(UtlQueryResultFormatter.getFooter(result, format));
    }
}

