/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryConfig;
import com.neeve.query.impl.QueryObject;
import com.neeve.query.impl.index.IdxBaseIndex;
import com.neeve.query.impl.index.IdxComparatorRegistry;
import com.neeve.query.impl.index.IdxNonUniqueTreeIndex;
import com.neeve.query.impl.index.IdxUniqueBaseIndex;
import com.neeve.query.impl.index.IdxUniqueTreeIndex;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThread;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mapdb.Atomic;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Fun;

public class IdxIndexManager<ID, REC>
extends QueryObject {
    private static final String NVX = "nvx:";
    private static final String COMMIT_SEQUENCE_NUMBER_KEY = "nvx:commitSeqNo";
    private final Mode mode;
    private DB db;
    private Map<String, String> properties;
    private Map<String, String> canonicalNames;
    private Map<String, IdxIndex.Stats<?>> statsMap;
    private File indexFile;
    private boolean asyncWrites = false;
    private int asyncFlushMillis = 5;
    private boolean stringDeltaCompression = true;
    private volatile Set<CountDownLatch> closingTempDbs = Sets.newHashSet();
    private Map<String, IdxIndex<?, ID>> indexCache = Maps.newHashMap();
    private Atomic.Long liveCommitSequenceNumber;

    public static <ID, REC> IdxIndexManager<ID, REC> createFileBased(File directory, String name) {
        return new IdxIndexManager<ID, REC>(directory, name);
    }

    public static <ID, REC> IdxIndexManager<ID, REC> createMemoryBased() {
        return new IdxIndexManager<ID, REC>(Mode.MEMORY);
    }

    public static <ID, REC> IdxIndexManager<ID, REC> createTemp() {
        return new IdxIndexManager<ID, REC>(Mode.TEMP);
    }

    private IdxIndexManager(Mode mode) {
        super(QueryConfig.getConfig());
        this.mode = mode;
    }

    private IdxIndexManager(File directory, String name) {
        this(Mode.FILE);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.indexFile = new File(directory, name);
        if (this.tracer.debug) {
            this.tracer.log("[IdxIndexManager] Created (liveCommitSequenceNumber=" + this.liveCommitSequenceNumber + ")", Tracer.Level.DEBUG);
        }
    }

    public void setAsyncWrite(boolean async) {
        this.asyncWrites = async;
    }

    public void setAsyncFlushMillis(int flushMillis) {
        this.asyncFlushMillis = flushMillis;
    }

    public void setStringDeltaCompression(boolean compress) {
        this.stringDeltaCompression = compress;
    }

    public void open() {
        if (this.db == null) {
            try {
                this.loadDb();
            }
            catch (Exception e) {
                if (this.mode == Mode.FILE) {
                    this.indexFile.delete();
                    this.loadDb();
                }
                if (e instanceof QueryException) {
                    throw (QueryException)((Object)e);
                }
                throw new QueryException(e);
            }
        }
    }

    private void loadDb() {
        DBMaker maker;
        switch (this.mode) {
            case FILE: {
                if (!this.indexFile.exists()) {
                    try {
                        this.indexFile.createNewFile();
                    }
                    catch (IOException e) {
                        throw new QueryException("Cannot create the index file.", e);
                    }
                }
                maker = DBMaker.newFileDB((File)this.indexFile);
                if (!this.asyncWrites) break;
                maker = maker.asyncWriteEnable().asyncWriteFlushDelay(this.asyncFlushMillis);
                break;
            }
            case MEMORY: {
                maker = DBMaker.newMemoryDB();
                break;
            }
            case TEMP: {
                maker = DBMaker.newTempFileDB().asyncWriteEnable().asyncWriteFlushDelay(this.asyncFlushMillis).transactionDisable().deleteFilesAfterClose();
                break;
            }
            default: {
                throw new QueryException("Unrecognized mode: " + (Object)((Object)this.mode));
            }
        }
        if (this.mode != Mode.MEMORY) {
            maker = maker.closeOnJvmShutdown();
            if (!System.getProperty("os.name").startsWith("Windows")) {
                maker = maker.mmapFileEnable();
            }
        }
        this.db = maker.make();
        this.canonicalNames = this.db.getTreeMap("nvx:canonicalNames");
        this.statsMap = this.db.getTreeMap("nvx:indexStats");
        this.properties = this.db.getHashMap("nvx:properties");
        this.db.commit();
        this.loadIndexes();
        this.db.commit();
    }

    public synchronized void close() {
        try {
            this.indexCache.clear();
            if (this.db != null) {
                if (this.mode == Mode.FILE) {
                    this.db.rollback();
                    this.db.compact();
                }
                if (this.mode == Mode.TEMP) {
                    this.closeAsynchronously(this.db);
                } else {
                    this.db.close();
                }
            }
        }
        finally {
            this.db = null;
            this.canonicalNames = null;
            this.statsMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAsynchronously(final DB mapdb) {
        final CountDownLatch closingTempDb = new CountDownLatch(1);
        IdxIndexManager idxIndexManager = this;
        synchronized (idxIndexManager) {
            this.closingTempDbs.add(closingTempDb);
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UtlThread.setDefaultCPUAffinityMask();
                mapdb.close();
                closingTempDb.countDown();
                IdxIndexManager idxIndexManager = IdxIndexManager.this;
                synchronized (idxIndexManager) {
                    IdxIndexManager.this.closingTempDbs.remove(closingTempDb);
                }
            }
        }, "Index Storage Cleaner").start();
    }

    public boolean isOpen() {
        return this.db != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown() throws InterruptedException {
        ArrayList latches;
        IdxIndexManager idxIndexManager = this;
        synchronized (idxIndexManager) {
            latches = Lists.newArrayList(this.closingTempDbs);
        }
        for (CountDownLatch closingTempDb : latches) {
            closingTempDb.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitShutdown(long millis) {
        ArrayList latches;
        IdxIndexManager idxIndexManager = this;
        synchronized (idxIndexManager) {
            latches = Lists.newArrayList(this.closingTempDbs);
        }
        try {
            long toWait = millis;
            for (CountDownLatch closingTempDb : latches) {
                long startWaiting = System.currentTimeMillis();
                if (closingTempDb.await(toWait, TimeUnit.MILLISECONDS)) {
                    long waited = System.currentTimeMillis() - startWaiting;
                    waited = waited <= toWait ? waited : toWait;
                    toWait -= waited;
                    continue;
                }
                return false;
            }
            return true;
        }
        catch (InterruptedException ie) {
            return false;
        }
    }

    public boolean exists() {
        return this.db != null || this.mode == Mode.FILE && this.indexFile.exists();
    }

    public void delete() {
        if (this.db != null) {
            throw new IllegalStateException("Attempt to delete an open index file: " + this.indexFile.getName());
        }
        if (this.mode == Mode.FILE) {
            this.indexFile.delete();
            final ArrayList tempFiles = new ArrayList();
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.getName().startsWith(IdxIndexManager.this.indexFile.getName())) {
                        tempFiles.add(pathname);
                        return true;
                    }
                    return false;
                }
            };
            this.indexFile.getParentFile().listFiles(filter);
            for (File tempFile : tempFiles) {
                int retries = 0;
                while (tempFile.exists() && retries < 10) {
                    tempFile.delete();
                    if (!tempFile.exists()) continue;
                    try {
                        Thread.sleep(100L);
                        if (++retries != 10) continue;
                        this.tracer.log("Couldn't delete " + tempFile, Tracer.Level.WARNING);
                    }
                    catch (InterruptedException e) {
                        retries = 10;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    public void rename(String newName) throws QueryException {
        boolean dbWasOpen;
        if (this.mode != Mode.FILE) {
            return;
        }
        final String oldName = this.indexFile.getName();
        if (oldName.equals(newName)) {
            return;
        }
        boolean bl = dbWasOpen = this.db != null;
        if (dbWasOpen) {
            this.close();
            try {
                this.awaitShutdown();
            }
            catch (InterruptedException e) {
                throw new QueryException("Shutdown failed during attempted rename of mapdb file", e);
            }
        }
        if (!this.indexFile.renameTo(new File(this.indexFile.getParentFile(), newName))) {
            throw new QueryException("Error renaming index file to " + new File(this.indexFile.getParentFile(), newName));
        }
        this.indexFile = new File(this.indexFile.getParentFile(), newName);
        final ArrayList tempFiles = new ArrayList();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().startsWith(oldName)) {
                    tempFiles.add(pathname);
                    return true;
                }
                return false;
            }
        };
        this.indexFile.getParentFile().listFiles(filter);
        for (File tempFile : tempFiles) {
            tempFile.renameTo(new File(tempFile.getParentFile(), newName + tempFile.getName().substring(oldName.length())));
        }
        if (dbWasOpen) {
            this.open();
        }
    }

    public void rollback() {
        this.db.rollback();
        for (IdxIndex<?, ID> index : this.indexCache.values()) {
            if (!((IdxBaseIndex.StatsImpl)((IdxBaseIndex)index).getStats()).resetDirty()) continue;
            String canonicalName = index.getField().getCanonicalName();
            ((IdxBaseIndex)index).setStats(this.statsMap.get(canonicalName));
        }
    }

    public void commit(long commitSequenceNumber) {
        long liveCommitSequenceNumber = this.liveCommitSequenceNumber.get();
        if (this.tracer.debug) {
            this.tracer.log("[IdxIndexManager] Commit start (commitSequenceNumber=" + commitSequenceNumber + ", liveCommitSequenceNumber=" + liveCommitSequenceNumber + ")", Tracer.Level.DEBUG);
        }
        boolean live = commitSequenceNumber >= liveCommitSequenceNumber;
        for (IdxIndex<?, ID> index : this.indexCache.values()) {
            IdxBaseIndex indexImpl = (IdxBaseIndex)index;
            boolean statsUpdated = false;
            if (((IdxBaseIndex.StatsImpl)indexImpl.getStats()).resetDirty()) {
                indexImpl.stats.setCommitSequenceNumber(commitSequenceNumber);
                statsUpdated = true;
            }
            if (!indexImpl.stats.isLive()) {
                if (live) {
                    indexImpl.stats.setLive(true);
                    statsUpdated = true;
                    if (this.tracer.debug) {
                        this.tracer.log("Trailing index caught up: " + index + " commitSequenceNumber: " + commitSequenceNumber, Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log("Index build: " + index + " - " + indexImpl.stats.getCommitSequenceNumber() + " < " + liveCommitSequenceNumber, Tracer.Level.DEBUG);
                }
            }
            if (!statsUpdated) continue;
            this.statsMap.put(index.getField().getCanonicalName(), index.getStats());
        }
        if (live) {
            this.liveCommitSequenceNumber.set(commitSequenceNumber);
        }
        if (this.tracer.debug) {
            this.tracer.log("[IdxIndexManager] Commit complete (liveCommitSequenceNumber=" + this.liveCommitSequenceNumber + ")", Tracer.Level.DEBUG);
        }
        this.db.commit();
    }

    public <T> IdxIndex.Stats<T> getIndexStats(IdxField<REC, T> field) {
        String canonicalName = field.getCanonicalName();
        IdxIndex<?, ID> index = this.indexCache.get(canonicalName);
        if (index == null) {
            return null;
        }
        return index.getStats();
    }

    public <T> IdxUniqueBaseIndex<T, ID> createUniqueIndex(IdxField<REC, T> field, String name) {
        IdxUniqueBaseIndex<T, ID> index = this.getUniqueIndex(field);
        if (index != null) {
            return index;
        }
        String canonicalName = field.getCanonicalName();
        if (name == null) {
            name = canonicalName;
        }
        DB.BTreeMapMaker builder = this.db.createTreeMap(canonicalName).counterEnable();
        Comparator<T> keyComparator = IdxComparatorRegistry.lookup(field.getFieldType());
        if (keyComparator != null) {
            builder.comparator(keyComparator);
        }
        if (this.stringDeltaCompression && field.getFieldType() == String.class) {
            builder = builder.keySerializer(BTreeKeySerializer.STRING);
        }
        BTreeMap map = builder.make();
        index = new IdxUniqueTreeIndex(name, map);
        index.setField(field);
        this.canonicalNames.put(name, canonicalName);
        this.statsMap.put(canonicalName, index.getStats());
        this.indexCache.put(canonicalName, index);
        this.db.commit();
        return index;
    }

    public <T> IdxNonUniqueTreeIndex<T, ID> createNonUniqueIndex(IdxField<REC, T> field, String name) {
        IdxNonUniqueTreeIndex<T, ID> index = this.getNonUniqueIndex(field);
        if (index != null) {
            return index;
        }
        String canonicalName = field.getCanonicalName();
        if (name == null) {
            name = canonicalName;
        }
        DB.BTreeSetMaker setBuilder = this.db.createTreeSet(canonicalName).counterEnable();
        DB.BTreeSetMaker keySetBuilder = this.db.createTreeSet(this.getKeysetName(canonicalName)).counterEnable();
        Comparator<T> keyComparator = IdxComparatorRegistry.lookup(field.getFieldType());
        if (keyComparator != null) {
            Fun.Tuple2Comparator setComparator = new Fun.Tuple2Comparator(keyComparator, null);
            setBuilder.comparator((Comparator)setComparator);
            keySetBuilder.comparator(keyComparator);
        }
        NavigableSet set = setBuilder.make();
        NavigableSet keySet = keySetBuilder.make();
        index = new IdxNonUniqueTreeIndex(name, keySet, set);
        index.setField(field);
        this.canonicalNames.put(name, canonicalName);
        this.statsMap.put(canonicalName, index.getStats());
        this.indexCache.put(canonicalName, index);
        this.db.commit();
        return index;
    }

    private String getKeysetName(String name) {
        return "nvxKeys:" + name;
    }

    public <T> IdxIndex<T, ID> getIndex(IdxField<REC, T> field) {
        String canonicalName = field.getCanonicalName();
        return this.indexCache.get(canonicalName);
    }

    public <T> IdxUniqueBaseIndex<T, ID> getUniqueIndex(IdxField<REC, T> field) {
        IdxIndex<T, ID> index = this.getIndex(field);
        if (index == null || index.isUnique()) {
            return (IdxUniqueBaseIndex)index;
        }
        throw new QueryException("This index is non-unique");
    }

    public <T> IdxNonUniqueTreeIndex<T, ID> getNonUniqueIndex(IdxField<REC, T> field) {
        IdxIndex<T, ID> index = this.getIndex(field);
        if (index == null || !index.isUnique()) {
            return (IdxNonUniqueTreeIndex)index;
        }
        throw new QueryException("This index is unique");
    }

    private final <T> void loadIndexes() {
        for (Map.Entry<String, String> nameEntry : this.canonicalNames.entrySet()) {
            IdxBaseIndex index;
            String name = nameEntry.getKey();
            String canonicalName = nameEntry.getValue();
            IdxIndex.Stats<?> stats = this.statsMap.get(canonicalName);
            if (stats.isUnique()) {
                BTreeMap map = this.db.getTreeMap(canonicalName);
                index = new IdxUniqueTreeIndex(name, map);
            } else {
                NavigableSet set = this.db.getTreeSet(canonicalName);
                NavigableSet keySet = this.db.getTreeSet(this.getKeysetName(canonicalName));
                index = new IdxNonUniqueTreeIndex(name, keySet, set);
            }
            index.setStats(stats);
            this.indexCache.put(canonicalName, index);
            this.tracer.log("Loaded index " + index, Tracer.Level.VERBOSE);
        }
        this.liveCommitSequenceNumber = this.db.getAtomicLong(COMMIT_SEQUENCE_NUMBER_KEY);
        if (this.liveCommitSequenceNumber == null) {
            this.liveCommitSequenceNumber = this.db.createAtomicLong(COMMIT_SEQUENCE_NUMBER_KEY, -1L);
        }
        this.tracer.log("Loaded " + this.indexCache.size() + " indexes, last commit sequence: " + this.liveCommitSequenceNumber.get(), Tracer.Level.VERBOSE);
    }

    public final <T> boolean dropIndex(String name) {
        String indexName = null;
        String canonicalName = null;
        if (this.canonicalNames.containsKey(name)) {
            indexName = name;
            canonicalName = this.canonicalNames.get(name);
        } else {
            for (Map.Entry<String, String> nameEntry : this.canonicalNames.entrySet()) {
                if (!nameEntry.getValue().equals(name)) continue;
                indexName = nameEntry.getKey();
                canonicalName = nameEntry.getValue();
                break;
            }
        }
        if (canonicalName != null) {
            this.canonicalNames.remove(indexName);
            this.statsMap.remove(canonicalName);
            IdxIndex<?, ID> index = this.indexCache.remove(canonicalName);
            if (!index.isUnique()) {
                this.db.delete(this.getKeysetName(canonicalName));
            }
            this.db.delete(canonicalName);
            this.db.commit();
            return true;
        }
        return false;
    }

    public <T> boolean dropIndex(IdxField<REC, T> field) {
        String canonicalName = field.getCanonicalName();
        return this.dropIndex(canonicalName);
    }

    public Collection<IdxIndex<?, ID>> getIndexes() {
        return this.indexCache.values();
    }

    public long getLiveCommitSequenceNumber() {
        return this.liveCommitSequenceNumber.get();
    }

    public final void setIndexProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public final String getIndexProperty(String name) {
        return this.properties.get(name);
    }

    public void clear(boolean dropIndexes) {
        HashMap propertiesBackup = Maps.newHashMap(this.properties);
        ArrayList indexes = dropIndexes ? null : Lists.newArrayList(this.getIndexes());
        this.close();
        if (this.mode == Mode.FILE) {
            this.delete();
        }
        this.open();
        this.properties.putAll(propertiesBackup);
        if (!dropIndexes) {
            for (IdxIndex index : indexes) {
                if (index.isUnique()) {
                    this.createUniqueIndex(index.getField(), index.getName());
                    continue;
                }
                this.createNonUniqueIndex(index.getField(), index.getName());
            }
        }
        this.liveCommitSequenceNumber.set(0L);
        this.commit(0L);
    }

    public boolean isLiveCommitSequenceNumber(long commitSequence) {
        long currentCommitSequence = this.getLiveCommitSequenceNumber();
        return commitSequence > currentCommitSequence || currentCommitSequence <= 0L;
    }

    public DB getMapDb() {
        return this.db;
    }

    public String getName() {
        if (this.mode == Mode.FILE) {
            return this.indexFile.getName();
        }
        return this.mode.toString();
    }

    private static enum Mode {
        FILE,
        MEMORY,
        TEMP;

    }
}

