/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.Maps;
import com.neeve.query.QueryException;
import com.neeve.query.QueryIndexer;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryMonotonicField;
import com.neeve.query.impl.QueryObject;
import com.neeve.query.impl.index.IdxIndexerImpl;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.query.index.IdxUniqueIndex;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlReadWriteLock;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class QueryRepositoryBase<ID, REC>
extends QueryObject
implements QueryIndexableRepository<ID, REC> {
    private volatile long liveCommitSequenceNumber;
    protected QueryIndexer<ID, REC> indexer;
    private final UtlReadWriteLock indexerLock;
    private boolean started = false;
    private final File dataDirectory;
    private String name;
    private Map<IdxField<REC, ?>, QueryMonotonicField<REC, ?, ID>> monotonicFields = Maps.newHashMap();
    private boolean indexerEarlyCreated = this.isIndexerEarlyCreated();

    protected QueryRepositoryBase(File dataDirectory, String name, RootConfig.ObjectConfig config) {
        super(config);
        this.dataDirectory = dataDirectory;
        this.indexerLock = UtlReadWriteLock.create((String)name);
        this.name = name;
        if (this.indexerEarlyCreated) {
            this.indexer = this.createIndexer();
        }
    }

    private QueryIndexer<ID, REC> createIndexer() {
        return this.dataDirectory == null ? IdxIndexerImpl.createMemoryBased(this) : IdxIndexerImpl.createFileBased(this.dataDirectory, this.getName() + ".index", this);
    }

    protected final void index(REC value) throws InterruptedException {
        this.indexerLock.getWriteLock();
        try {
            if (this.tracer.debug) {
                this.tracer.log("Indexing: " + value, Tracer.Level.DEBUG);
            }
            this.indexer.put(value);
        }
        finally {
            this.indexerLock.releaseLock();
        }
    }

    protected final void removeIndexing(REC value) throws InterruptedException {
        this.indexerLock.getWriteLock();
        try {
            if (this.tracer.debug) {
                this.tracer.log("Deindexing: " + value, Tracer.Level.DEBUG);
            }
            this.indexer.remove(value);
        }
        finally {
            this.indexerLock.releaseLock();
        }
    }

    protected final void updateIndexing(REC before, REC after) throws InterruptedException {
        this.indexerLock.getWriteLock();
        try {
            if (this.tracer.debug) {
                this.tracer.log("Updating indexing: " + before, Tracer.Level.DEBUG);
            }
            this.indexer.update(before, after);
        }
        finally {
            this.indexerLock.releaseLock();
        }
    }

    protected final void commit(long commitSequenceNumber) throws InterruptedException {
        this.indexerLock.getWriteLock();
        try {
            this.indexer.commit(commitSequenceNumber);
            this.liveCommitSequenceNumber = Math.max(this.liveCommitSequenceNumber, commitSequenceNumber);
        }
        finally {
            this.indexerLock.releaseLock();
        }
    }

    @Override
    public final <T> IdxIndex<T, ID> createIndex(IdxField<REC, T> field, boolean unique) {
        return this.createIndex(field, unique, null);
    }

    private void beforeDdl() throws QueryException {
        try {
            this.stopIndexing();
            this.indexerLock.getWriteLock();
            this.indexer.rollback();
        }
        catch (InterruptedException ie) {
            this.indexerLock.releaseLock();
            Thread.currentThread().interrupt();
            throw new QueryException("Interrupted creating index", ie);
        }
        catch (QueryException qe) {
            this.indexerLock.releaseLock();
            throw qe;
        }
    }

    private void afterDdl(long commitSequenceNumber) {
        try {
            this.indexer.commit(0L);
            this.startIndexing(commitSequenceNumber);
        }
        finally {
            this.indexerLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IdxIndex<T, ID> createIndex(IdxField<REC, T> field, boolean unique, String name) throws QueryException {
        IdxIndex<T, ID> idxIndex;
        if (this.indexer == null) {
            throw new QueryException("Can't create an index when closed");
        }
        IdxIndex<T, ID> index = this.indexer.getIndex(field);
        if (index != null) {
            if (name == null || index.getName().equals(name)) {
                if (index.isUnique() == unique) {
                    return index;
                }
                throw new QueryException("A " + (index.isUnique() ? "UNIQUE" : "NON-UNIQUE") + " index already exists on this field.");
            }
            throw new QueryException("An index named '" + index.getName() + "' already exists on this field.");
        }
        try {
            this.beforeDdl();
            idxIndex = index = this.indexer.createIndex(field, unique, name);
        }
        catch (Throwable throwable) {
            try {
                this.afterDdl(index == null ? this.liveCommitSequenceNumber : 0L);
            }
            catch (QueryException qe) {
                this.tracer.log("Error reindexing: " + qe.getMessage(), Tracer.Level.SEVERE);
                this.indexer.dropIndex(field);
                this.indexer.commit(0L);
                throw qe;
            }
            throw throwable;
        }
        try {
            this.afterDdl(index == null ? this.liveCommitSequenceNumber : 0L);
        }
        catch (QueryException qe) {
            this.tracer.log("Error reindexing: " + qe.getMessage(), Tracer.Level.SEVERE);
            this.indexer.dropIndex(field);
            this.indexer.commit(0L);
            throw qe;
        }
        return idxIndex;
    }

    protected boolean isIndexerEarlyCreated() {
        return false;
    }

    @Override
    public boolean dropIndex(String indexName) throws QueryException {
        if (this.indexer == null) {
            throw new QueryException("Can't drop an index when closed");
        }
        try {
            this.beforeDdl();
            boolean bl = this.indexer.dropIndex(indexName);
            return bl;
        }
        finally {
            this.afterDdl(this.liveCommitSequenceNumber);
        }
    }

    @Override
    public boolean dropIndex(IdxField<REC, ?> field) {
        if (this.indexer == null) {
            throw new QueryException("Can't drop an index when closed");
        }
        try {
            this.beforeDdl();
            boolean bl = this.indexer.dropIndex(field);
            return bl;
        }
        finally {
            this.afterDdl(this.liveCommitSequenceNumber);
        }
    }

    @Override
    public final List<IdxIndex<?, ID>> getIndexes() {
        if (this.indexer == null) {
            throw new IllegalStateException("Can't retrieve indexes when closed");
        }
        return this.indexer.getIndexes();
    }

    @Override
    public final <T> IdxIndex.Stats<T> getIndexStats(IdxField<REC, T> field) {
        if (this.indexer == null) {
            throw new IllegalStateException("Can't retrieve index stats when closed");
        }
        return this.indexer.getIndexStats(field);
    }

    @Override
    public final <T> IdxUniqueIndex<T, ID> getUniqueIndex(IdxField<REC, T> field) {
        if (this.indexer == null) {
            throw new IllegalStateException("Can't retrieve index when closed");
        }
        return this.indexer.getUniqueIndex(field);
    }

    @Override
    public final <T> IdxIndex<T, ID> getIndex(IdxField<REC, T> field) throws QueryException {
        if (this.indexer == null) {
            throw new IllegalStateException("Can't retrieve index when closed");
        }
        return this.indexer.getIndex(field);
    }

    @Override
    public final <T> IdxNonUniqueIndex<T, ID> getNonUniqueIndex(IdxField<REC, T> field) {
        if (this.indexer == null) {
            throw new IllegalStateException("Can't retrieve index when closed");
        }
        return this.indexer.getNonUniqueIndex(field);
    }

    @Override
    public final Iterable<REC> retrieve(final Iterable<ID> keys) throws QueryException {
        return new Iterable<REC>(){

            @Override
            public Iterator<REC> iterator() {
                final Iterator keyIterator = keys.iterator();
                return new Iterator<REC>(){

                    @Override
                    public boolean hasNext() {
                        return keyIterator.hasNext();
                    }

                    @Override
                    public REC next() {
                        Object position = keyIterator.next();
                        try {
                            return QueryRepositoryBase.this.retrieve(position);
                        }
                        catch (Exception e) {
                            throw new QueryException("Error fetching log entry at " + position + " [" + e.getLocalizedMessage() + "]", e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove is not supported for QueryRepository iterators");
                    }
                };
            }
        };
    }

    @Override
    public final void acquireWriteLock() {
        this.indexerLock.getWriteLockUninterrupted();
    }

    @Override
    public final void releaseWriteLock() {
        this.indexerLock.releaseLock();
    }

    @Override
    public Iterable<REC> retrieveAll() throws QueryException {
        return this.retrieve(0L, Long.MAX_VALUE);
    }

    public abstract Iterable<REC> retrieve(long var1, long var3) throws QueryException;

    protected abstract void stopIndexing() throws QueryException, InterruptedException;

    protected abstract void startIndexing(long var1) throws QueryException;

    @Override
    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open() throws Exception {
        if (!this.started) {
            if (!this.indexerEarlyCreated) {
                this.indexer = this.createIndexer();
            }
            this.indexer.open();
            try {
                this.onIndexerOpened(this.indexer);
                long reindexStartPos = this.liveCommitSequenceNumber = this.indexer.getLiveCommitSequenceNumber();
                for (IdxIndex<?, ID> index : this.getIndexes()) {
                    if (reindexStartPos == 0L) break;
                    if (index.getStats().isLive()) continue;
                    reindexStartPos = Math.min(reindexStartPos, index.getStats().getCommitSequenceNumber());
                }
                this.started = true;
                this.startIndexing(reindexStartPos);
            }
            catch (Exception e) {
                this.tracer.log("Error opening query repository: " + e.getMessage(), Tracer.Level.SEVERE);
                try {
                    if (this.indexer != null) {
                        this.indexer.close();
                    }
                }
                finally {
                    this.indexer = null;
                }
                throw e;
            }
        }
    }

    protected void onIndexerOpened(QueryIndexer<ID, REC> indexer) throws QueryException {
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.indexer != null) {
            try {
                this.indexer.close();
            }
            finally {
                this.indexer = null;
                this.started = false;
            }
        }
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public int getSize() {
        return this.indexer.getSize();
    }

    protected abstract boolean isOrderedRepository();

    @Override
    public <T extends Comparable<T>> void registerMonotonicField(IdxField<REC, T> field, boolean ascending) {
        if (!this.isOrderedRepository()) {
            throw new UnsupportedOperationException("This repository does not have a natural order and so cannot support monotonically increasing/decreasing fields.");
        }
        QueryMonotonicField monotonicField = new QueryMonotonicField(field, ascending);
        this.monotonicFields.put(field, monotonicField);
    }

    public <T extends Comparable<T>> QueryMonotonicField<REC, T, ID> getMonotonicField(IdxField<REC, ?> field) {
        return this.monotonicFields.get(field);
    }

    public Collection<QueryMonotonicField<REC, ?, ID>> getMonotonicFields() {
        return this.monotonicFields.values();
    }
}

