/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.base.Strings;
import com.google.common.primitives.Primitives;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryAbstractField;
import com.neeve.query.impl.index.IdxMappable;
import com.neeve.query.impl.util.UtlQueryReflection;
import java.lang.reflect.Method;

public class QueryReflectionField<RECORD, T>
extends QueryAbstractField<RECORD, T> {
    private static final long serialVersionUID = 1L;
    private static final Class<?>[] NO_ARGS = new Class[0];
    private final String[] path;
    private boolean containsIdxMappablePathComponents = false;

    public QueryReflectionField(Class<? extends RECORD> recordType, Class<T> fieldType, String fieldPath, Class<?> ... pathSelector) {
        super(recordType, fieldPath, fieldType, pathSelector);
        this.path = fieldPath == null ? null : fieldPath.split("\\.");
        this.validateFieldPath();
    }

    private final void validateFieldPath() {
        Class<Object> selectedType = this.recordType;
        Class<Object> beanType = this.recordType;
        if (this.path == null || this.path.length == 0) {
            return;
        }
        for (int i = 0; i < this.path.length; ++i) {
            String accessorName = this.path[i];
            try {
                if (IdxMappable.class.isAssignableFrom(beanType)) {
                    this.containsIdxMappablePathComponents = true;
                    beanType = Object.class;
                } else {
                    Method accessor = null;
                    try {
                        accessor = beanType.getMethod("get" + accessorName.substring(0, 1).toUpperCase() + accessorName.substring(1), NO_ARGS);
                        beanType = accessor.getReturnType();
                    }
                    catch (NoSuchMethodException nsme) {
                        accessor = beanType.getMethod("is" + accessorName.substring(0, 1).toUpperCase() + accessorName.substring(1), NO_ARGS);
                        beanType = accessor.getReturnType();
                    }
                }
                if (i == this.path.length - 1) {
                    selectedType = this.getFieldType();
                } else {
                    Class<Object> clazz = selectedType = this.pathSelector == null || i >= this.pathSelector.length ? Object.class : this.pathSelector[i];
                }
                if (selectedType == Object.class) continue;
                if (beanType.isPrimitive() && !selectedType.isPrimitive()) {
                    beanType = Primitives.wrap(beanType);
                }
                if (!beanType.isAssignableFrom(selectedType)) {
                    throw new QueryException("Invalid fieldPath for " + this + ", selected type " + selectedType.getName() + " at '" + QueryReflectionField.reconstructFieldPath(this.path, i) + "' is not assignable to the bean type " + beanType.getName());
                }
                beanType = selectedType;
                continue;
            }
            catch (SecurityException e) {
                if (selectedType == Object.class) continue;
                throw new QueryException("Invalid fieldPath for " + this + ", " + QueryReflectionField.reconstructFieldPath(this.path, i) + " is not accessible.");
            }
            catch (NoSuchMethodException e) {
                if (selectedType == Object.class) continue;
                throw new QueryException("Invalid fieldPath for " + this + " at " + QueryReflectionField.reconstructFieldPath(this.path, i) + ", " + selectedType.getName() + " has no accessor for " + QueryReflectionField.reconstructFieldPath(this.path, i));
            }
        }
    }

    private static final String reconstructFieldPath(String[] paths, int index) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= index; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(paths[i]);
        }
        return sb.toString();
    }

    public final T apply(RECORD entity) {
        if (Strings.isNullOrEmpty((String)this.fieldPath)) {
            return (T)entity;
        }
        if (entity == null) {
            return null;
        }
        if (!this.getTypePredicate().apply(entity)) {
            return null;
        }
        Object rc = null;
        if (this.containsIdxMappablePathComponents) {
            RECORD bean = entity;
            for (int i = 0; i < this.path.length && bean != null; ++i) {
                Object o = null;
                if (bean instanceof IdxMappable) {
                    o = ((IdxMappable)bean).getQueryFieldValue(this.path[i]);
                }
                if (o == null) {
                    o = UtlQueryReflection.getProperty(bean, (String)this.path[i]);
                }
                bean = o;
            }
            rc = bean;
        }
        if (rc == null) {
            rc = UtlQueryReflection.getProperty(entity, (String)this.fieldPath);
        }
        return (T)rc;
    }

    @Override
    public double getCost() {
        return 1.0 + super.getCost();
    }
}

