/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.EmxNwLnk;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOBufferPacket;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.impl.EStoreReplicatorMemberLinkException;
import com.neeve.ods.impl.StoreMemberReplicationStatus;
import com.neeve.ods.impl.StoreReplicator;
import com.neeve.ods.impl.StoreReplicatorEventSequencer;
import com.neeve.ods.impl.StoreReplicatorMemberLink;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.types.PktBodyOdsBackupInitEnd;
import com.neeve.pkt.types.PktBodyOdsBackupInitStart;
import com.neeve.pkt.types.PktBodyOdsCommitAck;
import com.neeve.pkt.types.PktBodyOdsMemberConnectRequestReply;
import com.neeve.pkt.types.PktBodyOdsPrimaryBackupHello;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlThread;
import java.util.Map;

final class StoreReplicatorMember
extends OdsObject
implements IStoreMember {
    private final StoreReplicator replicator;
    private final StoreReplicatorEventSequencer eventSequencer;
    private final UtlPool<StoreMemberReplicationStatus> replicationStatusPool;
    private final PktPacket commitAckPacket;
    private final long linkReaderAffinityMask;
    private String name;
    private IStoreBinding.Role role;
    private IDiscoveryEntity entity;
    private StoreReplicatorMemberLink link;
    private volatile State state;
    private boolean ready;

    private final IllegalStateException prepareStateValidationErrorException() {
        switch (this.state) {
            case Init: {
                return new IllegalStateException("member has not been opened");
            }
            case Open: {
                return new IllegalStateException("member is open");
            }
            case Failed: {
                return new IllegalStateException("member has failed");
            }
            case Closed: {
                return new IllegalStateException("member is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    StoreReplicatorMember(StoreReplicator replicator, String name, IDiscoveryEntity entity) {
        super(null);
        this.replicator = replicator;
        this.name = name;
        this.role = null;
        this.entity = entity;
        this.eventSequencer = replicator.getEventSequencer();
        this.linkReaderAffinityMask = UtlThread.parseAffinityMask((String)replicator.getDescriptor().getProperty("linkReaderCpuAffinityMask", "0"));
        this.replicationStatusPool = UtlPool.create((String)"ods_repstat", (String)name, (UtlPool.Factory)new StoreMemberReplicationStatusFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
        try {
            this.commitAckPacket = PktFactory.getInstance().createPacket(761);
        }
        catch (EPktException e) {
            throw new InternalError("Failed to create commit ack packet [" + e.toString() + "]");
        }
        this.state = State.Init;
    }

    private final InternalError convertUnknownWriteOrFlushExceptionToInternalError(String msg, Exception e) {
        InternalError error = new InternalError("Received unknown exception '" + e.toString() + "' when sending " + msg + "!");
        error.initCause(e);
        return error;
    }

    private final EStoreReplicatorMemberLinkException prepareWriteOrFlushFailureException(String msg, Exception e) {
        if (e instanceof EStoreReplicatorMemberLinkException) {
            return (EStoreReplicatorMemberLinkException)e;
        }
        throw this.convertUnknownWriteOrFlushExceptionToInternalError(msg, e);
    }

    private final void sendMemberConnectRequestReply(PktPacket packet) throws EStoreReplicatorMemberLinkException {
        PktBodyOdsMemberConnectRequestReply body = (PktBodyOdsMemberConnectRequestReply)packet.getBody();
        IStoreBinding.Role role = this.replicator.getRole();
        if (role != null) {
            body.setRole(role == IStoreBinding.Role.Primary ? PktBodyOdsMemberConnectRequestReply.Role.Primary : PktBodyOdsMemberConnectRequestReply.Role.Backup);
        }
        body.setMemberName(this.replicator.getMemberName());
        try {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "--> [Member '" + this.getName() + "'] MemberConnect" + (packet.getHeader().getBodyType() == 756 ? "Request" : "Reply") + " [length=" + packet.getSerializedLength() + "]", Tracer.Level.DEBUG);
            }
            this.link.write(packet, true, true);
        }
        catch (Exception e) {
            throw this.prepareWriteOrFlushFailureException("member connect request reply", e);
        }
    }

    private final void sendPrimaryBackupHello(PktPacket packet, long lastCommittedTransactionId) throws EStoreReplicatorMemberLinkException {
        PktBodyOdsPrimaryBackupHello body = (PktBodyOdsPrimaryBackupHello)packet.getBody();
        body.setLastCommittedTransactionId(lastCommittedTransactionId);
        try {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "--> [Member '" + this.getName() + "'] " + (packet.getHeader().getBodyType() == 762 ? "Primary" : "Backup") + "Hello [length=" + packet.getSerializedLength() + "]", Tracer.Level.DEBUG);
            }
            this.link.write(packet, true, true);
        }
        catch (Exception e) {
            throw this.prepareWriteOrFlushFailureException("primary backup hello", e);
        }
        finally {
            packet.dispose();
        }
    }

    private final void sendMemberConnectRequest() throws EStoreReplicatorMemberLinkException {
        this.sendMemberConnectRequestReply(PktFactory.getInstance().createPacket(756));
    }

    private final void sendMemberConnectReply() throws EStoreReplicatorMemberLinkException {
        this.sendMemberConnectRequestReply(PktFactory.getInstance().createPacket(757));
    }

    final StoreReplicator getReplicator() {
        return this.replicator;
    }

    final void setName(String name) {
        if (this.state == State.Init) {
            if (this.name == null) {
                this.name = name;
            } else if (!this.name.equals(name)) {
                throw new IllegalStateException("name already set");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    final void setRole(IStoreBinding.Role role) {
        this.role = role;
    }

    final void setEntity(IDiscoveryEntity entity) {
        if (this.state == State.Init) {
            if (this.entity != null) {
                throw new IllegalStateException("entity already set");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
        this.entity = entity;
    }

    final void setLink(EmxNwLnk link, Map<String, Object> linkParams) throws Exception {
        if (this.state == State.Init) {
            if (this.link != null) {
                throw new IllegalStateException("link already set");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
        this.link = new StoreReplicatorMemberLink(this, link, linkParams, this.linkReaderAffinityMask);
    }

    final void open(boolean active) throws OdsException {
        if (this.state == State.Init) {
            if (this.link == null) {
                throw new InternalError("member link not set at the time of open!");
            }
            try {
                if (active) {
                    this.sendMemberConnectRequest();
                }
                this.sendMemberConnectReply();
                this.setOpen();
            }
            catch (Exception e) {
                throw new OdsException("Failed to send member connect " + (active ? "request" : "reply ") + "packet [" + e.toString() + "]");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    final State getState() {
        return this.state;
    }

    final IDiscoveryEntity getEntity() {
        return this.entity;
    }

    final StoreReplicatorMemberLink getLink() {
        return this.link;
    }

    final void setOpen() {
        this.state = State.Open;
    }

    final void setReady() {
        this.ready = true;
    }

    final void clearReady() {
        this.ready = false;
    }

    final boolean isReady() {
        return this.ready;
    }

    final void sendPrimaryHello(long lastCommittedTransactionId) throws EStoreReplicatorMemberLinkException {
        this.sendPrimaryBackupHello(PktFactory.getInstance().createPacket(762), lastCommittedTransactionId);
    }

    final void sendBackupHello(long lastCommittedTransactionId) throws EStoreReplicatorMemberLinkException {
        this.sendPrimaryBackupHello(PktFactory.getInstance().createPacket(763), lastCommittedTransactionId);
    }

    final void sendBackupInitStart(IOElasticBuffer persisterMetadata) throws EStoreReplicatorMemberLinkException {
        PktPacket packet = PktFactory.getInstance().createPacket(779);
        PktBodyOdsBackupInitStart body = (PktBodyOdsBackupInitStart)packet.getBody();
        PktSubheaderODS subheaderODS = packet.getHeader().activateODSSubheader(false);
        subheaderODS.copyObjectMetadataFrom(null);
        subheaderODS.copyPersisterMetadataFrom(persisterMetadata);
        PktSubheaderODS.prepare((PktPacket)packet, null, (short)0, (short)0, (short)0, (long)0L, (long)0L, (long)0L, (long)0L, (byte)-128);
        try {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "--> [Member '" + this.getName() + "'] BackupInitStart [length=" + packet.getSerializedLength() + "]", Tracer.Level.DEBUG);
            }
            this.link.write(packet, true, true);
        }
        catch (Exception e) {
            throw this.prepareWriteOrFlushFailureException("init start", e);
        }
        finally {
            packet.getHeader().deactivateODSSubheader();
            packet.dispose();
        }
    }

    final void sendBackupInitEnd(long transactionId) throws EStoreReplicatorMemberLinkException {
        PktPacket packet = PktFactory.getInstance().createPacket(778);
        PktBodyOdsBackupInitEnd body = (PktBodyOdsBackupInitEnd)packet.getBody();
        PktSubheaderODS subheaderODS = packet.getHeader().activateODSSubheader(false);
        subheaderODS.copyObjectMetadataFrom(null);
        PktSubheaderODS.prepare((PktPacket)packet, null, (short)0, (short)0, (short)0, (long)0L, (long)0L, (long)0L, (long)0L, (byte)-128);
        body.setTransactionId(transactionId);
        try {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "--> [Member '" + this.getName() + "'] BackupInitEnd [length=" + packet.getSerializedLength() + "]", Tracer.Level.DEBUG);
            }
            this.link.write(packet, true, true);
        }
        catch (Exception e) {
            throw this.prepareWriteOrFlushFailureException("init end", e);
        }
        finally {
            packet.getHeader().deactivateODSSubheader();
            packet.dispose();
        }
    }

    final long sendCommitEntry(PktPacket packet, boolean flush) throws EStoreReplicatorMemberLinkException {
        if (this.state == State.Open) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log(this.replicator.getTracePrefix() + "--> [Member '" + this.getName() + "'] CommitEntry [length=" + packet.getSerializedLength() + "]", Tracer.Level.DEBUG);
                }
                return this.link.write(packet, false, flush);
            }
            catch (Exception e) {
                throw this.prepareWriteOrFlushFailureException("commit entry (packet)", e);
            }
        }
        if (this.state == State.Failed) {
            return 0L;
        }
        throw this.prepareStateValidationErrorException();
    }

    final long sendCommitEntry(IOElasticBuffer serializedPacket, boolean flush) throws EStoreReplicatorMemberLinkException {
        if (this.state == State.Open) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log(this.replicator.getTracePrefix() + "--> [Member '" + this.getName() + "'] CommmitEntry [length=" + serializedPacket.getLength() + "]", Tracer.Level.DEBUG);
                }
                return this.link.write(serializedPacket, flush);
            }
            catch (Exception e) {
                throw this.prepareWriteOrFlushFailureException("commit entry (packet)", e);
            }
        }
        if (this.state == State.Failed) {
            return 0L;
        }
        throw this.prepareStateValidationErrorException();
    }

    final long sendCommitAck(long transactionId, long meanCommitEntryWireTime) throws EStoreReplicatorMemberLinkException {
        PktBodyOdsCommitAck body = (PktBodyOdsCommitAck)this.commitAckPacket.getBody();
        body.setTransactionId(transactionId);
        body.setMeanCommitEntryWireTime(meanCommitEntryWireTime);
        try {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "--> [Member '" + this.getName() + "'] CommitAck [length=" + this.commitAckPacket.getSerializedLength() + "]", Tracer.Level.DEBUG);
            }
            return this.link.write(this.commitAckPacket, true, true);
        }
        catch (Exception e) {
            throw this.prepareWriteOrFlushFailureException("commit ack", e);
        }
    }

    final void onPacket(IOBufferPacket packet) {
        if (this.tracer.debug) {
            switch (PktHeader.getBodyType((IOBuffer)packet.buf, (int)packet.offset)) {
                case 756: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] MemberConnectRequest [length=" + packet.length + "]", Tracer.Level.DEBUG);
                    break;
                }
                case 757: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] MemberConnectReply [length=" + packet.length + "]", Tracer.Level.DEBUG);
                    break;
                }
                case 762: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] PrimaryHello [length=" + packet.length + "]", Tracer.Level.DEBUG);
                    break;
                }
                case 763: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] BackupHello [length=" + packet.length + "]", Tracer.Level.DEBUG);
                    break;
                }
                case 779: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] BackupInitStart [length=" + packet.length + "]", Tracer.Level.DEBUG);
                    break;
                }
                case 778: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] BackupInitEnd [length=" + packet.length + "]", Tracer.Level.DEBUG);
                    break;
                }
                case 759: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] ObjectRemove [length=" + packet.length + "]", Tracer.Level.DEBUG);
                    break;
                }
                case 761: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] CommitAck [length=" + packet.length + "]", Tracer.Level.DEBUG);
                    break;
                }
                default: {
                    if (!this.tracer.debug) break;
                    this.tracer.log(this.replicator.getTracePrefix() + "<-- [Member '" + this.getName() + "'] CommitEntry [length=" + packet.length + "]", Tracer.Level.DEBUG);
                }
            }
        }
        this.eventSequencer.onPacket(this, packet);
    }

    final void onPacketProcesssingFailure(Throwable cause) {
        this.tracer.log(this.replicator.getTracePrefix() + "encountered failure in processing a packet received from member '" + this.getName() + "' [" + (cause.getMessage() != null ? cause.getMessage() : cause.toString()) + "].", Tracer.Level.SEVERE);
        this.fail(cause);
    }

    final void onLinkClosure() {
        this.tracer.log(this.replicator.getTracePrefix() + "member '" + this.getName() + "' closed its link.", Tracer.Level.VERBOSE);
        this.fail(null);
    }

    final void onLinkFailure(Throwable cause) {
        this.tracer.log(this.replicator.getTracePrefix() + "member '" + this.getName() + "' link has failed [" + (cause.getMessage() != null ? cause.getMessage() : cause.toString()) + "].", Tracer.Level.WARNING);
        this.fail(cause);
    }

    final void close() {
        if (this.state != State.Closed) {
            try {
                if (this.link != null) {
                    try {
                        this.link.close();
                    }
                    catch (Exception e) {
                        this.tracer.log(this.replicator.getTracePrefix() + "failed to close member link [member='" + this.getName() + "', exception=" + e.toString() + "].", Tracer.Level.WARNING);
                    }
                }
            }
            finally {
                this.state = State.Closed;
                this.replicationStatusPool.close();
            }
        }
    }

    @Override
    public final String getName() {
        return this.name == null ? "<anonymous>" : this.name;
    }

    @Override
    public final IStoreBinding.Role getRole() {
        return this.role;
    }

    @Override
    public final StoreMemberReplicationStatus createReplicationStatus() {
        return (StoreMemberReplicationStatus)this.replicationStatusPool.get(null);
    }

    @Override
    public final void fail(Throwable cause) {
        if (this.state != State.Failed && this.state != State.Closed) {
            this.tracer.log(this.replicator.getTracePrefix() + "failing member [member='" + this.getName() + "', cause=" + (cause != null ? cause.toString() : "null") + "].", Tracer.Level.WARNING);
            this.state = State.Failed;
            this.replicator.getEventSequencer().scheduleMemberFail(this);
        }
    }

    public final String toString() {
        return this.name;
    }

    static enum State {
        Init,
        Open,
        Failed,
        Closed;

    }

    private final class StoreMemberReplicationStatusFactory
    implements UtlPool.Factory<StoreMemberReplicationStatus> {
        private StoreMemberReplicationStatusFactory() {
        }

        public final StoreMemberReplicationStatus createItem(Object object) {
            return new StoreMemberReplicationStatus(StoreReplicatorMember.this);
        }

        public final StoreMemberReplicationStatus[] createItemArray(int size) {
            return new StoreMemberReplicationStatus[size];
        }
    }
}

