/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.neeve.config.Config;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxDispatcherRunCompletionChecker;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOBufferPacket;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsFatalException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.impl.EStoreReplicatorMemberLinkException;
import com.neeve.ods.impl.StoreCommitCompletionStatus;
import com.neeve.ods.impl.StoreReplicator;
import com.neeve.ods.impl.StoreReplicatorMember;
import com.neeve.ods.impl.StoreReplicatorStats;
import com.neeve.pkt.EPktCorruptException;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.stats.Stats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlConcurrentRingBuffer;
import com.neeve.util.UtlDisruptor;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

final class StoreReplicatorEventSequencer
extends OdsObject {
    private static final int HANDLE_MEMBER_CONNECT_REQUEST_DISPATCH_ALARM_INTERVAL_MILLIS = 200;
    private final StoreReplicator replicator;
    private final StoreReplicatorStats stats;
    private final InboundSequencerThread inboundSequencer;
    private final EntityUpAction entityUpAction;
    private final ScheduleMemberTableOpenWaitCompletionAlarmAction scheduleMemberTableOpenWaitCompletionAlarmAction;
    private final MemberTableOpenWaitCompletionAlarmEventHandler memberTableOpenWaitCompletionAlarmEventHandler;
    private final UnscheduleMemberTableOpenWaitCompletionAlarmAction unscheduleMemberTableOpenWaitCompletionAlarmAction;
    private final ScheduleHandleMemberConnectRequestDispatchAlarmAction scheduleHandleMemberConnectRequestDispatchAlarmAction;
    private final HandleMemberConnectRequestDispatchAlarmEventHandler handleMemberConnectRequestDispatchAlarmEventHandler;
    private final MemberHandshakeStartReadyAction memberHandshakeStartReadyAction;
    private final MemberInitReadyAction memberInitReadyAction;
    private final EntityDownAction entityDownAction;
    private final MemberFailAction memberFailAction;
    private final FailAction failAction;
    private final CloseAction closeAction;
    private final AtomicBoolean closeInitiated = new AtomicBoolean();
    private final MemberList attachedSendMemberList;
    private final boolean recordLegLatencies;
    private IEmxAlarmEvent memberTableOpenWaitCompletionAlarmEvent;
    private final UtlConcurrentRingBuffer<HandleMemberConnectRequestDispatchAlarmContext> memberConnectRequestProcessingAlarmContexts;
    private final String detachedSendClaimStrategyStr;
    private final String detachedSendWaitStrategyStr;
    private final Disruptor<DetachedSendCarrierEvent> detachedSendDisruptor;
    private final RingBuffer<DetachedSendCarrierEvent> detachedSendRingBuffer;
    private final long detachedSenderCpuAffinityMask;
    private Thread detachedSender;
    private final String detachedDispatchClaimStrategyStr;
    private final String detachedDispatchWaitStrategyStr;
    private final Disruptor<DetachedDispatchCarrierEvent> detachedDispatchDisruptor;
    private final RingBuffer<DetachedDispatchCarrierEvent> detachedDispatchRingBuffer;
    private final long detachedDispatcherCpuAffinityMask;
    private Thread detachedDispatcher;
    private final PktPacket memberConnectRequestPacket;
    private final PktPacket memberConnectReplyPacket;
    private final PktPacket primaryHelloPacket;
    private final PktPacket backupHelloPacket;
    private final PktPacket backupInitStartPacket;
    private final PktPacket backupInitEndPacket;
    private final PktPacket objectRemovePacket;
    private final PktPacket commitAckPacket;
    private final PktPacket dataPacket;
    private volatile State state;
    private volatile boolean failScheduled;

    StoreReplicatorEventSequencer(StoreReplicator replicator) throws Exception {
        super(null);
        boolean detachedDispatch;
        boolean detachedSend;
        this.replicator = replicator;
        this.stats = replicator.getStats();
        this.recordLegLatencies = replicator.getBinding().recordLegLatencies;
        this.inboundSequencer = new InboundSequencerThread();
        this.entityUpAction = new EntityUpAction();
        this.memberInitReadyAction = new MemberInitReadyAction();
        this.scheduleMemberTableOpenWaitCompletionAlarmAction = new ScheduleMemberTableOpenWaitCompletionAlarmAction();
        this.memberTableOpenWaitCompletionAlarmEventHandler = new MemberTableOpenWaitCompletionAlarmEventHandler();
        this.unscheduleMemberTableOpenWaitCompletionAlarmAction = new UnscheduleMemberTableOpenWaitCompletionAlarmAction();
        this.scheduleHandleMemberConnectRequestDispatchAlarmAction = new ScheduleHandleMemberConnectRequestDispatchAlarmAction();
        this.handleMemberConnectRequestDispatchAlarmEventHandler = new HandleMemberConnectRequestDispatchAlarmEventHandler();
        this.memberHandshakeStartReadyAction = new MemberHandshakeStartReadyAction();
        this.entityDownAction = new EntityDownAction();
        this.memberFailAction = new MemberFailAction();
        this.failAction = new FailAction();
        this.closeAction = new CloseAction();
        this.memberConnectRequestProcessingAlarmContexts = UtlConcurrentRingBuffer.create((int)256, (UtlConcurrentRingBuffer.ItemFactory)new HandleMemberConnectRequestDispatchAlarmContextFactory());
        this.attachedSendMemberList = new MemberList(null);
        try {
            detachedSend = Boolean.parseBoolean(replicator.getDescriptor().getProperty("detachedSend", "false"));
        }
        catch (Exception e) {
            this.tracer.log(replicator.getTracePrefix() + "failed to parse 'detachedSend' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.SEVERE);
            throw new OdsException(e);
        }
        if (detachedSend) {
            int queueDepth;
            try {
                queueDepth = Integer.parseInt(replicator.getDescriptor().getProperty("senderQueueDepth", "1024"));
            }
            catch (Exception e) {
                this.tracer.log(replicator.getTracePrefix() + "failed to parse 'senderQueueDepth' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.SEVERE);
                throw new OdsException(e);
            }
            ProducerType producerType = ProducerType.SINGLE;
            this.detachedSendClaimStrategyStr = UtlDisruptor.toProducerTypeStr((ProducerType)producerType);
            WaitStrategy waitStrategy = UtlDisruptor.getWaitStrategy((String)replicator.getDescriptor().getProperty("senderQueueWaitStrategy", null), (boolean)true);
            this.detachedSendWaitStrategyStr = UtlDisruptor.waitStrategyToStr((WaitStrategy)waitStrategy);
            this.detachedSendDisruptor = UtlDisruptor.createSingleConsumerDisruptor((EventFactory)new DetachedSendCarrierEventFactory(), (int)queueDepth, (ThreadFactory)new DetachedSendCarrierEventProcessorThreadFactory(), (ProducerType)producerType, (WaitStrategy)waitStrategy, (EventHandler)new DetachedSendCarrierEventProcessor());
            this.detachedSendRingBuffer = this.detachedSendDisruptor.getRingBuffer();
            this.detachedSenderCpuAffinityMask = UtlThread.parseAffinityMask((String)replicator.getDescriptor().getProperty("senderCpuAffinityMask", UtlThread.getDefaultCPUAffinityMask()));
        } else {
            this.detachedSenderCpuAffinityMask = 0L;
            this.detachedSendClaimStrategyStr = "N/A";
            this.detachedSendWaitStrategyStr = "N/A";
            this.detachedSendDisruptor = null;
            this.detachedSendRingBuffer = null;
        }
        try {
            detachedDispatch = Boolean.parseBoolean(replicator.getDescriptor().getProperty("detachedDispatch", "false"));
        }
        catch (Exception e) {
            this.tracer.log(replicator.getTracePrefix() + "failed to parse 'detachedDispatch' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.SEVERE);
            throw new OdsException(e);
        }
        if (detachedDispatch) {
            int queueDepth;
            try {
                queueDepth = Integer.parseInt(replicator.getDescriptor().getProperty("dispatcherQueueDepth", "1024"));
            }
            catch (Exception e) {
                this.tracer.log(replicator.getTracePrefix() + "failed to parse 'dispatcherQueueDepth' configuration parameter from descriptor [" + e.toString() + "].", Tracer.Level.SEVERE);
                throw new OdsException(e);
            }
            ProducerType producerType = ProducerType.SINGLE;
            this.detachedDispatchClaimStrategyStr = UtlDisruptor.toProducerTypeStr((ProducerType)producerType);
            WaitStrategy waitStrategy = UtlDisruptor.getWaitStrategy((String)replicator.getDescriptor().getProperty("dispatcherQueueWaitStrategy", null), (boolean)true);
            this.detachedDispatchWaitStrategyStr = UtlDisruptor.waitStrategyToStr((WaitStrategy)waitStrategy);
            this.detachedDispatchDisruptor = UtlDisruptor.createSingleConsumerDisruptor((EventFactory)new DetachedDispatchCarrierEventFactory(), (int)queueDepth, (ThreadFactory)new DetachedDispatchCarrierEventProcessorThreadFactory(), (ProducerType)producerType, (WaitStrategy)waitStrategy, (EventHandler)new DetachedDispatchCarrierEventProcessor());
            this.detachedDispatchRingBuffer = this.detachedDispatchDisruptor.getRingBuffer();
            this.detachedDispatcherCpuAffinityMask = UtlThread.parseAffinityMask((String)replicator.getDescriptor().getProperty("dispatcherCpuAffinityMask", UtlThread.getDefaultCPUAffinityMask()));
        } else {
            this.detachedDispatcherCpuAffinityMask = 0L;
            this.detachedDispatchClaimStrategyStr = "N/A";
            this.detachedDispatchWaitStrategyStr = "N/A";
            this.detachedDispatchDisruptor = null;
            this.detachedDispatchRingBuffer = null;
        }
        this.memberConnectRequestPacket = PktFactory.getInstance().createPacket(756);
        this.memberConnectReplyPacket = PktFactory.getInstance().createPacket(757);
        this.primaryHelloPacket = PktFactory.getInstance().createPacket(762);
        this.backupHelloPacket = PktFactory.getInstance().createPacket(763);
        this.backupInitStartPacket = PktFactory.getInstance().createPacket(779);
        this.backupInitEndPacket = PktFactory.getInstance().createPacket(778);
        this.objectRemovePacket = PktFactory.getInstance().createPacket(759);
        this.commitAckPacket = PktFactory.getInstance().createPacket(761);
        this.dataPacket = PktFactory.getInstance().createPacket(257);
        this.state = State.Init;
        if (this.tracer.debug) {
            this.tracer.log(replicator.getTracePrefix() + "created replicator event sequencer...", Tracer.Level.DEBUG);
        }
    }

    private final IllegalStateException prepareStateValidationErrorException() {
        switch (this.state) {
            case Init: {
                return new IllegalStateException("sequencer has not been opened");
            }
            case Open: {
                return new IllegalStateException("sequencer is open");
            }
            case Closed: {
                return new IllegalStateException("sequencer is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    private final void onFatalError(Throwable cause) {
        OdsFatalException e;
        StringBuilder sb = new StringBuilder();
        sb.append(this.replicator.getTracePrefix() + "store replicator event sequencer encountered fatal exception ' [" + cause.toString() + "]").append("\n");
        sb.append("Stack Trace:").append("\n");
        sb.append(UtlThrowable.prepareStackTrace((Throwable)cause));
        sb.append("Shutting down store...").append("\n");
        this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        OdsFatalException odsFatalException = e = cause instanceof OdsFatalException ? (OdsFatalException)cause : new OdsFatalException(cause);
        if (Thread.currentThread() == this.getInboundDispatcherThread()) {
            this.replicator.handleFailure(e);
        } else {
            this.scheduleFail(e);
        }
    }

    private final void publishToDetachedDispatcher(DetachedDispatchCarrierEventType eventType, Object eventData, IOBufferPacket packet, StoreReplicatorMember packetMember) {
        long sequence = this.detachedDispatchRingBuffer.next();
        DetachedDispatchCarrierEvent carrierEvent = (DetachedDispatchCarrierEvent)this.detachedDispatchRingBuffer.get(sequence);
        carrierEvent.type = eventType;
        carrierEvent.data = eventData;
        if (packet != null && packet.length > 0) {
            ((DetachedDispatchCarrierEvent)carrierEvent).packet.buf = IOBuffer.ensureCapacity((IOBuffer)((DetachedDispatchCarrierEvent)carrierEvent).packet.buf, (int)packet.length, (boolean)false);
            ((DetachedDispatchCarrierEvent)carrierEvent).packet.length = packet.length;
            packet.buf.getTo(packet.offset, ((DetachedDispatchCarrierEvent)carrierEvent).packet.buf, 0, ((DetachedDispatchCarrierEvent)carrierEvent).packet.length);
            ((DetachedDispatchCarrierEvent)carrierEvent).packet.ioTs = packet.ioTs;
        } else {
            ((DetachedDispatchCarrierEvent)carrierEvent).packet.length = 0;
        }
        carrierEvent.packetMember = packetMember;
        if (this.recordLegLatencies) {
            carrierEvent.publishTs = UtlTime.now();
        }
        this.detachedDispatchRingBuffer.publish(sequence);
    }

    private final void dispatchHandleEntityUp(IDiscoveryEntity entity) {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleEntityUp(entity);
        }
    }

    private final void dispatchHandleMemberTableOpenWaitCompletion() {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleMemberTableOpenWaitCompletion();
        }
    }

    private final void dispatchHandleMemberConnectRequest(StoreReplicatorMember member) {
        if (!this.failScheduled && this.state != State.Closed) {
            try {
                this.replicator.handleMemberConnectRequest(member);
            }
            catch (Exception e) {
                this.tracer.log("Received exception on processing of member connect request\n" + UtlThrowable.prepareStackTrace((Throwable)e) + "\nClosing member...", Tracer.Level.WARNING);
                member.close();
            }
        } else {
            member.close();
        }
    }

    private final void dispatchHandleMemberHandshakeStartReady(IStoreMember member) {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleMemberHandshakeStartReady(member);
        }
    }

    private final void dispatchHandleMemberInitReady(IStoreMember member) {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleMemberInitReady(member);
        }
    }

    private final void dispatchHandleEntityDown(IDiscoveryEntity entity) {
        if (!this.failScheduled && this.state != State.Closed) {
            this.replicator.handleEntityDown(entity, "discovery");
        }
    }

    private final boolean isInitEntry(StoreReplicatorMember member, IOBufferPacket packet) {
        long addr = packet.buf.getNativeAddress();
        int odsSubheaderOffset = PktHeader.getSubheaderOffset((long)addr, (int)packet.offset, (int)7);
        if (odsSubheaderOffset >= 0) {
            return (PktSubheaderODS.getFlags((long)addr, (int)odsSubheaderOffset) & 0x80) == 128;
        }
        throw new EPktCorruptException("corrupt packet [no ODS subheader]");
    }

    private final void dispatchHandleMemberPacket(StoreReplicatorMember member, IOBufferPacket packet) throws Exception {
        if (!this.failScheduled && this.state != State.Closed) {
            block0 : switch (member.getState()) {
                case Init: {
                    switch (PktHeader.getBodyType((IOBuffer)packet.buf, (int)packet.offset)) {
                        case 756: {
                            this.memberConnectRequestPacket.deserialize(packet.buf, packet.offset, true, true);
                            this.replicator.handleMemberConnectRequest(member, this.memberConnectRequestPacket);
                            break block0;
                        }
                        case 757: {
                            this.memberConnectReplyPacket.deserialize(packet.buf, packet.offset, true, true);
                            this.replicator.handleMemberConnectReply(member, this.memberConnectReplyPacket);
                            break block0;
                        }
                        case 762: {
                            this.primaryHelloPacket.deserialize(packet.buf, packet.offset, true, true);
                            this.replicator.handlePrimaryHello(member, this.primaryHelloPacket);
                            break block0;
                        }
                    }
                    this.tracer.log(this.replicator.getTracePrefix() + "received packet with body type '" + PktHeader.getBodyType((IOBuffer)packet.buf, (int)packet.offset) + "' before member is opened. Fatal error. Failing member...", Tracer.Level.WARNING);
                    member.fail(new Exception("received packet with body type '" + PktHeader.getBodyType((IOBuffer)packet.buf, (int)packet.offset) + "' that is not permissible in Init state"));
                    break;
                }
                case Open: {
                    switch (PktHeader.getBodyType((IOBuffer)packet.buf, (int)packet.offset)) {
                        case 762: {
                            this.primaryHelloPacket.deserialize(packet.buf, packet.offset, true, true);
                            this.replicator.handlePrimaryHello(member, this.primaryHelloPacket);
                            break block0;
                        }
                        case 763: {
                            this.backupHelloPacket.deserialize(packet.buf, packet.offset, true, true);
                            this.replicator.handleBackupHello(member, this.backupHelloPacket);
                            break block0;
                        }
                        case 779: {
                            this.backupInitStartPacket.deserialize(packet.buf, packet.offset, true, true);
                            this.replicator.handleInitStart(member, this.backupInitStartPacket);
                            break block0;
                        }
                        case 778: {
                            this.backupInitEndPacket.deserialize(packet.buf, packet.offset, true, true);
                            this.replicator.handleInitComplete(member, this.backupInitEndPacket);
                            break block0;
                        }
                        case 759: {
                            this.objectRemovePacket.deserialize(packet.buf, packet.offset, true, true);
                            if (this.isInitEntry(member, packet)) {
                                this.replicator.handleInitEntry(member, this.objectRemovePacket);
                                break block0;
                            }
                            this.replicator.handleCommitEntry(member, this.objectRemovePacket, packet.ioTs);
                            break block0;
                        }
                        case 761: {
                            this.commitAckPacket.deserialize(packet.buf, packet.offset, true, true);
                            this.replicator.handleCommitAck(member, this.commitAckPacket, packet.ioTs);
                            break block0;
                        }
                    }
                    this.dataPacket.deserialize(packet.buf, packet.offset, true, true);
                    if (this.isInitEntry(member, packet)) {
                        this.replicator.handleInitEntry(member, this.dataPacket);
                        break;
                    }
                    this.replicator.handleCommitEntry(member, this.dataPacket, packet.ioTs);
                    break;
                }
                default: {
                    this.tracer.log(this.replicator.getTracePrefix() + "received packet after member '" + member.getName() + "' has closed or failed. Discarding packet...", Tracer.Level.WARNING);
                }
            }
        }
    }

    private final void dispatchHandleMemberFail(StoreReplicatorMember member) {
        if (this.state != State.Closed) {
            if (member.getEntity() != null) {
                this.replicator.handleEntityDown(member.getEntity(), "memberFail");
            } else {
                member.close();
            }
        }
    }

    private final void dispatchHandleFail(Exception e) {
        if (this.state != State.Closed) {
            this.replicator.handleFailure(e);
        }
    }

    final void onPacket(StoreReplicatorMember member, IOBufferPacket packet) {
        try {
            try {
                if (this.detachedDispatcher != null) {
                    this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberPacket, null, packet, member);
                } else {
                    this.dispatchHandleMemberPacket(member, packet);
                }
            }
            catch (Exception e) {
                this.tracer.log(this.replicator.getTracePrefix() + "failure in processing inbound packet [" + e.toString() + "].", Tracer.Level.WARNING);
                throw e;
            }
        }
        catch (Throwable e) {
            this.onFatalError(e);
        }
    }

    private final void sendCommitEntryCore(PktPacket packet, IOElasticBuffer serializedPacket, MemberList memberList, StoreCommitCompletionStatus completionStatus, boolean commitEnd, long postSerializeTs, Stats.LatencyManager s2w) {
        long preWireTs = 0L;
        for (int i = 0; i < memberList.memberCount; ++i) {
            try {
                if (packet != null) {
                    preWireTs = memberList.members[i].sendCommitEntry(packet, commitEnd);
                    continue;
                }
                preWireTs = memberList.members[i].sendCommitEntry(serializedPacket, commitEnd);
                continue;
            }
            catch (EStoreReplicatorMemberLinkException e) {
                this.tracer.log(this.replicator.getTracePrefix() + "failure in sending commit entry [cause=" + (e.getMessage() != null ? e.getMessage() : e.toString()) + "] to member '" + memberList.members[i].getName() + "'. failing member...", Tracer.Level.SEVERE);
                memberList.members[i].fail(e);
            }
        }
        if (completionStatus != null && preWireTs > 0L) {
            completionStatus.getCompletionEvent().setPreWireTs(preWireTs);
            if (s2w != null && postSerializeTs > 0L) {
                s2w.add((double)(preWireTs - postSerializeTs));
            }
        }
    }

    final boolean isDetachedSend() {
        return this.detachedSender != null;
    }

    final int getDetachedSendDisruptorCapacity() {
        return this.detachedSender != null ? this.detachedSendRingBuffer.getBufferSize() : -1;
    }

    final int getDetachedSendDisruptorRemaining() {
        return this.detachedSender != null ? (int)this.detachedSendRingBuffer.remainingCapacity() : -1;
    }

    final String getDetachedSendDisruptorClaimStrategy() {
        return this.detachedSendClaimStrategyStr;
    }

    final String getDetachedSendDisruptorWaitStrategy() {
        return this.detachedSendWaitStrategyStr;
    }

    final boolean isDetachedDispatch() {
        return this.detachedDispatcher != null;
    }

    final int getDetachedDispatchDisruptorCapacity() {
        return this.detachedDispatcher != null ? this.detachedDispatchRingBuffer.getBufferSize() : -1;
    }

    final int getDetachedDispatchDisruptorRemaining() {
        return this.detachedDispatcher != null ? (int)this.detachedDispatchRingBuffer.remainingCapacity() : -1;
    }

    final String getDetachedDispatchDisruptorClaimStrategy() {
        return this.detachedDispatchClaimStrategyStr;
    }

    final String getDetachedDispatchDisruptorWaitStrategy() {
        return this.detachedDispatchWaitStrategyStr;
    }

    final State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void open() {
        if (this.tracer.debug) {
            this.tracer.log(this.replicator.getTracePrefix() + "opening event sequencer...", Tracer.Level.DEBUG);
        }
        if (this.state == State.Init) {
            if (this.detachedSendDisruptor != null) {
                this.detachedSendDisruptor.start();
            }
            if (this.detachedDispatchDisruptor != null) {
                this.detachedDispatchDisruptor.start();
            }
            InboundSequencerThread.StartCoordinator startCoordinator = this.inboundSequencer.startCoordinator();
            this.inboundSequencer.start();
            InboundSequencerThread.StartCoordinator startCoordinator2 = this.inboundSequencer.startCoordinator;
            synchronized (startCoordinator2) {
                while (!startCoordinator.isStarted) {
                    try {
                        startCoordinator.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
        this.state = State.Open;
    }

    final Thread getInboundDispatcherThread() {
        return this.detachedDispatcher != null ? this.detachedDispatcher : this.inboundSequencer;
    }

    final void scheduleEntityUp(IDiscoveryEntity entity) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.inboundSequencer.invoke(this.entityUpAction, entity, 0);
    }

    final void scheduleMemberTableOpenWaitCompletion(int memberTableOpenWaitTime) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.inboundSequencer.invoke(this.scheduleMemberTableOpenWaitCompletionAlarmAction, memberTableOpenWaitTime, 0);
    }

    final void unscheduleMemberTableOpenWaitCompletion() throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.inboundSequencer.invoke(this.unscheduleMemberTableOpenWaitCompletionAlarmAction, null, 0);
    }

    final void scheduleHandleMemberConnectRequestDispatch(StoreReplicatorMember member) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.inboundSequencer.invoke(this.scheduleHandleMemberConnectRequestDispatchAlarmAction, member, 0);
    }

    final void scheduleMemberHandshakeStartReady(IStoreMember member) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.inboundSequencer.invoke(this.memberHandshakeStartReadyAction, member, 0);
    }

    final void scheduleMemberInitReady(IStoreMember member) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.inboundSequencer.invoke(this.memberInitReadyAction, member, 0);
    }

    final void scheduleEntityDown(IDiscoveryEntity entity) throws Exception {
        if (this.state != State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.inboundSequencer.invoke(this.entityDownAction, entity, 0);
    }

    final void scheduleMemberFail(StoreReplicatorMember member) {
        if (this.state == State.Open) {
            try {
                this.inboundSequencer.invoke(this.memberFailAction, member, 0);
            }
            catch (Exception e) {
                throw new InternalError("failed to schedule member fail in replicator inbound sequencer thread");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    final void scheduleFail(Exception cause) {
        if (this.state == State.Open) {
            try {
                this.failScheduled = true;
                this.inboundSequencer.invoke(this.failAction, cause, 0);
            }
            catch (Exception e) {
                throw new InternalError("failed to schedule fail in replicator inbound sequencer thread");
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    final MemberList getFreshReplicationMemberList() {
        if (this.detachedSender != null) {
            long sequence = this.detachedSendRingBuffer.next();
            DetachedSendCarrierEvent carrierEvent = (DetachedSendCarrierEvent)this.detachedSendRingBuffer.get(sequence);
            carrierEvent.sequence = sequence;
            return carrierEvent.memberList;
        }
        return this.attachedSendMemberList;
    }

    final void sendCommitEntry(StoreCommitEntry commitEntry, MemberList memberList, StoreCommitCompletionStatus completionStatus, long postSerializeTs, Stats.LatencyManager s2w) {
        PktHeader header = commitEntry.serializedObject.getHeader();
        header.setSrc(0);
        header.setSrcPort((short)0);
        header.setDest(0);
        header.setDestPort((short)0);
        if (memberList.carrierEvent != null) {
            commitEntry.serializedObject.getTo(memberList.carrierEvent.serializedPacket, 0);
            memberList.carrierEvent.completionStatus = completionStatus;
            memberList.carrierEvent.commitEnd = commitEntry.commitEnd;
            memberList.carrierEvent.postSerializeTs = postSerializeTs;
            memberList.carrierEvent.s2w = s2w;
            if (this.recordLegLatencies) {
                memberList.carrierEvent.publishTs = UtlTime.now();
            }
            this.detachedSendRingBuffer.publish(memberList.carrierEvent.sequence);
        } else {
            this.sendCommitEntryCore(commitEntry.serializedObject, null, memberList, completionStatus, commitEntry.commitEnd, postSerializeTs, s2w);
        }
    }

    final void close(Boolean dispatchMemberDownEvents) {
        block23: {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "closing event sequencer...", Tracer.Level.DEBUG);
            }
            if (this.state != State.Closed) {
                if (this.state == State.Open) {
                    try {
                        if (this.closeInitiated.compareAndSet(false, true)) {
                            if (this.detachedDispatchDisruptor != null) {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.replicator.getTracePrefix() + "shutting down the detached dispatcher thread...", Tracer.Level.DEBUG);
                                }
                                if (this.detachedDispatcher != null) {
                                    while (this.detachedDispatcher.isAlive()) {
                                        try {
                                            this.detachedDispatchDisruptor.halt();
                                            this.detachedDispatcher.join(500L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    UtlThread.deregister((Thread)this.detachedDispatcher);
                                    this.detachedDispatcher = null;
                                }
                            }
                            if (this.detachedSendDisruptor != null) {
                                if (this.tracer.debug) {
                                    this.tracer.log(this.replicator.getTracePrefix() + "shutting down the detached sender thread...", Tracer.Level.DEBUG);
                                }
                                if (this.detachedSender != null) {
                                    while (this.detachedSender.isAlive()) {
                                        try {
                                            this.detachedSendDisruptor.halt();
                                            this.detachedSender.join(500L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    UtlThread.deregister((Thread)this.detachedSender);
                                    this.detachedSender = null;
                                }
                            }
                            this.inboundSequencer.invoke(this.closeAction, dispatchMemberDownEvents, 1);
                        }
                        if (Thread.currentThread() == this.inboundSequencer) break block23;
                        while (true) {
                            try {
                                this.inboundSequencer.join();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        InternalError error = new InternalError("Failure encountered while shutting down ODS event replicator inbound sequencer thread [" + e.toString() + "]...");
                        error.initCause(e);
                        throw error;
                    }
                }
            } else if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "already closed.", Tracer.Level.DEBUG);
            }
        }
    }

    final class MemberList {
        private final DetachedSendCarrierEvent carrierEvent;
        final StoreReplicatorMember[] members = new StoreReplicatorMember[255];
        int memberCount;

        MemberList(DetachedSendCarrierEvent carrierEvent) {
            this.carrierEvent = carrierEvent;
        }

        final void reset() {
            this.memberCount = 0;
        }
    }

    static enum State {
        Init,
        Open,
        Closed;

    }

    private final class DetachedDispatchCarrierEventProcessorThreadFactory
    implements ThreadFactory {
        private DetachedDispatchCarrierEventProcessorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            return StoreReplicatorEventSequencer.this.detachedDispatcher = new DetachedDispatchCarrierEventProcessorThread("X-ODS-StoreReplicatorDispatcher-" + StoreReplicatorEventSequencer.this.replicator.getStoreName() + "-" + StoreReplicatorEventSequencer.this.replicator.getMemberName(), r);
        }
    }

    private final class DetachedDispatchCarrierEventProcessorThread
    extends Thread {
        private final Runnable r;

        DetachedDispatchCarrierEventProcessorThread(String name, Runnable r) {
            this.setDaemon(true);
            this.setName(name);
            this.r = r;
        }

        @Override
        public final void run() {
            UtlThread.setCPUAffinityMask((long)StoreReplicatorEventSequencer.this.detachedDispatcherCpuAffinityMask);
            this.r.run();
        }
    }

    private final class DetachedDispatchCarrierEventProcessor
    implements EventHandler<DetachedDispatchCarrierEvent> {
        private DetachedDispatchCarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void onEvent(DetachedDispatchCarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (event.publishTs > 0L) {
                    ((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).stats.ddo2p.add((double)(UtlTime.now() - event.publishTs));
                }
                switch (event.type) {
                    case EntityUp: {
                        StoreReplicatorEventSequencer.this.dispatchHandleEntityUp((IDiscoveryEntity)event.data);
                        return;
                    }
                    case MemberTableOpenWaitCompletion: {
                        StoreReplicatorEventSequencer.this.dispatchHandleMemberTableOpenWaitCompletion();
                        return;
                    }
                    case MemberConnectRequest: {
                        StoreReplicatorEventSequencer.this.dispatchHandleMemberConnectRequest((StoreReplicatorMember)event.data);
                        return;
                    }
                    case MemberHandshakeStartReady: {
                        StoreReplicatorEventSequencer.this.dispatchHandleMemberHandshakeStartReady((IStoreMember)event.data);
                        return;
                    }
                    case MemberInitReady: {
                        StoreReplicatorEventSequencer.this.dispatchHandleMemberInitReady((IStoreMember)event.data);
                        return;
                    }
                    case MemberPacket: {
                        StoreReplicatorEventSequencer.this.dispatchHandleMemberPacket(event.packetMember, event.packet);
                        return;
                    }
                    case MemberFail: {
                        StoreReplicatorEventSequencer.this.dispatchHandleMemberFail((StoreReplicatorMember)event.data);
                        return;
                    }
                    case EntityDown: {
                        StoreReplicatorEventSequencer.this.dispatchHandleEntityDown((IDiscoveryEntity)event.data);
                        return;
                    }
                    case Fail: {
                        StoreReplicatorEventSequencer.this.dispatchHandleFail((Exception)event.data);
                        return;
                    }
                    default: {
                        throw new InternalError("unknown detached dispatch event type '" + (Object)((Object)event.type) + "'");
                    }
                }
            }
            catch (Throwable e) {
                StoreReplicatorEventSequencer.this.onFatalError(e);
                return;
            }
            finally {
                event.reset();
            }
        }
    }

    private final class DetachedDispatchCarrierEventFactory
    implements EventFactory<DetachedDispatchCarrierEvent> {
        private DetachedDispatchCarrierEventFactory() {
        }

        public final DetachedDispatchCarrierEvent newInstance() {
            return new DetachedDispatchCarrierEvent();
        }
    }

    private final class DetachedDispatchCarrierEvent {
        private DetachedDispatchCarrierEventType type;
        private Object data;
        private final IOBufferPacket packet = new IOBufferPacket();
        private StoreReplicatorMember packetMember;
        private long publishTs;

        private DetachedDispatchCarrierEvent() {
        }

        final void reset() {
            this.publishTs = 0L;
            this.data = null;
            if (this.packet.buf != null && Config.conserveMemory()) {
                this.packet.buf.dispose();
                this.packet.buf = null;
            }
            this.packet.length = 0;
            this.packet.offset = 0;
            this.packet.ioTs = 0L;
        }
    }

    private static enum DetachedDispatchCarrierEventType {
        EntityUp,
        MemberTableOpenWaitCompletion,
        MemberConnectRequest,
        MemberHandshakeStartReady,
        MemberInitReady,
        MemberPacket,
        MemberFail,
        EntityDown,
        Fail;

    }

    private final class DetachedSendCarrierEventProcessorThreadFactory
    implements ThreadFactory {
        private DetachedSendCarrierEventProcessorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            return StoreReplicatorEventSequencer.this.detachedSender = new DetachedSendCarrierEventProcessorThread("X-ODS-StoreReplicatorSender-" + StoreReplicatorEventSequencer.this.replicator.getStoreName() + "-" + StoreReplicatorEventSequencer.this.replicator.getMemberName(), r);
        }
    }

    private final class DetachedSendCarrierEventProcessorThread
    extends Thread {
        private final Runnable r;

        DetachedSendCarrierEventProcessorThread(String name, Runnable r) {
            this.setDaemon(true);
            this.setName(name);
            this.r = r;
        }

        @Override
        public final void run() {
            UtlThread.setCPUAffinityMask((long)StoreReplicatorEventSequencer.this.detachedSenderCpuAffinityMask);
            this.r.run();
        }
    }

    private final class DetachedSendCarrierEventProcessor
    implements EventHandler<DetachedSendCarrierEvent> {
        private DetachedSendCarrierEventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onEvent(DetachedSendCarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (event.publishTs > 0L) {
                    ((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).stats.dso2p.add((double)(UtlTime.now() - event.publishTs));
                }
                StoreReplicatorEventSequencer.this.sendCommitEntryCore(null, event.serializedPacket, event.memberList, event.completionStatus, event.commitEnd, event.postSerializeTs, event.s2w);
            }
            catch (Throwable e) {
                StoreReplicatorEventSequencer.this.onFatalError(e);
            }
            finally {
                event.reset();
            }
        }
    }

    private final class DetachedSendCarrierEventFactory
    implements EventFactory<DetachedSendCarrierEvent> {
        private DetachedSendCarrierEventFactory() {
        }

        public final DetachedSendCarrierEvent newInstance() {
            return new DetachedSendCarrierEvent();
        }
    }

    private final class DetachedSendCarrierEvent {
        private final MemberList memberList;
        private final IOElasticBuffer serializedPacket;
        private StoreCommitCompletionStatus completionStatus;
        private boolean commitEnd;
        private long postSerializeTs;
        private Stats.LatencyManager s2w;
        private long publishTs;
        private long sequence;

        private DetachedSendCarrierEvent() {
            this.memberList = new MemberList(this);
            this.serializedPacket = IOElasticBuffer.create((int)128);
        }

        final void reset() {
            this.publishTs = 0L;
            this.memberList.reset();
            if (Config.conserveMemory()) {
                this.serializedPacket.reset();
            } else {
                this.serializedPacket.setLength(0);
            }
        }
    }

    private final class CloseAction
    implements IEmxAction<Object, Object> {
        private CloseAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            try {
                StoreReplicatorEventSequencer.this.replicator.handleClose((Boolean)object);
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder();
                sb.append(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "store replicator close handler faulter with error ' [" + t.toString() + "]").append("\n");
                sb.append("Stack Trace:").append("\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)t));
                sb.append("Ignoring...").append("\n");
                StoreReplicatorEventSequencer.this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
            try {
                if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                    StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "shutting down the replicator inbound sequencer thread...", Tracer.Level.DEBUG);
                }
                StoreReplicatorEventSequencer.this.inboundSequencer.shutdown();
            }
            finally {
                StoreReplicatorEventSequencer.this.state = State.Closed;
            }
            return null;
        }
    }

    private final class FailAction
    implements IEmxAction<Object, Object> {
        private FailAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventSequencer.this.detachedDispatcher != null) {
                StoreReplicatorEventSequencer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.Fail, object, null, null);
            } else {
                StoreReplicatorEventSequencer.this.dispatchHandleFail((Exception)object);
            }
            return null;
        }
    }

    private final class MemberFailAction
    implements IEmxAction<Object, Object> {
        private MemberFailAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventSequencer.this.detachedDispatcher != null) {
                StoreReplicatorEventSequencer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberFail, object, null, null);
            } else {
                StoreReplicatorEventSequencer.this.dispatchHandleMemberFail((StoreReplicatorMember)object);
            }
            return null;
        }
    }

    private final class EntityDownAction
    implements IEmxAction<Object, Object> {
        private EntityDownAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventSequencer.this.detachedDispatcher != null) {
                StoreReplicatorEventSequencer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.EntityDown, object, null, null);
            } else {
                StoreReplicatorEventSequencer.this.dispatchHandleEntityDown((IDiscoveryEntity)object);
            }
            return null;
        }
    }

    private final class MemberInitReadyAction
    implements IEmxAction<Object, Object> {
        private MemberInitReadyAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventSequencer.this.detachedDispatcher != null) {
                StoreReplicatorEventSequencer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberInitReady, object, null, null);
            } else {
                StoreReplicatorEventSequencer.this.dispatchHandleMemberInitReady((IStoreMember)object);
            }
            return null;
        }
    }

    private final class MemberHandshakeStartReadyAction
    implements IEmxAction<Object, Object> {
        private MemberHandshakeStartReadyAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventSequencer.this.detachedDispatcher != null) {
                StoreReplicatorEventSequencer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberHandshakeStartReady, object, null, null);
            } else {
                StoreReplicatorEventSequencer.this.dispatchHandleMemberHandshakeStartReady((IStoreMember)object);
            }
            return null;
        }
    }

    private final class HandleMemberConnectRequestDispatchAlarmEventHandler
    implements IEmxEventHandler {
        private HandleMemberConnectRequestDispatchAlarmEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "'handle member connect request' dispatch alarm has triggered.", Tracer.Level.DEBUG);
            }
            long slot = StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.nextRead();
            if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "Got slot #" + slot + ".", Tracer.Level.DEBUG);
            }
            HandleMemberConnectRequestDispatchAlarmContext alarmContext = (HandleMemberConnectRequestDispatchAlarmContext)StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.get(slot);
            StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.read(slot);
            if ((HandleMemberConnectRequestDispatchAlarmContext)event.getAttachment() == alarmContext) {
                StoreReplicatorMember member = alarmContext.member;
                if (StoreReplicatorEventSequencer.this.detachedDispatcher != null) {
                    StoreReplicatorEventSequencer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberConnectRequest, member, null, null);
                } else {
                    StoreReplicatorEventSequencer.this.dispatchHandleMemberConnectRequest(alarmContext.member);
                }
            } else {
                String error = "INTERNAL ERROR: 'handle member connect request' dispatch alarm triggered in unexpected order.";
                StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "INTERNAL ERROR: 'handle member connect request' dispatch alarm triggered in unexpected order.", Tracer.Level.SEVERE);
                StoreReplicatorEventSequencer.this.scheduleFail(new RuntimeException("INTERNAL ERROR: 'handle member connect request' dispatch alarm triggered in unexpected order."));
            }
            return false;
        }
    }

    private final class ScheduleHandleMemberConnectRequestDispatchAlarmAction
    implements IEmxAction<Object, Object> {
        private ScheduleHandleMemberConnectRequestDispatchAlarmAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "Scheduling 'handle member connect request' dispatch...", Tracer.Level.DEBUG);
            }
            StoreReplicatorMember member = (StoreReplicatorMember)object;
            if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "Allocating available slot in handle member connect request context buffer...", Tracer.Level.DEBUG);
            }
            if (StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.hasSpace()) {
                long slot = StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.nextWrite();
                if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                    StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "Got slot #" + slot + ".", Tracer.Level.DEBUG);
                }
                if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                    StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "Preparing context in slot...", Tracer.Level.DEBUG);
                }
                HandleMemberConnectRequestDispatchAlarmContext alarmContext = (HandleMemberConnectRequestDispatchAlarmContext)StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.get(slot);
                alarmContext.init(member);
                StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.write(slot);
                dispatcher.schedAlarmEv(alarmContext.alarmEvent);
                if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                    StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "Scheduled alarm to dispatch 'handle member connect request'", Tracer.Level.DEBUG);
                }
            } else {
                if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                    StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "No slot available in handle member connect request context buffer. closing member", Tracer.Level.DEBUG);
                }
                member.close();
            }
            return null;
        }
    }

    private final class UnscheduleMemberTableOpenWaitCompletionAlarmAction
    implements IEmxAction<Object, Object> {
        private UnscheduleMemberTableOpenWaitCompletionAlarmAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEvent != null) {
                dispatcher.unschedAlarmEv(StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEvent);
                StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEvent = null;
            }
            return null;
        }
    }

    private final class MemberTableOpenWaitCompletionAlarmEventHandler
    implements IEmxEventHandler {
        private MemberTableOpenWaitCompletionAlarmEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEvent = null;
            if (StoreReplicatorEventSequencer.this.detachedDispatcher != null) {
                StoreReplicatorEventSequencer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.MemberTableOpenWaitCompletion, null, null, null);
            } else {
                StoreReplicatorEventSequencer.this.dispatchHandleMemberTableOpenWaitCompletion();
            }
            return false;
        }
    }

    private final class ScheduleMemberTableOpenWaitCompletionAlarmAction
    implements IEmxAction<Object, Object> {
        private ScheduleMemberTableOpenWaitCompletionAlarmAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEvent == null) {
                dispatcher.schedAlarmEv(StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEvent = EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEventHandler, ((Integer)object).intValue()));
            }
            return null;
        }
    }

    private final class EntityUpAction
    implements IEmxAction<Object, Object> {
        private EntityUpAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (StoreReplicatorEventSequencer.this.detachedDispatcher != null) {
                StoreReplicatorEventSequencer.this.publishToDetachedDispatcher(DetachedDispatchCarrierEventType.EntityUp, object, null, null);
            } else {
                StoreReplicatorEventSequencer.this.dispatchHandleEntityUp((IDiscoveryEntity)object);
            }
            return null;
        }
    }

    private final class InboundSequencerThread
    extends Thread
    implements IEmxDispatcherRunCompletionChecker {
        private final StartCoordinator startCoordinator = new StartCoordinator();
        private final IEmxDispatcher dispatcher;
        private final EmxActionExecutor<Object, Object> actionExecutor;
        private boolean stopped;

        InboundSequencerThread() throws EEmxException {
            this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, "X-ODS-StoreReplicatorInboundSequencer-" + StoreReplicatorEventSequencer.this.replicator.getStoreName() + "-" + StoreReplicatorEventSequencer.this.replicator.getMemberName(), IEmxDispatcher.Params.create((boolean)false, (boolean)true));
            this.actionExecutor = new EmxActionExecutor();
            this.setName(this.dispatcher.getName());
            this.setDaemon(true);
        }

        final StartCoordinator startCoordinator() {
            return this.startCoordinator;
        }

        final void invoke(IEmxAction<Object, Object> action, Object object, int flags) throws Exception {
            this.actionExecutor.invoke(this.dispatcher, action, object, flags);
        }

        final void shutdown() {
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            long slot;
            UtlThread.setDefaultCPUAffinityMask();
            this.dispatcher.setOwner(1);
            StartCoordinator startCoordinator = this.startCoordinator;
            synchronized (startCoordinator) {
                this.startCoordinator.isStarted = true;
                this.startCoordinator.notifyAll();
            }
            while (true) {
                try {
                    this.dispatcher.run(-1, (IEmxDispatcherRunCompletionChecker)this);
                }
                catch (Throwable e) {
                    StoreReplicatorEventSequencer.this.onFatalError(e);
                    continue;
                }
                break;
            }
            if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "replicator inbound sequencer thread done.", Tracer.Level.DEBUG);
            }
            if (StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEvent != null) {
                this.dispatcher.unschedAlarmEv(StoreReplicatorEventSequencer.this.memberTableOpenWaitCompletionAlarmEvent);
            }
            while ((slot = StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.nextRead()) >= 0L) {
                ((HandleMemberConnectRequestDispatchAlarmContext)StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.get(slot)).close(this.dispatcher);
                StoreReplicatorEventSequencer.this.memberConnectRequestProcessingAlarmContexts.read(slot);
            }
            if (((StoreReplicatorEventSequencer)StoreReplicatorEventSequencer.this).tracer.debug) {
                StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "closing replicator inbound sequencer dispatcher...", Tracer.Level.DEBUG);
            }
            try {
                this.dispatcher.close(true);
            }
            catch (Exception e) {
                StoreReplicatorEventSequencer.this.tracer.log(StoreReplicatorEventSequencer.this.replicator.getTracePrefix() + "failed to close replicator inbound sequencer dispatcher [" + e.toString() + "].", Tracer.Level.WARNING);
            }
        }

        public final boolean isDone() {
            return this.stopped;
        }

        public final Object getCompletion() throws Exception {
            return null;
        }

        final class StartCoordinator {
            boolean isStarted = false;

            StartCoordinator() {
            }
        }
    }

    private final class HandleMemberConnectRequestDispatchAlarmContext {
        final IEmxAlarmEvent alarmEvent;
        StoreReplicatorMember member;

        HandleMemberConnectRequestDispatchAlarmContext() {
            this.alarmEvent = EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)StoreReplicatorEventSequencer.this.handleMemberConnectRequestDispatchAlarmEventHandler, 200);
            this.alarmEvent.setAttachment((Object)this);
        }

        final HandleMemberConnectRequestDispatchAlarmContext init(StoreReplicatorMember member) {
            this.member = member;
            return this;
        }

        final void close(IEmxDispatcher dispatcher) {
            dispatcher.unschedAlarmEv(this.alarmEvent);
            this.member.close();
        }
    }

    private final class HandleMemberConnectRequestDispatchAlarmContextFactory
    implements UtlConcurrentRingBuffer.ItemFactory<HandleMemberConnectRequestDispatchAlarmContext> {
        private HandleMemberConnectRequestDispatchAlarmContextFactory() {
        }

        public HandleMemberConnectRequestDispatchAlarmContext createItem() {
            return new HandleMemberConnectRequestDispatchAlarmContext();
        }

        public HandleMemberConnectRequestDispatchAlarmContext[] createItemArray(int size) {
            return new HandleMemberConnectRequestDispatchAlarmContext[size];
        }
    }
}

