/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.ods.IStoreWriterStats;
import com.neeve.ods.impl.StorePacketPersisterBase;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import java.text.NumberFormat;

public abstract class StorePacketPersisterStatsBase
extends Stats
implements IStoreWriterStats {
    private final StorePacketPersisterBase persister;
    protected final NumberFormat format;
    protected long startTime;
    protected long deltaStartTime;
    private long numPutsRecordedLast;
    private long numUpdatesRecordedLast;
    private long numRemovesRecordedLast;
    private long numSendsRecordedLast;
    private long numCommitsLast;
    private long numForksLast;
    long numPutsRecorded;
    long numUpdatesRecorded;
    long numRemovesRecorded;
    long numSendsRecorded;
    long numCommits;
    long numForks;
    final Stats.LatencyManager o2p = new Stats.LatencyManager("o2p");

    protected StorePacketPersisterStatsBase(StorePacketPersisterBase persister, String type, String name, String logger, String startProp) {
        super(type, name, logger, startProp);
        this.persister = persister;
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
        this.startPeriodicOutputIfConfigured();
    }

    protected void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
        this.numPutsRecordedLast = this.numPutsRecorded;
        this.numUpdatesRecordedLast = this.numUpdatesRecorded;
        this.numRemovesRecordedLast = this.numRemovesRecorded;
        this.numSendsRecordedLast = this.numSendsRecorded;
        this.numCommitsLast = this.numCommits;
        this.numForksLast = this.numForks;
    }

    protected void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    public void get(StringBuilder sb) {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        long numPutsRecordedCurrent = this.numPutsRecorded;
        long numUpdatesRecordedCurrent = this.numUpdatesRecorded;
        long numRemovesRecordedCurrent = this.numRemovesRecorded;
        long numSendsRecordedCurrent = this.numSendsRecorded;
        long numCommitsCurrent = this.numCommits;
        long numForksCurrent = this.numForks;
        String numPutsRecordedStr = this.format.format(numPutsRecordedCurrent);
        String deltaNumPutsRecordedStr = this.format.format(numPutsRecordedCurrent - this.numPutsRecordedLast);
        String putRecordRateStr = this.format.format(numPutsRecordedCurrent * 1000L / deltaTotalTime);
        String deltaPutRecordRateStr = this.format.format((numPutsRecordedCurrent - this.numPutsRecordedLast) * 1000L / deltaTime);
        String numUpdatesRecordedStr = this.format.format(numUpdatesRecordedCurrent);
        String deltaNumUpdatesRecordedStr = this.format.format(numUpdatesRecordedCurrent - this.numUpdatesRecordedLast);
        String updateRecordRateStr = this.format.format(numUpdatesRecordedCurrent * 1000L / deltaTotalTime);
        String deltaUpdateRecordRateStr = this.format.format((numUpdatesRecordedCurrent - this.numUpdatesRecordedLast) * 1000L / deltaTime);
        String numRemovesRecordedStr = this.format.format(numRemovesRecordedCurrent);
        String deltaNumRemovesRecordedStr = this.format.format(numRemovesRecordedCurrent - this.numRemovesRecordedLast);
        String removeRecordRateStr = this.format.format(numRemovesRecordedCurrent * 1000L / deltaTotalTime);
        String deltaRemoveRecordRateStr = this.format.format((numRemovesRecordedCurrent - this.numRemovesRecordedLast) * 1000L / deltaTime);
        String numSendsRecordedStr = this.format.format(numSendsRecordedCurrent);
        String deltaNumSendsRecordedStr = this.format.format(numSendsRecordedCurrent - this.numSendsRecordedLast);
        String sendRecordRateStr = this.format.format(numSendsRecordedCurrent * 1000L / deltaTotalTime);
        String deltaSendRecordRateStr = this.format.format((numSendsRecordedCurrent - this.numSendsRecordedLast) * 1000L / deltaTime);
        String numCommitsStr = this.format.format(numCommitsCurrent);
        String deltaNumCommitsStr = this.format.format(numCommitsCurrent - this.numCommitsLast);
        String commitRateStr = this.format.format(numCommitsCurrent * 1000L / deltaTotalTime);
        String deltaCommitRateStr = this.format.format((numCommitsCurrent - this.numCommitsLast) * 1000L / deltaTime);
        String numForksStr = this.format.format(numForksCurrent);
        String deltaNumForksStr = this.format.format(numForksCurrent - this.numForksLast);
        String forkRateStr = this.format.format(numForksCurrent * 1000L / deltaTotalTime);
        String deltaForkRateStr = this.format.format((numForksCurrent - this.numForksLast) * 1000L / deltaTime);
        int disruptorCapacityCurrent = this.getDisruptorCapacity();
        int disruptorRemainingCurrent = this.getDisruptorRemaining();
        int disruptorUsedCurrent = disruptorCapacityCurrent - disruptorRemainingCurrent;
        int disruptorUsagePctCurrent = disruptorCapacityCurrent > 0 ? disruptorUsedCurrent * 100 / disruptorCapacityCurrent : 0;
        String disruptorCapacityStr = this.format.format(disruptorCapacityCurrent);
        String disruptorUsedStr = this.format.format(disruptorUsedCurrent);
        String disruptorUsagePctStr = this.format.format(disruptorUsagePctCurrent);
        String claimStrategyStr = this.getDisruptorClaimStrategy();
        String waitStrategyStr = this.getDisruptorWaitStrategy();
        int writeQueueSizeCurrent = this.persister.getWriteQueueSize();
        this.o2p.compute();
        sb.append("Put {");
        sb.append(numPutsRecordedStr).append("(").append(putRecordRateStr).append(" ").append(deltaPutRecordRateStr).append(")");
        sb.append("} ");
        sb.append("Updates {");
        sb.append(numUpdatesRecordedStr).append("(").append(updateRecordRateStr).append(" ").append(deltaUpdateRecordRateStr).append(")");
        sb.append("} ");
        sb.append("Removes {");
        sb.append(numRemovesRecordedStr).append("(").append(removeRecordRateStr).append(" ").append(deltaRemoveRecordRateStr).append(")");
        sb.append("} ");
        sb.append("Sends {");
        sb.append(numSendsRecordedStr).append("(").append(sendRecordRateStr).append(" ").append(deltaSendRecordRateStr).append(")");
        sb.append("} ");
        sb.append("Commits {");
        sb.append(numCommitsStr).append("(").append(commitRateStr).append(" ").append(deltaCommitRateStr).append(")");
        sb.append("} ");
        sb.append("Forks {");
        sb.append(numForksStr).append("(").append(forkRateStr).append(" ").append(deltaForkRateStr).append(")");
        sb.append("}").append("\n");
        sb.append("Disruptor (").append(claimStrategyStr).append(", ").append(waitStrategyStr).append(") {");
        sb.append("[").append(disruptorUsedStr).append(" of ").append(disruptorCapacityStr).append("] ").append(disruptorUsagePctStr).append("%");
        sb.append("}").append("\n");
        this.o2p.get(sb);
        sb.append("Writer {");
        sb.append("qsize=").append(writeQueueSizeCurrent);
        sb.append("}").append("\n");
        this.stamp();
    }

    @Override
    public final long getNumPutsRecorded() {
        return this.numPutsRecorded;
    }

    @Override
    public final long getNumUpdatesRecorded() {
        return this.numUpdatesRecorded;
    }

    @Override
    public final long getNumRemovesRecorded() {
        return this.numRemovesRecorded;
    }

    @Override
    public final long getNumSendsRecorded() {
        return this.numSendsRecorded;
    }

    @Override
    public final long getNumCommits() {
        return this.numCommits;
    }

    @Override
    public final long getNumForks() {
        return this.numForks;
    }

    @Override
    public final boolean isDetached() {
        return this.persister.isDetached();
    }

    @Override
    public final int getDisruptorCapacity() {
        return this.persister.getDisruptorCapacity();
    }

    @Override
    public final int getDisruptorRemaining() {
        return this.persister.getDisruptorRemaining();
    }

    @Override
    public final String getDisruptorClaimStrategy() {
        return this.persister.getDisruptorClaimStrategy();
    }

    @Override
    public final String getDisruptorWaitStrategy() {
        return this.persister.getDisruptorWaitStrategy();
    }

    @Override
    public IStats.Latencies getOfferToPollLatencies() {
        return this.o2p;
    }
}

