/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.neeve.ods.IStorePersister;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.StorePersisterDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class StorePersisterFactory
extends OdsObject {
    private static final StorePersisterFactory instance = new StorePersisterFactory();

    private StorePersisterFactory() {
        super(null);
    }

    public static final StorePersisterFactory getInstance() {
        return instance;
    }

    public final IStorePersister createPersister(StorePersisterDescriptor descriptor) throws OdsException {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        Class<?> persisterClass = null;
        try {
            persisterClass = Class.forName(descriptor.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new OdsException("Store persister class [" + descriptor.getClassName() + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new OdsException("Store persister class [" + descriptor.getClassName() + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Method persisterCreateMethod = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.lang.String"), Class.forName("com.neeve.ods.StorePersisterDescriptor")};
            persisterCreateMethod = persisterClass.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to load java.util.Properties during instantiation of store persister class [" + descriptor.getClassName() + "]");
        }
        catch (SecurityException e) {
            throw new OdsException("Access to instantiation method in store persister class [" + descriptor.getClassName() + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new OdsException("Instantiation method in store persister class [" + descriptor.getClassName() + "] could not be found");
        }
        IStorePersister persister = null;
        try {
            try {
                Object[] parameters = new Object[]{descriptor.getName(), descriptor};
                persister = (IStorePersister)persisterCreateMethod.invoke(null, parameters);
                if (persister == null) {
                    throw new OdsException("Instantiation method in store persister class [" + descriptor.getClassName() + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new OdsException("Instantiation method in store persister class [" + descriptor.getClassName() + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new OdsException("Access to instantiation method in store persister class [" + descriptor.getClassName() + "] is denied");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof OdsException) {
                throw (OdsException)e.getCause();
            }
            throw new OdsException(e.getCause());
        }
        return persister;
    }

    public final IStorePersister createPersister(String name) throws OdsException {
        return this.createPersister(StorePersisterDescriptor.load(name));
    }
}

