/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.hstr;

import com.neeve.hstr.EHstrFormatException;
import java.util.StringTokenizer;

public class Hstr {
    private static char element_wildcard_char = (char)42;
    private static String level_wildcard_str = "...";
    private static String element_separator_str = "/";
    private static int flags;
    public static final int FLGHSTR_MUST_START_WITH_ELEMENT_SEPARATOR = 1;
    public static final int FLGHSTR_CANNOT_START_WITH_ELEMENT_SEPARATOR = 2;

    private static boolean doesElementMatchPattern(char[] element, int elementPos, char[] pattern, int patternPos) {
        int j;
        int i = elementPos;
        for (j = patternPos; i < element.length && j < pattern.length; ++j, ++i) {
            if (pattern[j] == element_wildcard_char) {
                while (++j < pattern.length && pattern[j] == element_wildcard_char) {
                }
                if (j == pattern.length) {
                    return true;
                }
                while (i < element.length) {
                    if (Hstr.doesElementMatchPattern(element, i, pattern, j)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            if (element[i] == pattern[j]) continue;
            return false;
        }
        while (j < pattern.length && pattern[j] == element_wildcard_char) {
            ++j;
        }
        return i == element.length && j == pattern.length;
    }

    static String normalize(String hstr, boolean validate) throws EHstrFormatException {
        if (validate && !Hstr.isValid(hstr)) {
            throw new EHstrFormatException(hstr);
        }
        if ((Hstr.getFlags() & 1) == 1) {
            return hstr;
        }
        if ((Hstr.getFlags() & 2) == 2) {
            return hstr;
        }
        return hstr.startsWith(Hstr.getElementSeparator()) ? hstr : Hstr.getElementSeparator() + hstr;
    }

    static String denormalize(String hstr, boolean validate) throws EHstrFormatException {
        if (validate && !Hstr.isValid(hstr)) {
            throw new EHstrFormatException(hstr);
        }
        if ((Hstr.getFlags() & 1) == 1) {
            return hstr.substring(Hstr.getElementSeparator().length());
        }
        if ((Hstr.getFlags() & 2) == 2) {
            return hstr;
        }
        return !hstr.startsWith(Hstr.getElementSeparator()) ? hstr : hstr.substring(Hstr.getElementSeparator().length());
    }

    public static void setElementWildcard(char ch) {
        element_wildcard_char = ch;
    }

    public static char getElementWildcard() {
        return element_wildcard_char;
    }

    public static void setLevelWildcard(String str) {
        if (str.length() == 0) {
            throw new IllegalArgumentException("Level wildcard string cannot be empty");
        }
        level_wildcard_str = str;
    }

    public static String getLevelWildcard() {
        return level_wildcard_str;
    }

    public static void setElementSeparator(String str) {
        if (str.length() == 0) {
            throw new IllegalArgumentException("Element separator string cannot be empty");
        }
        element_separator_str = str;
    }

    public static String getElementSeparator() {
        return element_separator_str;
    }

    public static void setFlags(int p_flags) {
        flags = p_flags;
    }

    public static int getFlags() {
        return flags;
    }

    public static boolean isWildcard(String hstr) {
        return hstr.indexOf(element_wildcard_char) != -1 || hstr.indexOf(level_wildcard_str) != -1;
    }

    public static boolean isValid(String hstr) {
        int index;
        String string = hstr = hstr == null ? null : hstr.trim();
        return !(hstr == null || hstr.length() == 0 || (flags & 1) == 1 && !hstr.startsWith(element_separator_str) || (flags & 2) == 2 && hstr.startsWith(element_separator_str) || hstr.compareTo(element_separator_str) == 0 || (index = hstr.indexOf(element_separator_str + element_separator_str)) != -1) && ((index = hstr.indexOf(level_wildcard_str)) == -1 || index == hstr.length() - level_wildcard_str.length());
    }

    public static String[] split(String hstr) {
        StringTokenizer tokenizer = new StringTokenizer(hstr, element_separator_str);
        String[] ret = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            ret[i++] = tokenizer.nextToken();
        }
        return ret;
    }

    public static String normalize(String hstr) throws EHstrFormatException {
        return Hstr.normalize(hstr, true);
    }

    public static boolean isElementMatch(String element1, String element2) {
        if (Hstr.isWildcard(element1)) {
            if (Hstr.isWildcard(element2)) {
                char[] element1Array = element1.toCharArray();
                char[] element2Array = element2.toCharArray();
                int element1ArrayLast = element1Array.length - 1;
                int element2ArrayLast = element2Array.length - 1;
                return !(element1Array[0] != element_wildcard_char && element2Array[0] != element_wildcard_char && element1Array[0] != element2Array[0] || element1Array[element1ArrayLast] != element_wildcard_char && element2Array[element2ArrayLast] != element_wildcard_char && element1Array[element1ArrayLast] != element2Array[element2ArrayLast]);
            }
            return Hstr.doesElementMatchPattern(element2.toCharArray(), 0, element1.toCharArray(), 0);
        }
        if (Hstr.isWildcard(element2)) {
            return Hstr.doesElementMatchPattern(element1.toCharArray(), 0, element2.toCharArray(), 0);
        }
        return element1.compareToIgnoreCase(element2) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMatch(String hstr1, String hstr2) throws EHstrFormatException {
        int elementCountToBeMatched;
        boolean hstr2HasLevelWildcard;
        if (!Hstr.isValid(hstr1)) {
            throw new EHstrFormatException(hstr1);
        }
        if (!Hstr.isValid(hstr2)) {
            throw new EHstrFormatException(hstr2);
        }
        if ((flags & 1) == 0 && (flags & 2) == 0) {
            if (hstr1.startsWith(element_separator_str)) {
                hstr1 = hstr1.substring(element_separator_str.length());
            }
            if (hstr2.startsWith(element_separator_str)) {
                hstr2 = hstr2.substring(element_separator_str.length());
            }
        }
        String[] hstr1Elements = Hstr.split(hstr1);
        String[] hstr2Elements = Hstr.split(hstr2);
        boolean hstr1HasLevelWildcard = hstr1Elements[hstr1Elements.length - 1].compareTo(level_wildcard_str) == 0;
        boolean bl = hstr2HasLevelWildcard = hstr2Elements[hstr2Elements.length - 1].compareTo(level_wildcard_str) == 0;
        if (hstr1HasLevelWildcard || hstr2HasLevelWildcard) {
            if (hstr1Elements.length > hstr2Elements.length) {
                if (!hstr1HasLevelWildcard) return false;
                elementCountToBeMatched = hstr2Elements.length;
            } else if (hstr1Elements.length < hstr2Elements.length) {
                if (!hstr2HasLevelWildcard) return false;
                elementCountToBeMatched = hstr1Elements.length;
            } else {
                elementCountToBeMatched = hstr1Elements.length;
            }
        } else {
            if (hstr1Elements.length != hstr2Elements.length) return false;
            elementCountToBeMatched = hstr1Elements.length;
        }
        for (int i = 0; i < elementCountToBeMatched; ++i) {
            if (Hstr.isElementMatch(hstr1Elements[i], hstr2Elements[i])) continue;
            return false;
        }
        return true;
    }
}

