/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.env;

import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlProps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class Env {
    private static final Map<String, Object> env = Env.getBootstrapEnvironment();
    private static final Map<String, Set<PropertyChangeCallback>> cbs = new UtlLinkedHashMap<String, Set<PropertyChangeCallback>>();
    public static final String APP_PROPFILE_PROPNAME = "nv.app.propfile";
    private static final String APP_PROPFILE_DEFAULT = "conf/rumi.conf";

    private static final void dispatchChangeNotifications(String key, Set<PropertyChangeCallback> cbset, Object currentValue, Object newValue) {
        Object v1;
        Object object = v1 = currentValue != null ? currentValue : newValue;
        if (v1 != null && !v1.equals(v1 == currentValue ? newValue : currentValue)) {
            for (PropertyChangeCallback cb : cbset) {
                try {
                    cb.onPropertyChange(key, currentValue, newValue);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static final void dispatchChangeNotifications(Map<String, Object> newEnv) {
        Set<PropertyChangeCallback> cbset;
        String key;
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            key = entry.getKey();
            cbset = cbs.get(key);
            if (cbset == null) continue;
            Env.dispatchChangeNotifications(key, cbset, entry.getValue(), newEnv.get(key));
        }
        for (Map.Entry<String, Object> entry : newEnv.entrySet()) {
            key = entry.getKey();
            if (env.containsKey(key) || (cbset = cbs.get(key)) == null) continue;
            Env.dispatchChangeNotifications(key, cbset, env.get(key), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<String, Object> getBootstrapEnvironment() {
        UtlLinkedHashMap<String, Object> env = new UtlLinkedHashMap<String, Object>();
        String nvRootFromEnv = System.getenv("NVROOT");
        String nvRoot = UtlProps.getValue(System.getProperties(), "NVROOT", nvRootFromEnv != null ? nvRootFromEnv : ".");
        String propfile = System.getProperty(APP_PROPFILE_PROPNAME, System.getenv(APP_PROPFILE_PROPNAME) != null ? System.getenv(APP_PROPFILE_PROPNAME) : System.getenv(APP_PROPFILE_PROPNAME.replace(".", "_")));
        if (propfile == null && new File(nvRoot + File.separator + APP_PROPFILE_DEFAULT).exists()) {
            propfile = nvRoot + File.separator + APP_PROPFILE_DEFAULT;
        }
        Properties systemProps = System.getProperties();
        for (String key : systemProps.stringPropertyNames()) {
            String value = systemProps.getProperty(key);
            if (value == null) continue;
            env.put(key, value);
        }
        Properties props = new Properties();
        if (propfile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propfile);
                props.load(fis);
            }
            catch (Exception value) {
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException value) {}
            }
        }
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            env.put(key, value);
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            env.put(entry.getKey(), entry.getValue());
            env.put(entry.getKey().replace('_', '.'), entry.getValue());
        }
        return env;
    }

    public static final void setEnvironment(Map<String, Object> val) {
        if (val == null) {
            throw new IllegalArgumentException("supplied environment cannot be null");
        }
        Env.dispatchChangeNotifications(val);
        env.clear();
        env.putAll(val);
    }

    public static final void resetEnvironment() {
        Env.setEnvironment(Env.getBootstrapEnvironment());
    }

    public static final synchronized Set<PropertyChangeCallback> getChangeCallbacks(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        Set<PropertyChangeCallback> cbset = cbs.get(name);
        return cbset != null ? new HashSet<PropertyChangeCallback>(cbset) : null;
    }

    public static final synchronized Set<PropertyChangeCallback> addChangeCallback(String name, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Set<PropertyChangeCallback> cbset = cbs.get(name);
        if (cbset == null) {
            cbset = new HashSet<PropertyChangeCallback>();
            cbs.put(name, cbset);
        }
        cbset.add(cb);
        return new HashSet<PropertyChangeCallback>(cbset);
    }

    public static final synchronized Set<PropertyChangeCallback> removeChangeCallback(String name, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        Set<PropertyChangeCallback> cbset = cbs.get(name);
        if (cbset != null) {
            cbset.remove(cb);
        }
        return new HashSet<PropertyChangeCallback>(cbset);
    }

    public static final String getValue(String name, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.addChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, (String)null);
    }

    public static final String getValue(String name) {
        return Env.getValue(name, (PropertyChangeCallback)null);
    }

    public static final String getValue(String name, String defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.addChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final String getValue(String name, String defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static final short getValue(String name, short defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.addChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final short getValue(String name, short defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static final int getValue(String name, int defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.addChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final int getValue(String name, int defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static final double getValue(String name, double defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.addChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final double getValue(String name, double defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static final boolean getValue(String name, boolean defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.addChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final boolean getValue(String name, boolean defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static interface PropertyChangeCallback {
        public void onPropertyChange(String var1, Object var2, Object var3);
    }
}

