/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl.loopback;

import com.neeve.config.Config;
import com.neeve.event.IEventHandler;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.loopback.LoopbackBus;
import com.neeve.sma.impl.loopback.LoopbackMessageChannel;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlTime;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class LoopbackMessageBusBinding
extends MessageBusBindingBase {
    private static final String SERIALIZE_MESSAGES = "serialize_messages";
    private static final String QUEUE_WAIT_STRATEGY = "queue_wait_strategy";
    private boolean serializeMessages;
    private LoopbackBus.AgentQueueWaitStrategy queueWaitStrategy;
    private LoopbackBus.Agent agent;
    private final UtlPool<LoopbackAcknowledger> acknowledgerPool;

    LoopbackMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(null, userName, descriptor, eventHandler);
        this.acknowledgerPool = UtlPool.create((String)"sma_loopback_acknowledger", (String)(userName + "." + this.getName()), (UtlPool.Factory)new UtlPool.Factory<LoopbackAcknowledger>(){

            public LoopbackAcknowledger createItem(Object object) {
                return new LoopbackAcknowledger();
            }

            public LoopbackAcknowledger[] createItemArray(int size) {
                return new LoopbackAcknowledger[size];
            }
        }, (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
    }

    final boolean serializeMessages() {
        return this.serializeMessages;
    }

    final void subscribe(String topic) {
        this.agent.subscribe(topic);
    }

    final void unsubscribe(String topic) {
        this.agent.unsubscribe(topic);
    }

    final void publish(LoopbackMessageChannel channel, XString topic, MessageView view, Object message, MessageMetadata metadata) throws SmaException {
        try {
            if (MessageLatencyManager.recordMsgLegWaypoints) {
                view.setPreWireTs(UtlTime.now());
            }
            this.agent.publish(channel, topic, view, message, metadata);
            if (MessageLatencyManager.recordMsgLegWaypoints) {
                view.setPostWireSendTs(UtlTime.now());
            }
            if (MessageLatencyManager.recordMsgLegLatencies) {
                this.latencyManager.calcAndRecordLegLatencies(view, MessageLatencyManager.MessagingDirection.Outbound);
            }
        }
        catch (Exception e) {
            throw new SmaException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onMessage(long sno, XString topic, Object message, MessageMetadata metadata, boolean ackRequired, long originTs, long preWireTs) {
        block25: {
            if (metadata != null) {
                metadata.acquire();
            }
            try {
                long now = MessageLatencyManager.recordMsgLegWaypoints ? UtlTime.now() : 0L;
                LoopbackMessageChannel channel = (LoopbackMessageChannel)this.findMessageChannelForInboundMessageDispatch(metadata.getMessageChannelNameAsRaw(), metadata.getMessageChannelId());
                if (channel != null) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Dispatching message sent on channel '" + metadata.getMessageChannelName() + "' via channel '" + channel.getName() + "'.", Tracer.Level.DEBUG);
                    }
                    try {
                        channel.onMessage(sno, message, metadata, ackRequired, topic, originTs, preWireTs, now);
                        break block25;
                    }
                    catch (Exception e) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Channel threw exception '" + e + "' on processing received message", Tracer.Level.DEBUG);
                        }
                        throw e;
                    }
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Channel (name=" + metadata.getMessageChannelName() + ", id=" + metadata.getMessageChannelId() + ") not found (or not joined) for inbound message with [sno=" + sno + ", topic=" + topic + "].", Tracer.Level.DEBUG);
                }
                throw new Exception(this.tracePrefix + "Channel (name=" + metadata.getMessageChannelName() + ", id=" + metadata.getMessageChannelId() + ") not found (or not joined) for inbound message with [sno=" + sno + ", topic=" + topic + "].");
            }
            catch (Throwable e) {
                byte[] serializedMetadata = null;
                if (metadata != null) {
                    serializedMetadata = new byte[metadata.getSerializedLength()];
                    metadata.getBuffer().getTo(0, serializedMetadata, 0, serializedMetadata.length);
                }
                byte[] serializedMessage = null;
                if (message != null) {
                    if (message instanceof String) {
                        try {
                            serializedMessage = ((String)message).getBytes("utf-8");
                        }
                        catch (UnsupportedEncodingException e1) {
                            this.tracer.log(this.tracePrefix + "Error serializing unhandled String encoded message to utf 8", Tracer.Level.WARNING);
                        }
                    } else if (message instanceof ByteBuffer) {
                        ByteBuffer bbMessage = (ByteBuffer)message;
                        serializedMessage = new byte[bbMessage.remaining()];
                        int pos = bbMessage.position();
                        try {
                            ((ByteBuffer)message).get(serializedMessage, 0, serializedMessage.length);
                        }
                        finally {
                            bbMessage.position(pos);
                        }
                    } else if (message instanceof IOBuffer) {
                        IOBuffer ioMessage = (IOBuffer)message;
                        serializedMessage = new byte[ioMessage.getLength()];
                        ioMessage.getTo(0, serializedMessage, 0, serializedMessage.length);
                    }
                }
                super.onInboundMessageHandlingFault(sno, topic == null ? null : topic.getValue(), metadata, message, serializedMetadata, serializedMessage, ackRequired ? this.createAcknowledger(sno) : null, e);
            }
            finally {
                if (metadata != null) {
                    metadata.dispose();
                }
            }
        }
    }

    final void onPublishComplete(LoopbackMessageChannel channel, MessageView view, MessageMetadata metadata, Exception status) {
        try {
            channel.onPublishComplete(view, metadata, status);
            view.dispose();
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix + "Channel threw exception '" + e + "' on processing publish completion", Tracer.Level.SEVERE);
            e.printStackTrace();
        }
    }

    final void onProcessingComplete(long sno) {
        try {
            this.agent.onProcessingComplete(sno);
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix + "Bus threw exception '" + e + "' on processing process completion (sno=" + sno + ")", Tracer.Level.SEVERE);
            e.printStackTrace();
        }
    }

    @Override
    protected final void doOpen() throws SmaException {
        Properties providerConfig = this.descriptor.getProviderConfig();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Opening binding (props=" + providerConfig + ")...", Tracer.Level.DEBUG);
        }
        this.serializeMessages = UtlProps.getValue((Properties)providerConfig, (String)SERIALIZE_MESSAGES, (boolean)Config.getValue((String)"nv.sma.loopback.serializemessages", (boolean)true));
        try {
            this.queueWaitStrategy = LoopbackBus.AgentQueueWaitStrategy.valueOf(UtlProps.getValue((Properties)providerConfig, (String)QUEUE_WAIT_STRATEGY, (String)"Sleeping"));
        }
        catch (Exception e) {
            throw new SmaException(e);
        }
        String address = UtlProps.getValue((Properties)providerConfig, (String)"Address", null);
        if (this.tracer.debug) {
            this.tracer.log("Setting agent parameters for '" + this.getUserName() + "' (queueWaitStrategy=" + (Object)((Object)this.queueWaitStrategy) + ")...", Tracer.Level.DEBUG);
        }
        LoopbackBus.getInstance(address).getAgentParameters(this.getUserName()).setQueueWaitStrategy(this.queueWaitStrategy);
        this.agent = LoopbackBus.getInstance(address).connect(this);
    }

    final LoopbackAcknowledger createAcknowledger(long sno) {
        return ((LoopbackAcknowledger)this.acknowledgerPool.get(null)).init(sno);
    }

    @Override
    protected final MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        return new LoopbackMessageChannel(descriptor, this);
    }

    @Override
    protected final void doStart() throws SmaException {
        try {
            this.agent.start();
        }
        catch (Exception e) {
            if (e instanceof SmaException) {
                throw (SmaException)e;
            }
            throw new SmaException(e);
        }
    }

    @Override
    protected final void doFlush() throws SmaException {
    }

    @Override
    protected final boolean doCanFail() {
        return true;
    }

    @Override
    protected final boolean doAcksRequireFlush() {
        return false;
    }

    @Override
    protected final void doClose() throws SmaException {
        this.agent.close();
        this.acknowledgerPool.close();
    }

    private final class LoopbackAcknowledger
    extends MessageBusBindingBase.Acknowledger<LoopbackAcknowledger> {
        long sno;

        LoopbackAcknowledger() {
        }

        final LoopbackAcknowledger init(long sno) {
            this.sno = sno;
            return this;
        }

        @Override
        public final void doAck() {
            if (((LoopbackMessageBusBinding)LoopbackMessageBusBinding.this).tracer.debug) {
                LoopbackMessageBusBinding.this.tracer.log(LoopbackMessageBusBinding.this.tracePrefix + "Processing for message (sno=" + this.sno + ") is complete. Acknowledging...", Tracer.Level.DEBUG);
            }
            LoopbackMessageBusBinding.this.onProcessingComplete(this.sno);
        }

        @Override
        protected void doReset() {
            this.sno = -1L;
        }
    }
}

