/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ddl;

import com.neeve.ddl.DdlConfigException;
import com.neeve.ddl.DdlConfigTree;
import com.neeve.util.UtlText;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlEnum;

public class DdlConfigNode
implements Comparable<DdlConfigNode> {
    private DdlConfigTree root;
    private DdlConfigNode parent;
    private Map<String, DdlConfigNode> children = new TreeMap<String, DdlConfigNode>();
    private String name;
    private String[] nameParts;
    private String value;
    private static final List<String> xElementOrder = Arrays.asList("profiles", "servers", "xvms", "apps", "buses", "busProviders", "env", "systemDetails");

    protected DdlConfigNode(DdlConfigTree root, DdlConfigNode parent, String name, String value) {
        this.value = value;
        this.onNodeLocationChange(parent, name);
    }

    static final String[] toPath(String name) {
        if (name == null) {
            return new String[0];
        }
        if (name.indexOf("\"") == -1) {
            return name.split("\\.");
        }
        String[] rc = name.split("\\.(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = UtlText.stripQuotesAndUnescape((String)rc[i]);
        }
        return rc;
    }

    static final String escapedPath(String ... path) {
        if (path.length == 1) {
            return path[0].indexOf(46) != -1 ? "\"" + path[0] + "\"" : path[0];
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            sb.append(DdlConfigNode.escapedPath(path[i]));
        }
        return sb.toString();
    }

    public final String getName() {
        return this.name == null ? null : this.nameParts[this.nameParts.length - 1];
    }

    final String[] getNameParts() {
        return this.nameParts;
    }

    public final String getFullName() {
        return this.name;
    }

    public final String getUnsubstitutedValue() {
        return this.value;
    }

    public final String getValue() {
        return this.root != null ? this.root.overrideProperty(this.getFullName(), this.value) : this.value;
    }

    public boolean getValue(String name, boolean defaultValue) {
        return Boolean.valueOf(this.getValue(name, Boolean.toString(defaultValue)));
    }

    public short getValue(String name, byte defaultValue) {
        return Byte.valueOf(this.getValue(name, Byte.toString(defaultValue))).byteValue();
    }

    public char getValue(String name, char defaultValue) {
        String value = this.getValue(name, Character.toString(defaultValue));
        if (value.length() == 1) {
            return value.charAt(0);
        }
        throw new DdlConfigException("Expected a char value for " + this.name + "." + name + " but '" + value + "' was specified.");
    }

    public short getValue(String name, short defaultValue) {
        try {
            return Short.valueOf(this.getValue(name, Short.toString(defaultValue)));
        }
        catch (NumberFormatException e) {
            throw new DdlConfigException("Expected a short value for " + this.name + "." + name + " but '" + this.getValue(name) + "' was specified.");
        }
    }

    public int getValue(String name, int defaultValue) {
        try {
            return Integer.valueOf(this.getValue(name, Integer.toString(defaultValue)));
        }
        catch (NumberFormatException e) {
            throw new DdlConfigException("Expected a int value for " + this.name + "." + name + " but '" + this.getValue(name) + "' was specified.");
        }
    }

    public long getValue(String name, long defaultValue) {
        try {
            return Long.valueOf(this.getValue(name, Long.toString(defaultValue)));
        }
        catch (NumberFormatException e) {
            throw new DdlConfigException("Expected a long value for " + this.name + "." + name + " but '" + this.getValue(name) + "' was specified.");
        }
    }

    public float getValue(String name, float defaultValue) {
        try {
            return Float.valueOf(this.getValue(name, Float.toString(defaultValue))).floatValue();
        }
        catch (NumberFormatException e) {
            throw new DdlConfigException("Expected a float value for " + this.name + "." + name + " but '" + this.getValue(name) + "' was specified.");
        }
    }

    public double getValue(String name, double defaultValue) {
        try {
            return Double.valueOf(this.getValue(name, Double.toString(defaultValue)));
        }
        catch (NumberFormatException e) {
            throw new DdlConfigException("Expected a double value for " + this.name + "." + name + " but '" + this.getValue(name) + "' was specified.");
        }
    }

    final <T extends Enum<T>> T getValue(String name, Class<T> enumType, T defaultValue, boolean required) {
        String configured = this.getValue(name);
        if (configured != null) {
            if (enumType.isAnnotationPresent(XmlEnum.class)) {
                try {
                    Method fromValueMethod = enumType.getMethod("fromValue", String.class);
                    return (T)((Enum)fromValueMethod.invoke(null, configured));
                }
                catch (Throwable thrown) {
                    throw new DdlConfigException("Error parsing value of " + (this.name == null ? null : this.getFullName() + "." + name), thrown);
                }
            }
            try {
                return Enum.valueOf(enumType, configured);
            }
            catch (Throwable thrown) {
                throw new DdlConfigException("Error parsing value of " + (this.name == null ? null : this.getFullName() + "." + name), thrown);
            }
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        if (required) {
            throw new DdlConfigException("Missing required property value " + (this.name == null ? null : this.getFullName() + "." + name) + "." + name);
        }
        return null;
    }

    public DdlConfigNode get(String relativePath) {
        if (this.root != null) {
            if (this.name == null) {
                return this.root.get(relativePath);
            }
            return this.root.get(this.name + "." + relativePath);
        }
        String[] path = DdlConfigNode.toPath(relativePath);
        if (path.length == 1) {
            return this.children.get(path[0]);
        }
        DdlConfigNode child = this.children.get(path[0]);
        if (child != null) {
            String descendantKey = relativePath.startsWith("\"") ? relativePath.substring(path[0].length() + 3) : relativePath.substring(path[0].length() + 1);
            return child.get(descendantKey);
        }
        return null;
    }

    public final String getValue(String name) {
        return this.getValue(name, null);
    }

    public final String getValue(String name, String defaultValue) {
        DdlConfigNode child = this.get(name);
        if (child != null) {
            String value = child.getValue();
            if (value != null) {
                return value;
            }
            return defaultValue;
        }
        if (this.root != null) {
            return this.root.overrideProperty(this.name == null ? null : this.getFullName() + "." + name, defaultValue);
        }
        return null;
    }

    public String getRequiredValue() {
        if (this.value == null) {
            throw new DdlConfigException("Value for '" + this.name + "' is required");
        }
        return this.value;
    }

    public String getRequiredValue(String name) {
        return this.getRequiredChild(name).getRequiredValue();
    }

    public DdlConfigTree getRoot() {
        return this.root;
    }

    public DdlConfigNode getParent() {
        return this.parent;
    }

    public Collection<DdlConfigNode> getChildren() {
        return this.children.values();
    }

    public DdlConfigNode getRequiredChild(String name) {
        DdlConfigNode child = this.get(name);
        if (child == null) {
            throw new DdlConfigException("Required value '" + this.name + "." + name + " was not found");
        }
        return child;
    }

    public void addAll(Properties properties) {
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            this.add(String.valueOf(prop.getKey()), String.valueOf(prop.getValue()));
        }
    }

    public void merge(DdlConfigNode source, boolean override) {
        if (override || this.value == null) {
            this.value = source.getValue();
        }
        for (DdlConfigNode sourceChild : source.getChildren()) {
            DdlConfigNode child = this.get(sourceChild.getName());
            if (child == null) {
                child = this.add(DdlConfigNode.escapedPath(sourceChild.getName()), sourceChild.getValue());
            }
            child.merge(sourceChild, override);
        }
    }

    public DdlConfigNode add(String key, String value) {
        if (key == null) {
            throw new NullPointerException("Can't add a null property name");
        }
        String[] path = DdlConfigNode.toPath(key);
        DdlConfigNode child = this.children.get(path[0]);
        if (child == null) {
            child = new DdlConfigNode(this.root, this, path[0], null);
            this.children.put(path[0], child);
        }
        if (path.length == 1) {
            child.value = value;
            return child;
        }
        String descendantKey = key.startsWith("\"") ? key.substring(path[0].length() + 3) : key.substring(path[0].length() + 1);
        return child.add(descendantKey, value);
    }

    public DdlConfigNode remove(String relativePath) {
        DdlConfigNode existing = this.get(relativePath);
        if (existing != null) {
            existing.parent.children.remove(existing.getName());
            existing.onNodeLocationChange(null, relativePath);
        }
        return existing;
    }

    public DdlConfigNode addNode(String relativePath, DdlConfigNode node) {
        if (relativePath == null) {
            throw new NullPointerException("Can't add a null property name");
        }
        if (node == null) {
            throw new NullPointerException("Can't add a null config node");
        }
        String[] path = DdlConfigNode.toPath(relativePath);
        DdlConfigNode child = this.children.get(path[0]);
        if (path.length == 1) {
            if (child != null) {
                this.remove(path[0]);
            }
            this.children.put(path[0], node);
            node.onNodeLocationChange(this, path[0]);
            return child;
        }
        if (child == null) {
            child = new DdlConfigNode(this.root, this, path[0], null);
            this.children.put(path[0], child);
        }
        String descendantKey = relativePath.startsWith("\"") ? relativePath.substring(path[0].length() + 3) : relativePath.substring(path[0].length() + 1);
        return child.addNode(descendantKey, node);
    }

    private final void onNodeLocationChange(DdlConfigNode parent, String name) {
        if (!(this instanceof DdlConfigTree)) {
            if (this.root != null) {
                this.root.onNodeRemoved(this);
            }
            this.parent = parent;
            this.root = parent != null ? parent.root : null;
            if (name != null && name.indexOf(46) != -1) {
                name = "\"" + name + "\"";
            }
            this.name = parent != null && parent != this.root ? parent.getFullName() + "." + name : name;
            this.nameParts = DdlConfigNode.toPath(this.name);
            if (this.root != null) {
                this.root.onNodeAdded(this);
            }
            for (DdlConfigNode child : this.children.values()) {
                child.onNodeLocationChange(this, child.getName());
            }
        } else {
            if (parent != null) {
                throw new IllegalArgumentException("A config tree root cannot be set as a child of " + parent.getFullName());
            }
            this.root = (DdlConfigTree)this;
            this.parent = parent;
        }
    }

    public Collection<DdlConfigNode> collectDescendents(Collection<DdlConfigNode> collection) {
        for (DdlConfigNode child : this.children.values()) {
            collection.add(child);
            child.collectDescendents(collection);
        }
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(DdlConfigNode o) {
        if (this.nameParts.length == 0) {
            return this.nameParts.length - o.nameParts.length;
        }
        if (o.nameParts.length == 0) {
            return o.nameParts.length - this.nameParts.length;
        }
        if (this.root == null) return this.name.compareTo(o.name);
        if (this.nameParts[0].equals(this.root.xConfigRoot)) {
            if (!o.nameParts[0].equals(this.root.xConfigRoot)) return -1;
            if (this.nameParts.length == 1) {
                return this.nameParts.length - o.nameParts.length;
            }
            if (o.nameParts.length == 1) {
                return o.nameParts.length - this.nameParts.length;
            }
            if (this.nameParts[1].toLowerCase().equals(o.nameParts[1].toLowerCase())) return this.name.compareTo(o.name);
            int i1 = xElementOrder.indexOf(this.nameParts[1].toLowerCase());
            int i2 = xElementOrder.indexOf(o.nameParts[1].toLowerCase());
            return -(i1 - i2);
        }
        if (!o.nameParts[0].equals(this.root.xConfigRoot)) return this.name.compareTo(o.name);
        return 1;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof DdlConfigNode) {
            return this.name == null && ((DdlConfigNode)other).name == null || this.name.equals(((DdlConfigNode)other).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb, "", true);
        return sb.toString();
    }

    private void dump(StringBuilder sb, String indent, boolean includeName) {
        if (this.name != null) {
            if (includeName) {
                sb.append(indent).append(DdlConfigNode.escapedPath(this.nameParts[this.nameParts.length - 1]));
            }
            if (this.value != null) {
                sb.append(" = ").append(this.getValue());
            }
        }
        if (!this.children.isEmpty()) {
            if (this.children.size() == 1 && this.value == null) {
                if (this.name != null) {
                    sb.append(".");
                }
                for (DdlConfigNode child : new TreeSet<DdlConfigNode>(this.children.values())) {
                    sb.append(DdlConfigNode.escapedPath(child.getName()));
                    child.dump(sb, indent, false);
                }
            } else {
                if (this.name != null) {
                    sb.append(" {\n");
                }
                for (DdlConfigNode child : new TreeSet<DdlConfigNode>(this.children.values())) {
                    child.dump(sb, indent + "  ", true);
                    sb.append("\n");
                }
                sb.append(indent).append("}");
            }
        }
    }
}

