/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.stats;

import com.neeve.NativeKernel;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.util.UtlTime;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public final class StatsLatencyWriter {
    private static final boolean USE_NATIVE;
    private final String _name;
    private final String _filename;
    private final boolean _printHeader;
    private final boolean _printIntervalStats;
    private final boolean _printStatsInNanos;
    private final Counters _counters;
    private RandomAccessFile _file;
    private IOBuffer _mappedFile;
    private long _lw;
    private State _state;

    public StatsLatencyWriter(String name, String filename, boolean printHeader, boolean printIntervalStats, boolean printStatsInNanos) throws Exception {
        this._name = name;
        this._filename = filename;
        this._printHeader = printHeader;
        this._printIntervalStats = printIntervalStats;
        this._printStatsInNanos = Config.getValue((String)"nv.stats.latencywriter.printinnanos", (boolean)printStatsInNanos);
        this._counters = new Counters();
        this._state = State.Init;
    }

    public StatsLatencyWriter(String name, String filename, boolean printIntervalStats) throws Exception {
        this(name, filename, true, printIntervalStats, false);
    }

    private static final int val(long arr, int idx) {
        return IOBuffer.getInt(arr, idx * 4);
    }

    private static final void swap(long arr, int a, int b) {
        int t = StatsLatencyWriter.val(arr, a);
        IOBuffer.putInt(arr, a * 4, StatsLatencyWriter.val(arr, b));
        IOBuffer.putInt(arr, b * 4, t);
    }

    private static final int percentile(long arr, int n, double rank) {
        int low = 0;
        int high = n - 1;
        int percentile_idx = (int)((double)high * (rank / 100.0));
        while (high > low) {
            if (high == low + 1) {
                if (StatsLatencyWriter.val(arr, low) > StatsLatencyWriter.val(arr, high)) {
                    StatsLatencyWriter.swap(arr, low, high);
                }
                return StatsLatencyWriter.val(arr, percentile_idx);
            }
            int middle = (low + high) / 2;
            if (StatsLatencyWriter.val(arr, middle) > StatsLatencyWriter.val(arr, high)) {
                StatsLatencyWriter.swap(arr, middle, high);
            }
            if (StatsLatencyWriter.val(arr, low) > StatsLatencyWriter.val(arr, high)) {
                StatsLatencyWriter.swap(arr, low, high);
            }
            if (StatsLatencyWriter.val(arr, middle) > StatsLatencyWriter.val(arr, low)) {
                StatsLatencyWriter.swap(arr, middle, low);
            }
            StatsLatencyWriter.swap(arr, middle, low + 1);
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (StatsLatencyWriter.val(arr, low) > StatsLatencyWriter.val(arr, ++ll)) {
                    continue;
                }
                while (StatsLatencyWriter.val(arr, --hh) > StatsLatencyWriter.val(arr, low)) {
                }
                if (hh < ll) break;
                StatsLatencyWriter.swap(arr, ll, hh);
            }
            StatsLatencyWriter.swap(arr, low, hh);
            if (hh <= percentile_idx) {
                low = ll;
            }
            if (hh < percentile_idx) continue;
            high = hh - 1;
        }
        return StatsLatencyWriter.val(arr, percentile_idx);
    }

    private final void printHeader() {
        System.out.println("");
        System.out.println("+------------------------------------------------------------------------------------------------------------------------------------------+");
        if (this._printStatsInNanos) {
            System.out.println("|          |              |                                          latency (nsec)                                                        |");
        } else {
            System.out.println("|          |              |                                          latency (usec)                                                        |");
        }
        System.out.println("+----------+--------------+--------+--------+--------+--------+----------+-----------+------------+-------------+--------+--------+--------+");
        System.out.println("|  metric  | # iterations | 50%ile | 75%ile | 90%ile | 99%ile | 99.9%ile | 99.99%ile | 99.999%ile | 99.9999%ile |   max  | avg(d) | avg(o) |");
        System.out.println("+----------+--------------+--------+--------+--------+--------+----------+-----------+------------+-------------+--------+--------+--------+");
    }

    private final void printSeparator() {
        System.out.println("+------------------------------------------------------------------------------------------------------------------------------------------+");
    }

    private final void printLatencies(long latencies, long itotal, long total, int icount, int count, int max, Stats stats) {
        int pct50 = StatsLatencyWriter.percentile(latencies, icount, 50.0);
        int pct75 = StatsLatencyWriter.percentile(latencies, icount, 75.0);
        int pct90 = StatsLatencyWriter.percentile(latencies, icount, 90.0);
        int pct99 = StatsLatencyWriter.percentile(latencies, icount, 99.0);
        int pct999 = StatsLatencyWriter.percentile(latencies, icount, 99.9);
        int pct9999 = StatsLatencyWriter.percentile(latencies, icount, 99.99);
        int pct99999 = StatsLatencyWriter.percentile(latencies, icount, 99.999);
        int pct999999 = StatsLatencyWriter.percentile(latencies, icount, 99.9999);
        double avgd = (double)itotal / (double)icount;
        double avgo = (double)total / (double)count;
        if (this._printStatsInNanos) {
            System.out.format(" %10s %14d %8d %8d %8d %8d %10d %11d %12d %13d %8d %8.2f %8.2f\n", this._name, icount, pct50, pct75, pct90, pct99, pct999, pct9999, pct99999, pct999999, max, avgd, avgo);
        } else {
            System.out.format(" %10s %14d %8.2f %8.2f %8.2f %8.2f %10.2f %11.2f %12.2f %13.2f %8.2f %8.2f %8.2f\n", this._name, icount, (double)pct50 / 1000.0, (double)pct75 / 1000.0, (double)pct90 / 1000.0, (double)pct99 / 1000.0, (double)pct999 / 1000.0, (double)pct9999 / 1000.0, (double)pct99999 / 1000.0, (double)pct999999 / 1000.0, (double)max / 1000.0, avgd / 1000.0, avgo / 1000.0);
        }
        if (stats != null) {
            stats.set(pct50, pct75, pct90, pct99, pct999, pct9999, pct99999, pct999999, max, avgd, avgo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printLatenciesFromFile(int warmupCount, Stats stats) {
        int count = this._counters.count - warmupCount;
        long latencies = IOBuffer.allocateMemoryBlock(count * 4, true);
        try {
            try (FileInputStream fis = new FileInputStream(this._filename);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                DataInputStream dis = new DataInputStream(bis);
                int max = 0;
                long total = 0L;
                int j = 0;
                for (int i = 0; i < this._counters.count; ++i) {
                    int latency = dis.readInt();
                    if (i < warmupCount) continue;
                    IOBuffer.putInt(latencies, j++ * 4, latency);
                    total += (long)latency;
                    if (latency <= max) continue;
                    max = latency;
                }
                this.printLatencies(latencies, total, total, count, count, max, stats);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        finally {
            IOBuffer.freeMemoryBlock(latencies, this._counters.count * 4);
        }
    }

    public static final boolean isNativeEnabled() {
        return USE_NATIVE;
    }

    public static final native long createNative(String var0, String var1, boolean var2, boolean var3, boolean var4) throws Exception;

    public static final native void startNative(long var0);

    public static final native void processNative(long var0, long var2, long var4, long var6, int var8, int var9, int var10) throws Exception;

    public static final native void closeNative(long var0, int var2, boolean var3);

    public static final native void destroyNative(long var0);

    private final void process() throws Exception {
        long latencies = this._counters.latencies;
        long itotal = this._counters.itotal;
        long total = this._counters.total;
        int icount = this._counters.icount;
        int count = this._counters.count;
        int max = this._counters.max;
        if (USE_NATIVE) {
            StatsLatencyWriter.processNative(this._lw, latencies, itotal, total, icount, count, max);
        } else {
            if (this._printIntervalStats) {
                this.printLatencies(latencies, itotal, total, icount, count, max, null);
            }
            if (this._mappedFile != null) {
                for (int i = 0; i < icount; ++i) {
                    IOBuffer.putInt(latencies, i * 4, Integer.reverseBytes(IOBuffer.getInt(latencies, i * 4)));
                }
                IOBuffer.copy(latencies, 0, this._mappedFile.getNativeAddress(), (count - icount) * 4, icount * 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void close(boolean finish, Stats stats, int warmupCount) throws Exception {
        if (this._state == State.Closed) {
            return;
        }
        try {
            this.stop();
            if (USE_NATIVE) {
                StatsLatencyWriter.closeNative(this._lw, this._counters.count, finish);
                StatsLatencyWriter.destroyNative(this._lw);
            } else {
                if (this._filename != null) {
                    this._mappedFile.dispose();
                    this._file.close();
                    if (this._printHeader) {
                        if (!this._printIntervalStats) {
                            this.printHeader();
                        } else {
                            this.printSeparator();
                        }
                    }
                    this.printLatenciesFromFile(warmupCount, stats);
                }
                if (finish && this._printHeader && (this._filename != null || this._printIntervalStats)) {
                    this.printSeparator();
                    System.out.println("");
                }
                this._counters.done();
            }
        }
        finally {
            this._state = State.Closed;
        }
    }

    public final void start(int rate, int count) throws Exception {
        if (this._state != State.Init) {
            throw new IllegalStateException("illegal state '" + (Object)((Object)this._state) + "'");
        }
        if (rate <= 0) {
            throw new IllegalArgumentException("rate must be > 0");
        }
        this._counters.init(rate, count);
        if (USE_NATIVE) {
            this._lw = StatsLatencyWriter.createNative(this._name, this._filename, this._printHeader, this._printIntervalStats, this._printStatsInNanos);
            StatsLatencyWriter.startNative(this._lw);
        } else {
            if (this._filename != null) {
                this._file = new RandomAccessFile(this._filename, "rw");
                this._file.setLength(0L);
                this._file.setLength(count * 4);
                this._mappedFile = IOBuffer.wrap(this._file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this._file.length()));
            }
            if (this._printHeader && this._printIntervalStats) {
                this.printHeader();
            }
        }
        this._state = State.Started;
    }

    public final boolean write(int val) throws Exception {
        if (this._state != State.Started) {
            throw new IllegalStateException("illegal state '" + (Object)((Object)this._state) + "'");
        }
        long now = UtlTime.now();
        boolean processed = this._counters.write(val, now);
        if (processed) {
            this.process();
            this._counters.reset();
        }
        return processed;
    }

    public final void stop() throws Exception {
        if (this._state == State.Stopped) {
            return;
        }
        if (this._state != State.Started) {
            throw new IllegalStateException("illegal state '" + (Object)((Object)this._state) + "'");
        }
        if (this._counters.icount > 0) {
            this.process();
        }
        this._state = State.Stopped;
    }

    public final void close(boolean finish) throws Exception {
        this.close(finish, null, 0);
    }

    public final void close(int warmupCount, Stats stats) throws Exception {
        this.close(true, stats, warmupCount);
    }

    public final void close() throws Exception {
        this.close(true);
    }

    public final void finish() {
        this.printSeparator();
    }

    static {
        boolean nativeKernelLoaded = false;
        try {
            NativeKernel.initialize();
            nativeKernelLoaded = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        USE_NATIVE = nativeKernelLoaded && Config.getValue((String)"nv.stats.latencywriter.usenative", (boolean)true);
    }

    public static final class Stats {
        public int pct50;
        public int pct75;
        public int pct90;
        public int pct99;
        public int pct999;
        public int pct9999;
        public int pct99999;
        public int pct999999;
        public int max;
        public double avgd;
        public double avgo;

        final void set(int pct50, int pct75, int pct90, int pct99, int pct999, int pct9999, int pct99999, int pct999999, int max, double avgd, double avgo) {
            this.pct50 = pct50;
            this.pct75 = pct75;
            this.pct90 = pct90;
            this.pct99 = pct99;
            this.pct999 = pct999;
            this.pct9999 = pct9999;
            this.pct99999 = pct99999;
            this.pct999999 = pct999999;
            this.max = max;
            this.avgd = avgd;
            this.avgo = avgo;
        }
    }

    private final class Counters {
        long start;
        long dstart;
        int trate;
        int tcount;
        int count;
        int icount;
        long total;
        long itotal;
        int max;
        long latencies;

        private Counters() {
        }

        final void init(int tr, int tc) {
            this.dstart = this.start = UtlTime.now();
            this.trate = tr;
            this.tcount = tc;
            this.count = 0;
            this.icount = 0;
            this.total = 0L;
            this.itotal = 0L;
            this.max = 0;
            this.latencies = IOBuffer.allocateMemoryBlock(this.trate * 4, true);
        }

        final boolean write(int val, long now) {
            IOBuffer.putInt(this.latencies, this.icount * 4, val);
            ++this.icount;
            ++this.count;
            this.itotal += (long)val;
            this.total += (long)val;
            if (val > this.max) {
                this.max = val;
            }
            return this.icount == this.trate || now - this.dstart >= 1000000000L;
        }

        final void reset() {
            this.icount = 0;
            this.itotal = 0L;
            this.max = 0;
            this.dstart = UtlTime.now();
        }

        final void done() {
            if (this.latencies != 0L) {
                IOBuffer.freeMemoryBlock(this.latencies, this.trate * 4);
                this.latencies = 0L;
            }
        }
    }

    private static enum State {
        Init,
        Started,
        Stopped,
        Closed;

    }
}

