/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XShortCollection;
import com.neeve.lang.XShortIterator;
import com.neeve.lang.XShortIteratorImpl;
import com.neeve.lang.XShortList;
import com.neeve.lang.XShortListIterator;
import com.neeve.lang.XShortSet;
import java.util.List;

public abstract class XShortCollectionBase
implements XShortCollection {
    private XShortIteratorImpl reusableIterator;

    protected XShortCollectionBase() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract XCollection.Record head();

    @Override
    public abstract XCollection.Record tail();

    @Override
    public abstract short valueOf(XCollection.Record var1);

    @Override
    public abstract void delete(XCollection.Record var1);

    @Override
    public XShortCollection unmodifiable() {
        return new Unmodifiable();
    }

    @Override
    public XShortCollection shared() {
        return new Shared();
    }

    @Override
    public XShortIterator iterator() {
        return XShortIteratorImpl.valueOf(this);
    }

    @Override
    public XShortIterator reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = XShortIteratorImpl.valueOf(this);
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean supportsIteratorModifications() {
        return true;
    }

    @Override
    public boolean add(short value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(short value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        XCollection.Record head = this.head();
        for (XCollection.Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(short value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(XShortCollection c) {
        boolean modified = false;
        XShortIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(XShortCollection c) {
        XShortIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(XShortCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(XShortCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public short[] toArray() {
        return this.toArray(new short[this.size()]);
    }

    @Override
    public short[] toArray(short[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new short[size];
        }
        if (array.length > size) {
            array[size] = -1;
        }
        int i = 0;
        short[] arrayView = array;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        XShortIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            short e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof XShortList) {
            return obj instanceof XShortList ? this.equalsOrder((XShortList)obj) : false;
        }
        if (obj instanceof XShortList) {
            return false;
        }
        if (!(obj instanceof XShortCollection)) {
            return false;
        }
        XShortCollection that = (XShortCollection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(XShortList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        XShortIterator thatIterator = that.iterator();
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            short o2;
            short o1 = this.valueOf(r);
            if (o1 == (o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += XShortCollectionBase.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + XShortCollectionBase.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    static int hashCodeFor(short value) {
        return value;
    }

    private class Shared
    implements XShortCollection {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XShortCollectionBase.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XShortCollectionBase.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(short o) {
            return XShortCollectionBase.this.contains(o);
        }

        @Override
        public synchronized short[] toArray() {
            return XShortCollectionBase.this.toArray();
        }

        @Override
        public synchronized short[] toArray(short[] a) {
            return XShortCollectionBase.this.toArray(a);
        }

        @Override
        public synchronized XShortIterator iterator() {
            return new CollectionArrayIterator(XShortCollectionBase.this.toArray());
        }

        @Override
        public XShortIterator reusableIterator() {
            throw new UnsupportedOperationException("Reusable iterator not supported for this shared collection");
        }

        @Override
        public synchronized boolean supportsIteratorModifications() {
            return XShortCollectionBase.this.supportsIteratorModifications();
        }

        @Override
        public synchronized boolean add(short e) {
            return XShortCollectionBase.this.add(e);
        }

        @Override
        public synchronized boolean remove(short o) {
            return XShortCollectionBase.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(XShortCollection c) {
            return XShortCollectionBase.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(XShortCollection c) {
            return XShortCollectionBase.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(XShortCollection c) {
            return XShortCollectionBase.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(XShortCollection c) {
            return XShortCollectionBase.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XShortCollectionBase.this.clear();
        }

        public synchronized String toString() {
            return XShortCollectionBase.this.toString();
        }

        @Override
        public synchronized XCollection.Record head() {
            return XShortCollectionBase.this.head();
        }

        @Override
        public synchronized XCollection.Record tail() {
            return XShortCollectionBase.this.tail();
        }

        @Override
        public short valueOf(XCollection.Record record) {
            return XShortCollectionBase.this.valueOf(record);
        }

        @Override
        public synchronized void delete(XCollection.Record record) {
            XShortCollectionBase.this.delete(record);
        }

        @Override
        public XShortCollection unmodifiable() {
            return XShortCollectionBase.this.unmodifiable();
        }

        @Override
        public XShortCollection shared() {
            return this;
        }

        private class CollectionArrayIterator
        implements XShortIterator {
            private short[] _elements;
            private int _index;
            private short _next;
            private boolean removed;

            public CollectionArrayIterator(short[] elements) {
                this._elements = elements;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public short next() {
                this.removed = false;
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("No element to remove");
                }
                Shared.this.remove(this._next);
                this.removed = true;
            }

            @Override
            public CollectionArrayIterator toFirst() {
                this._index = 0;
                this._next = 0;
                this._elements = Shared.this.toArray();
                this.removed = true;
                return this;
            }
        }
    }

    class Unmodifiable
    extends XShortCollectionBase
    implements XShortSet,
    XShortList {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XShortCollectionBase.this.size();
        }

        @Override
        public XCollection.Record head() {
            return XShortCollectionBase.this.head();
        }

        @Override
        public XCollection.Record tail() {
            return XShortCollectionBase.this.tail();
        }

        @Override
        public short valueOf(XCollection.Record record) {
            return XShortCollectionBase.this.valueOf(record);
        }

        @Override
        public boolean contains(short value) {
            return XShortCollectionBase.this.contains(value);
        }

        @Override
        public boolean containsAll(XShortCollection c) {
            return XShortCollectionBase.this.containsAll(c);
        }

        @Override
        public boolean add(short obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(XCollection.Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, XShortCollection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public short get(int index) {
            return ((XShortList)((Object)XShortCollectionBase.this)).get(index);
        }

        @Override
        public short set(int index, short element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, short element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(short index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public short remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(short o) {
            return ((XShortList)((Object)XShortCollectionBase.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(short o) {
            return ((XShortList)((Object)XShortCollectionBase.this)).lastIndexOf(o);
        }

        @Override
        public XShortListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XShortListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XShortList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }
}

