/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCharCollection;
import com.neeve.lang.XCharIterator;
import com.neeve.lang.XCharIteratorImpl;
import com.neeve.lang.XCharList;
import com.neeve.lang.XCharListIterator;
import com.neeve.lang.XCharSet;
import com.neeve.lang.XCollection;
import java.util.List;

public abstract class XCharCollectionBase
implements XCharCollection {
    private XCharIteratorImpl reusableIterator;

    protected XCharCollectionBase() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract XCollection.Record head();

    @Override
    public abstract XCollection.Record tail();

    @Override
    public abstract char valueOf(XCollection.Record var1);

    @Override
    public abstract void delete(XCollection.Record var1);

    @Override
    public XCharCollection unmodifiable() {
        return new Unmodifiable();
    }

    @Override
    public XCharCollection shared() {
        return new Shared();
    }

    @Override
    public XCharIterator iterator() {
        return XCharIteratorImpl.valueOf(this);
    }

    @Override
    public XCharIterator reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = XCharIteratorImpl.valueOf(this);
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean supportsIteratorModifications() {
        return true;
    }

    @Override
    public boolean add(char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(char value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        XCollection.Record head = this.head();
        for (XCollection.Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(char value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(XCharCollection c) {
        boolean modified = false;
        XCharIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(XCharCollection c) {
        XCharIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(XCharCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(XCharCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public char[] toArray() {
        return this.toArray(new char[this.size()]);
    }

    @Override
    public char[] toArray(char[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new char[size];
        }
        if (array.length > size) {
            array[size] = '\u0000';
        }
        int i = 0;
        char[] arrayView = array;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        XCharIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            char e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof XCharList) {
            return obj instanceof XCharList ? this.equalsOrder((XCharList)obj) : false;
        }
        if (obj instanceof XCharList) {
            return false;
        }
        if (!(obj instanceof XCharCollection)) {
            return false;
        }
        XCharCollection that = (XCharCollection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(XCharList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        XCharIterator thatIterator = that.iterator();
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            char o2;
            char o1 = this.valueOf(r);
            if (o1 == (o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += XCharCollectionBase.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + XCharCollectionBase.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    static int hashCodeFor(char value) {
        return value;
    }

    private class Shared
    implements XCharCollection {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XCharCollectionBase.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XCharCollectionBase.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(char o) {
            return XCharCollectionBase.this.contains(o);
        }

        @Override
        public synchronized char[] toArray() {
            return XCharCollectionBase.this.toArray();
        }

        @Override
        public synchronized char[] toArray(char[] a) {
            return XCharCollectionBase.this.toArray(a);
        }

        @Override
        public synchronized XCharIterator iterator() {
            return new CollectionArrayIterator(XCharCollectionBase.this.toArray());
        }

        @Override
        public XCharIterator reusableIterator() {
            throw new UnsupportedOperationException("Reusable iterator not supported for this shared collection");
        }

        @Override
        public synchronized boolean supportsIteratorModifications() {
            return XCharCollectionBase.this.supportsIteratorModifications();
        }

        @Override
        public synchronized boolean add(char e) {
            return XCharCollectionBase.this.add(e);
        }

        @Override
        public synchronized boolean remove(char o) {
            return XCharCollectionBase.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(XCharCollection c) {
            return XCharCollectionBase.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(XCharCollection c) {
            return XCharCollectionBase.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(XCharCollection c) {
            return XCharCollectionBase.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(XCharCollection c) {
            return XCharCollectionBase.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XCharCollectionBase.this.clear();
        }

        public synchronized String toString() {
            return XCharCollectionBase.this.toString();
        }

        @Override
        public synchronized XCollection.Record head() {
            return XCharCollectionBase.this.head();
        }

        @Override
        public synchronized XCollection.Record tail() {
            return XCharCollectionBase.this.tail();
        }

        @Override
        public char valueOf(XCollection.Record record) {
            return XCharCollectionBase.this.valueOf(record);
        }

        @Override
        public synchronized void delete(XCollection.Record record) {
            XCharCollectionBase.this.delete(record);
        }

        @Override
        public XCharCollection unmodifiable() {
            return XCharCollectionBase.this.unmodifiable();
        }

        @Override
        public XCharCollection shared() {
            return this;
        }

        private class CollectionArrayIterator
        implements XCharIterator {
            private char[] _elements;
            private int _index;
            private char _next;
            private boolean removed;

            public CollectionArrayIterator(char[] elements) {
                this._elements = elements;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public char next() {
                this.removed = false;
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("No element to remove");
                }
                Shared.this.remove(this._next);
                this.removed = true;
            }

            @Override
            public CollectionArrayIterator toFirst() {
                this._index = 0;
                this._next = '\u0000';
                this._elements = Shared.this.toArray();
                this.removed = true;
                return this;
            }
        }
    }

    class Unmodifiable
    extends XCharCollectionBase
    implements XCharSet,
    XCharList {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XCharCollectionBase.this.size();
        }

        @Override
        public XCollection.Record head() {
            return XCharCollectionBase.this.head();
        }

        @Override
        public XCollection.Record tail() {
            return XCharCollectionBase.this.tail();
        }

        @Override
        public char valueOf(XCollection.Record record) {
            return XCharCollectionBase.this.valueOf(record);
        }

        @Override
        public boolean contains(char value) {
            return XCharCollectionBase.this.contains(value);
        }

        @Override
        public boolean containsAll(XCharCollection c) {
            return XCharCollectionBase.this.containsAll(c);
        }

        @Override
        public boolean add(char obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(XCollection.Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, XCharCollection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public char get(int index) {
            return ((XCharList)((Object)XCharCollectionBase.this)).get(index);
        }

        @Override
        public char set(int index, char element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, char element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(char index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public char remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(char o) {
            return ((XCharList)((Object)XCharCollectionBase.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(char o) {
            return ((XCharList)((Object)XCharCollectionBase.this)).lastIndexOf(o);
        }

        @Override
        public XCharListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XCharListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XCharList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }
}

