#!/bin/bash

print_usage() {
    echo "usage: $0 [--help] [--addr <addr>] [--host <host>] " >&2
    exit 1
}

# Parse input parameters
HOSTNAME=""
ADDR=""
while [[ "$1" == -* ]]; do
    case "$1" in
    --help|-h)
        print_usage
    ;;
    --addr)
        shift
        ADDR=$1
        shift
    ;;
    --host)
        shift
        HOSTNAME=$1
        shift
    ;;
    *)
        echo "error: unknown option: $1" >&2
        exit 1
    ;;
    esac
done

if [[ -z "$HOSTNAME" ]]; then
   print_usage
fi
if [[ -z "$ADDR" ]]; then
   print_usage
fi

echo "$HOSTNAME.rumi.local. IN A $ADDR" | sudo tee -a /etc/named/zones/db.rumi.local > /dev/null
sudo systemctl restart named
