#!/bin/bash

# Usage function
print_usage() {
    echo "Usage: $0 --file <file_path>"
    exit 1
}

# Parse input arguments
FILE=""

while [[ "$1" == -* ]]; do
    case "$1" in
    --file)
        shift
        FILE=$1
        shift
    ;;
    *)
        echo "Error: Unknown option: $1" >&2
        exit 1
    ;;
    esac
done

# Validate input parameters
if [[ -z "$FILE" ]]; then
    print_usage
fi

# Ensure the file exists before uploading
if [[ ! -f "$FILE" ]]; then
    echo "Error: File '$FILE' does not exist."
    exit 1
fi

# Upload the file using curl to localhost
echo "Uploading '$FILE' to Rumi Agent..."
curl -X POST -F "xar=@$FILE" http://localhost:7778/rumi-agent/xars

# Check if the upload was successful
if [[ $? -eq 0 ]]; then
    echo "File successfully uploaded!"
else
    echo "Error: Upload failed."
    exit 1
fi
