/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.stats;

import com.neeve.trace.Tracer;

public final class StatsLogger {
    private final String name;
    private final String prefix;
    private final Tracer tracer;
    private final Callback cb;
    private Thread thread;
    private int interval;

    public StatsLogger(String name, String logger, Callback cb) {
        this.name = name;
        this.prefix = "[ <" + name + "> STATS]\n";
        this.tracer = Tracer.get(logger);
        this.cb = cb;
    }

    public final Tracer tracer() {
        return this.tracer;
    }

    public final void startPeriodicOutput(int interval) {
        if (this.thread == null) {
            this.interval = interval;
            this.thread = new StatisticsLoggerThread();
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public final void stopPeriodicOutput() {
        Thread thread = this.thread;
        if (thread != null) {
            this.interval = 0;
            thread.interrupt();
            if (Thread.currentThread() != thread) {
                while (true) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public static interface Callback {
        public void init();

        public void get(StringBuilder var1);

        public void before();

        public void after();
    }

    private final class StatisticsLoggerThread
    extends Thread {
        private final StringBuilder sb = new StringBuilder();

        StatisticsLoggerThread() {
            this.setName("X-Stats-Logger [" + StatsLogger.this.name + "]");
        }

        @Override
        public final void run() {
            StatsLogger.this.cb.init();
            while (StatsLogger.this.interval > 0) {
                try {
                    Thread.sleep(StatsLogger.this.interval * 1000);
                    this.sb.append(StatsLogger.this.prefix);
                    StatsLogger.this.cb.get(this.sb);
                    StatsLogger.this.cb.before();
                    StatsLogger.this.tracer.log(this.sb.toString(), Tracer.Level.INFO);
                    StatsLogger.this.cb.after();
                }
                catch (InterruptedException e) {
                    StatsLogger.this.interval = 0;
                }
                finally {
                    this.sb.setLength(0);
                }
            }
            StatsLogger.this.thread = null;
        }
    }
}

