/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config.impl;

import com.neeve.config.EConfigException;
import com.neeve.config.IConfigContentNode;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.config.impl.ConfigEntityBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import java.util.Map;
import java.util.Properties;

public class ConfigSimpleEntityBase
extends ConfigEntityBase
implements IConfigSimpleEntity {
    protected final Properties props = new Properties();

    public ConfigSimpleEntityBase(IConfigRepository repository, String name, IConfigSimpleEntityContainer container) {
        super(repository, name, container);
    }

    @Override
    public final IConfigSimpleEntity setProperties(Properties props) {
        if (props == null) {
            this.props.clear();
        } else {
            this.props.putAll((Map<?, ?>)props);
        }
        this.setDirty(true);
        return this;
    }

    @Override
    public final Properties getProperties() {
        return this.props;
    }

    @Override
    public final IConfigSimpleEntity setProperty(String propname, String propval) {
        if (propname == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        if (propval == null) {
            this.props.remove(propname);
        } else {
            this.props.setProperty(propname, propval);
        }
        this.setDirty(true);
        return this;
    }

    @Override
    public final String getProperty(String propname, String defval) {
        if (propname == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        return this.props.getProperty(propname, defval);
    }

    @Override
    public final IConfigContentNode clear() {
        this.props.clear();
        this.setDirty(true);
        return this;
    }

    @Override
    public final void serialize(StringBuilder builder) {
        UtlProps.serialize(this.props, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deserialize(String str, boolean markAsDirty) throws EConfigException {
        if (this.tracer.debug) {
            this.tracer.log("Deserializing simple entity '" + this.getName() + "' from '" + str + "'...", Tracer.Level.DEBUG);
        }
        boolean dirty = this.isDirty();
        try {
            this.setProperties(UtlProps.deserialize(str));
            if (this.tracer.debug) {
                this.tracer.log("Deserialized properties " + this.getProperties() + ".", Tracer.Level.DEBUG);
            }
            this.setDirty(dirty || markAsDirty);
        }
        catch (Throwable throwable) {
            this.setDirty(dirty || markAsDirty);
            throw throwable;
        }
    }

    @Override
    public final String toString() {
        return "[SimpleEntity] <" + super.toString() + ">";
    }
}

