/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XFloatCollection;
import com.neeve.lang.XFloatIterator;
import com.neeve.lang.XFloatIteratorImpl;
import com.neeve.lang.XFloatList;
import com.neeve.lang.XFloatListIterator;
import com.neeve.lang.XFloatSet;
import java.util.List;

public abstract class XFloatCollectionBase
implements XFloatCollection {
    private XFloatIteratorImpl reusableIterator;

    protected XFloatCollectionBase() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract XCollection.Record head();

    @Override
    public abstract XCollection.Record tail();

    @Override
    public abstract float valueOf(XCollection.Record var1);

    @Override
    public abstract void delete(XCollection.Record var1);

    @Override
    public XFloatCollection unmodifiable() {
        return new Unmodifiable();
    }

    @Override
    public XFloatCollection shared() {
        return new Shared();
    }

    @Override
    public XFloatIterator iterator() {
        return XFloatIteratorImpl.valueOf(this);
    }

    @Override
    public XFloatIterator reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = XFloatIteratorImpl.valueOf(this);
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean supportsIteratorModifications() {
        return true;
    }

    @Override
    public boolean add(float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(float value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        XCollection.Record head = this.head();
        for (XCollection.Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(float value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(XFloatCollection c) {
        boolean modified = false;
        XFloatIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(XFloatCollection c) {
        XFloatIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(XFloatCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(XFloatCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public float[] toArray() {
        return this.toArray(new float[this.size()]);
    }

    @Override
    public float[] toArray(float[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new float[size];
        }
        if (array.length > size) {
            array[size] = -1.0f;
        }
        int i = 0;
        float[] arrayView = array;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        XFloatIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            float e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof XFloatList) {
            return obj instanceof XFloatList ? this.equalsOrder((XFloatList)obj) : false;
        }
        if (obj instanceof XFloatList) {
            return false;
        }
        if (!(obj instanceof XFloatCollection)) {
            return false;
        }
        XFloatCollection that = (XFloatCollection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(XFloatList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        XFloatIterator thatIterator = that.iterator();
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            float o2;
            float o1 = this.valueOf(r);
            if (o1 == (o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += XFloatCollectionBase.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + XFloatCollectionBase.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    static int hashCodeFor(float value) {
        return Float.floatToIntBits(value);
    }

    private class Shared
    implements XFloatCollection {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XFloatCollectionBase.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XFloatCollectionBase.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(float o) {
            return XFloatCollectionBase.this.contains(o);
        }

        @Override
        public synchronized float[] toArray() {
            return XFloatCollectionBase.this.toArray();
        }

        @Override
        public synchronized float[] toArray(float[] a) {
            return XFloatCollectionBase.this.toArray(a);
        }

        @Override
        public synchronized XFloatIterator iterator() {
            return new CollectionArrayIterator(XFloatCollectionBase.this.toArray());
        }

        @Override
        public XFloatIterator reusableIterator() {
            throw new UnsupportedOperationException("Reusable iterator not supported for this shared collection");
        }

        @Override
        public synchronized boolean supportsIteratorModifications() {
            return XFloatCollectionBase.this.supportsIteratorModifications();
        }

        @Override
        public synchronized boolean add(float e) {
            return XFloatCollectionBase.this.add(e);
        }

        @Override
        public synchronized boolean remove(float o) {
            return XFloatCollectionBase.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(XFloatCollection c) {
            return XFloatCollectionBase.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(XFloatCollection c) {
            return XFloatCollectionBase.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(XFloatCollection c) {
            return XFloatCollectionBase.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(XFloatCollection c) {
            return XFloatCollectionBase.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XFloatCollectionBase.this.clear();
        }

        public synchronized String toString() {
            return XFloatCollectionBase.this.toString();
        }

        @Override
        public synchronized XCollection.Record head() {
            return XFloatCollectionBase.this.head();
        }

        @Override
        public synchronized XCollection.Record tail() {
            return XFloatCollectionBase.this.tail();
        }

        @Override
        public float valueOf(XCollection.Record record) {
            return XFloatCollectionBase.this.valueOf(record);
        }

        @Override
        public synchronized void delete(XCollection.Record record) {
            XFloatCollectionBase.this.delete(record);
        }

        @Override
        public XFloatCollection unmodifiable() {
            return XFloatCollectionBase.this.unmodifiable();
        }

        @Override
        public XFloatCollection shared() {
            return this;
        }

        private class CollectionArrayIterator
        implements XFloatIterator {
            private float[] _elements;
            private int _index;
            private float _next;
            private boolean removed;

            public CollectionArrayIterator(float[] elements) {
                this._elements = elements;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public float next() {
                this.removed = false;
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("No element to remove");
                }
                Shared.this.remove(this._next);
                this.removed = true;
            }

            @Override
            public CollectionArrayIterator toFirst() {
                this._index = 0;
                this._next = 0.0f;
                this._elements = Shared.this.toArray();
                this.removed = true;
                return this;
            }
        }
    }

    class Unmodifiable
    extends XFloatCollectionBase
    implements XFloatSet,
    XFloatList {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XFloatCollectionBase.this.size();
        }

        @Override
        public XCollection.Record head() {
            return XFloatCollectionBase.this.head();
        }

        @Override
        public XCollection.Record tail() {
            return XFloatCollectionBase.this.tail();
        }

        @Override
        public float valueOf(XCollection.Record record) {
            return XFloatCollectionBase.this.valueOf(record);
        }

        @Override
        public boolean contains(float value) {
            return XFloatCollectionBase.this.contains(value);
        }

        @Override
        public boolean containsAll(XFloatCollection c) {
            return XFloatCollectionBase.this.containsAll(c);
        }

        @Override
        public boolean add(float obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(XCollection.Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, XFloatCollection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public float get(int index) {
            return ((XFloatList)((Object)XFloatCollectionBase.this)).get(index);
        }

        @Override
        public float set(int index, float element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, float element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(float index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public float remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(float o) {
            return ((XFloatList)((Object)XFloatCollectionBase.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(float o) {
            return ((XFloatList)((Object)XFloatCollectionBase.this)).lastIndexOf(o);
        }

        @Override
        public XFloatListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XFloatListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XFloatList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }
}

