/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoDoubleArrayField
extends StoVariableLengthField<double[]> {
    private StoDoubleArrayField(String name) {
        super(StoField.Type.DOUBLE_ARRAY, name);
    }

    private StoDoubleArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoDoubleArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(double[] val) {
        return StoDoubleArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, double[] val) {
        StoDoubleArrayField.put(buffer, offset, val);
    }

    @Override
    protected final double[] deserialize(ByteBuffer buffer, int offset) {
        return StoDoubleArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(double[] val1, double[] val2) {
        return Arrays.equals(val1, val2);
    }

    @Override
    protected final double[] clone(double[] val) {
        return Arrays.copyOf(val, val.length);
    }

    @Override
    protected final String toString(double[] val) {
        return Arrays.toString(val);
    }

    public static StoDoubleArrayField create(String name) {
        return new StoDoubleArrayField(name);
    }

    public static StoDoubleArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoDoubleArrayField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        return 2 + (len < 0 ? (short)0 : len) * 8;
    }

    public static int getSerializedLength(double[] val) {
        return 2 + (val != null ? val.length * 8 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ByteBuffer buffer, int offset, double[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        if (val != null) {
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asDoubleBuffer().put(val);
            }
            finally {
                buffer.position(pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            double[] val = new double[len];
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asDoubleBuffer().get(val);
            }
            finally {
                buffer.position(pos);
            }
            return val;
        }
        if (len < 0) {
            return new double[0];
        }
        return null;
    }
}

