/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkObject;
import com.neeve.link.LnkSynchronizer;

public final class LnkSynchronousConnector
extends LnkObject {
    public LnkSynchronousConnector() {
        super(null);
    }

    public static LnkSynchronousConnector create() {
        return new LnkSynchronousConnector();
    }

    public final ILnkPeerEndpoint run(ILnkClientEndpoint cep, int timeout) throws ELnkInvalidStateException, ELnkOpFailedException {
        if (cep == null) {
            throw new IllegalArgumentException("client endpoint cannot be null");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be positive");
        }
        LnkEvents.ConnectAcceptCompleteEventData completionData = (LnkEvents.ConnectAcceptCompleteEventData)new LnkSynchronizer().run(new Operation(cep, timeout), -1, this.tracer);
        if (completionData.status) {
            return completionData.pep;
        }
        throw completionData.e;
    }

    private static final class Operation
    extends LnkSynchronizer.Operation {
        final ILnkClientEndpoint cep;
        final int timeout;

        Operation(ILnkClientEndpoint cep, int timeout) {
            this.cep = cep;
            this.timeout = timeout;
        }

        @Override
        final void execute(IEmxDispatcher dispatcher, ILnkEventHandler handler) throws ELnkOpFailedException {
            this.cep.connectPost(dispatcher, handler, this.timeout, 1);
        }
    }
}

