/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ddl;

import com.neeve.util.UtlStr;
import com.neeve.util.UtlTailoring;

final class XmlEscapingSubstResolver
implements UtlStr.ISubstResolver {
    private static final int XML_SPECIAL_CHARACTER_SUBSTITUTIONS_SIZE = 63;
    private static final String[] XML_SPECIAL_CHARACTER_SUBSTITUTIONS = new String[63];
    private final UtlTailoring.PropertySource valueResolver;

    public XmlEscapingSubstResolver(UtlTailoring.PropertySource valueResolver) {
        this.valueResolver = valueResolver;
    }

    public final String getValue(String key, String defaultValue) {
        return XmlEscapingSubstResolver.replaceSpecialXmlChars(this.valueResolver.getValue(key, defaultValue));
    }

    private static final String replaceSpecialXmlChars(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int begin = 0;
        for (int i = 0; i < str.length(); ++i) {
            String replacement;
            char c = str.charAt(i);
            if (c >= XML_SPECIAL_CHARACTER_SUBSTITUTIONS.length || (replacement = XML_SPECIAL_CHARACTER_SUBSTITUTIONS[c]) == null) continue;
            sb.append(str, begin, i);
            sb.append(replacement);
            begin = i + 1;
        }
        sb.append(str, begin, str.length());
        return sb.toString();
    }

    static {
        XmlEscapingSubstResolver.XML_SPECIAL_CHARACTER_SUBSTITUTIONS[60] = "&lt;";
        XmlEscapingSubstResolver.XML_SPECIAL_CHARACTER_SUBSTITUTIONS[62] = "&gt;";
        XmlEscapingSubstResolver.XML_SPECIAL_CHARACTER_SUBSTITUTIONS[38] = "&amp;";
        XmlEscapingSubstResolver.XML_SPECIAL_CHARACTER_SUBSTITUTIONS[34] = "&quot;";
        XmlEscapingSubstResolver.XML_SPECIAL_CHARACTER_SUBSTITUTIONS[39] = "&apos;";
    }
}

