/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.cloud.equinix.EquinixProvisioner;
import com.neeve.tools.AbstractCommand;
import jargs.gnu.CmdLineParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class EquinixCommand
extends AbstractCommand {
    private static final Set<String> commands = Stream.of("get-networks", "create-network", "delete-network").collect(Collectors.toCollection(HashSet::new));

    EquinixCommand() {
    }

    private final void printTopLevelUsage() {
        System.out.println("");
        System.out.println("      Rumi 'cloud equinix' commands:");
        System.out.println("");
        System.out.println("         get-networks     Fetches the list of configured networks");
        System.out.println("         create-network   Create a new network");
        System.out.println("         delete-network   Delete an existing network");
        System.out.println("");
        System.out.println("      Run 'rumi help cloud equinix <command>' for help on a specific command");
        System.out.println("");
    }

    private static final AbstractCommand commandHandler(String command) {
        if (command.equals("get-networks")) {
            return new GetNetworksCommand();
        }
        if (command.equals("create-network")) {
            return new CreateNetworkCommand();
        }
        if (command.equals("delete-network")) {
            return new DeleteNetworkCommand();
        }
        throw new IllegalArgumentException("unknown command '" + command + "'");
    }

    @Override
    final void help(String[] args) {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                EquinixCommand.commandHandler(command).help(null);
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    @Override
    final void execute(String[] args) throws Exception {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                EquinixCommand.commandHandler(command).execute(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    private static final class DeleteNetworkCommand
    extends AbstractCommand {
        private DeleteNetworkCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud equinix delete-network <args>' where args are:");
            System.out.println("          [{-k, --apiKey the user API key to use] (required)");
            System.out.println("          [{-i, --id the id of the network to delete] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeleteNetworkCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "apiKey");
            CmdLineParser.Option idOption = parser.addStringOption('i', "id");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String id = (String)parser.getOptionValue(idOption, null);
            if (apiKey != null && id != null) {
                String responseJson = EquinixProvisioner.create().deleteNetwork(apiKey, id);
                System.out.println("");
                System.out.println(this.toPrettyJson(responseJson));
                System.out.println("");
            } else {
                DeleteNetworkCommand.printUsage();
            }
        }
    }

    private static final class CreateNetworkCommand
    extends AbstractCommand {
        private CreateNetworkCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud equinix create-network <args>' where args are:");
            System.out.println("          [-k, --apiKey the user API key to use] (required)");
            System.out.println("          [-p, --projectId the UUID of the project whose networks are to be returned] (required)");
            System.out.println("          [-m, --metroCode the code of the metro whose networks are to be returned] (required)");
            System.out.println("          [-d, --description a description of the created network] (optional)");
            System.out.println("          [-t, --tags a comma separated set of tags to attach to the network] (optional)");
            System.out.println("");
        }

        private final String[] csvToArray(String commaSeparatedTags) {
            return commaSeparatedTags != null ? commaSeparatedTags.split(",") : null;
        }

        @Override
        final void help(String[] args) {
            CreateNetworkCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "apiKey");
            CmdLineParser.Option projectIdOption = parser.addStringOption('p', "projectId");
            CmdLineParser.Option metroCodeOption = parser.addStringOption('m', "metroCode");
            CmdLineParser.Option descriptionOption = parser.addStringOption('d', "description");
            CmdLineParser.Option tagsOption = parser.addStringOption('t', "tags");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String projectId = (String)parser.getOptionValue(projectIdOption, null);
            String metroCode = (String)parser.getOptionValue(metroCodeOption, null);
            String description = (String)parser.getOptionValue(descriptionOption, null);
            String commaSeparatedTags = (String)parser.getOptionValue(tagsOption, null);
            if (apiKey != null && projectId != null && metroCode != null) {
                String responseJson = EquinixProvisioner.create().createNetwork(apiKey, projectId, metroCode, description, this.csvToArray(commaSeparatedTags));
                System.out.println("");
                System.out.println(this.toPrettyJson(responseJson));
                System.out.println("");
            } else {
                CreateNetworkCommand.printUsage();
            }
        }
    }

    private static final class GetNetworksCommand
    extends AbstractCommand {
        private GetNetworksCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud equinix get-networks <args>' where args are:");
            System.out.println("          [-k, --apiKey the user API key to use] (required)");
            System.out.println("          [-p, --projectId the UUID of the project whose networks are to be returned] (required)");
            System.out.println("          [-m, --metroCode the code of the metro whose networks are to be returned] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            GetNetworksCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "apiKey");
            CmdLineParser.Option projectIdOption = parser.addStringOption('p', "projectId");
            CmdLineParser.Option metroCodeOption = parser.addStringOption('m', "metroCode");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String projectId = (String)parser.getOptionValue(projectIdOption, null);
            String metroCode = (String)parser.getOptionValue(metroCodeOption, null);
            if (apiKey != null && projectId != null && metroCode != null) {
                String responseJson = EquinixProvisioner.create().getNetworks(apiKey, projectId, metroCode);
                System.out.println("");
                System.out.println(this.toPrettyJson(responseJson));
                System.out.println("");
            } else {
                GetNetworksCommand.printUsage();
            }
        }
    }
}

