#!/bin/bash

# Create the Rumi user
sudo adduser rumi
# ...add it to the sudo group 
sudo usermod -aG wheel rumi
# ...update the sudo group to enable nopasswd login
sudo sed -i 's/%wheel\tALL=(ALL)\tALL/# %wheel\tALL=(ALL)\tALL/g' /etc/sudoers
sudo sed -i 's/# %wheel\tALL=(ALL)\tNOPASSWD: ALL/%wheel\tALL=(ALL)\tNOPASSWD: ALL/g' /etc/sudoers
# ...create the user's key pair and authorized keys
sudo mkdir ~rumi/.ssh
sudo ssh-keygen -t rsa -N '' -f ~rumi/.ssh/id_rsa <<< y
sudo cp /root/.ssh/authorized_keys ~rumi/.ssh
sudo chown -R rumi ~rumi/.ssh
sudo chgrp -R rumi ~rumi/.ssh
sudo chmod 700 ~rumi/.ssh

# Work around for "authenticity of host ... can't be established"
sudo echo "UserKnownHostsFile /dev/null" >> ~rumi/.ssh/config
sudo echo "StrictHostKeyChecking no" >> ~rumi/.ssh/config
sudo chmod 644 ~rumi/.ssh/config

# Create the various directories
sudo mkdir ~rumi/scripts
sudo chown -R rumi ~rumi/scripts
sudo chgrp -R rumi ~rumi/scripts

# TODO

# Disable remote login as root
sudo truncate --size=0 /root/.ssh/authorized_keys
