#!/bin/bash

print_usage() {
    echo "usage: $0 [--help] [--host <host>] [--port <target_port>] [--proxy-server <name>] [--proxy-port <listen_port>]" >&2
    exit 1
}

# Defaults
HOST=""
PORT=""
PROXY_SERVER="_"
PROXY_PORT=""

# Parse input parameters
while [[ "$1" == -* ]]; do
    case "$1" in
    --help|-h)
        print_usage
        ;;
    --host)
        shift
        HOST="$1"
        shift
        ;;
    --port)
        shift
        PORT="$1"
        shift
        ;;
    --proxy-server)
        shift
        PROXY_SERVER="$1"
        shift
        ;;
    --proxy-port)
        shift
        PROXY_PORT="$1"
        shift
        ;;
    *)
        echo "error: unknown option: $1" >&2
        print_usage
        ;;
    esac
done

if [[ -z "$HOST" ]]; then
    print_usage
fi

# If port was provided, default PROXY_PORT to it
if [[ -n "$PORT" && -z "$PROXY_PORT" ]]; then
    PROXY_PORT="$PORT"
fi

# Wait for HOST to be reachable
TIMEOUT=300
INTERVAL=5
ELAPSED=0
echo "Waiting for $HOST to become reachable..."
while ! ping -c 1 "$HOST" &> /dev/null; do
    if [ "$ELAPSED" -ge "$TIMEOUT" ]; then
        echo "Timeout reached! $HOST is still not reachable."
        exit 1
    fi

    echo "Still waiting... Retrying in $INTERVAL seconds..."
    sleep "$INTERVAL"
    ELAPSED=$((ELAPSED + INTERVAL))
done
echo "$HOST is now reachable!"

# Optionally add proxy
if [[ -n "$PORT" ]]; then
    echo "Adding proxy: host=$HOST, host-port=$PORT, proxy-port=$PROXY_PORT, server=$PROXY_SERVER"
    sudo /home/rumi/scripts/add_proxy.sh --host-name "$HOST" --host-port "$PORT" --port "$PROXY_PORT" --server "$PROXY_SERVER"
fi
