#!/bin/bash

# Create the Rumi user
sudo adduser rumi
# ...add it to the sudo group 
sudo usermod -aG wheel rumi
# ...update the sudo group to enable nopasswd login
sudo sed -i 's/%wheel\tALL=(ALL)\tALL/# %wheel\tALL=(ALL)\tALL/g' /etc/sudoers
sudo sed -i 's/# %wheel\tALL=(ALL)\tNOPASSWD: ALL/%wheel\tALL=(ALL)\tNOPASSWD: ALL/g' /etc/sudoers
# ...create the user's key pair and authorized keys
sudo mkdir ~rumi/.ssh
sudo ssh-keygen -t rsa -N '' -f ~rumi/.ssh/id_rsa <<< y
sudo cp /root/.ssh/authorized_keys ~rumi/.ssh
sudo chown -R rumi ~rumi/.ssh
sudo chgrp -R rumi ~rumi/.ssh
sudo chmod 700 ~rumi/.ssh

# Work around for "authenticity of host ... can't be established"
sudo echo "UserKnownHostsFile /dev/null" >> ~rumi/.ssh/config
sudo echo "StrictHostKeyChecking no" >> ~rumi/.ssh/config
sudo chmod 644 ~rumi/.ssh/config

# Create the various directories
sudo mkdir ~rumi/scripts
sudo chown -R rumi ~rumi/scripts
sudo chgrp -R rumi ~rumi/scripts

# Install CRON
sudo yum -y install cronie
sudo systemctl enable --now crond

# Install wget
sudo yum -y install wget

# Install Java
sudo dnf -y install java-1.8.0-openjdk-devel
sudo dnf -y install java-11-openjdk-devel
sudo dnf -y install java-17-openjdk-devel

# Set up rumi user's .bash_profile
sudo echo "export JAVA_HOME_OPENJDK_8=/usr/lib/jvm/java-1.8.0-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_OPENJDK_11=/usr/lib/jvm/java-11-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_OPENJDK_17=/usr/lib/jvm/java-17-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_8=\$JAVA_HOME_OPENJDK_8" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_11=\$JAVA_HOME_OPENJDK_11" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_17=\$JAVA_HOME_OPENJDK_17" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME=\$JAVA_HOME_8" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_11_OPTS=\"--add-opens=java.base/jdk.internal.ref=ALL-UNNAMED --add-opens=java.base/sun.nio.ch=ALL-UNNAMED --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/java.nio=ALL-UNNAMED --add-opens=java.base/java.io=ALL-UNNAMED --add-opens=java.management/sun.management=ALL-UNNAMED --illegal-access=warn\"" >> ~rumi/.setup_java.sh
sudo echo "export PATH=\$JAVA_HOME/bin:\$PATH" >> ~rumi/.setup_java.sh
sudo chown rumi ~rumi/.setup_java.sh
sudo chgrp rumi ~rumi/.setup_java.sh
sudo chmod +x ~rumi/.setup_java.sh
sudo echo ". ./.setup_java.sh" >> ~rumi/.bash_profile

# Install ActiveMQ  
sudo mkdir ~rumi/activemq
cd ~rumi/activemq
sudo wget https://dlcdn.apache.org//activemq/5.19.0/apache-activemq-5.19.0-bin.tar.gz
sudo tar -xv --no-same-owner -f apache-activemq-5.19.0-bin.tar.gz
cd apache-activemq-5.19.0/conf
sudo cp activemq.xml activemq.xml.orig
sudo sed -i "s/brokerName=\"localhost\"/brokerName=\"rumi-discovery\"/g" activemq.xml
sudo cp jetty.xml jetty.xml.orig
sudo sed -i "s/value=\"127.0.0.1\"/value=\"0.0.0.0\"/g" jetty.xml
cd ~
sudo chown -R rumi ~rumi/activemq
sudo chgrp -R rumi ~rumi/activemq

# Install and configure Rumi Agent
cd ~rumi
sudo wget http://nexus.rumidata.io:8081/repository/maven-public/com/neeve/nvx-rumi-agent/2.0.24/nvx-rumi-agent-2.0.24-bundled-linux-x86-64.tar.gz
sudo tar -xv --no-same-owner -f nvx-rumi-agent-2.0.24-bundled-linux-x86-64.tar.gz 
cd nvx-rumi-agent
sudo ln -s releases/v2.0.24-0024 current
sudo ./current/setenv.sh
cd ~rumi
sudo sed -i "s/mcast:\/\/224\.0\.1\.200:4090&localIfAddr=0\.0\.0\.0/activemq:\/\/localhost:61616?wireFormat\.maxInactivityDuration=0/g" nvx-rumi-agent/data/agent/agent.conf
sudo sed -i "s/rumi\.agent\.env=dev/rumi\.agent\.env=cloud/g" nvx-rumi-agent/data/controller/controller.conf
sudo sed -i "s/nv\.controller\.sshuser=root/nv\.controller\.sshuser=rumi/g" nvx-rumi-agent/data/controller/controller.conf
sudo sed -i "s/nv\.controller\.sshkeyfile=\/root\/\.ssh\/id_rsa/nv\.controller\.sshkeyfile=\/home\/rumi\/\.ssh\/rumi/g" nvx-rumi-agent/data/controller/controller.conf
cd ~
sudo chown -R rumi ~rumi/nvx-rumi-agent*
sudo chgrp -R rumi ~rumi/nvx-rumi-agent*

# Install Rumi Admin
cd ~rumi
sudo wget http://nexus.rumidata.io:8081/repository/maven-public/com/neeve/nvx-rumi-admin-server/2.0.24/nvx-rumi-admin-server-2.0.24.tar.gz
sudo tar -xv --no-same-owner -f nvx-rumi-admin-server-2.0.24.tar.gz
cd nvx-rumi-admin-server
sudo ln -s releases/v2.0.24 current
cd ~
sudo chown -R rumi ~rumi/nvx-rumi-admin-server*
sudo chgrp -R rumi ~rumi/nvx-rumi-admin-server*

# Prepare the boot.sh script
cd ~rumi
sudo mkdir logs
sudo mkdir logs/boot
sudo echo '#!/bin/bash' >> boot.sh
sudo echo '' >> boot.sh
sudo echo 'SCRIPT_ROOT="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null && pwd -P)"' >> boot.sh
sudo echo 'cd $SCRIPT_ROOT'>> boot.sh
sudo echo '. ./.setup_java.sh'>> boot.sh
sudo echo 'OUTFILE=`dirname $0`/logs/boot/`date +%Y-%m-%d-%H:%M:%S`.out' >> boot.sh
sudo echo 'JAVA_HOME=$JAVA_HOME_11 /home/rumi/activemq/apache-activemq-5.19.0/bin/activemq start | tee -a $OUTFILE' >> boot.sh
sudo echo 'JAVA_HOME=$JAVA_HOME_8 nvx-rumi-agent/current/start.sh | tee -a $OUTFILE' >> boot.sh
sudo echo 'nvx-rumi-admin-server/current/start.sh | tee -a $OUTFILE' >> boot.sh
sudo chmod +x boot.sh
sudo chown rumi boot.sh
sudo chgrp rumi boot.sh
sudo chown -R rumi logs
sudo chgrp -R rumi logs

# Configure CRON to run boot.sh on reboot
CRON_JOB="@reboot /home/rumi/boot.sh"
# ...check if the cron job already exists in rumi's crontab
sudo -u rumi crontab -l 2>/dev/null | grep -qF "$CRON_JOB"
if [[ $? -ne 0 ]]; then
    # add the cron job for rumi
    (sudo -u rumi crontab -l 2>/dev/null; echo "$CRON_JOB") | sudo -u rumi crontab -
fi

# Launch the services
sudo -u rumi /home/rumi/boot.sh

# Someone above changes the permissions on /home/rumi which prevents an ssh into the server. Switch it back
sudo chmod 750 /home/rumi

# Disable remote login as root
sudo truncate --size=0 /root/.ssh/authorized_keys
