/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.neeve.config.Config;
import com.neeve.util.UtlDisruptor;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlThread;
import java.util.concurrent.ThreadFactory;

final class UtlPoolWasher {
    private static final boolean detachedWash = Config.getValue((String)"nv.pool.detachedwash", (boolean)Config.getValue((String)"nv.poolwasher.detachedwash", (boolean)false));
    private final Disruptor<WasherEvent> disruptor;
    private final RingBuffer<WasherEvent> ringBuffer;
    private final long washerCpuAffinityMask;
    private Thread washer;
    private static final UtlPoolWasher instance = new UtlPoolWasher();

    private UtlPoolWasher() {
        if (detachedWash) {
            this.washerCpuAffinityMask = UtlThread.parseAffinityMask(Config.getValue((String)"nv.pool.detachedwash.cpuaffinitymask", (String)UtlThread.getDefaultCPUAffinityMask()));
            this.disruptor = UtlDisruptor.createSingleConsumerDisruptor(new WasherEventFactory(), Config.getValue((String)"nv.pool.detachedwash.queueDepth", (int)1024), new WasherThreadFactory(), ProducerType.MULTI, UtlDisruptor.getWaitStrategy(Config.getValue((String)"nv.pool.detachedwash.waitstrategy", (String)"Blocking"), true), new WasherEventProcessor());
            this.ringBuffer = this.disruptor.getRingBuffer();
            this.disruptor.start();
        } else {
            this.disruptor = null;
            this.ringBuffer = null;
            this.washerCpuAffinityMask = 0L;
        }
    }

    static final UtlPoolWasher getInstance() {
        return instance;
    }

    static final boolean isDetached() {
        return detachedWash;
    }

    private final void washAndPut(UtlPool.Item<?> item, boolean fromDetached) {
        item.init();
        item.getPool().postWash(item, fromDetached);
    }

    final void wash(UtlPool.Item<?> item, boolean forceAttached) {
        if (detachedWash && !forceAttached && Thread.currentThread() != this.washer) {
            long sequence = this.ringBuffer.next();
            WasherEvent carrierEvent = (WasherEvent)this.ringBuffer.get(sequence);
            carrierEvent.item = item;
            this.ringBuffer.publish(sequence);
        } else {
            this.washAndPut(item, false);
        }
    }

    private final class WasherThreadFactory
    implements ThreadFactory {
        private WasherThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            return UtlPoolWasher.this.washer = new WasherThread("X-Pool-Washer", r);
        }
    }

    private final class WasherThread
    extends Thread {
        private final Runnable r;

        WasherThread(String name, Runnable r) {
            this.setDaemon(true);
            this.setName(name);
            this.r = r;
        }

        @Override
        public final void run() {
            UtlThread.setCPUAffinityMask(UtlPoolWasher.this.washerCpuAffinityMask);
            this.r.run();
        }
    }

    private final class WasherEventProcessor
    implements EventHandler<WasherEvent> {
        private WasherEventProcessor() {
        }

        public final void onEvent(WasherEvent event, long sequence, boolean endOfBatch) throws Exception {
            UtlPoolWasher.this.washAndPut(event.item, true);
        }
    }

    private final class WasherEventFactory
    implements EventFactory<WasherEvent> {
        private WasherEventFactory() {
        }

        public final WasherEvent newInstance() {
            return new WasherEvent();
        }
    }

    private final class WasherEvent {
        UtlPool.Item<?> item;

        private WasherEvent() {
        }
    }
}

