/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XIntCollection;
import com.neeve.lang.XIntIterator;
import com.neeve.lang.XIntIteratorImpl;
import com.neeve.lang.XIntList;
import com.neeve.lang.XIntListIterator;
import com.neeve.lang.XIntSet;
import java.util.List;

public abstract class XIntCollectionBase
implements XIntCollection {
    private XIntIterator reusableIterator;

    protected XIntCollectionBase() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract XCollection.Record head();

    @Override
    public abstract XCollection.Record tail();

    @Override
    public abstract int valueOf(XCollection.Record var1);

    @Override
    public abstract void delete(XCollection.Record var1);

    @Override
    public XIntCollection unmodifiable() {
        return new Unmodifiable();
    }

    @Override
    public XIntCollection shared() {
        return new Shared();
    }

    @Override
    public XIntIterator iterator() {
        return XIntIteratorImpl.valueOf(this);
    }

    @Override
    public XIntIterator reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = this.iterator();
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean supportsIteratorModifications() {
        return true;
    }

    @Override
    public boolean add(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(int value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        XCollection.Record head = this.head();
        for (XCollection.Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(int value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(XIntCollection c) {
        boolean modified = false;
        XIntIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(XIntCollection c) {
        XIntIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(XIntCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(XIntCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public int[] toArray() {
        return this.toArray(new int[this.size()]);
    }

    @Override
    public int[] toArray(int[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new int[size];
        }
        if (array.length > size) {
            array[size] = -1;
        }
        int i = 0;
        int[] arrayView = array;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        XIntIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            int e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof XIntList) {
            return obj instanceof XIntList ? this.equalsOrder((XIntList)obj) : false;
        }
        if (obj instanceof XIntList) {
            return false;
        }
        if (!(obj instanceof XIntCollection)) {
            return false;
        }
        XIntCollection that = (XIntCollection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(XIntList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        XIntIterator thatIterator = that.iterator();
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            int o2;
            int o1 = this.valueOf(r);
            if (o1 == (o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += this.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + this.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    private int hashCodeFor(int value) {
        return value ^ value >>> 32;
    }

    private class Shared
    implements XIntCollection {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XIntCollectionBase.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XIntCollectionBase.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(int o) {
            return XIntCollectionBase.this.contains(o);
        }

        @Override
        public synchronized int[] toArray() {
            return XIntCollectionBase.this.toArray();
        }

        @Override
        public synchronized int[] toArray(int[] a) {
            return XIntCollectionBase.this.toArray(a);
        }

        @Override
        public synchronized XIntIterator iterator() {
            return new CollectionArrayIterator(XIntCollectionBase.this.toArray());
        }

        @Override
        public XIntIterator reusableIterator() {
            throw new UnsupportedOperationException("Reusable iterator not supported for this shared collection");
        }

        @Override
        public synchronized boolean supportsIteratorModifications() {
            return XIntCollectionBase.this.supportsIteratorModifications();
        }

        @Override
        public synchronized boolean add(int e) {
            return XIntCollectionBase.this.add(e);
        }

        @Override
        public synchronized boolean remove(int o) {
            return XIntCollectionBase.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(XIntCollection c) {
            return XIntCollectionBase.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(XIntCollection c) {
            return XIntCollectionBase.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(XIntCollection c) {
            return XIntCollectionBase.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(XIntCollection c) {
            return XIntCollectionBase.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XIntCollectionBase.this.clear();
        }

        public synchronized String toString() {
            return XIntCollectionBase.this.toString();
        }

        @Override
        public synchronized XCollection.Record head() {
            return XIntCollectionBase.this.head();
        }

        @Override
        public synchronized XCollection.Record tail() {
            return XIntCollectionBase.this.tail();
        }

        @Override
        public int valueOf(XCollection.Record record) {
            return XIntCollectionBase.this.valueOf(record);
        }

        @Override
        public synchronized void delete(XCollection.Record record) {
            XIntCollectionBase.this.delete(record);
        }

        @Override
        public XIntCollection unmodifiable() {
            return XIntCollectionBase.this.unmodifiable();
        }

        @Override
        public XIntCollection shared() {
            return this;
        }

        private class CollectionArrayIterator
        implements XIntIterator {
            private int[] _elements;
            private int _index;
            private int _next;
            private boolean removed;

            public CollectionArrayIterator(int[] elements) {
                this._elements = elements;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public int next() {
                this.removed = false;
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("No element to remove");
                }
                Shared.this.remove(this._next);
                this.removed = true;
            }

            @Override
            public CollectionArrayIterator toFirst() {
                this._index = 0;
                this._next = 0;
                this.removed = true;
                this._elements = Shared.this.toArray();
                return this;
            }
        }
    }

    class Unmodifiable
    extends XIntCollectionBase
    implements XIntSet,
    XIntList {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XIntCollectionBase.this.size();
        }

        @Override
        public XCollection.Record head() {
            return XIntCollectionBase.this.head();
        }

        @Override
        public XCollection.Record tail() {
            return XIntCollectionBase.this.tail();
        }

        @Override
        public int valueOf(XCollection.Record record) {
            return XIntCollectionBase.this.valueOf(record);
        }

        @Override
        public boolean contains(int value) {
            return XIntCollectionBase.this.contains(value);
        }

        @Override
        public boolean containsAll(XIntCollection c) {
            return XIntCollectionBase.this.containsAll(c);
        }

        @Override
        public boolean add(int obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(XCollection.Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, XIntCollection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int get(int index) {
            return ((XIntList)((Object)XIntCollectionBase.this)).get(index);
        }

        @Override
        public int set(int index, int element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, int element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int removeIndex(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(int o) {
            return ((XIntList)((Object)XIntCollectionBase.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(int o) {
            return ((XIntList)((Object)XIntCollectionBase.this)).lastIndexOf(o);
        }

        @Override
        public XIntListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XIntListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XIntList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }
}

